/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.dictionary.DictionaryDialog;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.spread_selection.ScopePanelAction;
import smart_gs.spread_selection.SetScopePanel;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.text_search.SearchTextAction;
import smart_gs.text_search.swingui.SearchResultViewer;

public class TextSearchDialog
extends JDialog {
    private SetScopePanel scopePanel;
    private JRadioButton allType;
    private JRadioButton firstIDAT;
    private JRadioButton text;
    private JRadioButton secondIDAT;
    private JRadioButton thirdIDAT;
    private JTextField queryTextPane;
    private JTextField queryReplacePane;
    private JCheckBox caseSensitiveBox;
    private JCheckBox regularExpressionsBox;
    private String queryText = null;
    private JButton ok;
    private JButton replace;
    private static boolean allTypeSelected = true;
    private static boolean firstidatSelected;
    private static boolean textSelected;
    private static boolean secondidatSelected;
    private static boolean thirdidatSelected;
    private static String queryTextPaneText;
    private static String queryReplacePaneText;
    private static boolean caseSensitiveBoxSelected;
    private static boolean regularExpressionsBoxSelected;

    public TextSearchDialog() {
        super((Frame)new JFrame(), "Search Dialog");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        JPanel queryTextPanel = new JPanel();
        queryTextPanel.setLayout(new BorderLayout());
        queryTextPanel.setBorder(new TitledBorder(""));
        this.queryTextPane = new JTextField();
        this.queryTextPane.setFont(new Font("default", 0, 20));
        this.queryTextPane.setText(queryTextPaneText);
        this.queryReplacePane = new JTextField();
        this.queryReplacePane.setFont(new Font("default", 0, 20));
        this.queryReplacePane.setText(queryReplacePaneText);
        GridBagConstraints c = new GridBagConstraints();
        JPanel findPanel = new JPanel(new GridBagLayout());
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 2, 0);
        c.anchor = 17;
        findPanel.add((Component)new JLabel("Find:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        findPanel.add((Component)this.queryTextPane, c);
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 2, 0);
        c.anchor = 17;
        findPanel.add((Component)new JLabel("Replace With:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        findPanel.add((Component)this.queryReplacePane, c);
        queryTextPanel.add((Component)findPanel, "Center");
        Panel boxPanel = new Panel();
        boxPanel.setLayout(new BorderLayout());
        this.caseSensitiveBox = new JCheckBox("Case sensitive");
        this.regularExpressionsBox = new JCheckBox("Regular expressions");
        boxPanel.add((Component)this.regularExpressionsBox, "North");
        boxPanel.add((Component)this.caseSensitiveBox, "South");
        queryTextPanel.add((Component)boxPanel, "South");
        mainPanel.add((Component)queryTextPanel, "North");
        JPanel optionPanel = new JPanel(new GridLayout(1, 2));
        mainPanel.add((Component)optionPanel, "Center");
        this.scopePanel = new SetScopePanel(false);
        this.scopePanel.setScopePanelAction(new TextSearchDialogScopePanelAction());
        optionPanel.add(this.scopePanel);
        JPanel documentTypePanel = new JPanel(new GridLayout(4, 1));
        documentTypePanel.setBorder(new TitledBorder("document type"));
        this.text = new JRadioButton("Text");
        this.text.setSelected(textSelected);
        this.firstIDAT = new JRadioButton(Preference.getInstance().getFirstIDATName());
        this.firstIDAT.setSelected(firstidatSelected);
        this.secondIDAT = new JRadioButton(Preference.getInstance().getSecondIDATName());
        this.secondIDAT.setSelected(secondidatSelected);
        this.thirdIDAT = new JRadioButton(Preference.getInstance().getThirdIDATName());
        this.thirdIDAT.setSelected(thirdidatSelected);
        this.allType = new JRadioButton("All Document Types");
        this.allType.setSelected(allTypeSelected);
        this.caseSensitiveBox.setSelected(caseSensitiveBoxSelected);
        this.regularExpressionsBox.setSelected(regularExpressionsBoxSelected);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.firstIDAT);
        group2.add(this.secondIDAT);
        group2.add(this.thirdIDAT);
        group2.add(this.text);
        group2.add(this.allType);
        this.firstIDAT.addActionListener(new DocumentTypeSelectAction());
        this.secondIDAT.addActionListener(new DocumentTypeSelectAction());
        this.thirdIDAT.addActionListener(new DocumentTypeSelectAction());
        this.text.addActionListener(new DocumentTypeSelectAction());
        this.allType.addActionListener(new DocumentTypeSelectAction());
        documentTypePanel.add(this.firstIDAT);
        documentTypePanel.add(this.secondIDAT);
        documentTypePanel.add(this.thirdIDAT);
        documentTypePanel.add(this.text);
        documentTypePanel.add(this.allType);
        optionPanel.add(documentTypePanel);
        JPanel buttonPanel = new JPanel();
        this.ok = new JButton("Search");
        this.ok.addActionListener(new OKAction());
        buttonPanel.add(this.ok);
        this.replace = new JButton("Replace");
        this.replace.addActionListener(new ReplaceAction());
        buttonPanel.add(this.replace);
        this.scopePanel.execScopePanelAction();
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setLocationRelativeTo(null);
        this.pack();
    }

    private void search(String queryText, int documentType, boolean isCaseSensitive, boolean isRegularExpressions) {
        List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
        ArrayList<Spread> spreadsToSearch = new ArrayList<Spread>();
        int i = 0;
        while (i < spreads.size()) {
            spreadsToSearch.add(spreads.get(i));
            ++i;
        }
        SearchTextAction searchAction = new SearchTextAction(queryText, spreadsToSearch, documentType, isCaseSensitive, isRegularExpressions);
        searchAction.execute();
        ArrayList results = (ArrayList)searchAction.getResults();
        new SearchResultViewer(queryText, results).setVisible(true);
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
    }

    private class DocumentTypeSelectAction
    implements ActionListener {
        private DocumentTypeSelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TextSearchDialog.this.text.isSelected()) {
                TextSearchDialog.this.scopePanel.setEnabled(false);
            } else {
                TextSearchDialog.this.scopePanel.setEnabled(true);
            }
        }
    }

    private class OKAction
    implements ActionListener {
        int documentType;

        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextSearchDialog.this.queryText = TextSearchDialog.this.queryTextPane.getText();
            if (TextSearchDialog.this.queryText.equals("")) {
                JOptionPane.showMessageDialog(null, "type any text");
            } else if (TextSearchDialog.this.scopePanel.isImageDictionary()) {
                DictionaryDialog dictionaryDialog = new DictionaryDialog((Frame)WorkspaceWindow.getInstance(), "Dictionary", false, 0);
                dictionaryDialog.search(TextSearchDialog.this.queryText, TextSearchDialog.this.regularExpressionsBox.isSelected(), TextSearchDialog.this.caseSensitiveBox.isSelected());
                dictionaryDialog.setVisible(true);
            } else {
                queryTextPaneText = TextSearchDialog.this.queryText;
                queryReplacePaneText = TextSearchDialog.this.queryReplacePane.getText();
                firstidatSelected = TextSearchDialog.this.firstIDAT.isSelected();
                thirdidatSelected = TextSearchDialog.this.thirdIDAT.isSelected();
                secondidatSelected = TextSearchDialog.this.secondIDAT.isSelected();
                allTypeSelected = TextSearchDialog.this.allType.isSelected();
                textSelected = TextSearchDialog.this.text.isSelected();
                caseSensitiveBoxSelected = TextSearchDialog.this.caseSensitiveBox.isSelected();
                regularExpressionsBoxSelected = TextSearchDialog.this.regularExpressionsBox.isSelected();
                if (TextSearchDialog.this.firstIDAT.isSelected()) {
                    this.documentType = 1;
                } else if (TextSearchDialog.this.thirdIDAT.isSelected()) {
                    this.documentType = 3;
                } else if (TextSearchDialog.this.secondIDAT.isSelected()) {
                    this.documentType = 2;
                } else if (TextSearchDialog.this.allType.isSelected()) {
                    this.documentType = 4;
                } else if (TextSearchDialog.this.text.isSelected()) {
                    this.documentType = 5;
                }
                TextSearchDialog.this.search(TextSearchDialog.this.queryText, this.documentType, TextSearchDialog.this.caseSensitiveBox.isSelected(), TextSearchDialog.this.regularExpressionsBox.isSelected());
            }
        }
    }

    private class ReplaceAction
    implements ActionListener {
        int documentType;

        private ReplaceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextSearchDialog.this.queryText = TextSearchDialog.this.queryTextPane.getText();
            if (TextSearchDialog.this.queryText.equals("")) {
                JOptionPane.showMessageDialog(null, "type any text");
            } else if (!TextSearchDialog.this.scopePanel.isImageDictionary()) {
                queryTextPaneText = TextSearchDialog.this.queryText;
                queryReplacePaneText = TextSearchDialog.this.queryReplacePane.getText();
                firstidatSelected = TextSearchDialog.this.firstIDAT.isSelected();
                thirdidatSelected = TextSearchDialog.this.thirdIDAT.isSelected();
                secondidatSelected = TextSearchDialog.this.secondIDAT.isSelected();
                allTypeSelected = TextSearchDialog.this.allType.isSelected();
                textSelected = TextSearchDialog.this.text.isSelected();
                caseSensitiveBoxSelected = TextSearchDialog.this.caseSensitiveBox.isSelected();
                regularExpressionsBoxSelected = TextSearchDialog.this.regularExpressionsBox.isSelected();
                if (TextSearchDialog.this.firstIDAT.isSelected()) {
                    this.documentType = 1;
                } else if (TextSearchDialog.this.thirdIDAT.isSelected()) {
                    this.documentType = 3;
                } else if (TextSearchDialog.this.secondIDAT.isSelected()) {
                    this.documentType = 2;
                } else if (TextSearchDialog.this.allType.isSelected()) {
                    this.documentType = 4;
                } else if (TextSearchDialog.this.text.isSelected()) {
                    this.documentType = 5;
                }
                SearchAllDialogManager.setting(TextSearchDialog.this.queryText, queryReplacePaneText, regularExpressionsBoxSelected, caseSensitiveBoxSelected);
                int scope = 0;
                String spreadSelection = "";
                if (TextSearchDialog.this.scopePanel.isAll()) {
                    scope = 0;
                } else if (TextSearchDialog.this.scopePanel.isCurrentDirectory()) {
                    scope = 1;
                } else if (TextSearchDialog.this.scopePanel.isSelectSpread()) {
                    scope = 2;
                    spreadSelection = TextSearchDialog.this.scopePanel.getSelectedPage();
                }
                SearchAllDialogManager.findfirst(this.documentType, scope, spreadSelection);
                TextSearchDialog.this.dispose();
            }
        }
    }

    class TextSearchDialogScopePanelAction
    implements ScopePanelAction {
        TextSearchDialogScopePanelAction() {
        }

        @Override
        public void actionPerformed(SetScopePanel setScopePanel) {
            if (setScopePanel.isImageDictionary()) {
                TextSearchDialog.this.allType.setEnabled(false);
                TextSearchDialog.this.firstIDAT.setEnabled(false);
                TextSearchDialog.this.text.setEnabled(false);
                TextSearchDialog.this.secondIDAT.setEnabled(false);
                TextSearchDialog.this.thirdIDAT.setEnabled(false);
                TextSearchDialog.this.replace.setEnabled(false);
            } else {
                TextSearchDialog.this.allType.setEnabled(true);
                TextSearchDialog.this.firstIDAT.setEnabled(true);
                TextSearchDialog.this.text.setEnabled(true);
                TextSearchDialog.this.secondIDAT.setEnabled(true);
                TextSearchDialog.this.thirdIDAT.setEnabled(true);
                TextSearchDialog.this.replace.setEnabled(true);
            }
        }
    }
}

