/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.logical.GSResource;
import smart_gs.logical.IDAT;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.Spread;
import smart_gs.logical.URISolver;
import smart_gs.logical.UsersNote;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.smleditor.swingui.GSTextEditor;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.text_search.swingui.TextToShow;
import sml_editor.swingui.GSHTMLEditorTextPane;

public class ResultPanel
extends JPanel {
    private JPanel resultPanel = this;
    private int length;

    private ResultPanel(TextToShow textToShow, String documentURI, int index) {
        this.length = textToShow.getLength();
        this.setPreferredSize(new Dimension(200, 50));
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(documentURI));
        this.setSize(400, 50);
        JTextField field = new JTextField();
        field.setHorizontalAlignment(2);
        field.setFont(new Font("default", 0, 20));
        field.setText(textToShow.getText());
        field.setBackground(Color.white);
        field.setOpaque(true);
        field.setEditable(false);
        field.setEnabled(false);
        field.setDisabledTextColor(Color.BLACK);
        this.add((Component)field, "West");
        this.setHighlight(textToShow, field);
        if (documentURI.startsWith("smart://usersNote")) {
            field.addMouseListener(new UsersNoteResultPanelMouseListener(index, documentURI));
        } else {
            field.addMouseListener(new ResultPanelJTextFieldMouseListener(index, documentURI));
        }
    }

    public static ResultPanel getInstance(TextToShow textToShow, String documentURI, int index) {
        return new ResultPanel(textToShow, documentURI, index);
    }

    private void setHighlight(TextToShow textToShow, JTextField field) {
        Highlighter hilite = field.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter hilightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
        try {
            hilite.addHighlight(textToShow.getIndex(), textToShow.getIndex() + textToShow.getLength(), hilightPainter);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    class GSEditorFocusListener
    implements FocusListener {
        protected GSHTMLEditorTextPane gsHTMLEditorTextPane;
        protected int index;

        public GSEditorFocusListener(GSHTMLEditorTextPane gsHTMLEditorTextPane, int index) {
            this.gsHTMLEditorTextPane = gsHTMLEditorTextPane;
            this.index = index;
        }

        @Override
        public void focusGained(FocusEvent e1) {
            this.gsHTMLEditorTextPane.setCaretPosition(this.index);
            Highlighter hilite = this.gsHTMLEditorTextPane.getHighlighter();
            DefaultHighlighter.DefaultHighlightPainter hilightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
            try {
                hilite.addHighlight(this.index, this.index + ResultPanel.this.length, hilightPainter);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.gsHTMLEditorTextPane.getHighlighter().removeAllHighlights();
            this.gsHTMLEditorTextPane.removeFocusListener(this);
        }
    }

    class ResultPanelJTextFieldMouseListener
    implements MouseListener {
        protected Spread spread;
        protected String documentURI;
        protected int index;

        public ResultPanelJTextFieldMouseListener(int index, String documentURI) {
            this.spread = URISolver.getSpreadByDocumentURI(documentURI);
            this.documentURI = documentURI;
            this.index = index;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            GSResource res = URISolver.getResource(this.documentURI);
            if (res == null) {
                System.out.println(String.format("Error: Spread of resouce %s is not found", this.documentURI));
                return;
            }
            if (!(res instanceof SmartDocument)) {
                return;
            }
            SmartDocument doc = (SmartDocument)res;
            if (!doc.isIDAT()) {
                return;
            }
            IDAT idat = (IDAT)doc;
            if (e.getClickCount() == 1) {
                int idat_index = idat.getIDATIndex();
                if (e.getButton() == 1 && !WorkspaceWindow.getInstance().isAlt()) {
                    if (this.spread != null) {
                        GSEditor gsEditor = new GSEditor(this.spread);
                        GSHTMLEditorTextPane gsHTMLEditorTextPane = null;
                        switch (idat_index) {
                            case 1: {
                                gsEditor.getSMLTabbedPane().setPanelToShow(1);
                                gsHTMLEditorTextPane = gsEditor.getSMLTabbedPane().getFirstIDAT().getGSHTMLEditorTextPane();
                                break;
                            }
                            case 2: {
                                gsEditor.getSMLTabbedPane().setPanelToShow(2);
                                gsHTMLEditorTextPane = gsEditor.getSMLTabbedPane().getSecondIDAT().getGSHTMLEditorTextPane();
                                break;
                            }
                            case 3: {
                                gsEditor.getSMLTabbedPane().setPanelToShow(3);
                                gsHTMLEditorTextPane = gsEditor.getSMLTabbedPane().getThirdIDAT().getGSHTMLEditorTextPane();
                                break;
                            }
                            default: {
                                System.out.println("Error in ResultPanelJTextFieldMouseListener");
                                return;
                            }
                        }
                        gsEditor.setVisible(true);
                        if (gsHTMLEditorTextPane != null) {
                            gsHTMLEditorTextPane.requestFocus();
                            gsHTMLEditorTextPane.addFocusListener(new GSEditorFocusListener(gsHTMLEditorTextPane, this.index + 1));
                        }
                    }
                } else if (e.getButton() == 3 || e.getButton() == 1) {
                    WorkspaceWindow window = WorkspaceWindow.getInstance();
                    GSTabbedPane tbp = null;
                    if (this.spread != null) {
                        boolean noSpread = false;
                        if (window.getSpread() == null) {
                            noSpread = true;
                            window.setSpread(this.spread);
                            window.setImageSearch(this.spread.toString());
                        } else if (!window.getSpread().equals(this.spread)) {
                            window.setSpread(this.spread);
                            window.setImageSearch(this.spread.toString());
                        }
                        SpreadCanvas canvas = WorkspaceWindow.getInstance().getSpreadCanvas();
                        canvas.imageLabel.showImage();
                        tbp = WorkspaceWindow.getInstance().getTabbedPane();
                        tbp.setSelectedIndex(idat_index - 1);
                    }
                    tbp.emphasize(idat_index, this.index, ResultPanel.this.length);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class UsersNoteResultPanelMouseListener
    implements MouseListener {
        UsersNote usersNote;
        String documentURI;
        int index;
        String name;
        private JWindow window;

        public UsersNoteResultPanelMouseListener(int index, String documentURI) {
            this.index = index;
            this.documentURI = documentURI;
            this.usersNote = (UsersNote)URISolver.getUsersNote(documentURI);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && !WorkspaceWindow.getInstance().isAlt()) {
                if (e.getClickCount() == 1) {
                    GSTextEditor gsTextEditor = new GSTextEditor(this.usersNote, this.name);
                    GSHTMLEditorTextPane gsHTMLEditorTextPane = gsTextEditor.getGSEditorTextPane().getGSHTMLEditorTextPane();
                    gsTextEditor.setVisible(true);
                    if (gsHTMLEditorTextPane != null) {
                        gsHTMLEditorTextPane.requestFocus();
                        gsHTMLEditorTextPane.addFocusListener(new GSEditorFocusListener(gsHTMLEditorTextPane, this.index + 1));
                    }
                }
            } else if (e.getButton() == 3 || e.getButton() == 1) {
                JLabel label = new JLabel("<html><b><font color='red' size='5'>Jump-operation is not applicable<br>to a user's note.</font></b></html>");
                JPanel panelToDisplayInformation = new JPanel();
                panelToDisplayInformation.add((Component)label, "Center");
                if (this.window == null) {
                    this.window = new JWindow();
                }
                this.window.getContentPane().setLayout(new BorderLayout());
                this.window.getContentPane().add((Component)label, "Center");
                Point orig_p = ResultPanel.this.resultPanel.getLocationOnScreen();
                Point p = new Point(orig_p.x + 50, orig_p.y - 10);
                this.window.setLocation(p);
                this.window.pack();
                this.window.setVisible(true);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.window != null) {
                this.window.setVisible(false);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

