/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.tree.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FileUtils;
import smart_gs.logical.GSResource;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.filter.ImageFileFilter;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.FileCopy;
import smart_gs.util.GSImageFileUtils;
import smart_gs.util.GSPathStringGrammarChecker;

public class ImportImagesAction
implements ActionListener {
    protected DefaultMutableTreeNode parentTreeNode;
    protected SpreadDirectory spreadDirectory;
    protected SpreadTree tree;
    protected SpreadDirectory parentSpreadDir;
    protected File targetDir;

    public ImportImagesAction(DefaultMutableTreeNode parentTreeNode, SpreadTree tree) {
        this.parentTreeNode = parentTreeNode;
        this.spreadDirectory = this.spreadDirectory;
        this.tree = tree;
        this.parentSpreadDir = (SpreadDirectory)parentTreeNode.getUserObject();
        this.targetDir = this.parentSpreadDir.getFile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser("/");
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new ImageFileFilter());
        int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
        if (input == 1) {
            return;
        }
        File[] files = chooser.getSelectedFiles();
        int size = files.length;
        int count = 0;
        while (count < size) {
            File file = files[count];
            String fullname = file.getName();
            if (!GSPathStringGrammarChecker.isFileDirIdentifier(fullname)) {
                JOptionPane.showMessageDialog(null, String.format("Error: name %s cannot be used in SMART-GS.", fullname));
            } else {
                int lastPeriodIndex = fullname.lastIndexOf(".");
                int length = fullname.length();
                if (lastPeriodIndex < 0 || lastPeriodIndex == length - 1) {
                    JOptionPane.showMessageDialog(null, String.format("Error: format type of %s is not available.", fullname));
                } else {
                    String extension = fullname.substring(lastPeriodIndex + 1);
                    if (!GSImageFileUtils.isSupportedFormat(extension)) {
                        JOptionPane.showMessageDialog(null, String.format("Error: file format %s of %s is not supported.", extension, fullname));
                    } else {
                        String name = fullname.substring(0, fullname.lastIndexOf("."));
                        Enumeration<TreeNode> enm = this.parentTreeNode.children();
                        boolean nameExists = false;
                        while (enm.hasMoreElements()) {
                            String tmp = ((GSResource)((DefaultMutableTreeNode)enm.nextElement()).getUserObject()).getName();
                            if (!tmp.equals(name)) continue;
                            nameExists = true;
                            JOptionPane.showMessageDialog(null, String.format("Error: name %s already used in %s\n.", tmp, SpreadTree.makePathString(this.parentTreeNode.getPath())));
                            break;
                        }
                        if (!nameExists) {
                            File sourceDscFile;
                            try {
                                FileUtils.copyFileToDirectory(file, this.targetDir);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            File targetFile = new File(this.targetDir, fullname);
                            this.tree.addImage(targetFile);
                            File sourceDscDir = new File(file.getParentFile(), "dsc");
                            if (sourceDscDir.exists() && (sourceDscFile = new File(sourceDscDir, String.valueOf(name) + "dsc")).exists()) {
                                File targetDscDir = new File(this.targetDir, "dsc");
                                targetDscDir.mkdir();
                                if (!targetDscDir.exists()) {
                                    System.out.printf("Error: %s does not exist\n", targetDscDir);
                                    return;
                                }
                                FileCopy.copy(sourceDscFile, targetDscDir);
                            }
                        }
                    }
                }
            }
            ++count;
        }
    }
}

