/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui.tree.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import smart_gs.logical.Preference;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.logical.filter.ImageDirectoryFilter;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GSStandardPath;

public class AddSpreadDirectoryAction
implements ActionListener {
    SpreadTree tree;
    File imageFolder = new File(Preference.getInstance().getImageFolderPathString());
    File openDirectory;
    String imageFolderPath;
    String openDirectoryPath;
    SpreadDirectory openSpreadDirectory;
    DefaultMutableTreeNode currentNode;

    public AddSpreadDirectoryAction(File openDirectory, SpreadDirectory openSpreadDirectory) {
        this.tree = SpreadTree.getInstance();
        this.imageFolderPath = GSStandardPath.toStandardOnCurrentOS(CanonicalPathString.get(this.imageFolder));
        this.openDirectory = openDirectory;
        this.openSpreadDirectory = openSpreadDirectory;
        this.openDirectoryPath = GSStandardPath.toStandardOnCurrentOS(CanonicalPathString.get(openDirectory));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreePath[] tmpTreePaths = this.tree.getSelectedPaths();
        this.currentNode = (DefaultMutableTreeNode)tmpTreePaths[0].getLastPathComponent();
        JFileChooser chooser = new JFileChooser(this.openDirectory);
        ImageDirectoryFilter filter = new ImageDirectoryFilter();
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(filter);
        int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
        if (input == 1) {
            return;
        }
        File[] files = chooser.getSelectedFiles();
        int size = files.length;
        int count = 0;
        while (count < size) {
            File file = files[count];
            if (file != null) {
                String openDirPath = GSStandardPath.toStandardOnCurrentOS(CanonicalPathString.get(this.openDirectory));
                String dirToAddPath = GSStandardPath.toStandardOnCurrentOS(CanonicalPathString.get(file));
                if (!dirToAddPath.startsWith(this.imageFolderPath)) {
                    JOptionPane.showMessageDialog(new Frame(), String.format("Directory %s \n is not in Image Folder %s.", dirToAddPath, this.imageFolderPath), "Information", -1);
                    return;
                }
                String dirName = file.getName();
                String path = String.valueOf(openDirPath) + "/" + dirName;
                if (!path.equals(dirToAddPath)) {
                    JOptionPane.showMessageDialog(new Frame(), String.format("Directory %s \n is not in the directory specified", dirName), "Information", -1);
                    return;
                }
                this.tree.addDir(this.currentNode, this.openDirectory, dirName);
            }
            ++count;
        }
    }
}

