/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.swingui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.action.ChangeSizeAction;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.action.DeleteDscFileAction;
import smart_gs.swingui.toolbar.action.DeleteLineSegmentsFileAction;
import smart_gs.swingui.toolbar.action.DscCompileAction;
import smart_gs.swingui.toolbar.action.ImportDscFileAction;
import smart_gs.swingui.toolbar.action.LineSegDscInformationAction;
import smart_gs.swingui.toolbar.action.PolygonalLineActionListener;
import smart_gs.swingui.toolbar.action.ReadSegmentInfoAction;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAndDscCompileAction;
import sml_editor.swingui.toolbar.action.SaveLineSegmentsAction;

public class LineSegmentsEditingFrame
extends JFrame {
    private static JToggleButton polygonalLine = null;
    private static boolean polygonalLineSelect = false;
    private static LineSegmentsEditingFrame singleton;

    public static LineSegmentsEditingFrame getInstance(AbstractGSWindow parent) {
        if (singleton == null) {
            singleton = new LineSegmentsEditingFrame(parent);
        }
        return singleton;
    }

    private LineSegmentsEditingFrame(AbstractGSWindow parent) {
        super("Editing Line Segments");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImageLabel.setLineVisible(false);
            }
        });
        polygonalLine = new JToggleButton("Edit Line Segments");
        polygonalLine.addActionListener(new PolygonalLineActionListener());
        polygonalLine.setToolTipText("Edit Line Segments");
        polygonalLine.setAlignmentX(0.5f);
        polygonalLine.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(polygonalLine);
        JButton changeSize = new JButton("Zoom & Move");
        changeSize.addActionListener(new ChangeSizeAction(parent));
        changeSize.setToolTipText("Change Size");
        changeSize.setAlignmentX(0.5f);
        changeSize.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(changeSize);
        JButton readLSeg = new JButton("Read Line Segments");
        readLSeg.addActionListener(new ReadSegmentInfoAction(parent));
        readLSeg.setToolTipText("Read Line Segments");
        readLSeg.setAlignmentX(0.5f);
        readLSeg.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(readLSeg);
        JButton saveLSeg = new JButton("Save Line Segments");
        saveLSeg.addActionListener(new SaveLineSegmentsAction(parent));
        saveLSeg.setToolTipText("Save Line Segments");
        saveLSeg.setAlignmentX(0.5f);
        saveLSeg.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(saveLSeg);
        JButton infoLSeg = new JButton("Line Seg & DSC Information");
        infoLSeg.addActionListener(new LineSegDscInformationAction(parent, this));
        infoLSeg.setToolTipText("Line Seg & DSC Information");
        infoLSeg.setAlignmentX(0.5f);
        infoLSeg.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(infoLSeg);
        JButton deleteLSeg = new JButton("Delete Line Segments File");
        deleteLSeg.addActionListener(new DeleteLineSegmentsFileAction(parent));
        deleteLSeg.setToolTipText("Delete Line Segments File");
        deleteLSeg.setAlignmentX(0.5f);
        deleteLSeg.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(deleteLSeg);
        JButton createDSC = new JButton("Make DSC File");
        createDSC.addActionListener(new DscCompileAction(parent));
        createDSC.setToolTipText("Make DSC File");
        createDSC.setAlignmentX(0.5f);
        createDSC.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(createDSC);
        JButton createLineSegAndDSC = new JButton("Save Line Seg & Make DSC File");
        createLineSegAndDSC.addActionListener(new SaveLineSegmentsAndDscCompileAction(parent));
        createLineSegAndDSC.setToolTipText("Save Line Seg & Make DSC File");
        createLineSegAndDSC.setAlignmentX(0.5f);
        createLineSegAndDSC.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(createLineSegAndDSC);
        JButton deleteDSC = new JButton("Delete DSC File");
        deleteDSC.addActionListener(new DeleteDscFileAction(parent));
        deleteDSC.setToolTipText("Delete DSC File");
        deleteDSC.setAlignmentX(0.5f);
        deleteDSC.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(deleteDSC);
        JButton importDSC = new JButton("Import DSC File");
        importDSC.addActionListener(new ImportDscFileAction(parent));
        importDSC.setToolTipText("Import DSC File");
        importDSC.setAlignmentX(0.5f);
        importDSC.setMaximumSize(new Dimension(1000, 1000));
        this.getContentPane().add(importDSC);
        int width = createLineSegAndDSC.getWidth() + 300;
        this.pack();
        deleteDSC.repaint();
    }

    public static boolean isPolygonalLineSelect() {
        return polygonalLineSelect;
    }

    public static void polygonalLineClaer() {
        polygonalLine.setSelected(false);
        polygonalLineSelect = false;
    }

    public static void polygonalLineSet() {
        polygonalLine.setSelected(true);
        polygonalLineSelect = true;
    }
}

