/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.smleditor.swingui;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import smart_gs.drawing_tool.drawing_mode.AnchorMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.logical.AnchorTextSegment;
import smart_gs.logical.SmartDocument;
import smart_gs.logical.TextSegment;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import sml_editor.swingui.MarkupDialog;

public class GSMarkupDialog
extends MarkupDialog {
    public GSMarkupDialog(GSEditorTextPane textPane, int start, int end) {
        super(textPane, start, end);
    }

    @Override
    public void show() {
        super.show();
        String tagname = this.getTagName();
        if (tagname == null) {
            return;
        }
        SmartDocument document = ((GSEditorTextPane)this.textPane).getSmartDocument();
        if (tagname.equals("anchor")) {
            AnchorTextSegment anchorTextSegment = new AnchorTextSegment(document, this.id);
            AnchorMode.setAnchorTextSegment(anchorTextSegment);
            DefaultState.getInstance().setMode(AnchorMode.getInstance());
            document.addTextSegment(anchorTextSegment);
        } else {
            TextSegment segment = new TextSegment(tagname, document, this.id);
            document.addTextSegment(segment);
        }
        ((GSEditorTextPane)this.textPane).save();
    }

    @Override
    protected Object[] makeTagList() {
        Vector<String> taglist = new Vector<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader("tags.txt"));
            while ((line = reader.readLine()) != null) {
                taglist.add(line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List tagnames = this.textPane.getGSHTMLEditorTextPane().getTagNames();
        if (tagnames != null) {
            int i = 0;
            while (i < tagnames.size()) {
                if (!taglist.contains(((String)tagnames.get(i)).trim())) {
                    taglist.add(((String)tagnames.get(i)).trim());
                }
                ++i;
            }
        }
        if (!((GSEditorTextPane)this.textPane).getSmartDocument().isIDAT()) {
            taglist.remove("anchor");
        }
        return taglist.toArray();
    }
}

