/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public abstract class View {
    protected final int MARKER_SIZE = 4;
    protected boolean isSelected;
    protected Color defaultColor;
    protected Color currentColor;
    private static List<View> selectedViews = new ArrayList<View>();

    public abstract void drawShape(Graphics2D var1);

    public void drawTranslucentShape(Graphics2D g) {
        g.setComposite(AlphaComposite.getInstance(3, 0.3f));
        this.drawShape(g);
    }

    public abstract void moveBy(Point2D var1);

    public abstract boolean contains(Point2D var1);

    public abstract Rectangle2D getRectangle();

    public abstract void setRectangle(double var1, double var3, double var5, double var7);

    public abstract void setRectangle(double var1, double var3);

    public abstract String toString();

    protected void setMarker(Graphics2D g, Point2D p) {
        g.fill(new Rectangle2D.Double(p.getX(), p.getY(), 4.0, 4.0));
    }

    public void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (this.isSelected) {
            selectedViews.add(this);
        } else {
            selectedViews.remove(this);
        }
    }

    public static void clearSelection() {
        int i = 0;
        while (i < selectedViews.size()) {
            selectedViews.get(i).setIsSelected(false);
            ++i;
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setDrawColor(Color color) {
        this.currentColor = color;
    }

    public void restoreDefaultColor() {
        this.currentColor = this.defaultColor;
    }
}

