/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import reasoning_web.logical.Connection;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.Region;
import smart_gs.logical.TextSegment;
import smart_gs.logical.Zombie;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.swingui.LocalViewFrame;
import smart_gs.reasoning_web.swingui.action.ShowExplanatoryAction;
import smart_gs.util.Quadruple;

public class LocalViewPanel
extends JPanel {
    private JTextField nameField;
    private static final int BOX_HEIGHT = 140;

    public LocalViewPanel(ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> elements, LocalViewFrame parent) {
        this.setLayout(new GridLayout(elements.size(), 1));
        Enumeration<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> enume = Collections.enumeration(elements);
        while (enume.hasMoreElements()) {
            Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer> quadruple = enume.nextElement();
            Connection connection = quadruple.getFirst();
            String connectionName = connection.getName();
            GS_RWElement element = quadruple.getSecond();
            GSExplanatoryNote expNote = quadruple.getThird();
            Integer peer_edge_type = quadruple.getFourth();
            JSplitPane rowForConnection = new JSplitPane();
            if (peer_edge_type == 1) {
                rowForConnection.setBorder(new TitledBorder("Source: " + element.getURI()));
            } else if (peer_edge_type == 2) {
                rowForConnection.setBorder(new TitledBorder("Target: " + element.getURI()));
            } else {
                rowForConnection.setBorder(new TitledBorder("Linked to itself: " + element.getURI()));
            }
            int width = 140;
            int height = 140;
            rowForConnection.setDividerLocation(width);
            try {
                JPanel elementViewPanel = element instanceof Region ? ((Region)element).createElementViewPanelForLocalView() : (element instanceof TextSegment ? ((TextSegment)element).createElementViewPanelForLocalView() : (element instanceof Zombie ? ((Zombie)element).createElementViewPanelForLocalView() : element.createElementViewPanel(width, height)));
                rowForConnection.setLeftComponent(elementViewPanel);
            }
            catch (NoWayToShowException e) {
                e.printStackTrace();
            }
            try {
                JPanel panel = new JPanel();
                panel.setLayout(new GridLayout(2, 1));
                panel.setPreferredSize(new Dimension(210, 140));
                this.nameField = new JTextField(15);
                this.nameField.setBorder(new TitledBorder("Connection Name"));
                this.nameField.setText(connectionName);
                panel.add(this.nameField);
                JButton editButton = new JButton("Explantory Note");
                panel.add(editButton);
                editButton.addActionListener(new ShowExplanatoryAction(expNote));
                rowForConnection.setRightComponent(panel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.add(rowForConnection);
        }
    }
}

