/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.reasoning_web.swingui.view.View;

public class ElementsPanel
extends JPanel
implements Observer,
ListSelectionListener {
    private JList list;

    public ElementsPanel() {
        JLabel label = new JLabel("Markups");
        label.setBorder(new LineBorder(Color.BLACK));
        this.list = new JList();
        this.setLayout(new BorderLayout());
        this.add((Component)label, "North");
        List<RWElement> elements = GS_RWRepository.getInstance().getAllElements();
        this.list.setListData(elements.toArray());
        this.list.addListSelectionListener(this);
        this.add((Component)this.list, "Center");
    }

    public void reload() {
        this.list.removeAll();
        List<RWElement> elements = GS_RWRepository.getInstance().getAllElements();
        this.list.setListData(elements.toArray());
        this.validate();
    }

    @Override
    public void update() {
        this.reload();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        RWElement element = (RWElement)this.list.getSelectedValue();
        if (element == null) {
            return;
        }
        View.clearSelection();
        if (GS_RWRepository.getInstance().getResourcePointer((GS_RWElement)element) != null) {
            GS_RWRepository.getInstance().getResourcePointer((GS_RWElement)element).getView().setIsSelected(true);
        }
        ReasoningWebFrame.getInstance().repaint();
    }

    public void setElement(RWElement selectedElement) {
        this.list.setSelectedValue(selectedElement, true);
    }
}

