/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.reasoning_web;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smart_gs.util.HrefChecker;

public class ExternalLinkDialog
extends JDialog {
    protected static final Pattern pattern = Pattern.compile("(http://|https://){1}[\\w\\.\\-/:\\#\\?\\=\\&\\;\\%\\~\\+]+");
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTextField urlField = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private String urlStr = null;
    private boolean cancel = false;
    private String url = null;
    private JDialog myJDialog;

    public ExternalLinkDialog(Frame owner) {
        this(owner, null);
    }

    public ExternalLinkDialog(Frame owner, String urlStr) {
        super(owner, true);
        this.urlStr = urlStr;
        this.initialize();
        this.myJDialog = this;
    }

    private void initialize() {
        this.setSize(398, 115);
        this.setContentPane(this.getJContentPane());
        this.setTitle("External link");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getUrlField(), null);
            this.jContentPane.add((Component)this.getOkButton(), null);
            this.jContentPane.add((Component)this.getCancelButton(), null);
        }
        return this.jContentPane;
    }

    private JTextField getUrlField() {
        if (this.urlField == null) {
            this.urlField = new JTextField();
            this.urlField.setBounds(new Rectangle(25, 16, 341, 26));
            if (this.urlStr == null) {
                this.urlField.setText("http://");
            } else {
                this.urlField.setText(this.urlStr);
            }
        }
        return this.urlField;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(100, 50, 90, 25));
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean warning;
                    String urlCheck;
                    block7: {
                        urlCheck = ExternalLinkDialog.this.urlField.getText();
                        warning = false;
                        if (urlCheck.startsWith("http")) {
                            try {
                                Matcher matcher = pattern.matcher(urlCheck);
                                if (matcher.find()) {
                                    new URL(urlCheck);
                                    int checkid = HrefChecker.check(urlCheck);
                                    if (checkid != -1) {
                                        warning = true;
                                    }
                                    break block7;
                                }
                                warning = true;
                            }
                            catch (MalformedURLException e1) {
                                warning = true;
                            }
                        } else {
                            warning = urlCheck.toLowerCase().startsWith("file:") ? false : (urlCheck.toLowerCase().startsWith("mailto:") ? false : !urlCheck.toLowerCase().startsWith("ftp:"));
                        }
                    }
                    if (warning) {
                        JOptionPane.showMessageDialog(new JFrame(), "Please input correct URL.", "warning", 2);
                        return;
                    }
                    ExternalLinkDialog.this.url = urlCheck;
                    ExternalLinkDialog.this.myJDialog.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setBounds(new Rectangle(205, 50, 90, 25));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExternalLinkDialog.this.cancel = true;
                    ExternalLinkDialog.this.myJDialog.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel = true;
            this.setVisible(false);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isCancel() {
        return this.cancel;
    }
}

