/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.menu.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.logical.UsersNote;
import smart_gs.logical.UsersNoteTree;
import smart_gs.menu.export.ExportHtmlCreater;
import smart_gs.spread_selection.SetScopePanel;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.HTMLFileFilter;
import smart_gs.swingui.toolbar.action.TextFileFilter;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.StringUtils;

public class ExportDialog
extends JDialog {
    private SetScopePanel scopePanel;
    private JRadioButton allType;
    private JRadioButton docType;
    private JCheckBox firstidat;
    private JRadioButton text;
    private JCheckBox secondidat;
    private JCheckBox thirdidat;
    private JCheckBox caseSensitiveBox;
    private ButtonGroup group2;
    private JCheckBox html;
    protected File currentFile;

    public ExportDialog(File currentFile) {
        super((Frame)new JFrame(), "Export Dialog");
        this.currentFile = currentFile;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        JPanel optionPanel = new JPanel(new GridLayout(1, 2));
        mainPanel.add((Component)optionPanel, "Center");
        this.scopePanel = new SetScopePanel(false);
        optionPanel.add(this.scopePanel);
        this.html = new JCheckBox("Export by HTML");
        mainPanel.add((Component)this.html, "South");
        JPanel documentTypePanel = new JPanel(new GridLayout(4, 1));
        documentTypePanel.setBorder(new TitledBorder("document type"));
        this.docType = new JRadioButton("document");
        this.text = new JRadioButton("Text");
        this.firstidat = new JCheckBox(Preference.getInstance().getFirstIDATName());
        this.firstidat.setSelected(true);
        this.secondidat = new JCheckBox(Preference.getInstance().getSecondIDATName());
        this.thirdidat = new JCheckBox(Preference.getInstance().getThirdIDATName());
        this.allType = new JRadioButton("All Document Types");
        this.group2 = new ButtonGroup();
        this.group2.add(this.docType);
        this.group2.add(this.text);
        this.group2.add(this.allType);
        this.firstidat.addActionListener(new DocumentTypeCheckBoxSelectAction());
        this.secondidat.addActionListener(new DocumentTypeCheckBoxSelectAction());
        this.thirdidat.addActionListener(new DocumentTypeCheckBoxSelectAction());
        this.text.addActionListener(new DocumentTypeSelectAction());
        this.allType.addActionListener(new DocumentTypeSelectAction());
        documentTypePanel.add(this.firstidat);
        documentTypePanel.add(this.secondidat);
        documentTypePanel.add(this.thirdidat);
        documentTypePanel.add(this.text);
        documentTypePanel.add(this.allType);
        optionPanel.add(documentTypePanel);
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("Save");
        ok.addActionListener(new OKAction());
        buttonPanel.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new CancelAction());
        buttonPanel.add(cancel);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setLocationRelativeTo(null);
        this.pack();
    }

    private void export(ArrayList<Integer> documentTypeList, boolean isCaseSensitive) {
        block42: {
            String currentDirectory;
            List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
            String htmlbase = null;
            if (this.html.isSelected()) {
                htmlbase = ExportHtmlCreater.getHTMLStr();
            }
            if ((currentDirectory = Preference.getInstance().getSmart_exportFolderPathString()) == null) {
                currentDirectory = "C:/";
            }
            File directory = new File(currentDirectory);
            JFileChooser chooser = new JFileChooser(directory);
            if (this.currentFile != null) {
                chooser.setSelectedFile(this.currentFile);
            }
            FileFilter fileFilter = this.html.isSelected() ? new HTMLFileFilter() : new TextFileFilter();
            chooser.setFileFilter(fileFilter);
            int input = chooser.showSaveDialog(WorkspaceWindow.getInstance());
            if (input == 1) {
                this.dispose();
                return;
            }
            File file = chooser.getSelectedFile();
            String path = CanonicalPathString.get(file);
            if (!path.toLowerCase().endsWith("." + fileFilter.getDescription())) {
                path = path.endsWith(".") ? String.valueOf(path) + fileFilter.getDescription() : String.valueOf(path) + "." + fileFilter.getDescription();
            }
            OutputStreamWriter writer = null;
            StringBuffer buf = new StringBuffer();
            String br = null;
            br = this.html.isSelected() ? "<br>\n" : "\n";
            try {
                try {
                    Integer documentType;
                    boolean textmode = false;
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
                    if (documentTypeList.size() == 1 && (documentType = documentTypeList.get(0)) == 5) {
                        textmode = true;
                    }
                    if (textmode) {
                        boolean isBr = false;
                        ArrayList arrList1 = (ArrayList)UsersNoteTree.getInstance().getUsersNotes();
                        for (UsersNote usersNote : arrList1) {
                            String xmlstr = usersNote.getSource();
                            xmlstr = this.html.isSelected() ? this.getHtml(xmlstr) : this.getText(xmlstr);
                            if (!xmlstr.trim().equals("")) {
                                buf.append(xmlstr);
                                buf.append(br);
                                isBr = true;
                            }
                            if (!isBr) continue;
                            buf.append(br);
                        }
                    } else {
                        String xmlstr;
                        int i = 0;
                        while (i < spreads.size()) {
                            Spread spread = spreads.get(i);
                            boolean isBr = false;
                            int j = 0;
                            while (j < documentTypeList.size()) {
                                int documentType2 = documentTypeList.get(j);
                                if (documentType2 == 1 || documentType2 == 4) {
                                    xmlstr = spread.getFirstIDAT().getSource();
                                    xmlstr = this.html.isSelected() ? this.getHtml(xmlstr) : this.getText(xmlstr);
                                    if (!xmlstr.trim().equals("")) {
                                        buf.append(xmlstr);
                                        buf.append(br);
                                        isBr = true;
                                    }
                                }
                                if (documentType2 == 2 || documentType2 == 4) {
                                    xmlstr = spread.getSecondIDAT().getSource();
                                    xmlstr = this.html.isSelected() ? this.getHtml(xmlstr) : this.getText(xmlstr);
                                    if (!xmlstr.trim().equals("")) {
                                        buf.append(xmlstr);
                                        buf.append(br);
                                        isBr = true;
                                    }
                                }
                                if (documentType2 == 3 || documentType2 == 4) {
                                    xmlstr = spread.getThirdIDAT().getSource();
                                    xmlstr = this.html.isSelected() ? this.getHtml(xmlstr) : this.getText(xmlstr);
                                    if (!xmlstr.trim().equals("")) {
                                        buf.append(xmlstr);
                                        buf.append(br);
                                        isBr = true;
                                    }
                                }
                                if (isBr) {
                                    buf.append(br);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        boolean outputText = false;
                        int i2 = 0;
                        while (i2 < documentTypeList.size()) {
                            Integer documentType3 = documentTypeList.get(i2);
                            if (documentType3 == 4) {
                                outputText = true;
                            }
                            ++i2;
                        }
                        if (outputText) {
                            boolean isBr = false;
                            ArrayList arrList1 = (ArrayList)UsersNoteTree.getInstance().getUsersNotes();
                            for (UsersNote usersNote : arrList1) {
                                xmlstr = usersNote.getSource();
                                xmlstr = this.html.isSelected() ? this.getHtml(xmlstr) : this.getText(xmlstr);
                                if (!xmlstr.trim().equals("")) {
                                    buf.append(xmlstr);
                                    buf.append(br);
                                    isBr = true;
                                }
                                if (!isBr) continue;
                                buf.append(br);
                            }
                        }
                    }
                    if (this.html.isSelected()) {
                        String writeStr;
                        if (htmlbase != null) {
                            writeStr = htmlbase;
                            writeStr = StringUtils.replaceString(writeStr, "$BODY$", buf.toString());
                        } else {
                            writeStr = buf.toString();
                        }
                        writer.write(writeStr);
                    } else {
                        writer.write(buf.toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block42;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected String getText(String str) {
        String xmlstr = StringUtils.replaceString(str, "<br>", "\n");
        Pattern pattern = Pattern.compile("<.+?>", 32);
        Matcher matcher = pattern.matcher(xmlstr);
        xmlstr = matcher.replaceAll("");
        xmlstr = xmlstr.trim();
        return xmlstr;
    }

    protected String getHtml(String str) {
        if (str.startsWith("<xml><html>") && str.endsWith("</html></xml>")) {
            return str.substring(str.indexOf("<xml><html>") + "<xml><html>".length(), str.lastIndexOf("</html></xml>"));
        }
        return null;
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("canceled");
            ExportDialog.this.dispose();
        }
    }

    private class DocumentTypeCheckBoxSelectAction
    implements ActionListener {
        private DocumentTypeCheckBoxSelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportDialog.this.scopePanel.setEnabled(true);
            ExportDialog.this.docType.setSelected(true);
        }
    }

    private class DocumentTypeSelectAction
    implements ActionListener {
        private DocumentTypeSelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExportDialog.this.text.isSelected()) {
                ExportDialog.this.firstidat.setSelected(false);
                ExportDialog.this.thirdidat.setSelected(false);
                ExportDialog.this.secondidat.setSelected(false);
                ExportDialog.this.scopePanel.setEnabled(false);
            } else {
                ExportDialog.this.scopePanel.setEnabled(true);
            }
            if (ExportDialog.this.allType.isSelected()) {
                ExportDialog.this.firstidat.setSelected(false);
                ExportDialog.this.thirdidat.setSelected(false);
                ExportDialog.this.secondidat.setSelected(false);
            }
        }
    }

    private class OKAction
    implements ActionListener {
        ArrayList<Integer> documentTypeList = new ArrayList();

        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExportDialog.this.firstidat.isSelected()) {
                this.documentTypeList.add(new Integer(1));
            }
            if (ExportDialog.this.thirdidat.isSelected()) {
                this.documentTypeList.add(new Integer(3));
            }
            if (ExportDialog.this.secondidat.isSelected()) {
                this.documentTypeList.add(new Integer(2));
            }
            if (ExportDialog.this.allType.isSelected()) {
                this.documentTypeList.add(new Integer(4));
            }
            if (ExportDialog.this.text.isSelected()) {
                this.documentTypeList.add(new Integer(5));
            }
            ExportDialog.this.export(this.documentTypeList, ExportDialog.this.caseSensitiveBox.isSelected());
        }
    }
}

