/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.menu;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import smart_gs.SmartGS;
import smart_gs.logical.Preference;
import smart_gs.menu.SetDefaultGsFileAction;
import smart_gs.menu.action.SetCurrentDirectoryAction;
import smart_gs.menu.action.SetDscFolderPathAction;
import smart_gs.menu.action.SetImageFolderPathAction;
import smart_gs.menu.action.SetRWBackgroundFilePathAction;
import smart_gs.swingui.ButtonFrame;
import smart_gs.util.GSImageFileUtils;
import smart_gs.util.GSPathStringGrammarChecker;

public class DirectorySettingWindow
extends ButtonFrame
implements ActionListener {
    private JPanel directorySettingPanel;
    private JTextField smart_gsTextField;
    private JPanel gsFolderPanel;
    private JTextField gsTextField;
    private JPanel imageFolderPanel;
    private JTextField imageTextField;
    private JPanel dscFolderPanel;
    private JTextField dscTextField;
    private JPanel defaultGsFilePanel;
    private JTextField defaultGsFileTextField;
    private JPanel RWBackgroundFilePanel;
    private JTextField RWBackgroundFileTextField;
    private static DirectorySettingWindow singleton = new DirectorySettingWindow();

    public static DirectorySettingWindow getInstance() {
        return singleton;
    }

    public DirectorySettingWindow() {
        super("Data Directories & Files Setting");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.directorySettingPanel = SmartGS.isDscFolderSetting() ? new JPanel(new GridLayout(5, 1)) : new JPanel(new GridLayout(4, 1));
        this.gsFolderPanel = new JPanel(new FlowLayout());
        this.gsFolderPanel.setBorder(new TitledBorder("GS Files"));
        this.gsTextField = new JTextField(20);
        this.gsTextField.setText(Preference.getInstance().getGsFolderPathString());
        JButton gsReferenceButton = new JButton("Select ...");
        SetCurrentDirectoryAction gsAction = new SetCurrentDirectoryAction();
        gsReferenceButton.addActionListener(gsAction);
        this.gsFolderPanel.add(this.gsTextField);
        this.gsFolderPanel.add(gsReferenceButton);
        this.imageFolderPanel = new JPanel(new FlowLayout());
        this.imageFolderPanel.setBorder(new TitledBorder("Images"));
        this.imageTextField = new JTextField(20);
        this.imageTextField.setText(Preference.getInstance().getImageFolderPathString());
        JButton imageReferenceButton = new JButton("Select ...");
        SetImageFolderPathAction imageAction = new SetImageFolderPathAction();
        imageReferenceButton.addActionListener(imageAction);
        this.imageFolderPanel.add(this.imageTextField);
        this.imageFolderPanel.add(imageReferenceButton);
        if (SmartGS.isDscFolderSetting()) {
            this.dscFolderPanel = new JPanel(new FlowLayout());
            this.dscFolderPanel.setBorder(new TitledBorder("DSC Folder"));
            this.dscTextField = new JTextField(20);
            this.dscTextField.setText(Preference.getInstance().getDscFolderPathString());
            JButton dscReferenceButton = new JButton("Select ...");
            SetDscFolderPathAction dscAction = new SetDscFolderPathAction();
            dscReferenceButton.addActionListener(dscAction);
            this.dscFolderPanel.add(this.dscTextField);
            this.dscFolderPanel.add(dscReferenceButton);
        }
        this.defaultGsFilePanel = new JPanel(new FlowLayout());
        this.defaultGsFilePanel.setBorder(new TitledBorder("Default GS File"));
        this.defaultGsFileTextField = new JTextField(20);
        this.defaultGsFileTextField.setText(Preference.getInstance().getDefaultGsFilePathString());
        JButton defaultGsFileReferenceButton = new JButton("Select ...");
        SetDefaultGsFileAction defaultGsFileAction = new SetDefaultGsFileAction();
        defaultGsFileReferenceButton.addActionListener(defaultGsFileAction);
        this.defaultGsFilePanel.add(this.defaultGsFileTextField);
        this.defaultGsFilePanel.add(defaultGsFileReferenceButton);
        this.RWBackgroundFilePanel = new JPanel(new FlowLayout());
        this.RWBackgroundFilePanel.setBorder(new TitledBorder("RW Background File"));
        this.RWBackgroundFileTextField = new JTextField(20);
        this.RWBackgroundFileTextField.setText(Preference.getInstance().getRWBackgroundFilePathString());
        JButton RWBackgroundFileReferenceButton = new JButton("Select ...");
        SetRWBackgroundFilePathAction RWBackgroundFileAction = new SetRWBackgroundFilePathAction();
        RWBackgroundFileReferenceButton.addActionListener(RWBackgroundFileAction);
        this.RWBackgroundFilePanel.add(this.RWBackgroundFileTextField);
        this.RWBackgroundFilePanel.add(RWBackgroundFileReferenceButton);
        this.directorySettingPanel.add(this.gsFolderPanel);
        this.directorySettingPanel.add(this.imageFolderPanel);
        if (SmartGS.isDscFolderSetting()) {
            this.directorySettingPanel.add(this.dscFolderPanel);
        }
        this.directorySettingPanel.add(this.defaultGsFilePanel);
        this.directorySettingPanel.add(this.RWBackgroundFilePanel);
        this.getContentPane().add((Component)this.directorySettingPanel, "Center");
        this.pack();
    }

    public void setSmart_gsTextField(String path) {
        this.smart_gsTextField.setText(path);
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        this.setGsTextField(String.valueOf(path) + "gs/");
        this.setImageTextField(String.valueOf(path) + "images/");
    }

    public void setGsTextField(String path) {
        this.gsTextField.setText(path);
    }

    public void setImageTextField(String path) {
        this.imageTextField.setText(path);
    }

    public void setDscTextField(String path) {
        this.dscTextField.setText(path);
    }

    public void setDefaultGsFileField(String path) {
        this.defaultGsFileTextField.setText(path);
    }

    public void setRWBackgroundFileField(String path) {
        this.RWBackgroundFileTextField.setText(path);
    }

    @Override
    public void ok() {
        boolean gsFilesCondition = false;
        boolean imagesCondtion = false;
        boolean dscCondtion = false;
        boolean defaultGsFileCondition = false;
        boolean rWBackgroundFileCondition = false;
        String gsFilesPathString = this.gsTextField.getText();
        String imagesPathString = this.imageTextField.getText();
        if (this.dscTextField == null) {
            this.dscTextField = this.imageTextField;
        }
        String dscPathString = this.dscTextField.getText();
        String defaultGsFilePathString = this.defaultGsFileTextField.getText();
        String rWBackgroundFilePathString = this.RWBackgroundFileTextField.getText();
        gsFilesCondition = GSPathStringGrammarChecker.isGsPath(gsFilesPathString);
        imagesCondtion = GSPathStringGrammarChecker.isGsPath(imagesPathString);
        dscCondtion = GSPathStringGrammarChecker.isGsPath(dscPathString);
        defaultGsFileCondition = GSPathStringGrammarChecker.isGsPath(defaultGsFilePathString) || defaultGsFilePathString.equals("");
        rWBackgroundFileCondition = GSPathStringGrammarChecker.isGsPath(rWBackgroundFilePathString);
        String errorMessage = "";
        String warningMessage = "";
        if (!gsFilesCondition) {
            errorMessage = String.valueOf(errorMessage) + "GS Files Path Error: not fit to the GS file path grammar.\n";
        } else {
            if (GSPathStringGrammarChecker.confusingSeparators(gsFilesPathString)) {
                warningMessage = String.valueOf(warningMessage) + "GS Files Path Warnig: both of \\ and / present.\n";
            }
            if (!GSPathStringGrammarChecker.endsWithSeparator(gsFilesPathString)) {
                warningMessage = String.valueOf(warningMessage) + "GS Files Path Warnig: it ends not with a separator.\n";
            }
        }
        if (!imagesCondtion) {
            errorMessage = String.valueOf(errorMessage) + "Images Path Error: not fit to the GS file path grammar.\n";
        } else {
            if (GSPathStringGrammarChecker.confusingSeparators(imagesPathString)) {
                warningMessage = String.valueOf(warningMessage) + "Images Path Warnig: both of \\ and / present.\n";
            }
            if (!GSPathStringGrammarChecker.endsWithSeparator(imagesPathString)) {
                warningMessage = String.valueOf(warningMessage) + "Images Path Warnig: it ends not with a separator.\n";
            }
        }
        if (!dscCondtion) {
            errorMessage = String.valueOf(errorMessage) + "DSC Folder Path Error: not fit to the GS file path grammar.\n";
        } else {
            if (GSPathStringGrammarChecker.confusingSeparators(dscPathString)) {
                warningMessage = String.valueOf(warningMessage) + "DSC Folder Path Warnig: both of \\ and / present.\n";
            }
            if (!GSPathStringGrammarChecker.endsWithSeparator(dscPathString)) {
                warningMessage = String.valueOf(warningMessage) + "DSC Folder Path Warnig: it ends not with a separator.\n";
            }
        }
        if (!defaultGsFileCondition) {
            errorMessage = String.valueOf(errorMessage) + "Default GS File Path Error: not fit to the GS file path grammar.\n";
        } else if (GSPathStringGrammarChecker.confusingSeparators(defaultGsFilePathString)) {
            warningMessage = String.valueOf(warningMessage) + "Default GS File Path Warnig: both of \\ and / present.\n";
        }
        if (!(defaultGsFilePathString.endsWith(".gs") || defaultGsFilePathString.endsWith(".gsx") || defaultGsFilePathString.equals(""))) {
            errorMessage = String.valueOf(errorMessage) + "Default GS File Name Error: must ends with \".gs\" or \".gsx\".\n";
        }
        if (!rWBackgroundFileCondition) {
            errorMessage = String.valueOf(errorMessage) + "RW Backgroundfile Path Error: not fit to the GS file path grammar.\n";
        } else if (GSPathStringGrammarChecker.confusingSeparators(rWBackgroundFilePathString)) {
            warningMessage = String.valueOf(warningMessage) + "RW Backgroundfile Path Warnig: both of \\ and / present.\n";
        }
        if (!GSImageFileUtils.isAcceptable(rWBackgroundFilePathString)) {
            errorMessage = String.valueOf(errorMessage) + "Default GS File Name Error: must ends with one of " + GSImageFileUtils.getDescription() + ".\n";
        }
        if (!errorMessage.isEmpty()) {
            JOptionPane.showMessageDialog(null, String.valueOf(errorMessage) + warningMessage, "message", 1);
            return;
        }
        Preference.getInstance().setGsFolderPathString(gsFilesPathString);
        Preference.getInstance().setImageFolderPathString(imagesPathString);
        Preference.getInstance().setDscFolderPathString(dscPathString);
        Preference.getInstance().setDefaultGsFilePath(defaultGsFilePathString);
        Preference.getInstance().setRWBackgroundFilePathString(rWBackgroundFilePathString);
        JOptionPane.showMessageDialog(null, "Pathes are set.\nReboot SMAR-GS to validate path settings.\n" + warningMessage, "message", 1);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    class GsFileNameFormatException
    extends Exception {
        public GsFileNameFormatException() {
            singleton.setAlwaysOnTop(false);
            JOptionPane.showConfirmDialog(null, "GsFile must has extension \".gs or .gsx\"", "error", 0, 2);
            singleton.setAlwaysOnTop(true);
        }
    }

    class RWBackgroundNameFormatException
    extends Exception {
        public RWBackgroundNameFormatException() {
            singleton.setAlwaysOnTop(false);
            JOptionPane.showConfirmDialog(null, "RWBackground must be image file", "error", 0, 2);
            singleton.setAlwaysOnTop(true);
        }
    }
}

