/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.io.File;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.drawing_tool.view.AnchorView;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.PolygonView;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.AnchorTextSegment;
import smart_gs.logical.ConvertGS;
import smart_gs.logical.FirstIDAT;
import smart_gs.logical.GSResource;
import smart_gs.logical.IDAT;
import smart_gs.logical.Region;
import smart_gs.logical.SecondIDAT;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.TextSegment;
import smart_gs.logical.ThirdIDAT;
import smart_gs.logical.URISolver;
import smart_gs.logical.UsersNote;
import smart_gs.logical.Zombie;
import smart_gs.logical.region.AnchorRegion;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.util.GSStandardPath;

public class XML2ResourceConverter {
    public static GSResource convert(Element element) {
        String tagname = element.getNodeName();
        if (tagname.equals("standardDocument")) {
            return XML2ResourceConverter.getStandardDocument(element);
        }
        if (tagname.equals("usersNote")) {
            return XML2ResourceConverter.getUsersNote(element);
        }
        String uri = element.getAttribute("uri");
        return URISolver.getRegion(uri);
    }

    public static Region getRegion(Spread spread, Element element) {
        String name = element.getAttribute("name");
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String oldVersionURI = element.getAttribute("oldVersionURI");
        String version = element.getAttribute("version");
        String protection = element.getAttribute("protection");
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element elem;
            String tagname;
            if (nodes.item(i).getNodeType() == 1 && (tagname = (elem = (Element)nodes.item(i)).getNodeName()).equals("view")) {
                String type = elem.getAttribute("type");
                View view = null;
                if (type.equals("rect")) {
                    view = RectangleView.restore(elem);
                    Region region = new Region(spread, view, uri, originalURI, version);
                    region.setOldVersionURI(oldVersionURI);
                    region.setName(name);
                    region.setProtection(protection);
                    region.getView().setIsProtected(protection);
                    return region;
                }
                if (type.equals("marker")) {
                    view = MarkerView.restore(elem);
                    Region region = new Region(spread, view, uri, originalURI, version);
                    region.setOldVersionURI(oldVersionURI);
                    region.setName(name);
                    region.setProtection(protection);
                    region.getView().setIsProtected(protection);
                    return region;
                }
                if (type.equals("line")) {
                    view = LineView.restore(elem);
                    Region region = new Region(spread, view, uri, originalURI, version);
                    region.setOldVersionURI(oldVersionURI);
                    region.setName(name);
                    region.setProtection(protection);
                    region.getView().setIsProtected(protection);
                    return region;
                }
                if (type.equals("polygon")) {
                    view = PolygonView.restore(elem);
                    Region region = new Region(spread, view, uri, originalURI, version);
                    region.setOldVersionURI(oldVersionURI);
                    region.setName(name);
                    region.setProtection(protection);
                    region.getView().setIsProtected(protection);
                    return region;
                }
                if (type.equals("memopad")) {
                    view = MemoPadView.restore(elem);
                    Region region = new Region(spread, view, uri, originalURI, version);
                    region.setOldVersionURI(oldVersionURI);
                    region.setName(name);
                    region.setProtection(protection);
                    region.getView().setIsProtected(protection);
                    return region;
                }
                if (type.equals("bookmark")) {
                    view = BookmarkView.restore(elem);
                    BookmarkRegion region = new BookmarkRegion(spread, view, uri, originalURI, version);
                    region.setOldVersionURI(oldVersionURI);
                    region.setName(name);
                    region.setProtection(protection);
                    region.getView().setIsProtected(protection);
                    return region;
                }
                if (type.equals("anchor")) {
                    view = AnchorView.restore(elem);
                    AnchorRegion region = new AnchorRegion(spread, view, uri, originalURI, version);
                    region.setOldVersionURI(oldVersionURI);
                    region.setName(name);
                    region.setProtection(protection);
                    region.getView().setIsProtected(protection);
                    return region;
                }
            }
            ++i;
        }
        return null;
    }

    public static IDAT getIDAT(Spread spread, Element element) {
        String type = element.getAttribute("type");
        String source = element.getAttribute("source");
        if (!source.startsWith("<xml><html>")) {
            try {
                ConvertGS convertGS = new ConvertGS(source);
                source = convertGS.parser();
                source = source.equals("") ? "<xml><html></html></xml>" : "<xml><html>" + source + "</html></xml>";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String oldVersionURI = element.getAttribute("oldVersionURI");
        String version = element.getAttribute("version");
        IDAT doc = null;
        if (type.equals("1")) {
            doc = new FirstIDAT(spread, uri, originalURI, version);
        } else if (type.equals("2")) {
            doc = new SecondIDAT(spread, uri, originalURI, version);
        } else if (type.equals("3")) {
            doc = new ThirdIDAT(spread, uri, originalURI, version);
        }
        doc.setOldVersionURI(oldVersionURI);
        doc.setSource(source);
        NodeList list = element.getElementsByTagName("segment");
        int i = 0;
        while (i < list.getLength()) {
            TextSegment segment;
            Element elm = (Element)list.item(i);
            if (elm.getAttribute("tagname").equals("anchor")) {
                segment = AnchorTextSegment.restore(elm, spread);
                String segmentURI = segment.getURI();
                doc.addTextSegment(segment);
                segment.setSmartDocument(doc);
                String regionURI = "smart://" + segmentURI.substring(segmentURI.indexOf("@anchor") + 1);
                AnchorRegion region = (AnchorRegion)spread.getRegionByURI(regionURI);
                ((AnchorTextSegment)segment).setAnchorRegion(region);
                if (region != null) {
                    region.setAnchorTextSegment((AnchorTextSegment)segment);
                }
            } else {
                segment = TextSegment.restore(elm);
                doc.addTextSegment(segment);
                segment.setSmartDocument(doc);
            }
            ++i;
        }
        return doc;
    }

    public static Spread getSpread(SpreadDirectory parent, File parentpath, Element element) {
        String name = element.getAttribute("name");
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String oldVersionURI = element.getAttribute("oldVersionURI");
        String version = element.getAttribute("version");
        String[] token = GSStandardPath.standardizeDirName(element.getAttribute("filename")).split("/");
        String imageFileName = token[token.length - 1];
        File filepath = new File(parentpath, imageFileName);
        Spread spread = new Spread(parent, filepath, uri, originalURI, version);
        spread.setOldVersionURI(oldVersionURI);
        spread.setName(name);
        spread.setFirstIDATName(element.getAttribute("firstIDATName"));
        spread.setSecondIDATName(element.getAttribute("secondIDATName"));
        spread.setThirdIDATName(element.getAttribute("thirdIDATName"));
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getNodeType() == 1) {
                Element elem = (Element)nodes.item(i);
                String tagname = elem.getNodeName();
                if (tagname.equals("region")) {
                    Region region = XML2ResourceConverter.getRegion(spread, elem);
                    spread.addRegion(region);
                } else if (tagname.equals("spreadDocument")) {
                    IDAT iDAT = XML2ResourceConverter.getIDAT(spread, elem);
                    if (iDAT.getType() == 2) {
                        spread.setSecondIDAT((SecondIDAT)iDAT);
                    } else if (iDAT.getType() == 1) {
                        spread.setFirstIDAT((FirstIDAT)iDAT);
                    } else if (iDAT.getType() == 3) {
                        spread.setThirdIDAT((ThirdIDAT)iDAT);
                    }
                }
            }
            ++i;
        }
        return spread;
    }

    public static TextSegment getTextSegment(Element element, Spread spread) {
        String tagname = element.getAttribute("tagname");
        String id = element.getAttribute("id");
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String oldVersionURI = element.getAttribute("oldVersionURI");
        String version = element.getAttribute("version");
        if (tagname.equals("anchor")) {
            AnchorTextSegment segment = new AnchorTextSegment(new Integer(id), uri, originalURI, version);
            String anchorURI = "smart://" + uri.substring(uri.indexOf("@anchor") + 1);
            AnchorRegion region = (AnchorRegion)spread.getRegionByURI(anchorURI);
            segment.setAnchorRegion(region);
            region.setAnchorTextSegment(segment);
            return segment;
        }
        TextSegment segment = new TextSegment(tagname, new Integer(id), uri, originalURI, version);
        segment.setOldVersionURI(oldVersionURI);
        return segment;
    }

    private static StandardTextDocument getStandardDocument(Element element) {
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String oldVersionURI = element.getAttribute("oldVersionURI");
        String version = element.getAttribute("version");
        String name = element.getAttribute("name");
        String source = element.getAttribute("source");
        NodeList list = element.getElementsByTagName("segment");
        StandardTextDocument doc = new StandardTextDocument(source, name, uri, originalURI, version);
        doc.setOldVersionURI(oldVersionURI);
        int i = 0;
        while (i < list.getLength()) {
            TextSegment segment = TextSegment.restore((Element)list.item(i));
            doc.addTextSegment(segment);
            segment.setSmartDocument(doc);
            ++i;
        }
        return doc;
    }

    public static UsersNote getUsersNote(Element element) {
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String oldVersionURI = element.getAttribute("oldVersionURI");
        String version = element.getAttribute("version");
        String name = element.getAttribute("name");
        String source = element.getAttribute("source");
        if (!source.startsWith("<xml><html>")) {
            try {
                ConvertGS convertGS = new ConvertGS(source);
                source = convertGS.parser();
                source = source.equals("") ? "<xml><html></html></xml>" : "<xml><html>" + source + "</html></xml>";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        NodeList list = element.getElementsByTagName("segment");
        UsersNote usersNote = new UsersNote();
        usersNote.setSource(source);
        usersNote.setURIs(uri, originalURI);
        usersNote.setOldVersionURI(oldVersionURI);
        usersNote.setVersion(version);
        usersNote.setName(name);
        int i = 0;
        while (i < list.getLength()) {
            TextSegment segment = TextSegment.restore((Element)list.item(i));
            usersNote.addTextSegment(segment);
            segment.setSmartDocument(usersNote);
            ++i;
        }
        return usersNote;
    }

    public Zombie getZombie(Element element) {
        String uri = element.getAttribute("uri");
        String originalURI = element.getAttribute("originalURI");
        String version = element.getAttribute("version");
        String deadURI = element.getAttribute("deadURI");
        Zombie zombie = new Zombie(deadURI);
        zombie.setURI(uri);
        zombie.setDeadURI(deadURI);
        zombie.setOriginalURI(originalURI);
        zombie.setVersion(version);
        return zombie;
    }
}

