/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.logical.DefaultMutableTreeNodeNameComparator;
import smart_gs.logical.GSResource;
import smart_gs.logical.GSResourceNameComparator;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadSelectionListManager;
import smart_gs.logical.URICreator;
import smart_gs.logical.filter.ImageFileDirFilterForSpreadTree;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.logical.visitor.CreateXMLElementVisitor;
import smart_gs.reasoning_web.logical.LinkRemover;
import smart_gs.spread_selection.IndexChangeTable;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.GSPathStringGrammarChecker;
import smart_gs.util.GSStandardPath;
import smart_gs.util.StringUtils;

public class SpreadTree
extends JTree
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private static SpreadTree singleton = new SpreadTree();
    private List<Spread> registeredSpreads;
    private List<SpreadDirectory> registeredSpreadDirectories;
    private TreePath[] selectedPaths;
    private static String IMAGE_FOLDER_PATH_STRING;
    private static String DSC_FOLDER_PATH_STRING;
    private static File IMAGE_FOLDER_PATH;
    private static File DSC_FOLDER_PATH;
    private SpreadDirectory root;
    private DefaultMutableTreeNode rootNode;
    private static final String NAME = "SpreadTree";
    private static final DataFlavor localObjectFlavor;
    private static final DataFlavor[] supportedFlavors;
    protected DragSource dragSource;
    protected DropTarget dropTarget;
    TreeNode dropTargetNode = null;
    TreeNode draggedNode = null;
    TreePath dragsourceTreePath = null;
    protected HashMap<String, String> allowImageMap = new HashMap();

    static {
        localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref", NAME);
        supportedFlavors = new DataFlavor[]{localObjectFlavor};
    }

    private SpreadTree() {
        super(new DefaultMutableTreeNode("root"));
        String[] formatNames = ImageIO.getReaderFormatNames();
        int i = 0;
        while (i < formatNames.length) {
            this.allowImageMap.put(formatNames[i].toLowerCase(), formatNames[i].toLowerCase());
            ++i;
        }
        Spread.resetIndex();
        this.registeredSpreads = new ArrayList<Spread>();
        this.registeredSpreadDirectories = new ArrayList<SpreadDirectory>();
        IMAGE_FOLDER_PATH_STRING = CanonicalPathString.get(new File(Preference.getInstance().getImageFolderPathString()));
        IMAGE_FOLDER_PATH = new File(IMAGE_FOLDER_PATH_STRING);
        DSC_FOLDER_PATH_STRING = CanonicalPathString.get(new File(Preference.getInstance().getDscFolderPathString()));
        DSC_FOLDER_PATH = new File(DSC_FOLDER_PATH_STRING);
        if (!IMAGE_FOLDER_PATH_STRING.equals("")) {
            this.root = new SpreadDirectory("root", new File(IMAGE_FOLDER_PATH_STRING));
            this.rootNode = new DefaultMutableTreeNode(this.root);
            ((DefaultTreeModel)this.getModel()).setRoot(this.rootNode);
            this.updateModel();
        }
        this.getSelectionModel().setSelectionMode(4);
        this.setCellRenderer(new SpreadTreeCellRenderer());
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dropTarget = new DropTarget(this, this);
    }

    public List<File> getDSCFiles() {
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        while (i < this.registeredSpreads.size()) {
            if (this.registeredSpreads.get(i).hasDscFile()) {
                files.add(this.registeredSpreads.get(i).getDscFile());
            }
            ++i;
        }
        return files;
    }

    public void loadAllImages() {
        int i = 0;
        while (i < this.registeredSpreads.size()) {
            if (this.registeredSpreads.get(i).hasDscFile()) {
                this.registeredSpreads.get(i).loadImage();
            }
            ++i;
        }
    }

    public static SpreadTree getInstance() {
        return singleton;
    }

    public List<Spread> getSpreads() {
        return this.registeredSpreads;
    }

    public void registorSpread(Spread spread) {
        this.registeredSpreads.add(spread);
    }

    public List<Spread> getDSCSpreads() {
        ArrayList<Spread> results = new ArrayList<Spread>();
        int i = 0;
        while (i < this.registeredSpreads.size()) {
            if (this.registeredSpreads.get(i).hasDscFile()) {
                results.add(this.registeredSpreads.get(i));
            }
            ++i;
        }
        return results;
    }

    public TreePath[] getSelectedPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public SpreadDirectory getRootSpreadDirectory() {
        return this.root;
    }

    public boolean isRegistered(File file) {
        int i = 0;
        while (i < this.registeredSpreadDirectories.size()) {
            if (this.registeredSpreadDirectories.get(i).getFile().equals(file)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.registeredSpreads.size()) {
            if (this.registeredSpreads.get(i).getFile().equals(file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SpreadDirectory getCurrentDirectory() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        if (path == null) {
            return (SpreadDirectory)((DefaultMutableTreeNode)this.getModel().getRoot()).getUserObject();
        }
        Object selectedObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        while (!(selectedObject instanceof SpreadDirectory)) {
            path = path.getParentPath();
            selectedObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        return (SpreadDirectory)selectedObject;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        if (path == null) {
            return this.rootNode;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    public boolean isImage(File file) {
        String ext;
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        return index >= 0 && this.allowImageMap.containsKey((ext = fileName.substring(index + 1)).toLowerCase());
    }

    private void loadImages(SpreadDirectory parent, boolean sort) {
        File[] files = parent.getFile().listFiles(new ImageFileDirFilterForSpreadTree());
        if (sort) {
            Arrays.sort(files, new SpreadFileComparator());
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                SpreadDirectory directory;
                if (this.isRegistered(file)) {
                    directory = this.getDirectory(file);
                    this.loadImages(directory, sort);
                } else {
                    directory = new SpreadDirectory(parent, file.getName(), file);
                    this.registeredSpreadDirectories.add(directory);
                    parent.addResource(directory);
                    this.loadImages(directory, sort);
                }
            } else if (!this.isRegistered(file) && this.isImage(file)) {
                Spread spread = new Spread(parent, file);
                parent.addResource(spread);
                this.registeredSpreads.add(spread);
            }
            ++i;
        }
    }

    private SpreadDirectory getDirectory(File file) {
        int i = 0;
        while (i < this.registeredSpreadDirectories.size()) {
            if (this.registeredSpreadDirectories.get(i).getFile().equals(file)) {
                return this.registeredSpreadDirectories.get(i);
            }
            ++i;
        }
        return null;
    }

    public void updateModel() {
        this.root.setTree(this.rootNode);
        ((DefaultTreeModel)this.getModel()).setRoot(this.rootNode);
        ((DefaultTreeModel)this.getModel()).reload();
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public void restore(Element element) {
        NodeList list = element.getElementsByTagName("directory");
        if (list.getLength() < 1) {
            System.out.println("list error");
            return;
        }
        Element rootElement = (Element)list.item(0);
        this.registeredSpreads.clear();
        this.registeredSpreadDirectories.clear();
        Spread.resetIndex();
        this.rootNode.removeAllChildren();
        String imageFolderPath = Preference.getInstance().getImageFolderPathString();
        String name = rootElement.getAttribute("name");
        String uri = rootElement.getAttribute("uri");
        String originalURI = rootElement.getAttribute("originalURI");
        String version = rootElement.getAttribute("version");
        File filepath = new File(imageFolderPath);
        this.root = new SpreadDirectory("root", filepath, uri, originalURI, version);
        this.root.setVersion(version);
        this.root.setName(name);
        this.rootNode.setUserObject(this.root);
        this.root.restore(rootElement, filepath);
        this.registeredSpreads = this.root.getSpreads();
        this.registeredSpreadDirectories = this.root.getSpreadDirectorys();
        this.updateModel();
    }

    public void save(Document document, Element parent) {
        Element element = document.createElement("spreadTree");
        parent.appendChild(element);
        CreateXMLElementVisitor visitor = new CreateXMLElementVisitor(document);
        this.root.accept(visitor);
        element.appendChild(visitor.getLastElement());
    }

    public void registorSpreadDirectory(SpreadDirectory directory) {
        this.registeredSpreadDirectories.add(directory);
    }

    public Spread getSpreadByResourceURI(String uri) {
        int i = 0;
        while (i < this.registeredSpreads.size()) {
            if (this.extractSpreadURI(uri).equals(URICreator.getURIWithoutHeader(this.registeredSpreads.get(i))) || this.extractSpreadURI(uri).equals(this.registeredSpreads.get(i).getOriginalURI().substring("smart://".length())) || uri.equals(this.registeredSpreads.get(i).getURI())) {
                return this.registeredSpreads.get(i);
            }
            ++i;
        }
        return null;
    }

    private Object extractSpreadURI(String uri) {
        return uri.substring(uri.indexOf("^spread") + 1);
    }

    public Spread getSpreadByURI(String uri) {
        int i = 0;
        while (i < this.registeredSpreads.size()) {
            if (this.registeredSpreads.get(i).getURI().equals(uri)) {
                return this.registeredSpreads.get(i);
            }
            ++i;
        }
        return null;
    }

    public Spread getSpreadByURI2(String uri) {
        int i = 0;
        while (i < this.registeredSpreads.size()) {
            String srcurl = this.registeredSpreads.get(i).getURI();
            if ((srcurl = GSStandardPath.toStandardOnCurrentOS(srcurl)).indexOf(uri) != -1) {
                return this.registeredSpreads.get(i);
            }
            ++i;
        }
        return null;
    }

    public void export(Writer writer) throws IOException {
        int i = 0;
        while (i < this.registeredSpreads.size()) {
            Spread spread = this.registeredSpreads.get(i);
            boolean isBr = false;
            String xmlstr = spread.getFirstIDAT().getSource();
            xmlstr = StringUtils.replaceString(xmlstr, "<br>", "\n");
            Pattern pattern = Pattern.compile("<.+?>", 32);
            Matcher matcher = pattern.matcher(xmlstr);
            xmlstr = matcher.replaceAll("");
            if (!(xmlstr = xmlstr.trim()).trim().equals("")) {
                writer.write(xmlstr);
                writer.write("\n");
                isBr = true;
            }
            xmlstr = spread.getSecondIDAT().getSource();
            xmlstr = StringUtils.replaceString(xmlstr, "<br>", "\n");
            pattern = Pattern.compile("<.+?>", 32);
            matcher = pattern.matcher(xmlstr);
            xmlstr = matcher.replaceAll("");
            if (!(xmlstr = xmlstr.trim()).trim().equals("")) {
                writer.write(xmlstr);
                writer.write("\n");
                isBr = true;
            }
            xmlstr = spread.getThirdIDAT().getSource();
            xmlstr = StringUtils.replaceString(xmlstr, "<br>", "\n");
            pattern = Pattern.compile("<.+?>", 32);
            matcher = pattern.matcher(xmlstr);
            xmlstr = matcher.replaceAll("");
            if (!(xmlstr = xmlstr.trim()).trim().equals("")) {
                writer.write(xmlstr);
                writer.write("\n");
                isBr = true;
            }
            if (isBr) {
                writer.write("\n");
            }
            ++i;
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dropTargetNode = null;
        this.draggedNode = null;
        this.dragsourceTreePath = null;
        WorkspaceWindow.setUpdated(true);
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        this.selectedPaths = null;
        this.selectedPaths = this.getSelectedPaths();
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Object droppedObject;
        DataFlavor[] f = dtde.getCurrentDataFlavors();
        boolean isDataFlavorSupported = f[0].getHumanPresentableName().equals(NAME);
        if (!isDataFlavorSupported) {
            this.rejectDrag(dtde);
            return;
        }
        Point pt = dtde.getLocation();
        TreePath path = this.getPathForLocation(pt.x, pt.y);
        Rectangle r2 = new Rectangle(pt.x, pt.y, 10, 10);
        Rectangle r1 = new Rectangle(pt.x - 10, pt.y - 10, 10, 10);
        this.scrollRectToVisible(r1);
        this.scrollRectToVisible(r2);
        if (path == null) {
            this.rejectDrag(dtde);
            return;
        }
        try {
            droppedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
        }
        catch (Exception ex) {
            this.rejectDrag(dtde);
            return;
        }
        if (path == null || !path.getParentPath().toString().equals(this.dragsourceTreePath.getParentPath().toString())) {
            this.rejectDrag(dtde);
            return;
        }
        this.selectedPaths = null;
        this.selectedPaths = this.getSelectedPaths();
        if (!this.areSelectedPathsInSameNode(this.selectedPaths)) {
            this.rejectDrag(dtde);
            return;
        }
        DefaultMutableTreeNode droppedNode = (DefaultMutableTreeNode)droppedObject;
        DefaultMutableTreeNode parentOfDroppedNode = (DefaultMutableTreeNode)droppedNode.getParent();
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode parentOfTargetNode = (DefaultMutableTreeNode)targetNode.getParent();
        while (parentOfTargetNode != null) {
            if (droppedNode.equals(parentOfTargetNode)) {
                this.rejectDrag(dtde);
                return;
            }
            parentOfTargetNode = (DefaultMutableTreeNode)parentOfTargetNode.getParent();
        }
        this.dropTargetNode = targetNode;
        dtde.acceptDrag(dtde.getDropAction());
        this.repaint();
    }

    private boolean areSelectedPathsInSameNode(TreePath[] selectedPaths2) {
        int size;
        if (this.selectedPaths != null && (size = this.selectedPaths.length) != 0) {
            DefaultMutableTreeNode parentOfFirstSelectedNode = (DefaultMutableTreeNode)this.selectedPaths[0].getParentPath().getLastPathComponent();
            int i = 1;
            while (i < size) {
                DefaultMutableTreeNode parentOfSelectedNode = (DefaultMutableTreeNode)this.selectedPaths[i].getParentPath().getLastPathComponent();
                if (!parentOfSelectedNode.equals(parentOfFirstSelectedNode)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        boolean droppedNodeIsSelected;
        Object droppedObject;
        try {
            droppedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.dropComplete(false);
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        Point p = dtde.getLocation();
        TreePath targetPath = this.getPathForLocation(p.x, p.y);
        if (targetPath == null || !(droppedObject instanceof MutableTreeNode)) {
            dtde.dropComplete(false);
            return;
        }
        DefaultMutableTreeNode droppedNode = (DefaultMutableTreeNode)droppedObject;
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)targetPath.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        if (targetNode.equals(droppedNode)) {
            dtde.dropComplete(false);
            return;
        }
        dtde.acceptDrop(2);
        TreePath pathOfDroppedNode = new TreePath(droppedNode.getPath());
        int size = -1;
        if (this.selectedPaths == null) {
            droppedNodeIsSelected = false;
        } else {
            size = this.selectedPaths.length;
            droppedNodeIsSelected = false;
            int i = 0;
            while (i < size) {
                if (pathOfDroppedNode.equals(this.selectedPaths[i])) {
                    droppedNodeIsSelected = true;
                    int droppedNodeIndexInSelection = i;
                    break;
                }
                ++i;
            }
        }
        List<GSResource> resources = ((SpreadDirectory)parentNode.getUserObject()).getResources();
        int droppedNodeIndex = model.getIndexOfChild(parentNode, droppedNode);
        int targetNodeIndex = model.getIndexOfChild(parentNode, targetNode);
        if (!droppedNodeIsSelected || size == 1) {
            model.removeNodeFromParent(droppedNode);
            GSResource elm = resources.get(droppedNodeIndex);
            resources.remove(droppedNodeIndex);
            int insertionPointIndex = 0;
            if (droppedNodeIndex < targetNodeIndex) {
                insertionPointIndex = targetNodeIndex - 1;
            } else if (droppedNodeIndex > targetNodeIndex) {
                insertionPointIndex = targetNodeIndex;
            }
            resources.add(insertionPointIndex, elm);
            model.insertNodeInto(droppedNode, parentNode, insertionPointIndex);
            this.setSelectionPath(pathOfDroppedNode);
            ((SpreadDirectory)parentNode.getUserObject()).setResources(resources);
        } else {
            int insertPointIndex = targetNodeIndex;
            MutableTreeNode[] tmpForJTree = new MutableTreeNode[size];
            GSResource[] tmpForSpreadTree = new GSResource[size];
            int i = 0;
            while (i < size) {
                MutableTreeNode selectedNode;
                tmpForJTree[i] = selectedNode = (MutableTreeNode)this.selectedPaths[i].getLastPathComponent();
                tmpForSpreadTree[i] = resources.get(model.getIndexOfChild(parentNode, selectedNode));
                ++i;
            }
            int insertionPointIndex = -1;
            int offset = 0;
            int i2 = 0;
            while (i2 < size) {
                insertionPointIndex = targetNodeIndex;
                MutableTreeNode selectedNode = (MutableTreeNode)this.selectedPaths[i2].getLastPathComponent();
                int selectedNodeIndex = model.getIndexOfChild(this.selectedPaths[i2].getParentPath().getLastPathComponent(), selectedNode);
                GSResource elm = resources.get(selectedNodeIndex);
                model.removeNodeFromParent(selectedNode);
                resources.remove(selectedNodeIndex);
                if (selectedNodeIndex < insertionPointIndex) {
                    ++offset;
                }
                ++i2;
            }
            insertionPointIndex -= offset;
            i2 = size - 1;
            while (i2 >= 0) {
                resources.add(insertionPointIndex, tmpForSpreadTree[i2]);
                model.insertNodeInto(tmpForJTree[i2], parentNode, insertionPointIndex);
                --i2;
            }
            this.setSelectionPaths(this.selectedPaths);
            ((SpreadDirectory)parentNode.getUserObject()).setResources(resources);
        }
        new AutomaticNumbering().execAndAdjustSpreadSelectionLists(this.rootNode);
        WorkspaceWindow.getInstance().updateMoveToolBar();
        WorkspaceWindow.setUpdated(true);
        this.repaint();
        dtde.dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        TreePath path = this.getPathForLocation(clickPoint.x, clickPoint.y);
        if (path == null || path.getParentPath() == null) {
            return;
        }
        this.dragsourceTreePath = path;
        this.draggedNode = (TreeNode)path.getLastPathComponent();
        if (this.draggedNode instanceof DefaultMutableTreeNode) {
            SpreadTreeTransferable trans = new SpreadTreeTransferable(this.draggedNode);
            this.dragSource.startDrag(dge, Cursor.getDefaultCursor(), trans, this);
        }
    }

    private void rejectDrag(DropTargetDragEvent dtde) {
        dtde.rejectDrag();
        this.dropTargetNode = null;
        this.repaint();
    }

    public Spread getSpreadByIndex(Integer index) {
        List<Spread> toseek = this.getSpreads();
        Spread result = null;
        int i = toseek.size() - 1;
        while (i >= 0) {
            if (toseek.get(i).getPageIndex() == index.intValue()) {
                result = toseek.get(i);
            }
            --i;
        }
        return result;
    }

    public List<GSResource> getBookmarks() {
        ArrayList<GSResource> bookmarks = new ArrayList<GSResource>();
        for (Spread spread : this.registeredSpreads) {
            for (Region region : spread.getRegions()) {
                if (region.getView().getType() != 6) continue;
                bookmarks.add((BookmarkRegion)region);
            }
        }
        return bookmarks;
    }

    public void sortSelectedItemsByName() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        this.selectedPaths = null;
        this.selectedPaths = this.getSelectedPaths();
        int size = this.selectedPaths.length;
        if (size == 0) {
            return;
        }
        if (!this.areSelectedPathsInSameNode(this.selectedPaths)) {
            JOptionPane.showMessageDialog(singleton, "Items must be in the same directory");
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.selectedPaths[0].getParentPath().getLastPathComponent();
        List<GSResource> resources = ((SpreadDirectory)parentNode.getUserObject()).getResources();
        int[] indexes = new int[size];
        int i = 0;
        while (i < size) {
            indexes[i] = parentNode.getIndex((DefaultMutableTreeNode)this.selectedPaths[i].getLastPathComponent());
            ++i;
        }
        Arrays.sort(indexes);
        i = 0;
        while (i < size - 1) {
            if (indexes[i + 1] > indexes[i] + 1) {
                JOptionPane.showMessageDialog(singleton, "Items must be consective:" + indexes[i] + "," + indexes[i + 1] + "\n");
                return;
            }
            ++i;
        }
        int insertionPointIndex = indexes[0];
        MutableTreeNode[] tmpForJTree = new MutableTreeNode[size];
        GSResource[] tmpForSpreadTree = new GSResource[size];
        int i2 = 0;
        while (i2 < size) {
            MutableTreeNode selectedNode;
            tmpForJTree[i2] = selectedNode = (MutableTreeNode)this.selectedPaths[i2].getLastPathComponent();
            tmpForSpreadTree[i2] = resources.get(model.getIndexOfChild(parentNode, selectedNode));
            ++i2;
        }
        Arrays.sort(tmpForJTree, new DefaultMutableTreeNodeNameComparator());
        Arrays.sort(tmpForSpreadTree, new GSResourceNameComparator());
        i2 = size - 1;
        while (i2 >= 0) {
            parentNode.remove(insertionPointIndex + i2);
            resources.remove(insertionPointIndex + i2);
            --i2;
        }
        i2 = size - 1;
        while (i2 >= 0) {
            resources.add(insertionPointIndex, tmpForSpreadTree[i2]);
            model.insertNodeInto(tmpForJTree[i2], parentNode, insertionPointIndex);
            --i2;
        }
        ((SpreadDirectory)parentNode.getUserObject()).setResources(resources);
        new AutomaticNumbering().execAndAdjustSpreadSelectionLists(this.rootNode);
        WorkspaceWindow.setUpdated(true);
        this.updateUI();
        this.repaint();
    }

    public DefaultMutableTreeNode makeSpreadDirectory(DefaultMutableTreeNode parentTreeNode, String name) {
        if (!GSPathStringGrammarChecker.isFileDirIdentifier(name)) {
            JOptionPane.showMessageDialog(null, String.format("Error: name %s cannot be used in SMART-GS.", name));
            return null;
        }
        if (name.equals(".") || name.equals("..")) {
            JOptionPane.showMessageDialog(null, String.format("Error: name %s is not allowed to avoid confusion.", name));
            return null;
        }
        if (name.equals("DscLocation")) {
            JOptionPane.showMessageDialog(null, String.format("Error: name %s is used by SMART-GS system, and so cannot be used.", name));
            return null;
        }
        Enumeration<TreeNode> enm = parentTreeNode.children();
        while (enm.hasMoreElements()) {
            String tmp = ((GSResource)((DefaultMutableTreeNode)enm.nextElement()).getUserObject()).getName();
            if (!tmp.equals(name)) continue;
            JOptionPane.showMessageDialog(null, String.format("Error: name %s already used in %s\n.", tmp, SpreadTree.makePathString(parentTreeNode.getPath())));
            return null;
        }
        SpreadDirectory parentSpreadDir = (SpreadDirectory)parentTreeNode.getUserObject();
        File newDir = new File(parentSpreadDir.getFile(), name);
        if (!newDir.exists()) {
            boolean check = newDir.mkdir();
            if (!check) {
                System.out.printf("Error: directory %s could not be made.\n", CanonicalPathString.get(newDir));
                return null;
            }
            File newDscDir = new File(newDir, "dsc");
            check = newDscDir.mkdir();
            if (!check) {
                System.out.printf("Error: dsc directory %s could not be made.\n", CanonicalPathString.get(newDscDir));
                return null;
            }
        }
        SpreadDirectory directory = new SpreadDirectory(parentSpreadDir, name, newDir);
        this.registeredSpreadDirectories.add(directory);
        parentSpreadDir.addResource(directory);
        DefaultMutableTreeNode directoryNode = new DefaultMutableTreeNode(directory);
        parentTreeNode.add(directoryNode);
        this.updateUI();
        this.repaint();
        return directoryNode;
    }

    public static String makePathString(TreeNode[] array_path) {
        StringBuffer tmp = new StringBuffer();
        int size = array_path.length;
        int i = 0;
        while (i < size) {
            tmp.append("/");
            tmp.append(array_path[i]);
            ++i;
        }
        return tmp.toString();
    }

    public DefaultMutableTreeNode addSpreadDirectory(DefaultMutableTreeNode treeNode, SpreadDirectory parent, File file) {
        boolean ans = file.isDirectory();
        if (file.isDirectory()) {
            if (!this.isRegistered(file)) {
                SpreadDirectory directory = new SpreadDirectory(parent, file.getName(), file);
                this.registeredSpreadDirectories.add(directory);
                parent.addResource(directory);
                DefaultMutableTreeNode directoryNode = new DefaultMutableTreeNode(directory);
                treeNode.add(directoryNode);
                return directoryNode;
            }
            Enumeration<TreeNode> e = treeNode.children();
            while (e.hasMoreElements()) {
                SpreadDirectory d;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
                GSResource r = (GSResource)child.getUserObject();
                if (!(r instanceof SpreadDirectory) || !(d = (SpreadDirectory)r).getFile().equals(file)) continue;
                return child;
            }
        }
        System.out.print("Something wrong with SpreadTree.addDirectory()\n");
        return null;
    }

    public void addLoadImage(DefaultMutableTreeNode treeNode, SpreadDirectory parent, File file) {
        if (!file.isDirectory() && !this.isRegistered(file) && this.isImage(file)) {
            Spread spread = new Spread(parent, file);
            parent.addResource(spread);
            this.registeredSpreads.add(spread);
            treeNode.add(new DefaultMutableTreeNode(spread));
            new AutomaticNumbering().execAndAdjustSpreadSelectionLists(this.rootNode);
        }
        this.updateUI();
    }

    public void addImage(File file) {
        SpreadTree tree = SpreadTree.getInstance();
        if (file != null) {
            if (tree.isRegistered(file)) {
                return;
            }
            DefaultMutableTreeNode spreadTreeNode = tree.getSelectedNode();
            SpreadDirectory spreadDirectory = (SpreadDirectory)spreadTreeNode.getUserObject();
            tree.addLoadImage(spreadTreeNode, spreadDirectory, file);
        }
    }

    public void addImage(DefaultMutableTreeNode spreadTreeNode, File file) {
        SpreadTree tree = SpreadTree.getInstance();
        if (file != null) {
            if (tree.isRegistered(file)) {
                return;
            }
            SpreadDirectory spreadDirectory = (SpreadDirectory)spreadTreeNode.getUserObject();
            tree.addLoadImage(spreadTreeNode, spreadDirectory, file);
        }
    }

    public void addImageFile(String rootDir, String openDirectoryPathInString, SpreadDirectory openDirectory, File imageFile) {
        if (singleton.isRegistered(imageFile)) {
            return;
        }
        String imageFilePath = CanonicalPathString.get(imageFile);
        DefaultMutableTreeNode treeNode = singleton.getSelectedNode();
        SpreadDirectory parent = openDirectory;
        if (!rootDir.equals(openDirectoryPathInString)) {
            String dir = imageFilePath.substring(openDirectoryPathInString.length(), imageFilePath.length() - imageFile.getName().length());
            dir = GSStandardPath.win2standard(dir);
            StringTokenizer st = new StringTokenizer(dir, "/");
            StringBuffer dirBuf = new StringBuffer();
            if (!rootDir.endsWith("/")) {
                rootDir = String.valueOf(rootDir) + "/";
            }
            dirBuf.append(openDirectoryPathInString);
            while (st.hasMoreTokens()) {
                dirBuf.append(String.valueOf(st.nextToken()) + "/");
                File newDir = new File(dirBuf.toString());
                treeNode = singleton.addSpreadDirectory(treeNode, parent, newDir);
                parent = (SpreadDirectory)treeNode.getUserObject();
            }
        }
        singleton.addLoadImage(treeNode, parent, imageFile);
    }

    public void addDir(DefaultMutableTreeNode theTargetNode, File parentDirectory, String newDirName) {
        DefaultMutableTreeNode newDirNode = this.makeSpreadDirectory(theTargetNode, newDirName);
        File newDirOnFileSystem = new File(parentDirectory, newDirName);
        File[] list = newDirOnFileSystem.listFiles(new ImageFileDirFilterForSpreadTree());
        int i = 0;
        while (i < list.length) {
            if (list[i].isDirectory()) {
                String dirName = list[i].getName();
                this.addDir(newDirNode, newDirOnFileSystem, dirName);
            } else {
                this.addImage(newDirNode, list[i]);
            }
            ++i;
        }
    }

    public void removeSelectedItems() {
        GSResource item;
        TreePath[] paths = this.getSelectedPaths();
        int size = paths.length;
        Object[] options = new Object[]{"delete the items", "don't delete the items", "Cancel"};
        int selectedProcessOption = JOptionPane.showOptionDialog(WorkspaceWindow.getInstance().getFrame(), "From Image Folder,", "Deletion options", 1, 3, null, options, options[0]);
        int i = 0;
        while (i < size) {
            item = (GSResource)((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
            if (item == null) break;
            if (item instanceof Spread) {
                this.removeSpread(paths[i]);
            } else if (item instanceof SpreadDirectory) {
                this.removeDirectory(paths[i]);
            } else {
                System.out.print("Bug in SpreadTree");
            }
            new AutomaticNumbering().execAndAdjustSpreadSelectionLists(this.rootNode);
            WorkspaceWindow.setUpdated(true);
            this.repaint();
            ++i;
        }
        if (selectedProcessOption == 0) {
            i = 0;
            while (i < size) {
                item = (GSResource)((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
                if (item == null) break;
                if (item instanceof Spread) {
                    Spread spread = (Spread)item;
                    File imageFile = spread.getImageFile();
                    File dscFile = spread.getDscFile();
                    File dscLineSegFile = spread.getDscLineSegFile();
                    File lineSegFile = spread.getLineSegFile();
                    if (imageFile.exists()) {
                        imageFile.delete();
                    }
                    if (dscFile.exists()) {
                        dscFile.delete();
                    }
                    if (dscLineSegFile.exists()) {
                        dscLineSegFile.delete();
                    }
                    if (lineSegFile.exists()) {
                        lineSegFile.delete();
                    }
                } else {
                    Object[] nodes = paths[i].getPath();
                    File image_fileDir_path = IMAGE_FOLDER_PATH;
                    int j = 1;
                    while (j < nodes.length) {
                        image_fileDir_path = new File(image_fileDir_path, nodes[j].toString());
                        ++j;
                    }
                    SpreadTree.deleteDir(image_fileDir_path);
                    if (!IMAGE_FOLDER_PATH_STRING.equals(DSC_FOLDER_PATH)) {
                        File dsc_fileDir_path = DSC_FOLDER_PATH;
                        int j2 = 1;
                        while (j2 < nodes.length) {
                            dsc_fileDir_path = new File(dsc_fileDir_path, nodes[j2].toString());
                            ++j2;
                        }
                        SpreadTree.deleteDir(dsc_fileDir_path);
                    }
                }
                ++i;
            }
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = SpreadTree.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        if (dir.exists()) {
            return dir.delete();
        }
        return true;
    }

    public void removeSpread(TreePath path) {
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj == null) {
            return;
        }
        Spread deletespread = (Spread)((DefaultMutableTreeNode)obj).getUserObject();
        if (deletespread == null) {
            return;
        }
        String nameStr = deletespread.toString();
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        int smallest = Integer.MAX_VALUE;
        if (nameStr.indexOf(":") != -1) {
            String numberStr = nameStr.substring(0, nameStr.indexOf(":"));
            try {
                smallest = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Enumeration<TreeNode> enumeration = parentNode.children();
        SpreadDirectory spreadDirectory = (SpreadDirectory)parentNode.getUserObject();
        int deletecount = 0;
        boolean deleteflg = false;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
            String childrenStr = childrenNode.toString();
            if (childrenNode.getUserObject() instanceof Spread && childrenStr.equals(nameStr)) {
                deleteflg = true;
                this.removeLink(((Spread)childrenNode.getUserObject()).getURI());
                this.registeredSpreads.remove((Spread)childrenNode.getUserObject());
                spreadDirectory.remove((Spread)childrenNode.getUserObject());
                break;
            }
            ++deletecount;
        }
        if (!deleteflg) {
            return;
        }
        parentNode.remove(deletecount);
        this.updateUI();
        this.repaint();
    }

    public void removeDirectory(TreePath path) {
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (obj == null) {
            return;
        }
        SpreadDirectory deleteDirectory = (SpreadDirectory)((DefaultMutableTreeNode)obj).getUserObject();
        if (deleteDirectory == null) {
            return;
        }
        List<SpreadDirectory> listdir = deleteDirectory.getSpreadDirectorys();
        int i = 0;
        while (i < listdir.size()) {
            SpreadDirectory spreadDirectory = listdir.get(i);
            this.removeLink(spreadDirectory.getURI());
            this.registeredSpreadDirectories.remove(spreadDirectory);
            ++i;
        }
        List<Spread> listfile = deleteDirectory.getSpreads();
        int i2 = 0;
        while (i2 < listfile.size()) {
            Spread spread = listfile.get(i2);
            this.removeLink(spread.getURI());
            this.registeredSpreads.remove(spread);
            ++i2;
        }
        deleteDirectory.removeAllChildren();
        this.registeredSpreadDirectories.remove(deleteDirectory);
        this.removeLink(deleteDirectory.getURI());
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        Object parentObject = parentNode.getUserObject();
        ((SpreadDirectory)parentObject).removeDirectory(deleteDirectory);
        parentNode.remove(targetNode);
        this.updateUI();
        this.repaint();
    }

    private void removeLink(String url) {
        LinkRemover.removeLinksOf(url);
    }

    class AutomaticNumbering {
        private int counter = 0;
        int ict_max = Spread.getCurrentMaxPageIndex();
        IndexChangeTable ict = new IndexChangeTable(this.ict_max);

        AutomaticNumbering() {
        }

        private void exec(DefaultMutableTreeNode parentNode) {
            Enumeration<TreeNode> enumeration = parentNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
                String childrenStr = childrenNode.toString();
                if (childrenNode.getUserObject() instanceof Spread) {
                    Spread spread = (Spread)childrenNode.getUserObject();
                    if (this.counter <= this.ict_max) {
                        this.ict.set(spread.getPageViewIndex(), this.counter);
                    }
                    spread.setPageViewIndex(this.counter);
                    ++this.counter;
                    continue;
                }
                if (!(childrenNode.getUserObject() instanceof SpreadDirectory)) continue;
                this.exec(childrenNode);
            }
            WorkspaceWindow.setUpdated(true);
        }

        public void execAndAdjustSpreadSelectionLists(DefaultMutableTreeNode rootNode) {
            this.exec(rootNode);
            SpreadSelectionListManager.getInstance().adjustSpreadSelctionLists(this.ict);
        }
    }

    class SpreadFileComparator
    implements Comparator<File> {
        SpreadFileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.compareTo(o2);
        }
    }

    class SpreadTreeCellRenderer
    extends DefaultTreeCellRenderer {
        boolean isTargetNode;
        boolean isTargetNodeLeaf;
        boolean isLastItem;
        Insets normalInsets = super.getInsets();
        Insets lastItemInsets;
        int BOTTOM_PAD = 30;

        public SpreadTreeCellRenderer() {
            this.lastItemInsets = new Insets(this.normalInsets.top, this.normalInsets.left, this.normalInsets.bottom + this.BOTTOM_PAD, this.normalInsets.right);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object obj;
            this.isTargetNode = value == SpreadTree.this.dropTargetNode;
            this.isTargetNodeLeaf = this.isTargetNode && ((TreeNode)value).isLeaf();
            boolean showSelected = isSelected & SpreadTree.this.dropTargetNode == null;
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            if (value != null && value instanceof DefaultMutableTreeNode && (obj = (defaultMutableTreeNode = (DefaultMutableTreeNode)value).getUserObject()) != null && obj instanceof SpreadDirectory) {
                Icon icon = renderer.getOpenIcon();
                renderer.setIcon(icon);
            }
            return renderer;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isTargetNode) {
                g.setColor(Color.black);
                g.drawLine(0, 0, this.getSize().width, 0);
            }
        }
    }

    class SpreadTreeTransferable
    implements Transferable {
        Object object;

        public SpreadTreeTransferable(Object o) {
            this.object = o;
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(df)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(df);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.getHumanPresentableName().equals(SpreadTree.NAME);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }
    }
}

