/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.logical;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smart_gs.logical.GSResource;
import smart_gs.logical.TextSegment;

public abstract class SmartDocument
extends GSResource {
    protected String source;
    protected List<TextSegment> segments;

    public SmartDocument() {
        this.source = "<sml></sml>";
        this.segments = new ArrayList<TextSegment>();
    }

    public SmartDocument(String source) {
        this.source = source;
        this.segments = new ArrayList<TextSegment>();
    }

    public List<TextSegment> getSegments() {
        return this.segments;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void addTextSegment(TextSegment segment) {
        this.segments.add(segment);
    }

    public void removeTextSegment(int id) {
        int i = 0;
        while (i < this.segments.size()) {
            if (id == this.segments.get(i).getId()) {
                this.segments.remove(i);
                return;
            }
            ++i;
        }
    }

    public TextSegment getSegmentByID(int id) {
        int i = 0;
        while (i < this.segments.size()) {
            if (id == this.segments.get(i).getId()) {
                return this.segments.get(i);
            }
            ++i;
        }
        return null;
    }

    public GSResource getSegments(String uri) {
        int i = 0;
        while (i < this.segments.size()) {
            if (this.segments.get(i).getURI().equals(uri)) {
                return this.segments.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void checkSegments(Element element) {
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            block3: {
                Element elem;
                block4: {
                    if (list.item(i).getNodeType() != 1) break block3;
                    elem = (Element)list.item(i);
                    if (!elem.hasAttribute("id")) break block4;
                    String id = elem.getAttribute("id");
                    if (this.hasSegment(new Integer(id))) break block3;
                    String tagname = elem.getNodeValue();
                    TextSegment segment = new TextSegment(tagname, this, new Integer(id));
                    this.addTextSegment(segment);
                }
                this.checkSegments(elem);
            }
            ++i;
        }
    }

    private boolean hasSegment(int id) {
        int i = 0;
        while (i < this.segments.size()) {
            if (this.segments.get(i).getId() == id) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isIDAT() {
        return this.getTypeString().equals("firstIdat") || this.getTypeString().equals("secondIdat") || this.getTypeString().equals("thirdIdat");
    }
}

