/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.research;

import java.util.ArrayList;
import java.util.List;
import smart_gs.image_search.SearchQueryAction;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.research.LineFilter;
import smart_gs.image_search.research.SearchFilter;
import smart_gs.image_search.research.SearchResultSet;
import smart_gs.image_search.research.SpreadFilter;
import smart_gs.image_search.research.swingui.REImageSearchDialog;
import smart_gs.logical.Spread;

public class RESearch {
    private List<GSQuery> queries;
    private List<SearchResultSet> results;
    private List<Spread> spreadsToSearch;
    private REImageSearchDialog dialog;
    private SearchFilter filter;

    public RESearch(REImageSearchDialog dialog, List<GSQuery> queries, List<Spread> spreadsToSearch) {
        this.queries = queries;
        this.spreadsToSearch = spreadsToSearch;
        this.results = new ArrayList<SearchResultSet>();
        this.dialog = dialog;
        this.filter = this.dialog.isLineSelected() ? new LineFilter(this.dialog.getLineNumber()) : new SpreadFilter();
    }

    public List<GSQuery> getQueries() {
        return this.queries;
    }

    public List<SearchResultSet> getResults() {
        return this.results;
    }

    public void execute() {
        ArrayList<List<SearchResult>> res = new ArrayList<List<SearchResult>>();
        int i = 0;
        while (i < this.queries.size()) {
            SearchQueryAction searcher = new SearchQueryAction(this.queries.get(i), this.spreadsToSearch);
            searcher.execute();
            List<SearchResult> result = searcher.getResults();
            res.add(result);
            ++i;
        }
        this.results = this.filter.filtering(res);
        this.results = this.simpleSorting(this.results);
    }

    public List<SearchResultSet> simpleSorting(List<SearchResultSet> result) {
        double minScore = -1.0;
        int minIndex = -1;
        int size = result.size();
        int i = 0;
        while (i < size) {
            minScore = result.get(i).getScore();
            minIndex = i;
            int j = i;
            while (j < result.size()) {
                double score = result.get(j).getScore();
                if (score < minScore) {
                    minIndex = j;
                }
                ++j;
            }
            SearchResultSet set = result.get(minIndex);
            result.remove(minIndex);
            result.add(i, set);
            ++i;
        }
        return result;
    }
}

