/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DrawingModeAdapter;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.region.MemoPadRegion;
import smart_gs.swingui.GSMouseEvent;

public class MemoPadMode
extends DrawingModeAdapter {
    private static Mode singleton = new MemoPadMode();
    private Point2D start;
    private Point2D end;

    public static Mode getInstance() {
        return singleton;
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        super.mousePressed(e, canvas);
        this.start = e.getPoint();
    }

    @Override
    public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
        super.mouseDragged(e, canvas);
        this.end = e.getPoint();
    }

    @Override
    public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
        super.mouseReleased(e, canvas);
        if (this.start == null || this.end == null) {
            return;
        }
        canvas.addRegion(new MemoPadRegion(canvas.getSpread(), this.adjustRect(this.start.getX(), this.start.getY())));
        this.start = null;
        this.end = null;
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
        super.paint(g, canvas);
        if (this.start == null || this.end == null) {
            return;
        }
        double ratio = canvas.getImageLabel().getRatio();
        double gapX = canvas.getImageLabel().getGapWidth();
        double gapY = canvas.getImageLabel().getGapHeight();
        MemoPadView view = new MemoPadView(this.adjustRect(this.start.getX(), this.start.getY()), MemoPadView.defaultMemoPadText).enlargedView(ratio, gapX, gapY);
        view.draw((Graphics2D)g);
    }

    private Rectangle2D.Double adjustRect(double sx, double sy) {
        double height;
        double startY;
        double width;
        double startX;
        if (this.start.getX() > this.end.getX()) {
            startX = this.end.getX();
            width = this.start.getX() - this.end.getX();
        } else {
            startX = this.start.getX();
            width = this.end.getX() - this.start.getX();
        }
        if (this.start.getY() > this.end.getY()) {
            startY = this.end.getY();
            height = this.start.getY() - this.end.getY();
        } else {
            startY = this.start.getY();
            height = this.end.getY() - this.start.getY();
        }
        return new Rectangle2D.Double(startX, startY, width, height);
    }
}

