/*
 * Decompiled with CFR 0.152.
 */
package image_search;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import smart_gs.logical.Spread;
import smart_gs.util.ImageCropper;

public class Query {
    protected File dscFile;
    protected Rectangle rectangle;
    protected Image image;
    protected Spread spread;
    protected Image queryImage;
    protected Image queryImageWithTransformation;

    public Spread getSpread() {
        return this.spread;
    }

    public void setSpread(Spread spread) {
        this.spread = spread;
    }

    public Query(Image image, File dscFile, Rectangle rectangle) {
        this.spread = null;
        this.dscFile = dscFile;
        this.rectangle = rectangle;
        this.image = image;
        this.queryImage = null;
        this.queryImageWithTransformation = null;
    }

    public Query(Spread spread, File dscFile, Rectangle rectangle) {
        this.dscFile = dscFile;
        this.rectangle = rectangle;
        this.image = spread.getImage();
        this.spread = spread;
        this.queryImage = null;
        this.queryImageWithTransformation = null;
    }

    public Image getQueryImage() {
        if (this.queryImage == null) {
            this.queryImage = new ImageCropper(this.image, (Rectangle2D)this.rectangle).crop();
        }
        return this.queryImage;
    }

    public Image getQueryImageWithTransformation() {
        if (this.spread == null) {
            System.out.println("getQueryImageWithTransformation is applicable only to Spread image");
            return null;
        }
        if (!this.spread.isTransformationIsNecessary()) {
            return this.getQueryImage();
        }
        if (this.queryImageWithTransformation == null) {
            AffineTransform affineTransformFromDSCToImage = this.spread.getAffineTranformFromDscToImg();
            Shape shapeMapped = affineTransformFromDSCToImage.createTransformedShape(this.rectangle);
            Rectangle rectangleMapped = shapeMapped.getBounds();
            this.queryImageWithTransformation = new ImageCropper(this.image, (Rectangle2D)rectangleMapped).crop();
        }
        return this.queryImageWithTransformation;
    }

    public File getDSCFile() {
        return this.dscFile;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }
}

