/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.BangBangDash;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.machines.BangBangDash.BangBangDashMainboard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class BangBangDashDataCounter
extends AbstractDataCounter {
    private JCheckBoxMenuItem modeReport = null;
    private JCheckBoxMenuItem bbdReport = null;
    private JCheckBoxMenuItem opaopaInBbdReport = null;
    private JCheckBoxMenuItem chanceReport = null;
    private int bbdHitCount = 0;
    private int bbdCount = 0;
    private int exHitCount = 0;
    private int chanceCount = 0;

    public static final void main(String[] args) {
        BangBangDashDataCounter main = null;
        try {
            main = new BangBangDashDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public BangBangDashDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel northPanel) {
        this.modeReport = new JCheckBoxMenuItem("\u30e2\u30fc\u30c9\u79fb\u884c\u8868\u793a", false);
        this.bbdReport = new JCheckBoxMenuItem("BBD \u60c5\u5831\u8868\u793a", true);
        this.opaopaInBbdReport = new JCheckBoxMenuItem("BBD\u4e2d\u30aa\u30d1\u30aa\u30d1\u8868\u793a", false);
        this.chanceReport = new JCheckBoxMenuItem("\u30c1\u30e3\u30f3\u30b9\u76ee\u8868\u793a", false);
        this.addOptionMenu(this.modeReport);
        this.addOptionMenu(this.bbdReport);
        this.addOptionMenu(this.opaopaInBbdReport);
        this.addOptionMenu(this.chanceReport);
    }

    protected String getFrameTitle() {
        return "\u30d0\u30f3\u30d0\u30f3\u30c0\u30c3\u30b7\u30e5\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new BangBangDashMainboard();
    }

    protected void processEvent(int event) {
        switch (event) {
            case 21: {
                ++this.bbdHitCount;
            }
            case 22: {
                ++this.bbdCount;
            }
            case 23: {
                this.logBbd(event);
                break;
            }
            case 24: {
                ++this.exHitCount;
            }
            case 25: {
                this.logEx(event);
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                this.logOpaopa(event);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.logMode(event);
                break;
            }
            case 20: {
                ++this.chanceCount;
                this.logChance();
            }
        }
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventBonusStart() {
    }

    protected void eventBonusEnd() {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (this.simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + this.currentBonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
        this.bbdHitCount = 0;
        this.bbdCount = 0;
        this.exHitCount = 0;
        this.chanceCount = 0;
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u30c1\u30e3\u30f3\u30b9\u76ee", this.chanceCount, this.getTotalGameCount());
        this.appendLogDenominator("BBD(\u521d\u5f53\u305f\u308a)", this.bbdHitCount, this.getTotalGameCount());
        this.appendLogDenominator("BBD", this.bbdCount, this.getTotalGameCount());
        this.appendLogDenominator("EX \u7a81\u5165", this.exHitCount, this.getTotalGameCount());
        this.appendLogPayout();
    }

    protected void logMode(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.modeReport.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        switch (event) {
            case 26: {
                this.appendLog("]\t[\u9ad8\u78baA\u958b\u59cb]");
                break;
            }
            case 27: {
                this.appendLog("]\t[\u9ad8\u78baA\u7d42\u4e86]");
                break;
            }
            case 28: {
                this.appendLog("]\t[\u9ad8\u78baB\u958b\u59cb]");
                break;
            }
            case 29: {
                this.appendLog("]\t[\u9ad8\u78baB\u7d42\u4e86]");
                break;
            }
            case 30: {
                this.appendLog("]\t[\u9ad8\u78baC\u958b\u59cb]");
                break;
            }
            case 31: {
                this.appendLog("]\t[\u9ad8\u78baC\u7d42\u4e86]");
                break;
            }
            case 32: {
                this.appendLog("]\t[\u9ad8\u78baD\u958b\u59cb]");
                break;
            }
            case 33: {
                this.appendLog("]\t[\u9ad8\u78baD\u7d42\u4e86]");
                break;
            }
            case 34: {
                this.appendLog("]\t[\u8d85\u9ad8\u78ba\u958b\u59cb]");
                break;
            }
            case 35: {
                this.appendLog("]\t[\u8d85\u9ad8\u78ba\u7d42\u4e86]");
            }
        }
        this.appendLog("\n");
    }

    protected void logChance() {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.chanceReport.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("]\t\u30c1\u30e3\u30f3\u30b9\u76ee");
        boolean isHigh = ((BangBangDashMainboard)this.simulator).isHigh();
        boolean isSuperHigh = ((BangBangDashMainboard)this.simulator).isSuperHigh();
        if (isSuperHigh) {
            this.appendLog("(\u8d85\u9ad8\u78ba)");
        } else if (isHigh) {
            this.appendLog("(\u9ad8\u78ba)");
        } else {
            this.appendLog("(\u4f4e\u78ba)");
        }
        this.appendLog("\n");
    }

    protected void logBbd(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.bbdReport.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("]");
        switch (event) {
            case 21: {
                this.appendLog("\t[BBD\u5f53\u9078(");
                int hitFactor = ((BangBangDashMainboard)this.simulator).getBbdHitFactor();
                switch (hitFactor) {
                    case 10: {
                        this.appendLog("BIG\u30d7\u30ec\u30df\u30a2");
                        break;
                    }
                    case 11: {
                        this.appendLog("\u30c1\u30a7\u30ea\u30fc\u30d7\u30ec\u30df\u30a2");
                        break;
                    }
                    case 1: {
                        this.appendLog("\u30c1\u30e3\u30f3\u30b9\u76ee(\u9ad8\u78baA)");
                        break;
                    }
                    case 2: {
                        this.appendLog("\u30c1\u30e3\u30f3\u30b9\u76ee(\u9ad8\u78baB)");
                        break;
                    }
                    case 3: {
                        this.appendLog("\u30c1\u30e3\u30f3\u30b9\u76ee(\u9ad8\u78baC)");
                        break;
                    }
                    case 4: {
                        this.appendLog("\u30c1\u30e3\u30f3\u30b9\u76ee(\u9ad8\u78baD)");
                        break;
                    }
                    case 0: {
                        this.appendLog("\u30c1\u30e3\u30f3\u30b9\u76ee(\u4f4e\u78ba)");
                        break;
                    }
                    case 5: {
                        this.appendLog("\u30c1\u30e3\u30f3\u30b9\u76ee(\u8d85\u9ad8\u78ba)");
                    }
                }
                this.appendLog(")\t\u9023=");
                this.appendLog(String.valueOf(((BangBangDashMainboard)this.simulator).getBbdCurrentHitCount()));
                this.appendLog("]");
                break;
            }
            case 22: {
                this.appendLog("\tBBD");
                this.appendLog(String.valueOf(((BangBangDashMainboard)this.simulator).getBbdFloor()));
                this.appendLog("\t\u958b\u59cb");
                this.appendLog("\t");
                this.appendLog(String.valueOf(this.getCoin()));
                break;
            }
            case 23: {
                this.appendLog("\tBBD\u7d42\u4e86\t\u6b8b=");
                this.appendLog(String.valueOf(((BangBangDashMainboard)this.simulator).getBbdCount()));
                this.appendLog("\t");
                this.appendLog(String.valueOf(this.getCoin()));
            }
        }
        this.appendLog("\n");
    }

    protected void logOpaopa(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.opaopaInBbdReport.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("]");
        switch (event) {
            case 38: {
                this.appendLog("\t[BBD \u4e2d\u30aa\u30d1\u30aa\u30d1]");
                break;
            }
            case 37: {
                this.appendLog("\t[\u6b8b\u6a5f\u30de\u30a4\u30ca\u30b9]\t\u6b8b\u6a5f=");
                this.appendLog(String.valueOf(((BangBangDashMainboard)this.simulator).getExOpaopaCount()));
                break;
            }
            case 36: {
                this.appendLog("\t[\u6b8b\u6a5f\u30d7\u30e9\u30b9]\t\u6b8b\u6a5f=");
                this.appendLog(String.valueOf(((BangBangDashMainboard)this.simulator).getExOpaopaCount()));
            }
        }
        this.appendLog("\n");
    }

    protected void logEx(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.bbdReport.isSelected()) {
            return;
        }
        this.appendLog("\t[");
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("]");
        switch (event) {
            case 24: {
                this.appendLog("\tEX\u958b\u59cb\t\u6b8b\u6a5f=");
                this.appendLog(String.valueOf(((BangBangDashMainboard)this.simulator).getExOpaopaCount()));
                this.appendLog("\t");
                this.appendLog(String.valueOf(this.getCoin()));
                break;
            }
            case 25: {
                this.appendLog("\tEX\u7d42\u4e86");
                this.appendLog("\t");
                this.appendLog(String.valueOf(this.getCoin()));
            }
        }
        this.appendLog("\n");
    }
}

