/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Shimamusume25;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.Shimamusume25.Shimamusume25MainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class Shimamusume25DataCounter
extends AbstractDataCounter4Stock {
    private int currentGameCount = 0;
    private int bigHitCount = 0;
    private int previousBonus = -1;

    public Shimamusume25DataCounter() {
        this.initialize();
    }

    protected String getFrameTitle() {
        return "\u306d\u3047\u30fc\u306d\u3047\u30fc\u5cf6\u5a18\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new Shimamusume25MainBoard();
    }

    protected void processEvent(int event) {
        switch (event) {
            case 20: {
                this.eventBonusEndAndModeMove();
            }
        }
    }

    protected void eventBonusEndAndModeMove() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(this.currentGameCount);
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG(");
            this.appendLog(((AbstractDataCounter)this).currentBonusCoin);
            this.appendLog(")");
        } else if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 4) {
            this.appendLog("REG");
        }
        this.appendLog("\tM");
        this.appendLog(((Shimamusume25MainBoard)((AbstractDataCounter)this).simulator).getPreviousMode() + 1);
        this.appendLog("->M");
        this.appendLog(this.getCurrentMode() + 1);
        this.appendLog("\t");
        this.appendLog(this.getCoin());
        this.appendLog("\n");
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventBonusStart() {
    }

    protected void eventBonusEnd() {
        this.currentGameCount = this.getCurrentGameCount();
        if (this.previousBonus != -1 && this.previousBonus == 4 && ((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            ++this.bigHitCount;
        }
        this.previousBonus = ((AbstractDataCounter)this).simulator.getCurrentBonus();
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
        this.bigHitCount = 0;
        this.previousBonus = -1;
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        this.appendLog("\n");
        this.appendLogDenominator("BIG\u521d\u5f53\u305f\u308a", this.bigHitCount, this.getTotalGameCount());
        this.appendLogDenominator("BIG\u521d\u5f53\u305f\u308a", this.bigHitCount, this.getRegCount());
        this.appendLog("\n");
        this.appendLogPayout();
    }

    public static void main(String[] args) {
        Shimamusume25DataCounter main = null;
        try {
            main = new Shimamusume25DataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    protected void initializeGui(JPanel northPanel) {
        super.initializeGui(northPanel);
    }
}

