/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.library;

import java.util.AbstractList;
import java.util.ListIterator;
import java.util.Vector;

public class Stock
extends Vector {
    private static final int BIG = 3;
    private static final int REG = 4;
    private int bigCount = 0;
    private int regCount = 0;

    public Stock() {
        super(256);
    }

    public boolean add(int bonus) {
        if (this.size() > 255) {
            return false;
        }
        if (bonus == 3) {
            ++this.bigCount;
        } else if (bonus == 4) {
            ++this.regCount;
        } else {
            throw new IllegalArgumentException("unknown bonus added!");
        }
        return super.add(new Integer(bonus));
    }

    public boolean add(Object bonus) {
        if (this.size() > 255) {
            return false;
        }
        if ((Integer)bonus == 3) {
            ++this.bigCount;
        } else if ((Integer)bonus == 4) {
            ++this.regCount;
        } else {
            throw new RuntimeException("unknown bonus added!");
        }
        return super.add(bonus);
    }

    public Object remove(int index) {
        int bonus = (Integer)this.get(index);
        if (bonus == 3) {
            --this.bigCount;
        } else if (bonus == 4) {
            --this.regCount;
        } else {
            throw new RuntimeException("unknown bonus find!");
        }
        return super.remove(index);
    }

    public int getBigCount() {
        return this.bigCount;
    }

    public int getRegCount() {
        return this.regCount;
    }

    public boolean isNoStock() {
        return this.bigCount + this.regCount == 0;
    }

    public String debugOutCount() {
        return "B" + this.bigCount + "R" + this.regCount;
    }

    public String debugOutBonus() {
        StringBuffer buffer = new StringBuffer();
        ListIterator iterator = ((AbstractList)this).listIterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            buffer.append(i == 3 ? "B" : "R");
        }
        return buffer.toString();
    }
}

