/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.datacounter;

import java.awt.Component;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.datacounter.DataCounterInterface;
import jp.sourceforge.slotsimulator.datacounter.DataCounterListener;
import jp.sourceforge.slotsimulator.datacounter.SlumpPanel;
import jp.sourceforge.slotsimulator.datacounter.StrategyLogPanel;
import jp.sourceforge.slotsimulator.datacounter.StrategyMonitorInterface;

public class DefaultStrategyMonitor
implements DataCounterInterface,
DataCounterListener,
StrategyMonitorInterface {
    private static int strategyCount = 0;
    private String title = null;
    private int myStrategyCount = 0;
    private StrategyLogPanel logPanel = null;
    private SlumpPanel slumpGraph = null;
    private int coin = 0;
    private int inCoin = 0;
    private int outCoin = 0;
    private boolean checking = false;
    private boolean isError = false;
    private boolean isBonus = false;
    private int strategyPreviousBonusGame = 0;
    private int strategyPreviousBonusKind = 0;
    private int strategyStartGameBonusKind = 0;
    private int strategyStartGame = 0;
    private int strategyStopGame = 0;
    private int strategyEndGame = 0;
    private int previousBonusGame = 0;
    private int previousBonusKind = 0;
    private int totalGameCount = 0;
    private List listeners = new Vector();
    private DataCounterInterface sender = null;
    int bonusCoin = 0;

    public void create(DataCounterInterface sender) {
        try {
            this.logPanel = new StrategyLogPanel();
            this.logPanel.initialize();
            this.sender = sender;
            this.myStrategyCount = ++strategyCount;
            this.title = "\u7acb\u3061\u56de\u308a" + this.myStrategyCount;
            ((AbstractDataCounter4Stock)sender).addLogPanel(this.title, this.logPanel);
            sender.addListener(this);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    public void terminate() {
        if (this.slumpGraph != null) {
            this.slumpGraph.dispose();
            this.slumpGraph = null;
        }
        if (this.sender != null) {
            ((AbstractDataCounter4Stock)this.sender).removeLogPanel(this.logPanel);
            this.sender = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        this.logPanel = null;
    }

    public void finalize() throws Throwable {
        try {
            this.terminate();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void addListener(DataCounterListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DataCounterListener l) {
        this.listeners.remove(l);
    }

    public int getMaxSimulateGame() {
        return this.sender.getMaxSimulateGame();
    }

    public void coinMinus(int state, int minus, int currentGameCount, int bigIntervalGameCount) {
        if (this.checking) {
            this.inCoin += minus;
            this.coin -= minus;
            ListIterator i = null;
            try {
                i = this.listeners.listIterator();
                while (i.hasNext()) {
                    ((DataCounterListener)i.next()).coinMinus(state, minus, currentGameCount, bigIntervalGameCount);
                }
                Object var7_6 = null;
                i = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                i = null;
                throw throwable;
            }
        }
    }

    public void coinPlus(int state, int plus, int currentGameCount, int bigIntervalGameCount) {
        if (this.checking) {
            this.outCoin += plus;
            this.coin += plus;
            ListIterator i = null;
            try {
                i = this.listeners.listIterator();
                while (i.hasNext()) {
                    ((DataCounterListener)i.next()).coinPlus(state, plus, currentGameCount, bigIntervalGameCount);
                }
                Object var7_6 = null;
                i = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                i = null;
                throw throwable;
            }
        }
    }

    public void event(int eventId, int currentGameCount, int bigIntervalGameCount) {
        switch (eventId) {
            case 1: {
                this.isError = false;
                this.isBonus = false;
                this.totalGameCount = 0;
                this.coin = 0;
                this.inCoin = 0;
                this.outCoin = 0;
                this.checking = false;
                this.logPanel.clear();
                this.strategyPreviousBonusGame = this.logPanel.getPreviousBonusGame();
                this.strategyStartGameBonusKind = this.logPanel.getStartGameBonusKind();
                this.strategyStartGame = this.logPanel.getStartGame();
                this.strategyStopGame = this.logPanel.getStopGame();
                this.strategyEndGame = this.logPanel.getEndGame();
                if (this.strategyStartGame == 0) {
                    this.isError = true;
                } else if (this.strategyStopGame <= this.strategyStartGame && this.strategyStopGame != 0) {
                    this.isError = true;
                } else if (this.strategyEndGame >= this.strategyStartGame) {
                    this.isError = true;
                }
                if (this.logPanel.isSlumpGraph()) {
                    if (this.slumpGraph == null) {
                        this.slumpGraph = new SlumpPanel();
                        this.slumpGraph.create(this, this.title);
                        ((Component)this.slumpGraph).setBounds(50 + this.myStrategyCount * 16, 50 + this.myStrategyCount * 16, 350, 300);
                    }
                } else if (this.slumpGraph != null) {
                    this.slumpGraph.dispose();
                    this.slumpGraph = null;
                }
                this.fireEvent(eventId, currentGameCount, bigIntervalGameCount);
                this.logSimulateStart();
                break;
            }
            case 3: {
                if (this.isError) {
                    return;
                }
                if (this.checking) {
                    ++this.totalGameCount;
                    this.fireEvent(eventId, currentGameCount, bigIntervalGameCount);
                    if (currentGameCount > this.strategyStopGame) {
                        this.checking = false;
                        this.logStop(currentGameCount, bigIntervalGameCount);
                        break;
                    }
                    if (currentGameCount <= this.strategyEndGame || !this.isBonus) break;
                    this.checking = false;
                    this.logEnd(currentGameCount, bigIntervalGameCount);
                    break;
                }
                if (currentGameCount < this.strategyStartGame || currentGameCount >= this.strategyStopGame || this.previousBonusGame <= this.strategyPreviousBonusGame) break;
                this.checking = true;
                this.isBonus = false;
                this.fireEvent(eventId, currentGameCount, bigIntervalGameCount);
                this.logStart(currentGameCount, bigIntervalGameCount);
                break;
            }
            case 4: {
                if (this.isError) {
                    return;
                }
                this.previousBonusGame = currentGameCount;
                if (!this.checking) break;
                this.logBonusStart(currentGameCount, bigIntervalGameCount);
                break;
            }
            case 5: {
                if (this.isError) {
                    return;
                }
                if (!this.checking) break;
                this.logBonusEnd(currentGameCount, bigIntervalGameCount);
                this.isBonus = true;
                break;
            }
            case 2: {
                if (this.isError) {
                    return;
                }
                this.fireEvent(eventId, currentGameCount, bigIntervalGameCount);
                this.logSimulateEnd();
            }
        }
    }

    protected void fireEvent(int eventId, int currentGameCount, int bigIntervalGameCount) {
        ListIterator i = null;
        try {
            i = this.listeners.listIterator();
            while (i.hasNext()) {
                ((DataCounterListener)i.next()).event(eventId, currentGameCount, bigIntervalGameCount);
            }
            Object var6_5 = null;
            i = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            i = null;
            throw throwable;
        }
    }

    public void logSimulateStart() {
        if (this.isError) {
            this.logPanel.addTextLine("\u5165\u529b\u6761\u4ef6\u304c\u77db\u76fe\u3057\u3066\u307e\u305b\u3093\uff1f");
        } else {
            this.logPanel.addTextLine("\u958b\u59cb\u3057\u307e\u3059\u3002");
        }
    }

    public void logStart(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.logPanel.addText(String.valueOf(currentGameCount));
        this.logPanel.addText("\t\u6253\u3061\u59cb\u3081");
        this.logPanel.addTextLine("\t" + this.coin);
    }

    public void logEnd(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.logPanel.addText(String.valueOf(currentGameCount));
        this.logPanel.addText("\t\u30e4\u30e1");
        this.logPanel.addTextLine("\t" + this.coin);
    }

    public void logStop(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.logPanel.addText(String.valueOf(currentGameCount));
        this.logPanel.addText("\t\u3042\u304d\u3089\u3081");
        this.logPanel.addTextLine("\t" + this.coin);
    }

    public void logBonusStart(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.bonusCoin = this.coin;
    }

    public void logBonusEnd(int currentGameCount, int bigIntervaleGameCount) {
        if (this.logPanel.isResultOnly()) {
            return;
        }
        this.bonusCoin = this.coin - this.bonusCoin;
        this.logPanel.addText(String.valueOf(currentGameCount));
        this.logPanel.addText("\tBONUS[");
        this.logPanel.addText(String.valueOf(this.bonusCoin));
        this.logPanel.addText("]");
        this.logPanel.addTextLine("\t" + this.coin);
    }

    public void logSimulateEnd() {
        double pay = (double)this.outCoin / (double)this.inCoin * 100.0;
        this.logPanel.addTextLine("");
        this.logPanel.addText("\u7dcf\u56de\u8ee2\u6570\t");
        this.logPanel.addTextLine(String.valueOf(this.totalGameCount));
        this.logPanel.addText("in:\t");
        this.logPanel.addTextLine(String.valueOf(this.inCoin));
        this.logPanel.addText("out:\t");
        this.logPanel.addTextLine(String.valueOf(this.outCoin));
        this.logPanel.addText("\u5dee\u679a:\t");
        this.logPanel.addText(String.valueOf(this.coin));
        this.logPanel.addText("(");
        this.logPanel.addText(String.valueOf(pay));
        this.logPanel.addTextLine("%)");
    }
}

