/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.Gogogo;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.Gogogo.GogogoMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class GogogoDataCounter
extends AbstractDataCounter4Stock {
    protected JCheckBoxMenuItem gtReport = null;
    protected JCheckBoxMenuItem modeReport = null;
    protected JCheckBoxMenuItem chanceReport = null;
    protected JCheckBoxMenuItem cup3Report = null;
    protected JCheckBoxMenuItem debug = null;
    protected int gtCount = 0;
    protected int gtCount0 = 0;
    protected int chanceCount = 0;
    protected int cup3NoGt = 0;

    public static final void main(String[] args) {
        GogogoDataCounter main = null;
        try {
            main = new GogogoDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public GogogoDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.modeReport = new JCheckBoxMenuItem("\u30e2\u30fc\u30c9\u5c65\u6b74");
        this.gtReport = new JCheckBoxMenuItem("GT\u5c65\u6b74", true);
        this.chanceReport = new JCheckBoxMenuItem("\u30c1\u30e3\u30f3\u30b9\u76ee\u8868\u793a", true);
        this.cup3Report = new JCheckBoxMenuItem("CUP3\u9023\u8868\u793a\u8868\u793a", true);
        this.debug = new JCheckBoxMenuItem("\u30c7\u30d0\u30c3\u30b0\u60c5\u5831");
        this.addOptionMenu(this.modeReport);
        this.addOptionMenu(this.gtReport);
        this.addOptionMenu(this.chanceReport);
        this.addOptionMenu(this.cup3Report);
        this.addOptionMenu(this.debug);
        this.textInitialStock.setText("100");
    }

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected String getFrameTitle() {
        return "\u30de\u30c3\u30cf\u30b4\u30fc\u30b4\u30fc\u30b4\u30fc\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new GogogoMainBoard();
    }

    public void processEvent(int eventId) {
        switch (eventId) {
            case 32: {
                ++this.chanceCount;
                this.eventChance();
                break;
            }
            case 33: {
                if (!((GogogoMainBoard)((AbstractDataCounter)this).simulator).isGt()) {
                    ++this.cup3NoGt;
                }
                this.eventCup3();
                break;
            }
            case 28: {
                this.eventSuperHighStart();
                break;
            }
            case 29: {
                this.eventSuperHighEnd();
                break;
            }
            case 30: {
                this.eventHighStart();
                break;
            }
            case 31: {
                this.eventHighEnd();
                break;
            }
            case 25: {
                ++this.gtCount0;
                this.eventGtHit();
                break;
            }
            case 26: {
                ++this.gtCount;
                this.eventGtStart();
                break;
            }
            case 27: {
                this.eventGtEnd();
                break;
            }
            case 23: {
                this.eventRtStart();
                break;
            }
            case 0: {
                if (!this.debug.isSelected()) break;
                this.eventDebug();
            }
        }
    }

    protected void eventBonusStart() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
    }

    protected void eventBonusEnd() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + ((AbstractDataCounter)this).currentBonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\t");
        int breakFactor = ((GogogoMainBoard)((AbstractDataCounter)this).simulator).getBreakFactor();
        switch (breakFactor) {
            case -10: {
                this.appendLog("RT\u30c6\u30fc\u30d6\u30eb");
                break;
            }
            case -11: {
                this.appendLog("\u7d14\u30cf\u30ba\u30ec");
                break;
            }
            case 11: {
                this.appendLog("CUP3\u9023");
            }
        }
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventGtHit() {
        int currentGameCount = this.getCurrentGameCount();
        if (!this.gtReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tGT\u5f53\u9078");
        int hitCount = ((GogogoMainBoard)((AbstractDataCounter)this).simulator).getCurrentGtHitCount();
        this.appendLog("\t\u9023=" + String.valueOf(hitCount));
        switch (((GogogoMainBoard)((AbstractDataCounter)this).simulator).getGtFactor()) {
            case 2: {
                this.appendLog("\tBIG\u4e2d\u30c1\u30a7\u30ea\u30fc");
                break;
            }
            case 4: {
                this.appendLog("\tBIG\u4e2d\u30cf\u30ba\u30ec");
                break;
            }
            case 3: {
                this.appendLog("\tBIG\u4e2d\u30b9\u30a4\u30ab");
                break;
            }
            case 5: {
                this.appendLog("\tJAC\u30cf\u30ba\u30ec");
                break;
            }
            case 0: {
                if (((GogogoMainBoard)((AbstractDataCounter)this).simulator).isSuperHigh()) {
                    this.appendLog("\t\u30c1\u30e3\u30f3\u30b9\u76ee(\u8d85\u9ad8\u78ba)");
                    break;
                }
                if (((GogogoMainBoard)((AbstractDataCounter)this).simulator).isHigh()) {
                    this.appendLog("\t\u30c1\u30e3\u30f3\u30b9\u76ee(\u9ad8\u78ba)");
                    break;
                }
                this.appendLog("\t\u30c1\u30e3\u30f3\u30b9\u76ee");
                break;
            }
            case 1: {
                this.appendLog("\t\u30c1\u30a7\u30ea\u30fc2\u9023");
                break;
            }
            case 6: {
                this.appendLog("\tREG\u4e2d\u30d3\u30bf");
            }
        }
        this.appendLog("\n");
    }

    protected void eventGtStart() {
        if (!this.gtReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(this.getCurrentGameCount()) + "]");
        int gtFloor = ((GogogoMainBoard)((AbstractDataCounter)this).simulator).getGtFloor();
        this.appendLog("\tGT" + gtFloor + "\u767a\u52d5\n");
    }

    protected void eventGtEnd() {
        if (!this.gtReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(this.getCurrentGameCount()) + "]");
        this.appendLog("\tGT\u7d42\u4e86");
        int gtZan = ((GogogoMainBoard)((AbstractDataCounter)this).simulator).getGtRenCount();
        this.appendLog("\tGT\u6b8b=" + String.valueOf(gtZan));
        this.appendLog("\n");
    }

    protected void eventRtStart() {
        int currentGameCount = this.getCurrentGameCount();
        if (!this.rtReport.isSelected() && !this.rtReportNotZero.isSelected()) {
            return;
        }
        if (currentGameCount == 0 && !this.rtReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tRT\u958b\u59cb");
        int rtFloor = ((GogogoMainBoard)((AbstractDataCounter)this).simulator).getRtFloor();
        this.appendLog("\t" + rtFloor);
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventDebug() {
        int currentFlag = ((GogogoMainBoard)((AbstractDataCounter)this).simulator).getCurrentFlag();
        this.appendLog("\t[" + this.getCurrentGameCount() + "]");
        switch (currentFlag) {
            case 2: {
                this.appendLog("\tBIG");
                break;
            }
            case 3: {
                this.appendLog("\tREG");
                break;
            }
            case 1: {
                this.appendLog("\t\u30ea\u30d7\u30ec\u30a4(X)");
                break;
            }
            case 9: {
                this.appendLog("\t\u30ea\u30d7\u30ec\u30a4(O)");
                break;
            }
            case 4: {
                this.appendLog("\tCUP(X)");
                break;
            }
            case 8: {
                this.appendLog("\tCUP(O)");
                break;
            }
            case 10: {
                this.appendLog("\tCUP(O),\u62bc\u3057\u9806\u4e0d\u554f");
                break;
            }
            case 5: {
                this.appendLog("\t\u30c1\u30a7\u30ea\u30fc");
                break;
            }
            case 6: {
                this.appendLog("\t\u30b9\u30a4\u30ab");
                break;
            }
            case 7: {
                this.appendLog("\t\u30c1\u30e3\u30f3\u30b9\u76ee");
                break;
            }
            default: {
                this.appendLog("\t\u4e0d\u660e\u306a\u30d5\u30e9\u30b0");
            }
        }
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\n");
    }

    protected void eventSimulateStart() {
        this.gtCount = 0;
        this.gtCount0 = 0;
        this.chanceCount = 0;
        this.cup3NoGt = 0;
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("GT", this.gtCount, this.getTotalGameCount());
        this.appendLogDenominator("GT\u521d\u5f53", this.gtCount0, this.getTotalGameCount());
        this.appendLogDenominator("\u30c1\u30e3\u30f3\u30b9\u76ee", this.chanceCount, this.getTotalGameCount());
        this.appendLogDenominator("\u81ea\u529bCUP3\u9023", this.cup3NoGt, this.getTotalGameCount());
        this.appendLog("\n");
        this.appendLogPayout();
    }

    protected void eventSuperHighStart() {
        if (!this.modeReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\t\u8d85\u9ad8\u78ba\u958b\u59cb");
        this.appendLog("\n");
    }

    protected void eventSuperHighEnd() {
        if (!this.modeReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\t\u8d85\u9ad8\u78ba\u7d42\u4e86");
        this.appendLog("\n");
    }

    protected void eventHighStart() {
        if (!this.modeReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\t\u9ad8\u78ba\u958b\u59cb");
        this.appendLog("\n");
    }

    protected void eventHighEnd() {
        if (!this.modeReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\t\u9ad8\u78ba\u7d42\u4e86");
        this.appendLog("\n");
    }

    protected void eventChance() {
        if (!this.chanceReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        if (((GogogoMainBoard)((AbstractDataCounter)this).simulator).isSuperHigh()) {
            this.appendLog("\t\u30c1\u30e3\u30f3\u30b9\u76ee(\u8d85\u9ad8\u78ba)");
        } else if (((GogogoMainBoard)((AbstractDataCounter)this).simulator).isHigh()) {
            this.appendLog("\t\u30c1\u30e3\u30f3\u30b9\u76ee(\u9ad8\u78ba)");
        } else {
            this.appendLog("\t\u30c1\u30e3\u30f3\u30b9\u76ee");
        }
        this.appendLog("\n");
    }

    protected void eventCup3() {
        if (!this.cup3Report.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tCUP3\u9023");
        this.appendLog("\n");
    }

    protected void processActionEvent(ActionEvent e) {
    }
}

