/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.NeoPlanet;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter4Stock;
import jp.sourceforge.slotsimulator.machines.NeoPlanet.NeoPlanetMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface4Stock;

public class NeoPlanetDataCounter
extends AbstractDataCounter4Stock {
    protected JCheckBoxMenuItem cherryReport = null;
    protected int[] modeStayed = new int[]{0, 0, 0, 0, 0, 0};

    public static final void main(String[] args) {
        NeoPlanetDataCounter main = null;
        try {
            main = new NeoPlanetDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public NeoPlanetDataCounter() {
        this.initialize();
    }

    protected void initializeGui(JPanel north) {
        super.initializeGui(north);
        this.cherryReport = new JCheckBoxMenuItem("\u30c1\u30a7\u30ea\u30fc\u8868\u793a");
        this.addOptionMenu(this.cherryReport);
        this.textInitialStock.setText("100");
    }

    protected Dimension getFrameSize() {
        return new Dimension(500, 550);
    }

    protected String getFrameTitle() {
        return "\u30cd\u30aa\u30d7\u30e9\u30b7\u30df\u30e5\u30ec\u30fc\u30bf";
    }

    protected MainBoardInterface getSimulator() {
        return new NeoPlanetMainBoard();
    }

    public void processEvent(int eventId) {
        switch (eventId) {
            case 23: {
                this.eventRtStart();
                break;
            }
            case 25: 
            case 26: {
                this.eventCherry(eventId);
            }
        }
    }

    protected void eventBonusStart() {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
    }

    protected void eventBonusEnd() {
        int currentMode = ((MainBoardInterface4Stock)((AbstractDataCounter)this).simulator).getCurrentMode();
        int n = currentMode - 1;
        this.modeStayed[n] = this.modeStayed[n] + 1;
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog(String.valueOf(this.getCurrentGameCount()));
        this.appendLog("\t");
        if (((AbstractDataCounter)this).simulator.getCurrentBonus() == 3) {
            this.appendLog("BIG[" + ((AbstractDataCounter)this).currentBonusCoin + "]");
        } else {
            this.appendLog("REG");
        }
        this.appendLog("\t");
        int breakFactor = ((NeoPlanetMainBoard)((AbstractDataCounter)this).simulator).getBreakFactor();
        switch (breakFactor) {
            case -10: {
                this.appendLog("\u5929\u4e95");
                break;
            }
            case -11: {
                this.appendLog("\u7d14\u30cf\u30ba\u30ec");
                break;
            }
            case 13: {
                this.appendLog("\u30c1\u30a7\u30ea\u30fc");
                break;
            }
            case 15: {
                this.appendLog("\u901a\u5e38\u89e3\u9664");
                break;
            }
            case 14: {
                this.appendLog("\u30ea\u30d7\u30ec\u30a4");
            }
        }
        this.appendLog("\tM" + String.valueOf(currentMode));
        this.appendLog("\t" + this.getCoin());
        this.appendLog("\tstock=" + this.getStockBRCount());
        this.appendLog("\n");
    }

    protected void eventRtStart() {
        int currentGameCount = this.getCurrentGameCount();
        if (!this.rtReport.isSelected() && !this.rtReportNotZero.isSelected()) {
            return;
        }
        if (currentGameCount == 0 && !this.rtReport.isSelected()) {
            return;
        }
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        this.appendLog("\tRT\u958b\u59cb");
        int mode = this.getCurrentMode();
        this.appendLog("\tM" + mode);
        this.appendLog("\n");
    }

    protected void eventStart() {
    }

    protected void eventSimulateStart() {
        int i = 0;
        while (i < 6) {
            this.modeStayed[i] = 0;
            ++i;
        }
    }

    protected void eventSimulateEnd() {
        this.appendLogStopGameAndTotalGame();
        this.appendLogDenominator("BIG", this.getBigCount(), this.getTotalGameCount());
        this.appendLogDenominator("REG", this.getRegCount(), this.getTotalGameCount());
        this.appendLogDenominator("\u5408\u6210", this.getBigCount() + this.getRegCount(), this.getTotalGameCount());
        int bonusCount = this.getBigCount() + this.getRegCount();
        this.appendLog("\n\nM1:\t" + this.modeStayed[0] / bonusCount * 100 + "%\n");
        this.appendLog("M2:\t" + this.modeStayed[1] / bonusCount * 100 + "%\n");
        this.appendLog("M3:\t" + this.modeStayed[2] / bonusCount * 100 + "%\n");
        this.appendLog("M4:\t" + this.modeStayed[3] / bonusCount * 100 + "%\n");
        this.appendLog("M5:\t" + this.modeStayed[4] / bonusCount * 100 + "%\n");
        this.appendLog("M6:\t" + this.modeStayed[5] / bonusCount * 100 + "%\n");
        this.appendLogPayout();
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventCherry(int eventId) {
        if (((AbstractDataCounter)this).menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.cherryReport.isSelected()) {
            return;
        }
        int currentGameCount = this.getCurrentGameCount();
        this.appendLog("\t[" + String.valueOf(currentGameCount) + "]");
        if (eventId == 25) {
            this.appendLog("\t2\u30c1\u30a7\u30ea\u30fc\n");
        } else {
            this.appendLog("\t4\u30c1\u30a7\u30ea\u30fc\n");
        }
    }
}

