/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.KingCamel;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import jp.sourceforge.slotsimulator.datacounter.AbstractDataCounter;
import jp.sourceforge.slotsimulator.machines.KingCamel.KingCamelMainBoard;
import jp.sourceforge.slotsimulator.mainboard.MainBoardInterface;

public class KingCamelDataCounter
extends AbstractDataCounter {
    private JCheckBoxMenuItem menuItemCz = null;
    private JCheckBoxMenuItem menuItemSyuutyuu = null;
    private JCheckBoxMenuItem menuItemDebug = null;
    private int currentGameCount = 0;
    private int totalGameCount = 0;
    private int kbCount = 0;
    private int mbCount = 0;
    private int ccCount = 0;
    private int atContinueGameCount = 0;
    private int atHitGameCount = 0;
    private int syuutyuuHitGameCount = 0;
    private int syuutyuuEndGameCount = 0;
    private int atStartCoin = 0;
    private int atCoin = 0;

    public static final void main(String[] args) {
        KingCamelDataCounter main = null;
        try {
            main = new KingCamelDataCounter();
            ((Window)((Object)main)).show();
            Object var3_2 = null;
            main = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            main = null;
            throw throwable;
        }
    }

    public KingCamelDataCounter() {
        this.initialize();
    }

    protected String getFrameTitle() {
        return "\u30ad\u30f3\u30b0\u30ad\u30e3\u30e1\u30eb\u30b7\u30df\u30e5";
    }

    protected MainBoardInterface getSimulator() {
        return new KingCamelMainBoard();
    }

    protected void initializeGui(JPanel northPanel) {
        this.menuItemCz = new JCheckBoxMenuItem("CZ(\u30c1\u30e3\u30f3\u30b9\u30be\u30fc\u30f3)\u8868\u793a");
        this.menuItemSyuutyuu = new JCheckBoxMenuItem("\u5185\u90e8\u96c6\u4e2d\u72b6\u614b\u8868\u793a");
        this.menuItemDebug = new JCheckBoxMenuItem("\u30c7\u30d0\u30c3\u30b0");
        this.menuOption.add(this.menuItemCz);
        this.menuOption.add(this.menuItemSyuutyuu);
        this.menuOption.add(this.menuItemDebug);
    }

    protected void processActionEvent(ActionEvent e) {
    }

    protected void eventBonusEnd() {
    }

    protected void eventBonusStart() {
    }

    protected void eventSimulateEnd() {
        this.appendLog("\n\n" + this.currentGameCount + "\u30e4\u30e1");
        this.appendLog("\tTotal:" + this.totalGameCount + "G");
        double ratio = (double)this.totalGameCount / (double)this.kbCount;
        this.appendLog("\n\nKB:\t" + this.kbCount + "\t1/" + ratio);
        ratio = (double)this.totalGameCount / (double)this.mbCount;
        this.appendLog("\nMB:\t" + this.mbCount + "\t1/" + ratio);
        ratio = (double)this.totalGameCount / (double)this.ccCount;
        this.appendLog("\nCC:\t" + this.ccCount + "\t1/" + ratio);
        double pay = (double)this.getOutCoin() / (double)this.getInCoin() * 100.0;
        this.appendLog("\n\nin:\t" + this.getInCoin());
        this.appendLog("\nout:\t" + this.getOutCoin());
        this.appendLog("\n\u5dee\u679a:\t" + this.getCoin() + "(" + pay + "%)");
        double time = (double)this.runTimeMillis / 1000.0;
        this.appendLog("\n\n" + time + "[ms]");
        this.appendLog("\tused:" + Runtime.getRuntime().freeMemory() / 1000L + "[kb]");
        this.appendLog("\ttotal" + Runtime.getRuntime().totalMemory() / 1000L + "[kb]");
    }

    protected void eventSimulateStart() {
        this.totalGameCount = 0;
        this.currentGameCount = 0;
        this.kbCount = 0;
        this.mbCount = 0;
        this.ccCount = 0;
    }

    protected void eventStart() {
        ++this.currentGameCount;
        ++this.totalGameCount;
    }

    protected void processEvent(int event) {
        switch (event) {
            case 20: {
                this.syuutyuuHitGameCount = this.currentGameCount;
                this.eventSyuutyuu(event);
                break;
            }
            case 21: {
                this.syuutyuuEndGameCount = this.currentGameCount;
                this.eventSyuutyuu(event);
                break;
            }
            case 30: 
            case 31: {
                this.eventCz(event);
                break;
            }
            case 32: {
                this.event3(event);
                break;
            }
            case 33: {
                ++this.currentGameCount;
                ++this.totalGameCount;
                break;
            }
            case 22: {
                ++this.kbCount;
                this.atHitGameCount = this.currentGameCount;
                this.atStartCoin = this.getCoin();
                this.eventAtStart(event);
                break;
            }
            case 24: {
                ++this.mbCount;
                this.atHitGameCount = this.currentGameCount;
                this.atStartCoin = this.getCoin();
                this.eventAtStart(event);
                break;
            }
            case 26: {
                ++this.ccCount;
                this.atHitGameCount = this.currentGameCount;
                this.atStartCoin = this.getCoin();
                this.eventAtStart(event);
                break;
            }
            case 28: {
                ++this.ccCount;
                this.atHitGameCount = this.currentGameCount;
                this.atStartCoin = this.getCoin();
                this.eventAtStart(event);
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                this.atCoin = this.getCoin() - this.atStartCoin;
                this.eventAtEnd(event);
                this.currentGameCount = 1;
                break;
            }
            case 50: {
                this.eventDebug(event);
            }
        }
    }

    protected void eventDebug(int event) {
        if (!this.menuItemDebug.isSelected()) {
            return;
        }
        this.appendLog("(");
        this.appendLog(String.valueOf(this.currentGameCount));
        this.appendLog(")\t");
        switch (this.simulator.getCurrentFlag()) {
            case 0: {
                this.appendLog("\u306f\u305a\u308c");
                break;
            }
            case 1: {
                this.appendLog("\u30ea\u30d7\u30ec\u30a4");
                break;
            }
            case 5: {
                this.appendLog("\u30d9\u30eb");
                break;
            }
            case 4: {
                this.appendLog("\u30b7\u30f3\u30b0\u30eb");
                break;
            }
            case 6: {
                this.appendLog("3\u679a\u5f79");
            }
        }
        this.appendLog("\t");
        this.appendLog(String.valueOf(this.getCoin()));
        if (((KingCamelMainBoard)this.simulator).isAt()) {
            this.appendLog("\tAT(");
            switch (((KingCamelMainBoard)this.simulator).getAtKind()) {
                case 0: {
                    this.appendLog("CC(s)");
                    break;
                }
                case 3: {
                    this.appendLog("CC(l)");
                    break;
                }
                case 2: {
                    this.appendLog("KB");
                    break;
                }
                case 1: {
                    this.appendLog("MB");
                }
            }
            this.appendLog(")");
        }
        this.appendLog("\n");
    }

    protected void event3(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        this.appendLog("(");
        this.appendLog(String.valueOf(this.currentGameCount));
        this.appendLog(")\t3\u679a\u5f79\n");
    }

    protected void eventAtStart(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
    }

    protected void eventAtEnd(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        int g = ((KingCamelMainBoard)this.simulator).getAtCounter();
        this.appendLog(String.valueOf(this.atHitGameCount));
        this.appendLog("\t");
        switch (event) {
            case 23: {
                this.appendLog("KB" + g);
                break;
            }
            case 25: {
                this.appendLog("MB" + g);
                break;
            }
            case 27: {
                this.appendLog("CC(short)" + g);
                break;
            }
            case 29: {
                this.appendLog("CC(long)" + g);
            }
        }
        this.appendLog("\t" + String.valueOf(this.atCoin) + "\u679a");
        this.appendLog("\tM" + String.valueOf(((KingCamelMainBoard)this.simulator).getCurrentMode()) + "\u3078");
        this.appendLog("\n");
    }

    protected void eventSyuutyuu(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.menuItemSyuutyuu.isSelected()) {
            return;
        }
        if (event == 20) {
            this.appendLog("\t(");
            this.appendLog(String.valueOf(this.syuutyuuHitGameCount));
            this.appendLog(")\t\u96c6\u4e2d");
            this.appendLog("\u5f53\u9078");
            this.appendLog("\tM" + String.valueOf(((KingCamelMainBoard)this.simulator).getCurrentMode()));
            this.appendLog("\n");
        } else {
            this.appendLog("\t(");
            this.appendLog(String.valueOf(this.syuutyuuEndGameCount));
            this.appendLog(")\t\u96c6\u4e2d");
            this.appendLog("\u30d1\u30f3\u30af\n");
        }
    }

    protected void eventCz(int event) {
        if (this.menuItemResultOnly.isSelected()) {
            return;
        }
        if (!this.menuItemCz.isSelected()) {
            return;
        }
        this.appendLog("\t(");
        this.appendLog(String.valueOf(this.currentGameCount));
        this.appendLog(")\tCZ");
        int czFloor = ((KingCamelMainBoard)this.simulator).getCzFloor();
        if (event == 30) {
            this.appendLog(String.valueOf(czFloor));
            this.appendLog("\u958b\u59cb\n");
        } else {
            this.appendLog("\u7d42\u4e86\n");
        }
    }
}

