/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.slotsimulator.machines.KingPulser;

import jp.sourceforge.slotsimulator.library.SimulatorLibrary;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard;
import jp.sourceforge.slotsimulator.mainboard.AbstractMainBoard4Stock;

public class KingPulserMainBoard
extends AbstractMainBoard4Stock {
    public static final int EVENT_RT_START = 23;
    public static final int EVENT_RT_END = 24;
    public static final int BREAK_REPLAY = 11;
    public static final int FLAG_BELL = 4;
    public static final int FLAG_CHERRY = 5;
    public static final int FLAG_ORANGE = 6;
    public static final int FLAG_BIG_BELL = 2;
    public static final int FLAG_BIG_CHERRY = 3;
    public static final int FLAG_BIG_ORANGE = 4;
    protected int[][] flagTable = new int[][]{{4, 57264, 220, 108, 7380, 80, 480}, {4, 57264, 220, 108, 7380, 80, 480}, {4, 57232, 232, 128, 7380, 80, 480}, {4, 57200, 244, 148, 7380, 80, 480}, {4, 57168, 256, 168, 7380, 80, 480}, {4, 56820, 272, 180, 7700, 80, 480}};
    protected int[][] flagTableBig = new int[][]{{6736, 19200, 28800, 4800, 6000}, {6736, 19200, 28800, 4800, 6000}, {6736, 19200, 28800, 4800, 6000}, {6736, 19200, 28800, 4800, 6000}, {4736, 19200, 30800, 4800, 6000}, {2736, 19200, 32800, 4800, 6000}};
    protected int[][] flagTableJac = new int[][]{{4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}, {4, 65532}};
    protected int[][] rtTable1 = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 140, 10, 60, 10, 13, 13}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 153, 10, 60, 10, 13, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 141, 10, 59, 10, 13, 13}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 153, 10, 60, 10, 13, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 191, 9, 30, 8, 6, 2}, {183, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 12, 20, 4, 2, 0}};
    protected int[][] rtTable2 = new int[][]{{11, 28, 34, 30, 16, 12, 20, 13, 8, 13, 0, 20, 14, 11, 13, 13}, {11, 28, 34, 30, 16, 12, 20, 13, 8, 13, 0, 30, 35, 3, 2, 1}, {18, 28, 30, 28, 16, 12, 18, 14, 8, 14, 0, 20, 14, 11, 12, 13}, {16, 21, 32, 45, 18, 12, 14, 10, 8, 9, 0, 30, 35, 3, 2, 1}, {16, 35, 34, 39, 16, 12, 20, 13, 8, 13, 0, 15, 10, 8, 8, 9}, {24, 41, 47, 40, 24, 12, 14, 9, 7, 9, 1, 10, 14, 3, 2, 0}};
    protected int[][] rtG = new int[][]{{1, 9, 17, 25, 33, 41, 49, 65, 81, 97, 128, 129, 257, 513, 769, 1025}, {8, 16, 24, 32, 40, 48, 64, 80, 96, 127, 128, 256, 512, 768, 1024, 1280}};
    protected boolean newStock = false;

    public int[][] getFlagTableHigh() {
        return this.flagTable;
    }

    public int[][] getFlagTableBigGame() {
        return this.flagTableBig;
    }

    public int[][] getFlagTableBonusGame() {
        return this.flagTableJac;
    }

    public void gameRt(int flag) {
        ++this.rtCounter;
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        if (this.rtCounter >= this.rtFloor) {
            this.isBreak = true;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[((AbstractMainBoard)this).settei - 1], (int)65536);
        switch (flag) {
            case 2: {
                this.stock.add(new Integer(3));
                break;
            }
            case 3: {
                this.stock.add(new Integer(4));
                break;
            }
            case 0: {
                this.breakFactor = -11;
                this.isBreak = true;
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
                break;
            }
            case 1: {
                if (random4096 < 6) {
                    this.breakFactor = 11;
                    this.isBreak = true;
                    break;
                }
                if (random4096 < 649) {
                    ((AbstractMainBoard)this).isReplay = true;
                    break;
                }
                if (!this.isBreak) break;
                this.bonusGet();
                this.fireCoinPlus(15);
            }
        }
    }

    public void gameNotRt(int flag) {
        if (!((AbstractMainBoard)this).isReplay) {
            this.fireCoinMinus(3);
        } else {
            ((AbstractMainBoard)this).isReplay = false;
        }
        int random4096 = SimulatorLibrary.random((int)4096);
        flag = SimulatorLibrary.getTableIndex((int[])this.flagTable[((AbstractMainBoard)this).settei - 1], (int)65536);
        switch (flag) {
            case 2: {
                this.stock.add(new Integer(3));
                this.reset();
                break;
            }
            case 3: {
                this.stock.add(new Integer(4));
                this.reset();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.fireCoinPlus(8);
                break;
            }
            case 5: {
                this.fireCoinPlus(4);
                break;
            }
            case 6: {
                this.fireCoinPlus(12);
            }
            case 1: {
                if (random4096 < 42 || random4096 >= 691) break;
                ((AbstractMainBoard)this).isReplay = true;
            }
        }
    }

    public void bigGame(int flag, int game, int jacInCount) {
        this.fireCoinMinus(3);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                if (jacInCount >= 2 && game <= 23) break;
                this.setJacIn();
                this.fireCoinPlus(6);
                break;
            }
            case 2: {
                this.fireCoinPlus(8);
                break;
            }
            case 3: {
                this.fireCoinPlus(4);
                break;
            }
            case 4: {
                this.fireCoinPlus(12);
            }
        }
    }

    public void jacGame(int flag, int gameCount) {
        this.fireCoinMinus(1);
        switch (flag) {
            case 0: {
                break;
            }
            case 1: {
                this.setJacHit();
                this.fireCoinPlus(15);
            }
        }
    }

    public void reset() {
        this.isBreak = false;
        if (this.stock.size() > 0) {
            this.newStock = this.noStock;
            this.nextBonus = (Integer)this.stock.get(0) == 3 ? 3 : 4;
            this.stock.remove(0);
            this.noStock = false;
        } else {
            this.nextBonus = -1;
            this.noStock = true;
        }
        if (!this.noStock) {
            this.rtFloor = this._getRtFloor();
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
            this.fireEvent(23);
        } else {
            this.rtCounter = 0;
            this.breakFactor = -10;
            super.reset();
        }
    }

    private int _getRtFloor() {
        int index = -1;
        index = this.newStock ? SimulatorLibrary.getTableIndex((int[])this.rtTable1[((AbstractMainBoard)this).settei - 1], (int)256) : SimulatorLibrary.getTableIndex((int[])this.rtTable2[((AbstractMainBoard)this).settei - 1], (int)256);
        int min = this.rtG[0][index];
        int max = this.rtG[1][index];
        int g = SimulatorLibrary.getRandomPerRange((int)min, (int)max);
        return g;
    }
}

