package Sledge::Plugin::ScratchPad;
# $Id: ScratchPad.pm,v 1.2 2003/02/14 07:46:18 miyagawa Exp $
#
# Tatsuhiko Miyagawa <miyagawa@edge.co.jp>
# Livin' On The EDGE, Limited.
#

use strict;
use vars qw($VERSION);
$VERSION = 0.01;

sub import {
    my $class = shift;
    my $pkg = caller;

    no strict 'refs';
    *{"$pkg\::pad"} = sub {
	my $self = shift;
	return $self->{pad};	# read only
    };

    $pkg->register_hook(
	AFTER_INIT => sub {
	    my $self = shift;
	    $self->{pad} = Sledge::Plugin::ScratchPad->new;
	},
    );
}


sub new { bless {}, shift }

sub param {
    my $self = shift;
    if (@_ == 0) {
	return keys %$self;
    }
    elsif (@_ == 1) {
	return $self->{$_[0]};
    }
    else {
	$self->{$_[0]} = $_[1];
    }
}

sub clear {
    my $self = shift;
    %$self = ();
}

1;

__END__

=head1 NAME

Sledge::Plugin::ScratchPad - temporary data buffer

=head1 SYNOPSIS

  package Foo::Pages::Bar;
  use Sledge::Plugin::ScratchPad;

  sub dispatch_baz {
      my $self = shift;
      $self->pad->param(foo => 'bar');    # store
      my $bar = $self->pad->param('foo'); # fetch
  }

=head1 DESCRIPTION

ScratchPadץ饰ϡƥݥ˥ǡ񤭤ΰ󶡤ޤ
ƥ֥ȴ֤ǥǡޤ魯ݤˡPages֥Ȥ̤ƥǡ
Ȥꤹ뤳ȤǤޤǼ줿ǡϡdispatch᥽åɤ
λ˴ޤ

=head1 METHODS

C<use Sledge::Plugin::ScrachPad> 뤳ȤǡΥ饹 C<pad>
᥽åɤѲǽˤʤޤC<pad> ᥽åɤ
Sledge::Plugin::ScratchPad 饹Υ󥹥󥹤ؤ read only accessor
ǡset/get ǽ C<param()> ᥽åɤӡȤˤC<clear()>
᥽åɤƤޤ

=head1 AUTHOR

Tatsuhiko Miyagawa <miyagawa@edge.co.jp> with Sledge development team.

=head1 SEE ALSO

pnotes in L<Apache>

=cut


