{*********************************************************

 SlavaNap Extend source code.

 Copyright 2002 by antidom <antidom@mail7.ph>
 Written Some comments in Japanese Shift_JIS char code.
 Released under GNU General Public License    //ׂGPLłR(L[`)m

 Latest version is available at #SlavaDev channel on "nanashi"

**********************************************************

 Unit: local2global

 NAT̒ɎIĂIʂ߰0ԼƂƂł悤ɂ߯߰

 How To Use:
 Np󂫂ڂ

 g: (How to Use in Japanese)
 1.handler.pasłunituses
 2.Handler_Login();  tmp_pos:=204; A
   Handler_Motd;̒̍s
   CnvLocalIPtoGlobalIP(local);
   }
 3.RpC
 4.(߄t)ϰ

 Other:
 Ɋւ٧ǁB
 OIProcessMessaagesٰ߂ő҂_ɂẮA
 Ƒf炵񎦂ȊÖӌ͖܂B

*********************************************************

  Special Thanks
  EȂՂɑgݍłꂽA܂ς玁
  MataPara

  Epb`낢뉺usj12262
  usj12262

  E#SlavaDev̖ʁX
  Member of #SlavaDev channel

*********************************************************

  Change Log

  ** 2002/04/25 09:00 JST +0900 **
  E쐬
  First Made


  ** 2002/05/01 12:00 JST +0900 **
  Eϊ悪[JɂȂĂ܂ꍇ͕ϊȂ悤ɂ
  It tried not to change it when the place of the change became local.

  E蕉׌y
  Decision load reduction.

  EebZ[WύX
  Each message modified.

  EMOTDƂĕϊS@bZ[WY[Uɗ
  Send message to an applicable user as MOTD.


*********************************************************}

unit local2global;

interface
uses
  //DelphiWunit
  Windows, WinSock, SysUtils, Classes, Messages, Forms,
  //SlavaNap Unit
  users, localusers, constants, vars, stypes, slavamasks;

function CnvLocalIPtoGlobalIP(local: TLocalUser): boolean;

const
  strResolveRange = '00:30:00';           //HH:MM:SSŉ̊ԊuB
  WM_NSLOOKUP_RESULT = WM_USER + $0174;   //Message of resolve action
  
type
  PGetHostStruct=^TGetHostStruct;
  TGetHostStruct=Record
          Case Integer of
          0: (buf: array [0..MAXGETHOSTSTRUCT-1] of BYTE);
          1: (hostEnt: THostEnt;);
  end;
  
  TASyncBlockResolver = class(TPersistent)
  private
    FSrvIP: in_addr;              //IP̃LbV
    FSrvIPstr: string;            //*.*.*.*`IP(ϊȂ緬Ɏc
    FResolved: Boolean;           //Osォ̃tO True:ς
    FResolving: Boolean;          //̃tO
    FResolveRange: TDateTime;     //̍ŒԊuAstrResolveRange̒li[
    FNextResolveTime: TDateTime;  //ɖO
    FResolveResult: Boolean;
                                  
    NsLookup_HostEnt: TGetHostStruct;
    
    FWindowHandle: THandle;
    FIsSrvIPLocal: boolean;       //T[oIP̓[Jۂ?̃LbV
  protected
    procedure WndProc(var Msg: TMessage);
    procedure WmNslookupResult(var Msg: TMessage);
  public
    constructor Create; 
    destructor Destroy; override;
    function Resolve  : boolean;
    function IsLocalIP(sIP: string): boolean; 
  published
    property SrvIP: in_addr read FSrvIP;  
    property SrvIPstr: string read FSrvIPstr;
    property Resolved: boolean read FResolved;
    property Resolving: boolean read FResolving;
    property ResolveRange: TDateTime read FResolveRange;
    property ResolveResult: Boolean read FResolveResult;
    property NextResolveTime: TDateTime read FNextResolveTime;
    property IsSrvIPLocal: boolean read FIsSrvIPLocal;
    
    property Handle: THandle read FWindowHandle;
  end;

implementation

uses
  handler, lang;

{$DEFINE SHOW_DEBUG}

const
  LNG_IPCONVERTED = 'local2global.pas: Your IP Address converted from:$1 to:$2';

var
  ASyncBlockResolver: TASyncBlockResolver;
                          
function CnvLocalIPtoGlobalIP(local: TLocalUser): boolean;
var
  TmpUserIP: string;
begin
  Result := False;
  TmpUserIP := Copy(inet_ntoa(in_addr(local.data.ip)), 1, 255);
   
  {$IFDEF SHOW_DEBUG}
  Debuglog('local2global.pas::Begin Judgment... User='+local.data.nick+' IP='+TmpUserIP);
  {$ENDIF}
  
  //moderatorȉƺݿقȂP
  If local.data.level in [napUserLeech, napUserUser, napUserModerator, napUserConsole] then begin  
    {$IFDEF SHOW_DEBUG}
    Debuglog('local2global.pas::NotMatch! User isn''t Admin or Elite.');
    {$ENDIF}
    Exit;
  end;

  //۰IPłȂΓP
  If not ASyncBlockResolver.IsLocalIP(TmpUserIP) then begin  
    {$IFDEF SHOW_DEBUG}
    Debuglog('local2global.pas::NotMatch! User''s IP isn''t local.');
    {$ENDIF}
    Exit;
  end;

  If now >= ASyncBlockResolver.NextResolveTime then begin
    //ׂ(߁)!!!!!̂ŉ
    if not ASyncBlockResolver.Resolve then begin
      {$IFDEF SHOW_DEBUG}
      Debuglog('local2global.pas::Resolve Failure...');
      {$ENDIF}    
      //ŝŉP
      Exit;
    end;
  end;

  If not ASyncBlockResolver.ResolveResult then begin 
    {$IFDEF SHOW_DEBUG}
    Debuglog('local2global.pas::Last Resolve Failed...');
    {$ENDIF}
    exit;
  end;

  If not(ASyncBlockResolver.IsSrvIPLocal) then begin
    //(߁)( ߁)( @)(@@)(@@)( @)( )(߁)!!
    //O[oIP?ɒu
    {$IFDEF SHOW_DEBUG}
    Debuglog('local2global.pas::Matched! ID='+local.data.Nick+' TmpUserIP='+TmpUserIP+' Replace to '+ASyncBlockResolver.SrvIPstr);
    {$ENDIF}

    //ւ
    local.data.ip := Cardinal(ASyncBlockResolver.SrvIP.S_addr);

    //local2global.pas: Your IP Address converted from:*.*.*.* to:*.*.*.*
    local.Exec(MSG_SERVER_MOTD, lang.GetLangEx(LNG_IPCONVERTED, TmpUserIP, ASyncBlockResolver.FSrvIPstr));

    Result  := True;
  end else begin
    {$IFDEF SHOW_DEBUG}
    Debuglog('local2global.pas::NotMatch! Server''s IP is Local! SrvIP='+ASyncBlockResolver.SrvIPstr);
    {$ENDIF}
  end;
end;


{ TASyncBlockResolver }

constructor TASyncBlockResolver.Create;
begin
  inherited;
  ZeroMemory(@SrvIP, SizeOf(SrvIP));
  FResolved  := False;
  FResolving := False;
  FResolveRange := StrToTime(strResolveRange);
  FNextResolveTime := 0;
  FIsSrvIPLocal := False;

  {$IFDEF VER140} //D6̑΍
  FWindowHandle := Classes.AllocateHWnd(WndProc);
  {$ELSE}         //D5ȉ
  FWindowHandle := AllocateHWnd(WndProc);
  {$ENDIF}
end;

destructor TASyncBlockResolver.Destroy;
begin
  if FWindowHandle <> 0 then begin
    {$IFDEF VER140} //D6̑΍
    Classes.DeallocateHWnd(FWindowHandle);
    {$ELSE}
    DeallocateHWnd(FWindowHandle);
    {$ENDIF}
  end;

  inherited Destroy;
end;

function TASyncBlockResolver.IsLocalIP(sIP: string): boolean;
begin
  //Is the IPAddress Local?
  //oȑ̓V[gT[LbglĂ܂
  Result := (sIP = '127.0.0.1') or
            MatchesMaskS(sIP, '192.168.*.*') or
            MatchesMaskS(sIP, '10.*.*.*') or
            MatchesMaskS(sIP, '172.16.*.*');
end;

function TASyncBlockResolver.Resolve: boolean;
var
  in_ipaddr: in_addr;
begin
  Result := False;
  If Resolving then Exit;
  FResolving := True;
  try
    FResolved := False;
    FResolveResult := False;

    //ϊs
    in_ipaddr.S_addr := inet_addr(PChar(servername_t));

    If in_ipaddr.S_addr = Integer(INADDR_NONE) then begin
      //IPAhXł͂ȂzXgł遨IPAhXɕϊ
      {$IFDEF SHOW_DEBUG}
      Debuglog('local2global.pas::Resolve::Begin...');
      {$ENDIF}
      WSAAsyncGetHostByName(ASyncBlockResolver.Handle, WM_NSLOOKUP_RESULT,
        PChar(servername_t), @ASyncBlockResolver.NsLookup_HostEnt,
        SizeOf(ASyncBlockResolver.NsLookup_HostEnt));
    end else
    begin     
      {$IFDEF SHOW_DEBUG}
      Debuglog('local2global.pas::Resolve::Success Immediately');
      {$ENDIF}
      FSrvIP := in_ipaddr;
      FResolved := True;
      FResolveResult := True;  
      FSrvIPstr := Copy(inet_ntoa(FSrvIP), 1, 255); //߰Ċm
    end;  
    
    while not FResolved do begin
      Sleep(20);
      Application.ProcessMessages;
    end;

    FIsSrvIPLocal:=IsLocalIP(FSrvIPStr);
    Result := ResolveResult;
  finally
    FResolving := False;
    FNextResolveTime := Now + ResolveRange;
  end;
end;

procedure TASyncBlockResolver.WmNslookupResult(var Msg: TMessage);
type
  PPChar = ^PChar;
var
	ppc:	PPChar;
begin
//ʂ(߁)!!!!!
  FResolveResult := False;
  if WSAGetAsyncError(Msg.lParam)<>0 then begin
    //nslookupɎs
    ZeroMemory(@FSrvIP, SizeOf(FSrvIP));  
    {$IFDEF SHOW_DEBUG}
    Debuglog( 'local2global.pas::Resolve::Failure [ '+ servername_t +
              ' ] Code: '+IntToStr(WSAGetAsyncError(Msg.lParam)));
    {$ENDIF}
  end else
  begin
    //Addresso
    ppc := pointer(NsLookup_HostEnt.hostEnt.h_addr_list);
    if Assigned(ppc^) then begin
      CopyMemory(@FSrvIP, pinaddr(ppc^), SizeOf(FSrvIP));   
      {$IFDEF SHOW_DEBUG}
      Debuglog('local2global.pas::Resolve::Success! '+servername_t+'='+Copy(inet_ntoa(FSrvIP), 1, 255));
      {$ENDIF}
      FResolveResult := True;
    end else
    begin
      //͂莸s
      ZeroMemory(@FSrvIP, SizeOf(FSrvIP));      
      {$IFDEF SHOW_DEBUG}
      Debuglog('local2global.pas::Resolve::Failure Could not Get IP from Arugment.');  
      {$ENDIF}
    end;
  end;
  FSrvIPstr := Copy(inet_ntoa(FSrvIP), 1, 255); //߰Ċm
  FResolved := True;
end;

procedure TASyncBlockResolver.WndProc(var Msg: TMessage);
begin
  if Msg.Msg = WM_NSLOOKUP_RESULT then
    //ʂ(߁)!!!!!
    WmNslookupResult(Msg)
  else
    with Msg do
      Result := DefWindowProc(FWindowHandle, Msg, WParam, LParam);
end;

initialization
  ASyncBlockResolver := TASyncBlockResolver.Create;

finalization
  ASyncBlockResolver.Free;

end.
 