{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by CyberAlien@users.sourceforge.net
 Released under GNU General Public License

 Latest version is available at
 http://slavanap2.sourceforge.net

**********************************************************

 Unit: vars

 Global variables

*********************************************************}
unit vars;

interface

uses
 SysUtils, Classes, graphics, zlib, slavasplitter, slavapanel, winsock,
 windows, constants, stypes, bans, blcksock, synsock, users, localusers,
 registered, servers, slavastrings, class_cmdlist, class_cmdexlist,
 class_doublecmdlist;

var
 running, restarting, showform, closing: Boolean;
 ApplicationDir: String;
 // server main variables
 server_socket: Array[0..MAX_LISTEN_SOCKET] of HSocket;
 server_port: Array[0..MAX_LISTEN_SOCKET] of Integer;
 servername_t, servername_i: String; // 2 variables instead of one to make it thread-safe
 myserverhandle: Integer;
 listen_interface: String;
 sync_reply_list: TNapDoubleCmdList;
 cmd_list: TNapDoubleCmdList;
 log_file, debug_file: TFileStream;
 start_time: Cardinal;
 start_time_t: time_t;
 cpu_usage: Integer;
 cpu_disable: Boolean;
 // options
 language: String;
 null_password: String;
 // limits
 registered_only: Boolean;
 allow_register: Boolean;
 accept_remote_users: Boolean;
 max_users: Integer;
 stats_delay: Cardinal;
 max_hotlist: Integer;
 max_ignorelist: Integer;
 max_clones: Integer;
 memory_limit: Integer;
 defsearchresults: Integer;
 maxsearchresults: Integer;
 maxremotesearchresults: Integer;
 disableremotesearch: Boolean;
 maxbrowseresults: Integer;
 maxremotebrowse: Integer;
 search_noforward_results, search_noforward_requests: Boolean;
 browse_noforward_results, browse_noforward_requests: Boolean;
 timeout_remote_search: Cardinal;
 linking: Boolean;
 max_accept: Integer;
 allow_create_channels: Boolean;
 redirect_cqex: Boolean;
 check_loginpass: Boolean;
 loginpass: String;
 old_opsay: Boolean;
 max_channels, max_channels_total: Integer;
 block_cqex_chat: Boolean;
 bytes_in, bytes_out, total_bytes_in, total_bytes_out: Int64;
 last_bytes_in, last_bytes_out: Int64;
 total_searches, num_searches, last_searches: Int64;
 total_transfers, num_transfers, last_transfers: Int64;
 num_login, last_login: Integer;
 num_rejects, last_rejects: Integer;
 num_servers: Integer;
 num_processed: Integer;
 blocked_clients: Array[0..softUnknown] of Boolean;
 blocked_custom: Array[0..MAX_CUSTOM_BLOCK] of String;
 blocked_messagetype: TBlockedMessageType;
 blocked_message: String;
 smart_block_winmx: Boolean;
 block_wantqueue: Boolean;
 allow_link: TAllowLinkType;
 allowed_servers: String;
 restrict_outgoing: Boolean;
 outgoing_list: String;
 switch_chat: Boolean;
 sockets_users_default: Boolean;
 sockets_users_send, sockets_users_recv: Integer;
 sockets_servers_default: Boolean;
 sockets_servers_send, sockets_servers_recv: Integer;
 max_privmsg_len, max_channelmsg_len: Integer;
 show_operators: Boolean;
 network_hub: Boolean;
 hub_syncreg, hub_syncban: Boolean;
 wallop_serverban: Boolean;
 banmail: String;
 redirect_url: String;
 channels_irc, channels_low: Boolean;
 autolink_only1: Boolean;
 restart_user: String;
 prevent_shouting: Boolean;
 chat_flash, chat_mini, wallop_im: Boolean;
 reconnect_delay: Boolean;
 search_antidom: Boolean;
 search_domshare: Integer;
 search_domsharesize: Int64;
 search_searchblock: Boolean;
 search_searchblockshare: Integer;
 search_searchblocksharesize: Int64;
 searchblock_chknum: Boolean;
 searchblock_chksize: Boolean;
 searchblock_logic_and: Boolean;
 browsedlblock_chknum: Boolean;
 browsedlblock_chksize: Boolean;
 browsedlblock_logic_and: Boolean;
 folder_depth: Integer;
 // lists
 db_online: TOnlineUserDataBase;
 db_local: TList;
 db_servers: TList;
 db_registered: TRegUserDataBase;
 db_bans: TBanList;
 db_motd: TStringHash;
 db_dengon: TStringHash;
 db_friends: TStringHash;
 db_blocks: TList;
 db_channels: TList;
 db_software: TNapCmdList;
 db_invitations: TNapCmdExList;
 db_reconnect: TStringList; // for reconnectors
 db_whowas: TNapCmdExList;
 // console
 cons: TLocalUser;
 cons_channels: TList;
 cons_chat: TList;
 cons_whois: TList;
 cons_blocks: TStringHash;
 cons_friends: TStringHash;
 cons_ignored: TStringHash;
 cons_list: TConsoleList;
 cons_reg_user: String;
 // interface
 b3_canclose: Bool3;
 allow_multiple_instances, startup_hide: Boolean;
 last_away_user: String;
 last_away_time: Cardinal;
 // log
 log_to_file, log_console_data: Boolean;
 save_stats: Boolean;
 clear_serverstats,
 clear_clientstats: Boolean;
 log_commands: Boolean;
 log_servercommands: Boolean;
 log_napigator: Boolean;
 log_dagsta: Boolean;
 log_login: Boolean;
 log_search: Boolean;
 log_transfers: Boolean;
// log_links: Boolean;
 // timeouts
 timeout_login: Cardinal;
 // statistics
 local_users, total_users, local_users_max, total_users_limit, total_users_max: Integer;
 local_files, total_files, local_files_max, total_files_max,
 local_bytes, total_bytes, local_bytes_max, total_bytes_max: Int64;
 total_connections: Integer;
 // sharing
 allow_share, shareinform: Boolean;
 share_nomodem, share_checkdup: Boolean;
 minshare, maxshare: Integer;
 minfilename: Integer;
 minduration: Integer;
 maxshareindex: Integer;
 maxshare_total: Int64;
 maxshare_audio,maxshare_video,maxshare_image,maxshare_app,maxshare_cd,maxshare_text,maxshare_mp3: Integer;
 minfilesize_audio,maxfilesize_audio,
 minfilesize_video,maxfilesize_video,
 minfilesize_image,maxfilesize_image,
 minfilesize_app,maxfilesize_app,
 minfilesize_cd,maxfilesize_cd,
 minfilesize_text,maxfilesize_text,
 minfilesize_mp3,maxfilesize_mp3: Int64;
 ext_mp3, ext_audio, ext_video, ext_text, ext_image, ext_app, ext_cd: String;
 ext_mp3_list, ext_audio_list, ext_video_list, ext_app_list, ext_image_list, ext_cd_list, ext_text_list: TStringHash;
 share_320,share_256,share_224,share_192,share_160,share_128,share_112,share_96,share_80,share_64,share_56,share_48,share_40,share_32,share_24,share_unknown: Boolean;
 nocount_text: Boolean;
 share_matchedfile_only: Boolean;
 // napigator
 stats_socket: HSocket;
 napigator_socket: HSocket;
 napigator_host: String;
 napigator_port: String;
 napigator_user: String;
 napigator_password: String;
 napigator_salt: String;
 napigator_myport: Integer;
 napigator_enabled: Boolean;
 napigator_myip: String;
 napigator_autodisconnect: Boolean;
 napigator_delay: Cardinal;
 napigator_fake_ip: Boolean;
 dagsta_socket: HSocket;
 dagsta_host: String;
 dagsta_port: String;
 dagsta_user: String;
 dagsta_password: String;
 dagsta_salt: String;
 dagsta_myport: Integer;
 dagsta_enabled: Boolean;
 dagsta_myip: String;
 dagsta_autodisconnect: Boolean;
 dagsta_delay: Cardinal;
 // bots
 ann_enabled: Boolean;
 ann_imenabled: Boolean;
 ann_delay, last_announcement: Cardinal;
 ann_user: String;
 ann_messages: Array[0..MAX_ANNOUNCEMENT] of String;
 old_report_enabled: Boolean;
 old_report_socket: HSocket;
 old_report_port: Integer;
 new_report_enabled: Boolean;
 new_report_socket: HSocket;
 new_report_port: Integer;
 new_report_hide_hub: Boolean;
 minshare_delay: Cardinal;
 minshare_ban: Boolean;
 minshare_banip: Boolean;
 minshare_bantime: Integer; // seconds
 minshare_size: Int64;
 minshare_fullonly: Boolean;
 minshare_only10: Boolean;
 minshare_kickchat: Boolean;
 loginim_enabled: Boolean;
 loginim_user: String;
 loginim: Array[0..MAX_LOGINIM] of String;
 force_enter: Boolean;
 force_enter_channel: String;
 force_enter_furiwake: Boolean;
 restrict_searchresult_per_user: Boolean;
 max_searchresult_per_user: Integer;
 dengon_enabled: Boolean;
 report_toami: Boolean;
 toami_judge: Integer;
 toami_leech: Boolean;
 toami_bantime: Integer;
 // bandwith limits
 bandwidth_up, bandwidth_down, bandwidth_maxup, bandwidth_maxdown, bandwidth_allowedup, bandwidth_alloweddown: Integer;
 bandwidth_limitservers, bandwidth_limited: Boolean;
 bandwidth_lastcheck: Cardinal;
 // flood control
 flood_max_user_message: Integer;
 flood_max_same_message: Integer;
 flood_warning: Boolean;
 flood_enable: Boolean;
 flood_max_searches: Integer;
 flood_max_wantqueue: Integer;
 // from handler.pas
 tmp_pos: Integer; // debug variable. shows position of exception. uses less than 1% of server time.
 // colors
 slError,
 slWallop,
 slAnnounce,
 slWhowas,
 slPong,
 slOffline,
 slOnline,
 slDebugData,
 slNapigator,
 slDagsta,
 slSearch,
 slRemoteSearch,
 slTransfer,
 slTopic,
 slChannelMessage,
 slChannelMyMessage,
 slChannelEmote,
 slChannelMyEmote,
 slChannelJoin,
 slChannelPart,
 slChatMessage,
 slChatMyMessage,
 slBackground,
 slText: Integer;

implementation

end.
