{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by CyberAlien@users.sourceforge.net
 Released under GNU General Public License

 Latest version is available at
 http://slavanap2.sourceforge.net

**********************************************************

 Unit: config

 Handler for remote configuration command

*********************************************************}
unit config;

interface

uses
 SysUtils, Classes, slavamasks, windows, constants, users, servers, stypes, localusers,
 registered, handler, lang, vars;

procedure SetConfig(user: POnlineUser; command: String);

implementation

var
 db_vars: TStringList;
 hlist: TStringList;

procedure ShowVar(command: String; value: String); overload;
begin
 Error(command+' = '+value);
end;

procedure ShowVar(command: String; value: Integer); overload;
begin
 ShowVar(command,IntToStr(value));
end;

procedure ShowVar(command: String; value: Int64); overload;
begin
 ShowVar(command,IntToStr(value));
end;

procedure ShowVar(command: String; value: Boolean); overload;
begin
 if value then
  ShowVar(command,'yes')
 else
  ShowVar(command,'no');
end;

procedure ShowVar(command: String; value: TAllowLinkType); overload;
begin
 if value=linkAll then
  ShowVar(command,'all')
 else if value=linkNone then
  ShowVar(command,'none')
 else if value=linkCustom then
  ShowVar(command,'custom')
 else
  ShowVar(command,'list');  
end;

procedure ListConfig(command: String);
begin
 if command='registered_only' then ShowVar(command,registered_only)
 else if command='allow_register' then ShowVar(command,allow_register)
 else if command='max_users' then ShowVar(command,max_users)
 else if command='stats_delay' then ShowVar(command,stats_delay div 1000)
 else if command='max_hotlist' then ShowVar(command,max_hotlist)
 else if command='max_ignorelist' then ShowVar(command,max_ignorelist)
 else if command='max_clones' then ShowVar(command,max_clones)
 else if command='memory_limit' then ShowVar(command,memory_limit div 1048576)
 else if command='def_search_results' then ShowVar(command,defsearchresults)
 else if command='max_remote_search_results' then ShowVar(command,maxremotesearchresults)
 else if command='max_search_results' then ShowVar(command,maxsearchresults)
 else if command='max_browse_results' then ShowVar(command,maxbrowseresults)
 else if command='max_remote_browse_results' then ShowVar(command,maxremotebrowse)
 else if command='disable_remote_search' then ShowVar(command,disableremotesearch)
 else if command='allow_create_channels' then ShowVar(command,allow_create_channels)
 else if command='max_channels' then ShowVar(command,max_channels)
 else if command='max_channels_total' then ShowVar(command,max_channels_total)
 else if command='block_cqex_chat' then ShowVar(command,block_cqex_chat)
 else if command='block_winmx_queue' then ShowVar(command,block_wantqueue)
 else if command='timeout_login' then ShowVar(command,timeout_login div 1000)
 else if command='max_searches_pm' then ShowVar(command,flood_max_searches)
 else if command='max_wantqueue_p3m' then ShowVar(command,flood_max_wantqueue)
 else if command='max_cpu_usage' then ShowVar(command,cpu_usage)
 else if command='max_cpu_disable' then ShowVar(command,cpu_disable)
 else if command='allow_share' then ShowVar(command,allow_share)
 else if command='share_nomodem' then ShowVar(command,share_nomodem)
 else if command='max_share' then ShowVar(command,maxshare)
 else if command='min_share' then ShowVar(command,minshare)
 else if command='min_share_size' then ShowVar(command,minshare_size div MegaByte)
 else if command='min_share_only10' then ShowVar(command,minshare_only10)
 else if command='min_share_kickchat' then ShowVar(command,minshare_kickchat)
 else if command='min_share_fullonly' then ShowVar(command,minshare_fullonly)
 else if command='min_share_bantime' then ShowVar(command,minshare_bantime div 60)
 else if command='min_share_banip' then ShowVar(command,minshare_banip)
 else if command='min_share_delay' then showVar(command,minshare_delay div 60000)
 else if command='min_share_ban' then ShowVar(command,minshare_ban)
 else if command='min_filename' then ShowVar(command,minfilename)
 else if command='min_duration' then ShowVar(command,minduration)
 else if command='max_share_total' then ShowVar(command,maxshare_total)
 else if command='max_share_audio' then ShowVar(command,maxshare_audio)
 else if command='max_share_video' then ShowVar(command,maxshare_video)
 else if command='max_share_image' then ShowVar(command,maxshare_image)
 else if command='max_share_app' then ShowVar(command,maxshare_app)
 else if command='max_share_cd' then ShowVar(command,maxshare_cd)
 else if command='max_share_text' then ShowVar(command,maxshare_text)
 else if command='max_share_mp3' then ShowVar(command,maxshare_mp3)
 else if command='min_filesize_audio' then ShowVar(command,minfilesize_audio)
 else if command='max_filesize_audio' then ShowVar(command,maxfilesize_audio)
 else if command='min_filesize_video' then ShowVar(command,minfilesize_video)
 else if command='max_filesize_video' then ShowVar(command,maxfilesize_video)
 else if command='min_filesize_image' then ShowVar(command,minfilesize_image)
 else if command='max_filesize_image' then ShowVar(command,maxfilesize_image)
 else if command='min_filesize_app' then ShowVar(command,minfilesize_app)
 else if command='max_filesize_app' then ShowVar(command,maxfilesize_app)
 else if command='min_filesize_cd' then ShowVar(command,minfilesize_cd)
 else if command='max_filesize_cd' then ShowVar(command,maxfilesize_cd)
 else if command='min_filesize_text' then ShowVar(command,minfilesize_text)
 else if command='max_filesize_text' then ShowVar(command,maxfilesize_text)
 else if command='min_filesize_mp3' then ShowVar(command,minfilesize_mp3)
 else if command='max_filesize_mp3' then ShowVar(command,maxfilesize_mp3)
 else if command='allow_link' then ShowVar(command,allow_link)
 else if command='drop_search_results' then ShowVar(command,search_noforward_results)
 else if command='drop_search_requests' then ShowVar(command,search_noforward_requests)
 else if command='drop_browse_results' then ShowVar(command,browse_noforward_results)
 else if command='drop_browse_requests' then ShowVar(command,browse_noforward_requests)
 else if command='timeout_remote_search' then ShowVar(command,timeout_remote_search div 1000)
 else if command='share_error_inform' then ShowVar(command,shareinform)
 else if command='max_accept' then ShowVar(command,max_accept)
 else if command='redirect_cqex' then ShowVar(command,redirect_cqex)
 else if command='network_hub' then ShowVar(command,network_hub)
 else if command='hub_syncreg' then ShowVar(command,hub_syncreg)
 else if command='hub_syncban' then ShowVar(command,hub_syncban)
 else if command='flood_enable' then ShowVar(command,flood_enable)
 else if command='prevent_shouting' then ShowVar(command,prevent_shouting)
 else if command='autolink_only1' then ShowVar(command,autolink_only1)
 else if command='search_antidom' then ShowVar(command,search_antidom)
 else if command='search_domshare' then ShowVar(command,search_domshare)
 else if command='search_domsharesize' then ShowVar(command,search_domsharesize div MegaByte)
 else if command='search_searchblock' then ShowVar(command,search_searchblock)
 else if command='search_searchblockshare' then ShowVar(command,search_searchblockshare)
 else if command='search_searchblocksharesize' then ShowVar(command,search_searchblocksharesize div MegaByte)
 else if command='searchblock_chknum' then ShowVar(command,searchblock_chknum)
 else if command='searchblock_chksize' then ShowVar(command,searchblock_chksize)
 else if command='browsedlblock_chknum' then ShowVar(command,browsedlblock_chknum)
 else if command='browsedlblock_chksize' then ShowVar(command,browsedlblock_chksize)
 else Error(GetLangT(LNG_NOVAR));
end;

procedure ListAllConfig;
var
 i: Integer;
begin
 for i:=0 to db_vars.count-1 do
  ListConfig(db_vars.Strings[i]);
end;

function SetBool(var variable: Boolean; value: Boolean): Boolean;
begin
 if variable=value then Result:=false
 else begin variable:=value; Result:=true; end;
end;

function SetInt(var variable: Integer; min,max,value: Integer): Boolean;
begin
 if (variable=value) or (value<min) or (value>max) then Result:=false
 else begin variable:=value; Result:=true; end;
end;

function SetCardinal(var variable: Cardinal; min,max,value: Cardinal): Boolean;
begin
 if (variable=value) or (value<min) or (value>max) then Result:=false
 else begin variable:=value; Result:=true; end;
end;

function SetInt64(var variable: Int64; min,max,value: Int64): Boolean;
begin
 if (variable=value) or (value<min) or (value>max) then Result:=false
 else begin variable:=value; Result:=true; end;
end;

function SetLink(value: String): Boolean;
begin
 value:=lowercase(value);
 Result:=true;
 if value='all' then
   allow_link:=linkAll
 else if value='none' then
   allow_link:=linkNone
 else if value='list' then
   allow_link:=linkList
 else if value='custom' then
   allow_link:=linkCustom
 else
   Result:=false;
end;

function SetVar(user: POnlineUser; variable,value: String): Boolean;
var
 b,b1: Boolean;
 i: Integer;
 i64: Int64;
begin
 Result:=false;
 b:=Str2Bool(value,false);
 b1:=Str2Bool(value,true);
 i:=StrToIntDef(value,-1);
 i64:=StrToInt64Def(value,-1);
 if variable='allow_link' then
 begin
   if allow_link=linkCustom then
    if lowercase(user^.nick)<>lowercase(cons_reg_user) then
    begin
      if not (userHideErrors in user^.state) then
       Exec(user,MSG_SERVER_NOSUCH,GetLangT(LNG_ACCESS));
      Result:=true;
      exit;
    end;
   Result:=SetLink(value);
 end;
 if b=b1 then // boolean is ok
 begin
  if variable='max_cpu_disable' then
  begin
    if not cpu_disable then
     if lowercase(user^.nick)<>lowercase(cons_reg_user) then
     begin
       if not (userHideErrors in user^.state) then
        Exec(user,MSG_SERVER_NOSUCH,GetLangT(LNG_ACCESS));
       Result:=true;
       exit;
     end;
    Result:=SetBool(cpu_disable,b);
  end;
  if variable='registered_only' then Result:=SetBool(registered_only,b)
  else if variable='allow_register' then Result:=SetBool(allow_register,b)
  else if variable='allow_create_channels' then Result:=SetBool(allow_create_channels,b)
  else if variable='block_cqex_chat' then Result:=SetBool(block_cqex_chat,b)
  else if variable='block_winmx_queue' then Result:=SetBool(block_wantqueue,b)
  else if variable='allow_share' then Result:=SetBool(allow_share,b)
  else if variable='share_nomodem' then Result:=SetBool(share_nomodem,b)
  else if variable='min_share_ban' then Result:=SetBool(minshare_ban,b)
  else if variable='min_share_banip' then Result:=SetBool(minshare_banip,b)
  else if variable='min_share_fullonly' then Result:=SetBool(minshare_fullonly,b)
  else if variable='min_share_only10' then Result:=SetBool(minshare_only10,b)
  else if variable='min_share_kickchat' then Result:=SetBool(minshare_kickchat,b)
  else if variable='search_antidom' then Result:=SetBool(search_antidom,b)
  else if variable='search_searchblock' then Result:=SetBool(search_searchblock,b)
  else if variable='drop_search_results' then Result:=SetBool(search_noforward_results,b)
  else if variable='drop_search_requests' then Result:=SetBool(search_noforward_requests,b)
  else if variable='drop_browse_results' then Result:=SetBool(browse_noforward_results,b)
  else if variable='drop_browse_requests' then Result:=SetBool(browse_noforward_requests,b)
  else if variable='disable_remote_search' then Result:=SetBool(disableremotesearch,b)
  else if variable='share_error_inform' then Result:=SetBool(shareinform,b)
  else if variable='redirect_cqex' then Result:=SetBool(redirect_cqex,b)
  else if variable='flood_enable' then Result:=SetBool(flood_enable,b)
  else if variable='prevent_shouting' then Result:=SetBool(prevent_shouting,b)
  else if variable='autolink_only1' then Result:=SetBool(autolink_only1,b)
  else if variable='hub_syncreg' then Result:=SetBool(hub_syncreg,b)
  else if variable='hub_syncban' then Result:=SetBool(hub_syncban,b);
 end;
 if i<>-1 then // integer is ok
 begin
   if variable='max_users' then Result:=SetInt(max_users,0,65535,i)
   else if variable='stats_delay' then Result:=SetCardinal(stats_delay,15000,300000,i*1000)
   else if variable='max_hotlist' then Result:=SetInt(max_hotlist,0,256,i)
   else if variable='max_ignorelist' then Result:=SetInt(max_ignorelist,0,256,i)
   else if variable='max_clones' then Result:=SetInt(max_clones,0,256,i)
   else if variable='memory_limit' then Result:=SetInt(memory_limit,0,MaxInt,i*1048576)
   else if variable='def_search_results' then Result:=SetInt(defsearchresults,1,MaxWord,i)
   else if variable='max_search_results' then Result:=SetInt(maxsearchresults,1,MaxWord,i)
   else if variable='max_browse_results' then Result:=SetInt(maxbrowseresults,0,MaxWord,i)
   else if variable='max_remote_browse_results' then Result:=SetInt(maxremotebrowse,0,MaxWord,i)
   else if variable='max_remote_search_results' then Result:=SetInt(maxremotesearchresults,1,MaxWord,i)
   else if variable='max_searches_pm' then Result:=SetInt(flood_max_searches,1,20,i)
   else if variable='max_wantqueue_p3m' then Result:=SetInt(flood_max_wantqueue,0,1000,i)
   else if variable='max_channels' then Result:=SetInt(max_channels,0,15,i)
   else if variable='max_channels_total' then Result:=SetInt(max_channels_total,0,1023,i)
   else if variable='timeout_login' then Result:=SetCardinal(timeout_login,10000,300000,i*1000)
   else if variable='max_share' then Result:=SetInt(maxshare,0,MaxWord,i)
   else if variable='min_share' then Result:=SetInt(minshare,0,maxshare,i)
   else if variable='min_filename' then Result:=SetInt(minfilename,0,256,i)
   else if variable='min_duration' then Result:=SetInt(minduration,0,maxword,i)
   else if variable='max_share_audio' then Result:=SetInt(maxshare_audio,0,MaxWord,i)
   else if variable='max_share_video' then Result:=SetInt(maxshare_video,0,MaxWord,i)
   else if variable='max_share_image' then Result:=SetInt(maxshare_image,0,MaxWord,i)
   else if variable='max_share_app' then Result:=SetInt(maxshare_app,0,MaxWord,i)
   else if variable='max_share_cd' then Result:=SetInt(maxshare_cd,0,MaxWord,i)
   else if variable='max_share_text' then Result:=SetInt(maxshare_text,0,MaxWord,i)
   else if variable='max_share_mp3' then Result:=SetInt(maxshare_mp3,0,MaxWord,i)
   else if variable='min_share_delay' then Result:=SetCardinal(minshare_delay,0,60*60000,i*60000)
   else if variable='min_share_bantime' then Result:=SetInt(minshare_bantime,60,60*1440,i*60)
   else if variable='search_domshare' then Result:=SetInt(search_domshare,0,10000,i)
   else if variable='search_searchblockshare' then Result:=SetInt(search_searchblockshare,0,10000,i)
   else if variable='timeout_remote_search' then Result:=SetCardinal(timeout_remote_search,30000,300000,i*1000)
   else if variable='max_accept' then Result:=SetInt(max_accept,0,65535,i);
 end;
 if i64<>-1 then
 begin
   if variable='max_share_total' then Result:=SetInt64(maxshare_total,0,MaxInt,i64)
   else if variable='min_filesize_audio' then Result:=SetInt64(minfilesize_audio,0,FileSizeLimit,i64)
   else if variable='max_filesize_audio' then Result:=SetInt64(maxfilesize_audio,0,FileSizeLimit,i64)
   else if variable='min_filesize_video' then Result:=SetInt64(minfilesize_video,0,FileSizeLimit,i64)
   else if variable='max_filesize_video' then Result:=SetInt64(maxfilesize_video,0,FileSizeLimit,i64)
   else if variable='min_filesize_image' then Result:=SetInt64(minfilesize_image,0,FileSizeLimit,i64)
   else if variable='max_filesize_image' then Result:=SetInt64(maxfilesize_image,0,FileSizeLimit,i64)
   else if variable='min_filesize_app' then Result:=SetInt64(minfilesize_app,0,FileSizeLimit,i64)
   else if variable='max_filesize_app' then Result:=SetInt64(maxfilesize_app,0,FileSizeLimit,i64)
   else if variable='min_filesize_cd' then Result:=SetInt64(minfilesize_cd,0,FileSizeLimit,i64)
   else if variable='max_filesize_cd' then Result:=SetInt64(maxfilesize_cd,0,FileSizeLimit,i64)
   else if variable='min_filesize_text' then Result:=SetInt64(minfilesize_text,0,FileSizeLimit,i64)
   else if variable='max_filesize_text' then Result:=SetInt64(maxfilesize_text,0,FileSizeLimit,i64)
   else if variable='min_filesize_mp3' then Result:=SetInt64(minfilesize_mp3,0,FileSizeLimit,i64)
   else if variable='max_filesize_mp3' then Result:=SetInt64(maxfilesize_mp3,0,FileSizeLimit,i64)
   else if variable='min_share_size' then Result:=SetInt64(minshare_size,0,1048576*MegaByte,i64*MegaByte)
   else if variable='search_domsharesize' then Result:=SetInt64(search_domsharesize,0,1048576*MegaByte,i64*MegaByte)
   else if variable='search_searchblocksharesize' then Result:=SetInt64(search_searchblocksharesize,0,1048576*MegaByte,i64*MegaByte);
 end;
end;

procedure SetConfig(user: POnlineUser; command: String);
var
 i: Integer;
begin
 i:=pos('=',command);
 if i>0 then command[i]:=' ';
 SplitString(command,hlist);
 if hlist.count=0 then // list vars
 begin
   if user^.level<napUserModerator then
     Error(GetLangT(LNG_ACCESS),true)
   else
     ListAllConfig;
   exit;
 end;
 hlist.Strings[0]:=lowercase(hlist.Strings[0]);
 if hlist.count=1 then // list var
 begin
   if user^.level<napUserModerator then
     Error(GetLangT(LNG_ACCESS),true)
   else
     ListConfig(command);
   exit;
 end;
 if user^.level<napUserElite then
 begin
   PermissionDenied('',true);
   exit;
 end;
 if SetVar(user,hlist.Strings[0],hlist.Strings[1]) then
  Wallop(MSG_SERVER_NOSUCH,wallopVar,GetLangT(LNG_CHANGEVAR,user^.nick,hlist.Strings[0],hlist.Strings[1]),true)
 else
  Error(GetLangT(LNG_BADVAR),true);
end;

procedure InitVars;
begin
 db_vars.Add('registered_only');
 db_vars.Add('allow_register');
 db_vars.Add('max_users'); // max_users
 db_vars.Add('stats_delay');  // stats_delay div 1000
 db_vars.Add('max_hotlist');
 db_vars.Add('max_ignorelist');
 db_vars.Add('max_clones');
 db_vars.Add('memory_limit');
 db_vars.Add('network_hub');
 db_vars.Add('hub_syncreg'); // sync registered list
 db_vars.Add('hub_syncban'); // sync ban list
 db_vars.Add('max_cpu_usage'); //cpu_usage
 db_vars.Add('max_cpu_disable'); //disable cpu_usage
 db_vars.Add('def_search_results'); // defsearchresults
 db_vars.Add('max_search_results'); // maxsearchresults
 db_vars.Add('max_browse_results'); // maxbrowseresults
 db_vars.Add('max_remote_browse_results'); // maxremotebrowse
 db_vars.Add('max_remote_search_results'); // maxremotesearchresults
 db_vars.Add('disable_remote_search'); // disableremotesearch
 db_vars.Add('max_searches_pm'); // maxsearchespm
 db_vars.Add('allow_create_channels');
 db_vars.Add('max_channels');
 db_vars.Add('max_channels_total');
 db_vars.Add('block_cqex_chat');
 db_vars.Add('block_winmx_queue'); // block_wantqueue
 db_vars.Add('timeout_login'); // timeout_login div 1000
 db_vars.Add('allow_share');
 db_vars.Add('share_nomodem');
 db_vars.Add('max_share'); // maxshare
 db_vars.Add('min_share'); // minshare
 db_vars.Add('min_share_size'); // minshare_size
 db_vars.Add('min_share_only10'); // minshare_only10
 db_vars.Add('min_share_kickchat'); // minshare_kickchat
 db_vars.Add('min_share_delay'); // minshare_delay
 db_vars.Add('min_share_ban'); // minshare_ban
 db_vars.Add('min_share_banip'); // minshare_banip
 db_vars.Add('min_share_bantime'); // minshare_bantime
 db_vars.Add('min_share_fullonly'); // minshare_fullonly
 db_vars.Add('min_filename'); // minfilename
 db_vars.Add('min_duration'); // minduration
 db_vars.Add('max_share_total'); // maxshare_total
 db_vars.Add('max_share_audio'); // maxshare_audio
 db_vars.Add('max_share_video'); // maxshare_video
 db_vars.Add('max_share_image'); // maxshare_image
 db_vars.Add('max_share_app'); // maxshare_app
 db_vars.Add('max_share_cd'); // maxshare_cd
 db_vars.Add('max_share_text'); // maxshare_text
 db_vars.Add('max_share_mp3'); // maxshare_mp3
 db_vars.Add('min_filesize_audio'); // minfilesize_audio
 db_vars.Add('max_filesize_audio'); // maxfilesize_audio
 db_vars.Add('min_filesize_video'); // minfilesize_video
 db_vars.Add('max_filesize_video'); // maxfilesize_video
 db_vars.Add('min_filesize_image'); // minfilesize_image
 db_vars.Add('max_filesize_image'); // maxfilesize_image
 db_vars.Add('min_filesize_app'); // minfilesize_app
 db_vars.Add('max_filesize_app'); // maxfilesize_app
 db_vars.Add('min_filesize_cd'); // minfilesize_cd
 db_vars.Add('max_filesize_cd'); // maxfilesize_cd
 db_vars.Add('min_filesize_text'); // minfilesize_text
 db_vars.Add('max_filesize_text'); // maxfilesize_text
 db_vars.Add('min_filesize_mp3'); // minfilesize_mp3
 db_vars.Add('max_filesize_mp3'); // maxfilesize_mp3
 db_vars.Add('allow_link'); // allow_link
 db_vars.Add('drop_search_results'); // search_noforward_results
 db_vars.Add('drop_search_requests'); // search_noforward_requests
 db_vars.Add('drop_browse_results'); // browse_noforward_results
 db_vars.Add('drop_browse_requests'); // browse_noforward_requests
 db_vars.Add('timeout_remote_search'); // timeout_remote_search
 db_vars.Add('share_error_inform'); // shareinform
 db_vars.Add('max_accept'); // max_accept
 db_vars.Add('redirect_cqex'); // redirect_cqex
 db_vars.Add('flood_enable'); // flood protection
 db_vars.Add('prevent_shouting');
 db_vars.Add('autolink_only1'); // do not autolink if already linked to 1 server
 db_vars.Add('search_searchblock'); //search_searchblock
 db_vars.Add('search_antidom'); //search_antidom
 db_vars.Add('search_domshare'); //search_domshare
 db_vars.Add('search_domsharesize'); //search_domsharesize
 db_vars.Add('search_searchblockshare'); //search_searchblockshare
 db_vars.Add('search_searchblocksharesize'); //search_searchblocksharesize
 db_vars.Add('searchblock_chknum'); //searchblock_chknum
 db_vars.Add('searchblock_chksize'); //searchblock_chksize
 db_vars.Add('browsedlblock_chknum'); //browsedlblock_chknum
 db_vars.Add('browsedlblock_chksize'); //browsedlblock_chksize
 db_vars.Sort;
end;

initialization
begin
 db_vars:=TStringList.Create;
 hlist:=TStringList.Create;
 InitVars;
end;

finalization
begin
 db_vars.Free;
 hlist.Free;
end;

end.
