{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by CyberAlien@users.sourceforge.net
 Released under GNU General Public License

 Latest version is available at
 http://slavanap2.sourceforge.net

**********************************************************

 Unit: lang

 Functions for language handling

*********************************************************}
unit lang;

interface

uses
 SysUtils, Classes, windows, inifiles, constants;

const
 LNG_UNKNOWN                 = '`';
 LNG_LOG_STARTING            = 0;
 LNG_SERVER_LISTEN           = 1;
 LNG_SERVER_LISTENERR        = 2;
 LNG_INVALIDCOMMAND          = 3;
 LNG_INVALIDARGS             = 4;
 LNG_ACCESS                  = 5;
 LNG_NOTLOGGED               = 6;
 LNG_LOGGED                  = 7;
 LNG_NOUSER                  = 8;
 LNG_OFFLINE                 = 9;
 LNG_REMOTE                  = 10;
 LNG_GHOST                   = 11;
 LNG_INVALIDNICK             = 12;
 LNG_INVALIDPASS             = 13;
 LNG_REGISTERED              = 14;
 LNG_USERSLIMIT              = 15;
 LNG_INVSPEED                = 16;
 LNG_REGISTEREDONLY          = 17;
 LNG_USERONLINE              = 18;
 LNG_USEROFFLINE             = 19;
 LNG_LEVEL                   = 20;
 LNG_USEROFFLINE2            = 21;
 LNG_BANNED2                 = 22;
 LNG_USERREGISTER            = 23;
 LNG_MAXCLONES               = 24;
 LNG_NAPIGATOR_ERROR         = 25;
 LNG_NAPIGATOR_REPLY         = 26;
 LNG_NAPIGATOR_SEND          = 27;
 LNG_NAPIGATOR_RESOLVED      = 28;
 LNG_NAPIGATOR_DISCONNECT    = 29;
 LNG_NAPIGATOR_NORESOLVE     = 30;
 LNG_NAPIGATOR_CONNECTED     = 31;
 LNG_NAPIGATOR_CONNECTING    = 32;
 LNG_NAPIGATOR_NOCONNECT     = 33;
 LNG_NAPIGATOR_NOWELCOME     = 34;
 LNG_SERVER_LISTENSTATS      = 35;
 LNG_DISCONNECT_INVCMD       = 36;
 LNG_DISCONNECT_SOCKETERR    = 37;
 LNG_DISCONNECT_SENDTIMEOUT  = 38;
 LNG_INVALIDLEVEL            = 39;
 LNG_LEVEL2                  = 40;
 LNG_LEVEL3                  = 41;
 LNG_KILLED                  = 42;
 LNG_NUKED                   = 43;
 LNG_KICK                    = 44;
 LNG_NUKE                    = 45;
 LNG_SHARE_SHORT             = 46;
 LNG_SHARE_BITRATE           = 47;
 LNG_SHARE_FREQ              = 48;
 LNG_SHARE_ERROR             = 49;
 LNG_SHARE_TIME              = 50;
 LNG_SHARE_LIMIT             = 51;
 LNG_SHARE_TOTAL_LIMIT       = 52;
 LNG_SHARE_MEMORY_LIMIT      = 53;
 LNG_MEMORYLIMIT             = 54;
 LNG_SHARE_SMALL             = 55;
 LNG_SHARE_LARGE             = 56;
 LNG_NOSHARE_BITRATE         = 57;
 LNG_SHARE_10300             = 58;
 LNG_SEARCHLOG3              = 59;
 LNG_TRANSFERLOG3            = 60;
 LNG_TRANSFERLOG4            = 61;
 LNG_TRANSFERLOG5            = 62;
 LNG_FIREWALL                = 63;
 LNG_BROWSEMOD               = 64;
 LNG_TB_BTN_LOG              = 65;
 LNG_TB_BTN_USERS            = 66;
 LNG_TB_BTN_SERVERS          = 67;
 LNG_TB_BTN_CHANNELS         = 68;
 LNG_TB_BTN_FRIENDS          = 69;
 LNG_TB_BTN_BANS             = 70;
 LNG_TB_BTN_HOTLIST          = 71;
 LNG_TB_BTN_IGNORE           = 72;
 LNG_TB_BTN_BLOCKS           = 73;
 LNG_TB_BTN_CONSOLEONLINE    = 74;
 LNG_TB_BTN_REGISTERED       = 75;
 LNG_TB_BTN_LOG_HINT         = 76;
 LNG_TB_BTN_USERS_HINT       = 77;
 LNG_TB_BTN_REGISTERED_HINT  = 78;
 LNG_TB_BTN_SERVERS_HINT     = 79;
 LNG_TB_BTN_CHANNELS_HINT    = 80;
 LNG_TB_BTN_FRIENDS_HINT     = 81;
 LNG_TB_BTN_BANS_HINT        = 82;
 LNG_TB_BTN_HOTLIST_HINT     = 83;
 LNG_TB_BTN_IGNORE_HINT      = 84;
 LNG_TB_BTN_BLOCKS_HINT      = 85;
 LNG_TB_BTN_CONSOLEONLINE_HINT = 86;
 LNG_TB_TOOLBAR_TOTAL        = 87;
 LNG_REG_TRANSFERS           = 88;
 LNG_REG_MUZZLED             = 89;
 LNG_CHANNELMODERATED        = 90;
 LNG_CHANNELOPERATOR         = 91;
 LNG_CHANNELOPERATOR2        = 92;
 LNG_INVALIDCHANNEL          = 93;
 LNG_NOCREATE                = 94;
 LNG_CHANNELLIMIT2           = 95;
 LNG_CHANNELLIMIT            = 96;
 LNG_NOCHANNEL               = 97;
 LNG_CHALREADYBANNED         = 98;
 LNG_CHBANNED                = 99;
 LNG_CHUNBANNED              = 100;
 LNG_IPREQMOD                = 102;
 LNG_WHOISMOD                = 103;
 LNG_SAVINGDATA              = 104;
 LNG_LEVEL1                  = 105;
 LNG_FRIENDLOGIN             = 106;
 LNG_CHJOINED                = 110;
 LNG_INVITE                  = 111;
 LNG_MUZZLE1                 = 112;
 LNG_UNMUZZLE1               = 113;
 LNG_MUZZLE3                 = 114;
 LNG_UNMUZZLE3               = 115;
 LNG_MUZZLE                  = 116;
 LNG_FLOODMUZZLE             = 117;
 LNG_UNMUZZLE                = 118;
 LNG_MUZZLEEXPIRE            = 119;
 LNG_CANTTALK                = 120;
 LNG_ALTERSPEED              = 121;
 LNG_ERRCLOAKED              = 122;
 LNG_ERRUNCLOAK              = 123;
 LNG_CLOAKED                 = 124;
 LNG_UNCLOAKED               = 125;
 LNG_CHPASS2                 = 126;
 LNG_CLEARCHANNEL            = 127;
 LNG_CHLEVEL                 = 128;
 LNG_LIMIT                   = 129;
 LNG_CHKICK                  = 130;
 LNG_NOVAR                   = 131;
 LNG_BADVAR                  = 132;
 LNG_CHANGEVAR               = 133;
 LNG_MENU_SERVER             = 134;
 LNG_MENU_SETTINGS           = 135;
 LNG_MENU_LANGUAGES          = 136;
 LNG_MENU_RESTART            = 137;
 LNG_MENU_EXIT               = 138;
 LNG_MENU_LOG                = 139;
 LNG_MENU_CLEAR              = 140;
 LNG_MENU_LOGIN              = 141;
 LNG_MENU_NAPIGATOR          = 142;
 LNG_MENU_RESET              = 143;
 LNG_MENU_SEARCH             = 144;
 LNG_MENU_TRANSFER           = 145;
 LNG_MENU_BLOCK              = 146;
 LNG_MENU_WINDOW             = 147;
 LNG_MENU_LOGWIN             = 148;
 LNG_MENU_USERS              = 149;
 LNG_MENU_SERVERS            = 150;
 LNG_MENU_CHANNELS           = 151;
 LNG_MENU_FRIENDS            = 152;
 LNG_MENU_BANS               = 153;
 LNG_MENU_HOTLIST            = 154;
 LNG_MENU_IGNORE             = 155;
 LNG_MENU_HELP               = 156;
 LNG_MENU_FAQ                = 157;
 LNG_MENU_MANUAL             = 158;
 LNG_MENU_FORUMS             = 159;
 LNG_MENU_UPDATE             = 160;
 LNG_MENU_ABOUT              = 161;
 LNG_MENU_SHOW               = 162;
 LNG_MENU_HIDE               = 163;
 LNG_USERS_LABEL             = 164;
 LNG_LIST_MUZZLED            = 165;
 LNG_LIST_CONSOLE            = 166;
 LNG_LIST_HEADER_NAME        = 167;
 LNG_LIST_HEADER_LEVEL       = 168;
 LNG_LIST_HEADER_SHARED      = 169;
 LNG_LIST_HEADER_SOFTWARE    = 170;
 LNG_LIST_HEADER_SPEED       = 171;
 LNG_LIST_HEADER_IP          = 172;
 LNG_LIST_HEADER_PORT        = 173;
 LNG_LIST_HEADER_SERVER      = 174;
 LNG_REG_USER                = 175;
 LNG_REG_LEVEL               = 176;
 LNG_REG_TRANSFERS2          = 177;
 LNG_REG_IP                  = 178;
 LNG_REG_TIME                = 179;
 LNG_LIST_BTN_MODS           = 180;
 LNG_LIST_BTN_USERS          = 181;
 LNG_LIST_BTN_LEECH          = 182;
 LNG_LIST_BTN_MUZZLED        = 183;
 LNG_LIST_BTN_LOCAL          = 184;
 LNG_LIST_BTN_REMOTE         = 185;
 LNG_OK                      = 186;
 LNG_CANCEL                  = 187;
 LNG_USERSERVER              = 188;
 LNG_REGEXISTS               = 189;
 LNG_REGOK2                  = 190;
 LNG_CHANOP                  = 191;
 LNG_CHNOOPS                 = 192;
 LNG_INVALIDNICK2            = 193;
 LNG_CHANOP2                 = 194;
 LNG_CHANOP3                 = 195;
 LNG_CHANDEOP                = 196;
 LNG_CHANDEOP2               = 197;
 LNG_CHANDEOP3               = 198;
 LNG_CHANDEOP4               = 199;
 LNG_DROPCHANNEL             = 200;
 LNG_UNKNOWNCHMODE           = 201;
 LNG_NOMODERATE              = 203;
 LNG_VOICE                   = 204;
 LNG_VOICE2                  = 205;
 LNG_VOICE3                  = 206;
 LNG_VOICE4                  = 207;
 LNG_DEVOICE                 = 208;
 LNG_DEVOICE2                = 209;
 LNG_DEVOICE3                = 210;
 LNG_DEVOICE4                = 211;
 LNG_DEVOICE5                = 212;
 LNG_ADDFRIEND               = 213;
 LNG_REMOVEFRIEND            = 214;
 LNG_CHLIMIT                 = 215;
 LNG_CHLEVEL2                = 216;
 LNG_CLIENTBLOCK             = 217;
 LNG_MENU_SAVE               = 218;
 LNG_LIST_BTN_KICK           = 219;
 LNG_LIST_BTN_NUKE           = 220;
 LNG_LIST_BTN_MUZZLE         = 221;
 LNG_LIST_BTN_REFRESH        = 222;
 LNG_LIST_BTN_BAN            = 223;
 LNG_LIST_DEFREASON          = 225;
 LNG_LIST_REASONHINT         = 226;
 LNG_LIST_MENU_REFRESH       = 227;
 LNG_LIST_MENU_KILL          = 228;
 LNG_LIST_MENU_NUKE          = 229;
 LNG_LIST_MENU_MUZZLE        = 230;
 LNG_LIST_MENU_BAN           = 231;
 LNG_LIST_MENU_LEVEL         = 233;
 LNG_LIST_MENU_SPEED         = 234;
 LNG_LIST_MENU_IM            = 235;
 LNG_LIST_MENU_SELALL        = 236;
 LNG_LIST_MENU_SELNONE       = 237;
 LNG_LIST_MENU_COPYNAME      = 238;
 LNG_LIST_MENU_WHOIS         = 239;
 LNG_LIST_MENU_FRIEND        = 240;
 LNG_LIST_MENU_HOTLIST       = 241;
 LNG_LIST_MENU_IGNORE        = 242;
 LNG_REG_LABEL               = 243;
 LNG_REG_BTN_MODS            = 244;
 LNG_REG_BTN_USERS           = 245;
 LNG_REG_BTN_LEECH           = 246;
 LNG_REG_BTN_MUZZLED         = 247;
 LNG_REG_BTN_REFRESH         = 248;
 LNG_REG_DEFREASON           = 249;
 LNG_REG_REASONHINT          = 250;
 LNG_REG_BTN_NUKE            = 251;
 LNG_REG_BTN_BAN             = 252;
 LNG_REG_BTN_BANIP           = 253;
 LNG_REG_MENU_REFRESH        = 254;
 LNG_REG_MENU_NUKE           = 255;
 LNG_REG_MENU_BAN            = 256;
 LNG_REG_MENU_BANIP          = 257;
 LNG_REG_MENU_LEVEL          = 258;
 LNG_REG_MENU_SELALL         = 259;
 LNG_REG_MENU_SELNONE        = 260;
 LNG_REG_MENU_COPYNAME       = 261;
 LNG_CH_LABEL                = 262;
 LNG_CLIST_NAME              = 263;
 LNG_CLIST_USERS             = 264;
 LNG_CLIST_MAXUSERS          = 265;
 LNG_CLIST_LEVEL             = 266;
 LNG_CLIST_STATUS            = 267;
 LNG_CLIST_TOPIC             = 268;
 LNG_CLIST_BANS              = 269;
 LNG_CLIST_OPS               = 270;
 LNG_CLIST_VOICES            = 271;
 LNG_CBTN_REFRESH            = 272;
 LNG_CBTN_JOIN               = 273;
 LNG_CBTN_PROPS              = 274;
 LNG_CBTN_ADD                = 275;
 LNG_CBTN_DELETE             = 276;
 LNG_CH_REASONHINT           = 277;
 LNG_EDIT_NAPIGATOR          = 278;
 LNG_EDIT_ADDCHANNEL         = 279;
 LNG_CH_REGISTERED           = 280;
 LNG_CH_MODERATED            = 281;
 LNG_CH_PRIVATE              = 282;
 LNG_CH_TOPIC                = 283;
 LNG_CMENU_REFRESH           = 284;
 LNG_CMENU_JOIN              = 285;
 LNG_CMENU_DELETE            = 286;
 LNG_CMENU_CLEAR             = 287;
 LNG_CMENU_ADD               = 288;
 LNG_CMENU_PROPS             = 289;
 LNG_CMENU_TOPIC             = 290;
 LNG_CMENU_SELECTALL         = 291;
 LNG_CMENU_SELECTNONE        = 292;
 LNG_CMENU_COPYNAME          = 293;
 LNG_CH_CHTOPIC              = 294;
 LNG_CH_JOIN                 = 295;
 LNG_CH_PART                 = 296;
 LNG_CH_USERLIST             = 297;
 LNG_CHCREATED               = 298;
 LNG_EDITCH_CAPTION          = 299;
 LNG_EDITCH_TOPIC            = 300;
 LNG_EDITCH_LIMIT            = 301;
 LNG_EDITCH_LEVEL            = 302;
 LNG_EDITCH_MOTD             = 303;
 LNG_EDITCH_OK               = 304;
 LNG_EDITCH_CANCEL           = 305;
 LNG_EDITCH_ATTR             = 306;
 LNG_EDITCH_REGISTERED       = 307;
 LNG_EDITCH_PRIVATE          = 308;
 LNG_EDITCH_MODERATED        = 309;
 LNG_EDITCH_TOPICATTR        = 310;
 LNG_BANS_NEVER_EXPIRE       = 311;
 LNG_BANS_LABEL              = 312;
 LNG_BBTN_REFRESH            = 313;
 LNG_BBTN_BAN                = 314;
 LNG_BBTN_UNBAN              = 315;
 LNG_BLIST_NAME              = 316;
 LNG_BLIST_IP                = 317;
 LNG_BLIST_ADMIN             = 318;
 LNG_BLIST_TIMESET           = 319;
 LNG_BLIST_EXPIRES           = 320;
 LNG_BLIST_REASON            = 321;
 LNG_BANS_BANHINT            = 322;
 LNG_BANS_REASONHINT         = 323;
 LNG_LINKED                  = 324;
 LNG_LINKREQ                 = 325;
 LNG_SLIST_HOST              = 326;
 LNG_SLIST_PORT              = 327;
 LNG_SLIST_STATUS            = 328;
 LNG_SLIST_AUTH              = 329;
 LNG_SLIST_USERS             = 330;
 LNG_SLIST_RELINK            = 331;
 LNG_SLIST_COMMENTS          = 332;
 LNG_SERVERS_LABEL           = 333;
 LNG_SRV_DISCONNECTED        = 334;
 LNG_SRV_LOGGED              = 335;
 LNG_SRV_HUB                 = 336;
 LNG_SRV_CONNECTING          = 337;
 LNG_SRV_LOGGING             = 338;
 LNG_SRV_PASSWORD            = 339;
 LNG_SRV_RESOLVE             = 340;
 LNG_SBTN_REFRESH            = 341;
 LNG_DELINK                  = 342;
 LNG_LINKERRRESOLVE          = 343;
 LNG_LINKERRCONNECT          = 344;
 LNG_LINKCONNECTED           = 345;
 LNG_LINKBADVERSION          = 346;
 LNG_LINKBADVERSION2         = 347;
 LNG_LINKNOLIST              = 348;
 LNG_LINKNOLIST2             = 349;
 LNG_LINKLOGGED              = 350;
 LNG_LINKLOGGED2             = 351;
 LNG_LINKLOGGING             = 352;
 LNG_LINKLOGGING2            = 353;
 LNG_LINKNOLINK              = 354;
 LNG_LINKNOLINK2             = 355;
 LNG_LINKINVHANDLE           = 356;
 LNG_LINKINVHANDLE2          = 357;
 LNG_LINKINVHANDLE3          = 358;
 LNG_LINKINVIP               = 359;
 LNG_LINKINVIP2              = 360;
 LNG_LINKERRLOGIN            = 361;
 LNG_DELINKHUB               = 362;
 LNG_LINKINVPASS             = 363;
 LNG_LINKINVPASS2            = 364;
 LNG_LINKSRVLOGGED           = 365;
 LNG_LINKSRVLOGGED2          = 366;
 LNG_LINKLOGINERR            = 367;
 LNG_SERVERGHOST             = 368;
 LNG_LINKINVCONSOLE          = 369;
 LNG_SBTN_CONNECT2           = 370;
 LNG_SBTN_DISCONNECT         = 371;
 LNG_NOSUCHSERVER            = 372;
 LNG_CANTDELINK              = 373;
 LNG_DELINKREQ               = 374;
 LNG_VOICE5                  = 375;
 LNG_VOICE6                  = 376;
 LNG_CHANOP4                 = 377;
 LNG_LINKSRVLOGGED3          = 378;
 LNG_INVLINKHANDLE           = 379;
 LNG_LINKINVHANDLE4          = 380;
 LNG_SEARCHLOG4              = 381;
 LNG_DELINK2                 = 382;
 LNG_LBL_IGNORED             = 383;
 LNG_IBTN_REFRESH            = 384;
 LNG_IBTN_ADD                = 385;
 LNG_IBTN_REMOVE             = 386;
 LNG_ILIST_USER              = 387;
 LNG_IEDIT_HINT              = 388;
 LNG_LBL_FRIENDS             = 389;
 LNG_FBTN_REFRESH            = 390;
 LNG_FBTN_ADD                = 391;
 LNG_FBTN_REMOVE             = 392;
 LNG_FLIST_USER              = 393;
 LNG_FEDIT_HINT              = 394;
 LNG_LBL_BLOCKS              = 395;
 LNG_BLBTN_REFRESH           = 396;
 LNG_BLBTN_ADD               = 397;
 LNG_BLBTN_REMOVE            = 398;
 LNG_BLLIST_ITEM             = 399;
 LNG_BLEDIT_HINT             = 400;
 LNG_SBTN_DELETE             = 401;
 LNG_SBTN_ADD                = 402;
 LNG_SBTN_PROPS              = 403;
 LNG_SHOST_HINT              = 404;
 LNG_EDITSRV_CAPTION         = 405;
 LNG_EDITSRV_HOST            = 406;
 LNG_EDITSRV_PORT            = 407;
 LNG_EDITSRV_IPINFO          = 408;
 LNG_EDITSRV_IPTEXT          = 409;
 LNG_EDITSRV_BOX             = 410;
 LNG_EDITSRV_RESOLVE         = 411;
 LNG_EDITSRV_PASSWORD        = 412;
 LNG_EDITSRV_MYPASS          = 413;
 LNG_EDITSRV_REMOTEPASS      = 414;
 LNG_EDITSRV_BOX2            = 415;
 LNG_EDITSRV_COMP0           = 416;
 LNG_EDITSRV_COMP1           = 417;
 LNG_EDITSRV_COMP2           = 418;
 LNG_EDITSRV_COMP3           = 419;
 LNG_EDITSRV_COMMENTS        = 420;
 LNG_EDITSRV_RELINK          = 421;
 LNG_EDITSRV_OK              = 422;
 LNG_EDITSRV_CANCEL          = 423;
 LNG_REMOVESERVER            = 424;
 LNG_CANTREMOVE              = 425;
 LNG_LINKREQ2                = 426;
 LNG_SRV_RELINKTIME          = 427;
 LNG_MENU_WEB                = 428;
 LNG_HLIST_NAME              = 429;
 LNG_HLIST_SERVER            = 430;
 LNG_HLIST_SPEED             = 431;
 LNG_HBTN_REFRESH            = 432;
 LNG_HBTN_ADD                = 433;
 LNG_HBTN_DELETE             = 434;
 LNG_HEDIT_HINT              = 435;
 LNG_HLIST_OFFLINE           = 436;
 LNG_LABEL_HOTLIST           = 437;
 LNG_MENU_REGISTERED         = 438;
 LNG_BANS_TIME60             = 443;
 LNG_BANS_TIME300            = 444;
 LNG_BANS_TIME600            = 445;
 LNG_BANS_TIME1800           = 446;
 LNG_BANS_TIME3600           = 447;
 LNG_BANS_TIME10800          = 448;
 LNG_BANS_TIME43200          = 449;
 LNG_BANS_TIME86400          = 450;
 LNG_BANS_TIME259200         = 451;
 LNG_BANS_TIME604800         = 452;
 LNG_BANS_TIME1209600        = 453;
 LNG_BANS_TIME2678400        = 454;
 LNG_BANS_TIME5184000        = 455;
 LNG_BANS_TIME7776000        = 456;
 LNG_BANS_TIME31536000       = 457;
 LNG_REG_HINT_USER           = 459;
 LNG_REG_HINT_PASSWORD       = 460;
 LNG_REG_HINT_LEVEL          = 461;
 LNG_REG_BTN_REGISTER        = 462;
 LNG_LIST_HINT_BAN           = 463;
 LNG_REG_HINT_BAN            = 464;
 LNG_NUKEMSG                 = 465;
 LNG_KICKMSG                 = 466;
 LNG_KICKMSG2                = 467;
 LNG_SLIST_LAG               = 468;
 LNG_SLIST_LAGSEC            = 469;
 LNG_SBTN_AUTOREFRESH        = 470;
 LNG_LOG_LABEL               = 471;
 LNG_LOG_CLEAR               = 472;
 LNG_CHAT                    = 473;
 LNG_CMNU_CLOSE              = 474;
 LNG_CMNU_HOTLIST            = 475;
 LNG_CMNU_FRIEND             = 476;
 LNG_CMNU_WHOIS              = 477;
 LNG_CMNU_IGNORE             = 478;
 LNG_LIST_BTN_KICKBAN        = 479;
 LNG_LIST_MENU_KICKBAN       = 480;
 LNG_ST_BYTES                = 481;
 LNG_ST_TIME                 = 482;
 LNG_ST_LOCAL                = 483;
 LNG_ST_LOCALMAX             = 484;
 LNG_ST_TOTAL                = 485;
 LNG_ST_TOTALMAX             = 486;
 LNG_ST_LASTTRANSFER         = 487;
 LNG_ST_LASTDATA             = 488;
 LNG_ST_TOTALTRANSFER        = 489;
 LNG_ST_TOTALDATA            = 490;
 LNG_MINSHARE                = 491;
 LNG_MINSHARE2               = 492;
 LNG_MINSHARE_REASON         = 493;
 LNG_ST_NOLINK               = 495;
 LNG_ST_LINK                 = 496;
 LNG_MINSHARE3               = 497;
 LNG_MINSHARE4               = 498;
 LNG_MINSHARE_REASON2        = 499;
 LNG_DISCONNECT_WINMX        = 502;
 LNG_BLOCKEDWINMX            = 503;
 LNG_REASON_WIMXBAN          = 504;
 LNG_SMENU_REFRESH           = 505;
 LNG_SMENU_CONNECT2          = 506;
 LNG_SMENU_DISCONNECT        = 507;
 LNG_SMENU_DELETE            = 508;
 LNG_SMENU_COMP              = 509;
 LNG_SMENU_COMP0             = 510;
 LNG_SMENU_COMP1             = 511;
 LNG_SMENU_COMP2             = 512;
 LNG_SMENU_COMP3             = 513;
 LNG_SMENU_STARTUP           = 514;
 LNG_SMENU_STARTUP2          = 515;
 LNG_SMENU_LINK300           = 516;
 LNG_SMENU_LINK600           = 517;
 LNG_SMENU_LINK900           = 518;
 LNG_SMENU_LINK1200          = 519;
 LNG_SMENU_LINK1800          = 520;
 LNG_SMENU_PROPS             = 521;
 LNG_SMENU_SELECTALL         = 522;
 LNG_SMENU_SELECTNONE        = 523;
 LNG_SMENU_COPYNAME          = 524;
 LNG_BANEXPCHANGE            = 525;
 LNG_BANREASONCHANGE         = 526;
 LNG_WHOIS_CAPTION           = 527;
 LNG_WHOIS_USER              = 528;
 LNG_WHOIS_LEVEL             = 529;
 LNG_WHOIS_TIME              = 530;
 LNG_WHOIS_CHANNELS          = 531;
 LNG_WHOIS_STATUS            = 532;
 LNG_WHOIS_SHARED            = 533;
 LNG_WHOIS_TRANSFERS         = 534;
 LNG_WHOIS_SPEED             = 535;
 LNG_WHOIS_SOFTWARE          = 536;
 LNG_WHOIS_TOTAL             = 537;
 LNG_WHOIS_IP                = 538;
 LNG_WHOIS_PORT              = 539;
 LNG_WHOIS_DATAPORT          = 540;
 LNG_WHOIS_SERVER            = 541;
 LNG_WHOIS_WHOWAS            = 542;
 LNG_BMENU_REFRESH           = 543;
 LNG_BMENU_UNBAN             = 544;
 LNG_BMENU_COPYUSER          = 545;
 LNG_BMENU_COPYIP            = 546;
 LNG_BMENU_COPYBAN           = 547;
 LNG_BMENU_COPYADMIN         = 548;
 LNG_BMENU_COPYREASON        = 549;
 LNG_BMENU_SELALL            = 550;
 LNG_BMENU_SELNONE           = 551;
 LNG_HMENU_REFRESH           = 552;
 LNG_HMENU_IM                = 553;
 LNG_HMENU_WHOIS             = 554;
 LNG_HMENU_FRIEND            = 555;
 LNG_HMENU_DELETE            = 556;
 LNG_HMENU_SELALL            = 557;
 LNG_HMENU_SELNONE           = 558;
 LNG_HMENU_COPYNAME          = 559;
 LNG_IMENU_REFRESH           = 560;
 LNG_IMENU_DELETE            = 561;
 LNG_IMENU_SELALL            = 562;
 LNG_IMENU_SELNONE           = 563;
 LNG_IMENU_COPYNAME          = 564;
 LNG_FMENU_REFRESH           = 565;
 LNG_FMENU_DELETE            = 566;
 LNG_FMENU_SELALL            = 567;
 LNG_FMENU_SELNONE           = 568;
 LNG_FMENU_COPYNAME          = 569;
 LNG_BMNU_REFRESH            = 570;
 LNG_BMNU_DELETE             = 571;
 LNG_BMNU_SELALL             = 572;
 LNG_BMNU_SELNONE            = 573;
 LNG_BMNU_COPYNAME           = 574;
 LNG_WMENU_CLOSE             = 575;
 LNG_WMENU_HOTLIST           = 576;
 LNG_WMENU_FRIEND            = 577;
 LNG_WMENU_IGNORE            = 578;
 LNG_WMENU_MESSAGE           = 579;
 LNG_CHMNU_IM                = 580;
 LNG_CHMNU_WHOIS             = 581;
 LNG_CHMNU_OP                = 582;
 LNG_CHMNU_DEOP              = 583;
 LNG_CHMNU_VOICE             = 584;
 LNG_CHMNU_UNVOICE           = 585;
 LNG_CHMNU_BAN               = 586;
 LNG_CHMNU_BANIP             = 587;
 LNG_CHMNU_KICK              = 588;
 LNG_CHMNU_COPYNAME          = 589;
 LNG_ST_BPS                  = 590;
 LNG_LIST_CLOAKED            = 591;
 LNG_LIST_CHATTING           = 592;
 LNG_CONSOLEPONG             = 593;
 LNG_NAPIGATOR_AUTODISCONNECT = 594;
 LNG_CMENU_CLEARBANS         = 595;
 LNG_BANNED3                 = 596;
 LNG_ST_BANDWIDTHLIMIT       = 597;
 LNG_BANDWIDTHLIMIT          = 598;
 LNG_INV_CAPTION             = 599;
 LNG_INV_NAME                = 600;
 LNG_INV_TOPIC               = 601;
 LNG_INV_ACCEPT              = 602;
 LNG_INV_DENY                = 603;
 LNG_INV_IGNORE              = 604;
 LNG_INV_WHOIS               = 605;
 LNG_INV_HOTLIST             = 606;
 LNG_INV_PRIVMSG             = 607;
 LNG_INV_MESSAGE             = 608;
 LNG_S_ITEM_MAIN             = 609;
 LNG_S_TEXT_MAIN             = 610;
 LNG_S_ITEM_USERS            = 611;
 LNG_S_TEXT_USERS            = 612;
 LNG_S_ITEM_LIMITS           = 613;
 LNG_S_TEXT_LIMITS           = 614;
 LNG_S_ITEM_INTERFACE        = 615;
 LNG_S_TEXT_INTERFACE        = 616;
 LNG_S_ITEM_LOG              = 617;
 LNG_S_TEXT_LOG              = 618;
 LNG_S_ITEM_SHARE            = 619;
 LNG_S_TEXT_SHARE            = 620;
 LNG_S_ITEM_SHARE_MP3        = 621;
 LNG_S_TEXT_SHARE_MP3        = 622;
 LNG_S_ITEM_SHARE_AUDIO      = 623;
 LNG_S_TEXT_SHARE_AUDIO      = 624;
 LNG_S_ITEM_SHARE_VIDEO      = 625;
 LNG_S_TEXT_SHARE_VIDEO      = 626;
 LNG_S_ITEM_SHARE_IMAGES     = 627;
 LNG_S_TEXT_SHARE_IMAGES     = 628;
 LNG_S_ITEM_SHARE_APP        = 629;
 LNG_S_TEXT_SHARE_APP        = 630;
 LNG_S_ITEM_SHARE_CD         = 631;
 LNG_S_TEXT_SHARE_CD         = 632;
 LNG_S_ITEM_SHARE_TEXT       = 633;
 LNG_S_TEXT_SHARE_TEXT       = 634;
 LNG_S_ITEM_NAPIGATOR        = 635;
 LNG_S_TEXT_NAPIGATOR        = 636;
 LNG_S_ITEM_SEARCH           = 637;
 LNG_S_TEXT_SEARCH           = 638;
 LNG_S_ITEM_LEVELS           = 639;
 LNG_S_TEXT_LEVELS           = 640;
 LNG_S_ITEM_CHANNELS         = 641;
 LNG_S_TEXT_CHANNELS         = 642;
 LNG_S_ITEM_CONSOLE          = 643;
 LNG_S_TEXT_CONSOLE          = 644;
 LNG_S_ITEM_BLOCKED          = 645;
 LNG_S_TEXT_BLOCKED          = 646;
 LNG_S_ITEM_LINKS            = 647;
 LNG_S_TEXT_LINKS            = 648;
 LNG_S_ITEM_SOCKETS          = 649;
 LNG_S_TEXT_SOCKETS          = 650;
 LNG_S_ITEM_OTHER            = 651;
 LNG_S_TEXT_OTHER            = 652;
 LNG_S_ITEM_REPORT           = 653;
 LNG_S_TEXT_REPORT           = 654;
 LNG_S_ITEM_MINSHARE         = 655;
 LNG_S_TEXT_MINSHARE         = 656;
 LNG_S_ITEM_MOTD             = 657;
 LNG_S_TEXT_MOTD             = 658;
 LNG_S_CAPTION               = 659;
 LNG_S_BTN_CHANGE            = 660;
 LNG_S_BTN_SAVE              = 661;
 LNG_S_BTN_RESTORE           = 662;
 LNG_S_BTN_CLOSE             = 663;
 LNG_S_LBL_NOTE              = 664;
 LNG_S_LBL_CHANGE            = 665;
 LNG_S_LBL_SAVE              = 666;
 LNG_FLOODWARN               = 667;
 LNG_FLOODMUZZLE1            = 668;
 LNG_FLOODMUZZLE2            = 669;
 LNG_S_ITEM_COLORS           = 670;
 LNG_S_TEXT_COLORS           = 671;
 LNG_LOG_CB_AWAY             = 672;
 LNG_LOG_LBL_AWAY            = 673;
 LNG_LOG_MODE                = 674;
 LNG_MODE_ERROR              = 675;
 LNG_MODE_ANNOUNCE           = 676;
 LNG_MODE_BAN                = 677;
 LNG_MODE_CHANGE             = 678;
 LNG_MODE_KILL               = 679;
 LNG_MODE_LEVEL              = 680;
 LNG_MODE_SERVER             = 681;
 LNG_MODE_MUZZLE             = 682;
 LNG_MODE_PORT               = 683;
 LNG_MODE_WALLOP             = 684;
 LNG_MODE_CLOAK              = 685;
 LNG_MODE_FLOOD              = 686;
 LNG_MODE_MSG                = 687;
 LNG_MODE_WHOIS              = 688;
 LNG_MODE_BROWSE             = 689;
 LNG_MODE_FRIEND             = 690;
 LNG_MODE_CHANNEL            = 691;
 LNG_MODE_REGISTER           = 692;
 LNG_MODE_VAR                = 693;
 LNG_MODE_OK                 = 694;
 LNG_MODE_ALL                = 695;
 LNG_MODE_NONE               = 696;
 LNG_MODE_CANCEL             = 697;
 LNG_MODE_CAPTION            = 698;
 LNG_ACCESSREG               = 699;
 LNG_LINKNOLIST3             = 700;
 LNG_LINKNOLIST1             = 701;
 LNG_S_ITEM_LINKS2           = 702;
 LNG_S_TEXT_LINKS2           = 703;
 LNG_OUTGOINGRESTRICTED      = 704;
 LNG_CHTOPIC                 = 705;
 LNG_RECONNECT               = 706;
 LNG_LOG_CB_AWAYPOPUP        = 707;
 LNG_LIST_EDIT_FILTER_HINT   = 708;
 LNG_LIST_HEADER_TIME        = 709;
 LNG_LIST_HEADER_TRANSFERS   = 710;
 LNG_LIST_HEADER_TOTAL       = 711;
 LNG_LIST_BTN_MODE           = 712;
 LNG_LIST_MNU2_LEVEL         = 713;
 LNG_LIST_MNU2_SHARED        = 714;
 LNG_LIST_MNU2_SOFT          = 715;
 LNG_LIST_MNU2_SPEED         = 716;
 LNG_LIST_MNU2_IP            = 717;
 LNG_LIST_MNU2_PORT          = 718;
 LNG_LIST_MNU2_TIME          = 719;
 LNG_LIST_MNU2_TRANSFERS     = 720;
 LNG_LIST_MNU2_TOTAL         = 721;
 LNG_LIST_MNU2_SERVER        = 722;
 LNG_LOG_CB_SOUND            = 723;
 LNG_LINKINVCONSOLE2         = 724;
 LNG_LINKINVCONSOLE3         = 725;
 LNG_REG_EDIT_FILTER_HINT    = 726;
 LNG_REG_CLOAKED             = 727;
 LNG_EDIT_DAGSTA             = 728;
 LNG_S_ITEM_DAGSTA           = 729;
 LNG_S_TEXT_DAGSTA           = 730;
 LNG_DAGSTA_CONNECTED        = 731;
 LNG_DAGSTA_ERROR            = 732;
 LNG_DAGSTA_REPLY            = 733;
 LNG_DAGSTA_SEND             = 734;
 LNG_DAGSTA_DISCONNECT       = 735;
 LNG_DAGSTA_CONNECTING       = 736;
 LNG_DAGSTA_NOCONNECT        = 737;
 LNG_DAGSTA_NORESOLVE        = 738;
 LNG_DAGSTA_RESOLVED         = 739;
 LNG_DAGSTA_NOWELCOME        = 740;
 LNG_DAGSTA_AUTODISCONNECT   = 741;
 LNG_MENU_DAGSTA             = 742;
 LNG_BROWSEFAIL              = 743;
 LNG_BROWSELEECH             = 744;
 LNG_BROWSEFIREWALL          = 745;
 LNG_OFFLINE2                = 746;
 LNG_LINKING                 = 747;
 LNG_INVALIDSOFTWARE         = 748;
 LNG_ALREADYREGISTERED       = 749;
 LNG_LIST_MENU_REGISTER      = 750;
 LNG_LIST_BTN_REGISTER       = 751;
 LNG_CANTKILL                = 752;
 LNG_KILLSERVER              = 753;
 LNG_MODE_PING               = 754;
 LNG_LIST_BTN_BANIP          = 755;
 LNG_LIST_MENU_BANIP         = 756;
 LNG_LIST_BTN_KICKBANIP      = 757;
 LNG_LIST_MENU_KICKBANIP     = 758;
 LNG_MENU_COPY               = 759;
 LNG_LOG_PAUSE               = 760;
 LNG_LOG_RESUME              = 761;
 LNG_SHAREFILESFIRST         = 762; // fredtest
 LNG_SHAREMEGSFIRST          = 763; // fredtest
 LNG_MAX                     = 775;

 // strings that shouldn't be translated
 STR_NOTIMPLEMENTED         = 'R}h [%d] '+SLAVANAP_VERSION_SHORT+'ł̓T|[g܂B';
 STR_DEFAULTTOPIC           = '悤%s`lցI'; // default channel topic
 STR_BAN_NUKE               = 'AJEg폜܂B'; // default reason for bans via 'nuke' command
 STR_SERVER_SHUT_DOWN       = 'T[o[Vbg_EĂ܂... ΂炭҂';
 STR_SERVER_SHUT_DOWN2      = '15bȓɃVbg_EȂx "Vbg_E"(܂"ċN")ĂB';
 STR_DEBUGCOMMAND           = 'Received command [%d] "%s" (%s)';
 STR_DEBUGCOMMAND_X         = 'Received compressed command [%d] "%s" (%s)';
 STR_DEBUGCOMMAND_NEW       = 'Received command [%d] "%s" (%s) (big-endian)';
 STR_DEBUGSEND              = 'Sending command [%d] "%s" (%s)';
 STR_DEBUGSEND_NEW          = 'Sending command [%d] "%s" (%s) (big-endian)';
 STR_DEBUGCOMMAND2          = 'Recv [%d] "%s" (%s)';
 STR_DEBUGCOMMAND2_NEW      = 'Recv [%d] "%s" (%s) (big-endian)';
 STR_INVALIDCOMMAND3        = 'Invalid command [%d] "%s" (server %s)';
 STR_INVALIDCOMMAND2        = 'Invalid command [%d] "%s" (%s)'; // [%d] - ID, "%s" - command text, (%s) - software
 STR_INVALIDCOMMAND2_NEW    = 'Invalid command [%d] "%s" (%s) (big-endian)'; // [%d] - ID, "%s" - command text, (%s) - software
 STR_INVALIDVERSION         = 'T[o[o[W(%s)܂B[go[W"%s"łB';
 STR_INVALIDSERVERHOST      = 'T[o[zXg܂B';
 STR_SELFCONNECT            = 'T[o[zXg܂Bgɐڑ悤ƂĂ܂񂩁HH';
 STR_INVALIDRESOLVE         = 'T[o[zXg܂BȂIP%sŁA%s IP%słBzXgIPꍇ̓[gT[o[łȂ̃T[o[̔F؂"pX[h`FbN"ɕύXĂB';
 STR_INVALIDRESOLVE2        = 'T[o[zXg܂B%sIPł܂BzXgIPꍇ̓[gT[o[łȂ̃T[o[̔F؂"pX[h`FbN"ɕύXĂB';
 STR_INVALIDSERVERPASS      = 'pX[h܂B';
 STR_NOINCOMING             = '̃T[o[͊ÕT[o[̐ڑ󂯓܂B';
 STR_MESSAGE                = '* ';
 STR_REMOTEMESSAGE          = '(%s) * ';

 // channel built-in commands. shold NOT be translated

 STR_CHSTR_LIST             = '">help"ŃR}hꗗ܂B';
 STR_CHSTR_UNKNOWN          = '"%s"͕sȃR}hłB">help"ŃR}hꗗ܂B';
 STR_CHSTR_UNKNOWNADMIN     = '"%s"͕sȃR}hłB">admin help"ŃR}hꗗ܂B';
 STR_CHSTR_UNKNOWNSERVER    = '"%s"͕sȃR}hłB">server help"ŃR}hꗗ܂B';
 STR_CHSTR_BAN              = ': >ban <user>';
 STR_CHSTR_BANIP            = ': >banip <user>';
 STR_CHSTR_UNBAN            = ': >unban <user>';
 STR_CHSTR_OP               = ': >op <user> [<user2> ...]';
 STR_CHSTR_DEOP             = ': >deop <user> [<user2> ...]';
 STR_CHSTR_KICK             = ': >kick <user> [reason]';
 STR_CHSTR_VOICE            = ': >voice <user> [<user2> ...]';
 STR_CHSTR_UNVOICE          = ': >unvoice <user> [<user2> ...]';
 STR_CHSTR_WHOIS            = ': >whois <user>';
 STR_CHSTR_INVITE           = ': >invite <user>';
 STR_CHSTR_REMOVE           = ': >remove <channel> [reason]';
 STR_CHSTR_SHOWSERVER       = ': >showserver <user>';
 STR_CHSTR_A_REGISTER       = ': >admin register <user> [<password> [<email> [<level>]]]';
 STR_CHSTR_A_BAN            = ': >admin ban <user!ip> [reason]';
 STR_CHSTR_A_UNBAN          = ': >admin unban <user!ip>';
 STR_CHSTR_A_FRIENDS        = ': >admin friends add|remove|list [user]';
 STR_CHSTR_A_REDIRECT       = ': >admin redirect <server> <port>';
 STR_CHSTR_A_CYCLE          = ': >admin cycle <metaserver>';
 STR_CHSTR_A_IP             = ': >admin ip <user>';
 STR_CHSTR_A_KILL           = ': >admin kill <jerk> [reason]';
 STR_CHSTR_A_NUKE           = ': >admin nuke <user> [reason]';
 STR_CHSTR_A_MUZZLE         = ': >admin muzzle <user> [reason]';
 STR_CHSTR_A_UNMUZZLE       = ': >admin unmuzzle <user> [reason]';
 STR_CHSTR_A_LEVEL          = ': >admin level <user> <level>';
 STR_CHSTR_S_PING           = ': >server ping <server> [<server2> ...]';
 STR_CHSTR_S_REMOVE         = ': >server remove <server>';
 STR_CHSTR_S_CONNECT        = ': >server connect <server>[:<port>]';
 STR_CHSTR_S_DISCONNECT     = ': >server disconnect <server>';

 // help
 STR_CHHLP_MAIN             = SLAVANAP_FULL+' help.';
 STR_CHHLP_HELPLIST         = 'płR}ḧꗗ :';
 STR_CHHLP_HELPLISTADMIN    = 'płTuR}ḧꗗ :';
 STR_CHHLP_HELPLISTSERVER   = 'płTuR}ḧꗗ :';
 STR_CHHLP_BAN              = '>ban <user> '#9#9#9'- ̃`l烆[U[֎~';
 STR_CHHLP_BANIP            = '>banip <user> '#9#9#9'- IPw肵ē֎~';
 STR_CHHLP_BANCLEAR         = '>banclear '#9#9#9'- ֎~ׂĉ';
 STR_CHHLP_BANLIST          = '>banlist '#9#9#9#9'- `l̓֎~҂ꗗ';
 STR_CHHLP_CLS              = '>cls '#9#9#9#9'- ʂNA';
 STR_CHHLP_HELP             = '>help '#9#9#9#9'- ̃bZ[W\';
 STR_CHHLP_OPSAY            = '>opsay <message> '#9#9'- ̃`lׂ̂ẴIy[^[ɃbZ[W𑗂';
 STR_CHHLP_OPEMOTE          = '>opemote <message> '#9#9'- ̃`lׂ̂ẴIy[^[ɊbZ[W𑗂';
 STR_CHHLP_UNBAN            = '>unban <user> '#9#9#9'- [U[̓֎~';
 STR_CHHLP_OP               = '>op <user> [<user2> ...] '#9#9'- ̃`l̃Iy[^[ɂ';
 STR_CHHLP_OPLIST           = '>oplist '#9#9#9#9'- ׂẴIy[^[̈ꗗ("User"x̐l̂)';
 STR_CHHLP_DEOP             = '>deop <user> [<user2> ...] '#9#9'- ̃`l̃Iy[^[͂';
// STR_CHHLP_REFRESH          = '>refresh '#9#9#9#9'- [U[ꗗXV';
 STR_CHHLP_PART             = '>part '#9#9#9#9'- ̃`lގ';
 STR_CHHLP_EMOTE            = '>me <message> '#9#9#9'- emote(\)';
 STR_CHHLP_KICK             = '>kick <user> [reason] '#9#9'- ̃`l烆[U[Ǖ';
 STR_CHHLP_TOPIC            = '>topic [topic] '#9#9#9'- VgsbNݒ';
 STR_CHHLP_DROP             = '>drop [reason] '#9#9#9'- ̃`l폜';
 STR_CHHLP_REMOVE           = '>remove <channel> [reason] '#9'- ̃`l폜';
 STR_CHHLP_CLEAR            = '>clear [reason] '#9#9#9'- ̃`l炷ׂẴ[U[Ǖ';
 STR_CHHLP_VOICE            = '>voice <user> [<user2> ...] '#9#9'- [U[ɂ̃`lł̔^';
 STR_CHHLP_UNVOICE          = '>unvoice <user> [<user2> ...] '#9'- グ';
 STR_CHHLP_WHOIS            = '>whois <user> '#9#9#9'- [U[̏擾';
 STR_CHHLP_MODE             = '>mode [+|- <mode> ...] '#9#9'- `l[h̕ύX';
 STR_CHHLP_RAW              = '>raw <number> [arguments ...] '#9'- R}hԍŎw肵Ďs';
 STR_CHHLP_LIMIT            = '>limit <number> '#9#9#9'- `l̒ݒ';
 STR_CHHLP_LEVEL            = '>level <level> '#9#9#9'- `lɓłŒ჆[U[xݒ';
 STR_CHHLP_INVITE           = '>invite <user> '#9#9#9'- [U[`lɏ';
 STR_CHHLP_USERMODE         = '>usermode [+|- <mode> ...] '#9#9'- Ȃ̃[hύX. ">usermode help" Ń[hꗗ';
 STR_CHHLP_SHOWSERVER       = '>showserver <user> '#9#9'- [U[OCĂT[o[\';
// STR_CHHLP_ADDFRIENDS       = '>addfriends <user> '#9#9#9'- [U[FlXgɒǉ';
// STR_CHHLP_REMFRIENDS       = '>remfriends <user> '#9#9#9'- FlXg烆[U[폜';
 STR_CHHLP_LISTFRIENDS      = '>listfriends '#9#9#9'- FlXg\';
 STR_CHHLP_CONSOLE          = '>console '#9#9#9#9'- T[o[̐[[U[̖O\';
 STR_CHHLP_VERSION          = '>version '#9#9#9#9'- T[o[\tgEFÃo[W\';
 STR_CHHLP_ADMIN            = '>admin <sub-command> [<args>...] '#9'- ǗҗpR}h. ">admin help" ŏڍ';
 STR_CHHLP_SERVER           = '>server <sub-command> [<args>...] '#9'- T[o[ÑR}h. ">server help" ŏڍ';
 STR_CHHLP_A_REGISTER       = '>admin register <name> [<password> <email> <level>] '#9'- [U[̐VKo^';
 STR_CHHLP_A_BAN            = '>admin ban <user!ip> [reason] '#9'- [U[OC֎~';
 STR_CHHLP_A_BANLIST        = '>admin banlist '#9#9#9'- OC֎~҂̈ꗗ';
 STR_CHHLP_A_UNBAN          = '>admin unban <user!ip> '#9#9'- [U[̃OC֎~';
 STR_CHHLP_A_FRIENDS        = '>admin friends add|remove|list [user] '#9'- Flǉ/폜/ꗗ';
 STR_CHHLP_A_ANNOUNCE       = '>admin announce <message> '#9'- ׂẴ[U[ɃAiEX';
 STR_CHHLP_A_WALLOP         = '>admin wallop <message> '#9#9'- ׂĂmods+ɃbZ[W𑗂';
 STR_CHHLP_A_REDIRECT       = '>admin redirect <server> <port> '#9'- ̃T[o[ɂׂẴ[U[_CNg (قƂǂ̃NCAgŃT|[gĂ܂)';
 STR_CHHLP_A_CYCLE          = '>admin cycle <metaserver> '#9'- ^T[o[ɂׂẴ[U[_CNg (قƂǂ̃NCAgŃT|[gĂ܂)';
 STR_CHHLP_A_SOFTWARE       = '>admin software '#9#9#9'- NCAg̓v\';
 STR_CHHLP_A_IP             = '>admin ip <user> '#9#9#9'- [U[IP擾';
 STR_CHHLP_A_VARIABLE       = '>admin set <variable> [value] '#9#9'- T[o[ϐ̕ύX';
 STR_CHHLP_A_VARIABLE2      = '>admin set <variable> '#9#9'- T[o[ϐ擾';
 STR_CHHLP_A_KILL           = '>admin kill <jerk> [reason] '#9#9'- [U[ؒf';
 STR_CHHLP_A_NUKE           = '>admin nuke <user> [reason] '#9'- [U[̃AJEg폜';
 STR_CHHLP_A_MUZZLE         = '>admin muzzle <user> [reason] '#9'- [U[𔭌֎~';
 STR_CHHLP_A_UNMUZZLE       = '>admin unmuzzle <user> [reason] '#9'- [U[̔֎~';
 STR_CHHLP_A_LEVEL          = '>admin level <user> <level> '#9'- [U[x̕ύX';
 STR_CHHLP_A_CLOAK          = '>admin cloak [1|0] '#9#9'- N[N';
 STR_CHHLP_S_VERSION        = '>server version '#9#9#9'- T[o[o[W̎擾';
 STR_CHHLP_S_PING           = '>server ping <server> [<server2> ...] '#9'- T[o[ping';
 STR_CHHLP_S_PINGALL        = '>server pingall '#9#9#9'- ׂẴNT[o[ping';
 STR_CHHLP_S_REMOVE         = '>server remove <server> '#9#9'- ꗗT[o[폜';
 STR_CHHLP_S_CONNECT        = '>server connect <server>[:<port>] '#9'- T[o[N';
 STR_CHHLP_S_DISCONNECT     = '>server disconnect <server> '#9'- T[o[ؒf';
 STR_CHHLP_S_CONSOLE        = '>server console '#9#9#9'- [[U[̖O擾';
 STR_CHHLP_S_LINKS          = '>server links '#9#9#9'- NT[o[ꗗ';
 STR_CHHLP_S_LAG            = '>server lag '#9#9#9'- NT[o[̒x\';
 STR_CHHLP_S_STATS          = '>server stats '#9#9#9'- T[o[̓v\';


procedure LoadLanguage(name: String='');
function  GetLangEx(str: String; arg1: String; arg2: String=''; arg3: string=''; arg4: string=''; arg5: String=''): String;
// should be accessed from main thread
function  GetLangT(id: Integer): String; overload;
function  GetLangT(id: Integer; arg: String): String; overload;
function  GetLangT(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String; overload;
function  GetLangT(id: Integer; i: Integer): String; overload;
function  GetLangT(id: Integer; i1,i2: Integer): String; overload;
function  GetLangT(id: Integer; i: Integer; arg: String): String; overload;
function  GetLangT(id: Integer; arg: String; i: Integer): String; overload;
function  GetLangT(id: Integer; arg1,arg2: String; i:Integer): String; overload;
// should be accessed from interface
function  GetLangI(id: Integer): String; overload;
function  GetLangI(id: Integer; arg: String): String; overload;
function  GetLangI(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String; overload;
function  GetLangI(id: Integer; i: Integer): String; overload;
function  GetLangI(id: Integer; i1,i2: Integer): String; overload;
function  GetLangI(id: Integer; i: Integer; arg: String): String; overload;
function  GetLangI(id: Integer; arg: String; i: Integer): String; overload;
function  GetLangI(id: Integer; arg1,arg2: String; i:Integer): String; overload;
// should be accessed from other threads
function  GetLangE(id: Integer): String; overload;
function  GetLangE(id: Integer; arg: String): String; overload;
function  GetLangE(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String; overload;
function  GetLangE(id: Integer; i: Integer): String; overload;
function  GetLangE(id: Integer; i1,i2: Integer): String; overload;
function  GetLangE(id: Integer; i: Integer; arg: String): String; overload;
function  GetLangE(id: Integer; arg: String; i: Integer): String; overload;
function  GetLangE(id: Integer; arg1,arg2: String; i:Integer): String; overload;


implementation

uses
 stypes, vars;

var
 // using 3 lists because compiling with Delphi 4. in d4 strings are not thread-safe
 language_t: TStringList; // accessed from main thread
 language_i: TStringList; // accessed from interface
 language_e: TStringList; // accessed from other threads

procedure InitLanguage;
var
 i: Integer;
begin
 language_t:=TStringList.Create;
 for i:=0 to LNG_MAX do
  language_t.Add(LNG_UNKNOWN);
 language_i:=TStringList.Create;
 for i:=0 to LNG_MAX do
  language_i.Add(LNG_UNKNOWN);
 language_e:=TStringList.Create;
 for i:=0 to LNG_MAX do
  language_e.Add(LNG_UNKNOWN);
end;

procedure DestroyLanguage;
begin
 language_t.Free;
 language_t:=nil;
 language_i.Free;
 language_i:=nil;
 language_e.Free;
 language_e:=nil;
end;

function  GetLangEx(str: String; arg1: String; arg2: String=''; arg3: string=''; arg4: string=''; arg5: String=''): String;
var
 i: Array[1..5] of Integer;
 len,j: Integer;
begin
 i[1]:=pos('$1',str);
 i[2]:=pos('$2',str);
 i[3]:=pos('$3',str);
 i[4]:=pos('$4',str);
 i[5]:=pos('$5',str);
 if i[1]>0 then
 begin // arg1
   system.delete(str,i[1],2);
   len:=Length(arg1);
   system.insert(arg1,str,i[1]);
   for j:=2 to 5 do
    if i[j]>=i[1] then
    begin
     dec(i[j],2);
     inc(i[j],len);
    end;
 end;
 if i[2]>0 then
 begin // arg2
   system.delete(str,i[2],2);
   len:=Length(arg2);
   system.insert(arg2,str,i[2]);
   for j:=3 to 5 do
    if i[j]>=i[2] then
    begin
     dec(i[j],2);
     inc(i[j],len);
    end;
 end;
 if i[3]>0 then
 begin // arg3
   system.delete(str,i[3],2);
   len:=Length(arg3);
   system.insert(arg3,str,i[3]);
   for j:=4 to 5 do
    if i[j]>=i[3] then
    begin
     dec(i[j],2);
     inc(i[j],len);
    end;
 end;
 if i[4]>0 then
 begin // arg4
   system.delete(str,i[4],2);
   len:=Length(arg4);
   system.insert(arg4,str,i[4]);
   if i[5]>=i[4] then
   begin
    dec(i[5],2);
    inc(i[5],len);
   end;
 end;
 if i[5]>0 then
 begin // arg5
   system.delete(str,i[1],2);
   system.insert(arg1,str,i[5]);
 end;
 Result:=str;
end;

// from main thread:

function  GetLangT(id: Integer; i: Integer): String;
begin
  Result:=GetLangT(id,IntToStr(i));
end;

function  GetLangT(id: Integer; i1,i2: Integer): String;
begin
  Result:=GetLangT(id,IntToStr(i1),IntToStr(i2));
end;

function  GetLangT(id: Integer; i: Integer; arg: String): String;
begin
  Result:=GetLangT(id,IntToStr(i),arg);
end;

function  GetLangT(id: Integer; arg: String; i: Integer): String;
begin
  Result:=GetLangT(id,arg,IntToStr(i));
end;

function  GetLangT(id: Integer; arg1,arg2: String; i:Integer): String;
begin
  Result:=GetLangT(id,arg1,arg2,IntToStr(i));
end;

// from interface:

function  GetLangI(id: Integer; i: Integer): String;
begin
  Result:=GetLangI(id,IntToStr(i));
end;

function  GetLangI(id: Integer; i1,i2: Integer): String;
begin
  Result:=GetLangI(id,IntToStr(i1),IntToStr(i2));
end;

function  GetLangI(id: Integer; i: Integer; arg: String): String;
begin
  Result:=GetLangI(id,IntToStr(i),arg);
end;

function  GetLangI(id: Integer; arg: String; i: Integer): String;
begin
  Result:=GetLangI(id,arg,IntToStr(i));
end;

function  GetLangI(id: Integer; arg1,arg2: String; i:Integer): String;
begin
  Result:=GetLangI(id,arg1,arg2,IntToStr(i));
end;

// from other threads:

function  GetLangE(id: Integer; i: Integer): String;
begin
  Result:=GetLangE(id,IntToStr(i));
end;

function  GetLangE(id: Integer; i1,i2: Integer): String;
begin
  Result:=GetLangE(id,IntToStr(i1),IntToStr(i2));
end;

function  GetLangE(id: Integer; i: Integer; arg: String): String;
begin
  Result:=GetLangE(id,IntToStr(i),arg);
end;

function  GetLangE(id: Integer; arg: String; i: Integer): String;
begin
  Result:=GetLangE(id,arg,IntToStr(i));
end;

function  GetLangE(id: Integer; arg1,arg2: String; i:Integer): String;
begin
  Result:=GetLangE(id,arg1,arg2,IntToStr(i));
end;

// other functions

function UnEscape(str: String): String;
begin
 ReplaceString(str,'\t',#9);
 ReplaceString(str,'\n',#10);
 Result:=str;
end;

procedure GetIni(ini: TIniFile; num: Integer; section, variable: String);
var
 str: String;
begin
 try
  if language_t=nil then exit;
  str:=ini.ReadString(section,variable,language_t.Strings[num]);
  language_t.Strings[num]:=str;
  language_i.Strings[num]:=str;
  language_e.Strings[num]:=str;
  except
 end;
end;

procedure SetConstant(num: Integer; str: String);
begin
 try
  if language_t=nil then exit;
  language_t.Strings[num]:=str;
  language_i.Strings[num]:=str;
  language_e.Strings[num]:=str;
  except
 end;
end;

procedure LoadLanguage(name: String='');
var
 ini: TIniFile;
begin
 if name='' then name:='english';
 try // log and console messages
  ini:=TIniFile.Create(ApplicationDir+name+'.lng');
  GetIni(ini,LNG_LOG_STARTING             ,'Log','SERVER_INIT');
  GetIni(ini,LNG_SERVER_LISTEN            ,'Log','SERVER_LISTEN');
  GetIni(ini,LNG_SERVER_LISTENERR         ,'Log','SERVER_LISTENERR');
  GetIni(ini,LNG_USERONLINE               ,'Log','USERONLINE');
  GetIni(ini,LNG_USEROFFLINE              ,'Log','USEROFFLINE');
  GetIni(ini,LNG_USEROFFLINE2             ,'Log','USEROFFLINE2');
  GetIni(ini,LNG_USERREGISTER             ,'Log','USERREGISTER');
  GetIni(ini,LNG_SERVER_LISTENSTATS       ,'Log','SERVER_LISTENSTATS');
  GetIni(ini,LNG_DISCONNECT_INVCMD        ,'Log','DISCONNECT_INVCMD');
  GetIni(ini,LNG_DISCONNECT_SOCKETERR     ,'Log','DISCONNECT_SOCKETERR');
  GetIni(ini,LNG_DISCONNECT_SENDTIMEOUT   ,'Log','DISCONNECT_SENDTIMEOUT');
  GetIni(ini,LNG_DISCONNECT_WINMX         ,'Log','DISCONNECT_WINMX');
  GetIni(ini,LNG_REASON_WIMXBAN           ,'Log','REASON_WIMXBAN');
  GetIni(ini,LNG_KILLED                   ,'Log','KILLED');
  GetIni(ini,LNG_NUKED                    ,'Log','NUKED');
  GetIni(ini,LNG_SEARCHLOG3               ,'Log','SEARCHLOG3');
  GetIni(ini,LNG_SEARCHLOG4               ,'Log','SEARCHLOG4');
  GetIni(ini,LNG_TRANSFERLOG3             ,'Log','TRANSFERLOG3');
  GetIni(ini,LNG_TRANSFERLOG4             ,'Log','TRANSFERLOG4');
  GetIni(ini,LNG_TRANSFERLOG5             ,'Log','TRANSFERLOG5');
  GetIni(ini,LNG_SAVINGDATA               ,'Log','SAVINGDATA');
  GetIni(ini,LNG_SERVERGHOST              ,'Log','SERVERGHOST');
  GetIni(ini,LNG_MINSHARE2                ,'Log','MINSHARE2');
  GetIni(ini,LNG_MINSHARE4                ,'Log','MINSHARE4');
  GetIni(ini,LNG_MINSHARE_REASON          ,'Log','MINSHARE_REASON');
  GetIni(ini,LNG_MINSHARE_REASON2         ,'Log','MINSHARE_REASON2');
  GetIni(ini,LNG_CONSOLEPONG              ,'Log','CONSOLEPONG');
  GetIni(ini,LNG_CHAT                     ,'Chat','CAPTION');
  GetIni(ini,LNG_CMNU_CLOSE               ,'Chat','MNU_CLOSE');
  GetIni(ini,LNG_CMNU_HOTLIST             ,'Chat','MNU_HOTLIST');
  GetIni(ini,LNG_CMNU_FRIEND              ,'Chat','MNU_FRIEND');
  GetIni(ini,LNG_CMNU_WHOIS               ,'Chat','MNU_WHOIS');
  GetIni(ini,LNG_CMNU_IGNORE              ,'Chat','MNU_IGNORE');
  GetIni(ini,LNG_TB_BTN_LOG               ,'Toolbar','BTN_LOG');
  GetIni(ini,LNG_TB_BTN_USERS             ,'Toolbar','BTN_USERS');
  GetIni(ini,LNG_TB_BTN_SERVERS           ,'Toolbar','BTN_SERVERS');
  GetIni(ini,LNG_TB_BTN_CHANNELS          ,'Toolbar','BTN_CHANNELS');
  GetIni(ini,LNG_TB_BTN_FRIENDS           ,'Toolbar','BTN_FRIENDS');
  GetIni(ini,LNG_TB_BTN_BANS              ,'Toolbar','BTN_BANS');
  GetIni(ini,LNG_TB_BTN_HOTLIST           ,'Toolbar','BTN_HOTLIST');
  GetIni(ini,LNG_TB_BTN_IGNORE            ,'Toolbar','BTN_IGNORE');
  GetIni(ini,LNG_TB_BTN_BLOCKS            ,'Toolbar','BTN_BLOCKS');
  GetIni(ini,LNG_TB_BTN_CONSOLEONLINE     ,'Toolbar','BTN_CONSOLEONLINE');
  GetIni(ini,LNG_TB_BTN_REGISTERED        ,'Toolbar','BTN_REGISTERED');
  GetIni(ini,LNG_TB_BTN_LOG_HINT          ,'Toolbar','BTN_LOG_HINT');
  GetIni(ini,LNG_TB_BTN_USERS_HINT        ,'Toolbar','BTN_USERS_HINT');
  GetIni(ini,LNG_TB_BTN_REGISTERED_HINT   ,'Toolbar','BTN_REGISTERED_HINT');
  GetIni(ini,LNG_TB_BTN_SERVERS_HINT      ,'Toolbar','BTN_SERVERS_HINT');
  GetIni(ini,LNG_TB_BTN_CHANNELS_HINT     ,'Toolbar','BTN_CHANNELS_HINT');
  GetIni(ini,LNG_TB_BTN_FRIENDS_HINT      ,'Toolbar','BTN_FRIENDS_HINT');
  GetIni(ini,LNG_TB_BTN_BANS_HINT         ,'Toolbar','BTN_BANS_HINT');
  GetIni(ini,LNG_TB_BTN_HOTLIST_HINT      ,'Toolbar','BTN_HOTLIST_HINT');
  GetIni(ini,LNG_TB_BTN_IGNORE_HINT       ,'Toolbar','BTN_IGNORE_HINT');
  GetIni(ini,LNG_TB_BTN_BLOCKS_HINT       ,'Toolbar','BTN_BLOCKS_HINT');
  GetIni(ini,LNG_TB_BTN_CONSOLEONLINE_HINT,'Toolbar','BTN_CONSOLEONLINE_HINT');
  GetIni(ini,LNG_TB_TOOLBAR_TOTAL         ,'Toolbar','TOOLBAR_TOTAL');
  GetIni(ini,LNG_MENU_SERVER              ,'Menu','MENU_SERVER');
  GetIni(ini,LNG_MENU_SETTINGS            ,'Menu','MENU_SETTINGS');
  GetIni(ini,LNG_MENU_LANGUAGES           ,'Menu','MENU_LANGUAGES');
  GetIni(ini,LNG_MENU_SAVE                ,'Menu','MENU_SAVE');
  GetIni(ini,LNG_MENU_RESTART             ,'Menu','MENU_RESTART');
  GetIni(ini,LNG_MENU_EXIT                ,'Menu','MENU_EXIT');
  GetIni(ini,LNG_MENU_LOG                 ,'Menu','MENU_LOG');
  GetIni(ini,LNG_MENU_CLEAR               ,'Menu','MENU_CLEAR');
  GetIni(ini,LNG_MENU_COPY                ,'Menu','MENU_COPY');
  GetIni(ini,LNG_MENU_LOGIN               ,'Menu','MENU_LOGIN');
  GetIni(ini,LNG_MENU_NAPIGATOR           ,'Menu','MENU_NAPIGATOR');
  GetIni(ini,LNG_MENU_DAGSTA              ,'Menu','MENU_DAGSTA');
  GetIni(ini,LNG_MENU_SEARCH              ,'Menu','MENU_SEARCH');
  GetIni(ini,LNG_MENU_TRANSFER            ,'Menu','MENU_TRANSFER');
  GetIni(ini,LNG_MENU_RESET               ,'Menu','MENU_RESET');
  GetIni(ini,LNG_MENU_WINDOW              ,'Menu','MENU_WINDOW');
  GetIni(ini,LNG_MENU_BLOCK               ,'Menu','MENU_BLOCK');
  GetIni(ini,LNG_MENU_REGISTERED          ,'Menu','MENU_REGISTERED');
  GetIni(ini,LNG_MENU_LOGWIN              ,'Menu','MENU_LOGWIN');
  GetIni(ini,LNG_MENU_USERS               ,'Menu','MENU_USERS');
  GetIni(ini,LNG_MENU_SERVERS             ,'Menu','MENU_SERVERS');
  GetIni(ini,LNG_MENU_CHANNELS            ,'Menu','MENU_CHANNELS');
  GetIni(ini,LNG_MENU_FRIENDS             ,'Menu','MENU_FRIENDS');
  GetIni(ini,LNG_MENU_BANS                ,'Menu','MENU_BANS');
  GetIni(ini,LNG_MENU_HOTLIST             ,'Menu','MENU_HOTLIST');
  GetIni(ini,LNG_MENU_IGNORE              ,'Menu','MENU_IGNORE');
  GetIni(ini,LNG_MENU_HELP                ,'Menu','MENU_HELP');
  GetIni(ini,LNG_MENU_FAQ                 ,'Menu','MENU_FAQ');
  GetIni(ini,LNG_MENU_MANUAL              ,'Menu','MENU_MANUAL');
  GetIni(ini,LNG_MENU_FORUMS              ,'Menu','MENU_FORUMS');
  GetIni(ini,LNG_MENU_UPDATE              ,'Menu','MENU_UPDATE');
  GetIni(ini,LNG_MENU_ABOUT               ,'Menu','MENU_ABOUT');
  GetIni(ini,LNG_MENU_SHOW                ,'Menu','MENU_SHOW');
  GetIni(ini,LNG_MENU_HIDE                ,'Menu','MENU_HIDE');
  GetIni(ini,LNG_MENU_WEB                 ,'Menu','MENU_WEB');
  GetIni(ini,LNG_USERS_LABEL              ,'Users','LABEL');
  GetIni(ini,LNG_LIST_MUZZLED             ,'Users','LIST_MUZZLED');
  GetIni(ini,LNG_LIST_CONSOLE             ,'Users','LIST_CONSOLE');
  GetIni(ini,LNG_LIST_CLOAKED             ,'Users','LIST_CLOAKED');
  GetIni(ini,LNG_LIST_CHATTING            ,'Users','LIST_CHATTING');
  GetIni(ini,LNG_LIST_HEADER_NAME         ,'Users','LIST_HEADER_NAME');
  GetIni(ini,LNG_LIST_HEADER_LEVEL        ,'Users','LIST_HEADER_LEVEL');
  GetIni(ini,LNG_LIST_HEADER_SHARED       ,'Users','LIST_HEADER_SHARED');
  GetIni(ini,LNG_LIST_HEADER_SOFTWARE     ,'Users','LIST_HEADER_SOFTWARE');
  GetIni(ini,LNG_LIST_HEADER_SPEED        ,'Users','LIST_HEADER_SPEED');
  GetIni(ini,LNG_LIST_HEADER_IP           ,'Users','LIST_HEADER_IP');
  GetIni(ini,LNG_LIST_HEADER_PORT         ,'Users','LIST_HEADER_PORT');
  GetIni(ini,LNG_LIST_HEADER_SERVER       ,'Users','LIST_HEADER_SERVER');
  GetIni(ini,LNG_LIST_HEADER_TIME         ,'Users','LIST_HEADER_TIME');
  GetIni(ini,LNG_LIST_HEADER_TRANSFERS    ,'Users','LIST_HEADER_TRANSFERS');
  GetIni(ini,LNG_LIST_HEADER_TOTAL        ,'Users','LIST_HEADER_TOTAL');
  GetIni(ini,LNG_LIST_BTN_MODE            ,'Users','LIST_BTN_MODE');
  GetIni(ini,LNG_LIST_BTN_MODS            ,'Users','LIST_BTN_MODS');
  GetIni(ini,LNG_LIST_BTN_USERS           ,'Users','LIST_BTN_USERS');
  GetIni(ini,LNG_LIST_BTN_LEECH           ,'Users','LIST_BTN_LEECH');
  GetIni(ini,LNG_LIST_BTN_MUZZLED         ,'Users','LIST_BTN_MUZZLED');
  GetIni(ini,LNG_LIST_BTN_LOCAL           ,'Users','LIST_BTN_LOCAL');
  GetIni(ini,LNG_LIST_BTN_REMOTE          ,'Users','LIST_BTN_REMOTE');
  GetIni(ini,LNG_LIST_BTN_KICK            ,'Users','LIST_BTN_KICK');
  GetIni(ini,LNG_LIST_BTN_NUKE            ,'Users','LIST_BTN_NUKE');
  GetIni(ini,LNG_LIST_BTN_MUZZLE          ,'Users','LIST_BTN_MUZZLE');
  GetIni(ini,LNG_LIST_BTN_REFRESH         ,'Users','LIST_BTN_REFRESH');
  GetIni(ini,LNG_LIST_BTN_BAN             ,'Users','LIST_BTN_BAN');
  GetIni(ini,LNG_LIST_BTN_BANIP           ,'Users','LIST_BTN_BANIP');
  GetIni(ini,LNG_LIST_BTN_KICKBAN         ,'Users','LIST_BTN_KICKBAN');
  GetIni(ini,LNG_LIST_BTN_KICKBANIP       ,'Users','LIST_BTN_KICKBANIP');
  GetIni(ini,LNG_LIST_BTN_REGISTER        ,'Users','LIST_BTN_REGISTER');
  GetIni(ini,LNG_LIST_DEFREASON           ,'Users','LIST_DEFREASON');
  GetIni(ini,LNG_LIST_REASONHINT          ,'Users','LIST_REASONHINT');
  GetIni(ini,LNG_LIST_MENU_REFRESH        ,'Users','LIST_MENU_REFRESH');
  GetIni(ini,LNG_LIST_MENU_KILL           ,'Users','LIST_MENU_KILL');
  GetIni(ini,LNG_LIST_MENU_NUKE           ,'Users','LIST_MENU_NUKE');
  GetIni(ini,LNG_LIST_MENU_MUZZLE         ,'Users','LIST_MENU_MUZZLE');
  GetIni(ini,LNG_LIST_MENU_BAN            ,'Users','LIST_MENU_BAN');
  GetIni(ini,LNG_LIST_MENU_BANIP          ,'Users','LIST_MENU_BANIP');
  GetIni(ini,LNG_LIST_MENU_KICKBAN        ,'Users','LIST_MENU_KICKBAN');
  GetIni(ini,LNG_LIST_MENU_KICKBANIP      ,'Users','LIST_MENU_KICKBANIP');
  GetIni(ini,LNG_LIST_MENU_REGISTER       ,'Users','LIST_MENU_REGISTER');
  GetIni(ini,LNG_LIST_MENU_LEVEL          ,'Users','LIST_MENU_LEVEL');
  GetIni(ini,LNG_LIST_MENU_SPEED          ,'Users','LIST_MENU_SPEED');
  GetIni(ini,LNG_LIST_MENU_IM             ,'Users','LIST_MENU_IM');
  GetIni(ini,LNG_LIST_MENU_SELALL         ,'Users','LIST_MENU_SELALL');
  GetIni(ini,LNG_LIST_MENU_SELNONE        ,'Users','LIST_MENU_SELNONE');
  GetIni(ini,LNG_LIST_MENU_COPYNAME       ,'Users','LIST_MENU_COPYNAME');
  GetIni(ini,LNG_LIST_MENU_WHOIS          ,'Users','LIST_MENU_WHOIS');
  GetIni(ini,LNG_LIST_MENU_FRIEND         ,'Users','LIST_MENU_FRIEND');
  GetIni(ini,LNG_LIST_MENU_HOTLIST        ,'Users','LIST_MENU_HOTLIST');
  GetIni(ini,LNG_LIST_MENU_IGNORE         ,'Users','LIST_MENU_IGNORE');
  GetIni(ini,LNG_LIST_MNU2_LEVEL          ,'Users','LIST_MNU2_LEVEL');
  GetIni(ini,LNG_LIST_MNU2_SHARED         ,'Users','LIST_MNU2_SHARED');
  GetIni(ini,LNG_LIST_MNU2_SOFT           ,'Users','LIST_MNU2_SOFT');
  GetIni(ini,LNG_LIST_MNU2_SPEED          ,'Users','LIST_MNU2_SPEED');
  GetIni(ini,LNG_LIST_MNU2_IP             ,'Users','LIST_MNU2_IP');
  GetIni(ini,LNG_LIST_MNU2_PORT           ,'Users','LIST_MNU2_PORT');
  GetIni(ini,LNG_LIST_MNU2_TIME           ,'Users','LIST_MNU2_TIME');
  GetIni(ini,LNG_LIST_MNU2_TRANSFERS      ,'Users','LIST_MNU2_TRANSFERS');
  GetIni(ini,LNG_LIST_MNU2_TOTAL          ,'Users','LIST_MNU2_TOTAL');
  GetIni(ini,LNG_LIST_MNU2_SERVER         ,'Users','LIST_MNU2_SERVER');
  GetIni(ini,LNG_LIST_HINT_BAN            ,'Users','LIST_HINT_BAN');
  GetIni(ini,LNG_LIST_EDIT_FILTER_HINT    ,'Users','LIST_EDIT_FILTER_HINT');
  GetIni(ini,LNG_OK                       ,'Interface','OK');
  GetIni(ini,LNG_CANCEL                   ,'Interface','CANCEL');
  GetIni(ini,LNG_LOG_LABEL                ,'LogWin','LABEL');
  GetIni(ini,LNG_LOG_CLEAR                ,'LogWin','CLEAR');
  GetIni(ini,LNG_LOG_MODE                 ,'LogWin','MODE');
  GetIni(ini,LNG_LOG_PAUSE                ,'LogWin','PAUSE');
  GetIni(ini,LNG_LOG_RESUME               ,'LogWin','RESUME');
  GetIni(ini,LNG_LOG_CB_AWAY              ,'LogWin','CB_AWAY');
  GetIni(ini,LNG_LOG_LBL_AWAY             ,'LogWin','LBL_AWAY');
  GetIni(ini,LNG_LOG_CB_AWAYPOPUP         ,'LogWin','CB_AWAYPOPUP');
  GetIni(ini,LNG_LOG_CB_SOUND             ,'LogWin','CB_SOUND');
  GetIni(ini,LNG_MODE_ERROR               ,'UserMode','ERROR');
  GetIni(ini,LNG_MODE_ANNOUNCE            ,'UserMode','ANNOUNCE');
  GetIni(ini,LNG_MODE_BAN                 ,'UserMode','BAN');
  GetIni(ini,LNG_MODE_CHANGE              ,'UserMode','CHANGE');
  GetIni(ini,LNG_MODE_KILL                ,'UserMode','KILL');
  GetIni(ini,LNG_MODE_LEVEL               ,'UserMode','LEVEL');
  GetIni(ini,LNG_MODE_SERVER              ,'UserMode','SERVER');
  GetIni(ini,LNG_MODE_MUZZLE              ,'UserMode','MUZZLE');
  GetIni(ini,LNG_MODE_PORT                ,'UserMode','PORT');
  GetIni(ini,LNG_MODE_WALLOP              ,'UserMode','WALLOP');
  GetIni(ini,LNG_MODE_CLOAK               ,'UserMode','CLOAK');
  GetIni(ini,LNG_MODE_FLOOD               ,'UserMode','FLOOD');
  GetIni(ini,LNG_MODE_MSG                 ,'UserMode','MSG');
  GetIni(ini,LNG_MODE_WHOIS               ,'UserMode','WHOIS');
  GetIni(ini,LNG_MODE_BROWSE              ,'UserMode','BROWSE');
  GetIni(ini,LNG_MODE_FRIEND              ,'UserMode','FRIEND');
  GetIni(ini,LNG_MODE_CHANNEL             ,'UserMode','CHANNEL');
  GetIni(ini,LNG_MODE_REGISTER            ,'UserMode','REGISTER');
  GetIni(ini,LNG_MODE_VAR                 ,'UserMode','VAR');
  GetIni(ini,LNG_MODE_PING                ,'UserMode','PING');
  GetIni(ini,LNG_MODE_OK                  ,'UserMode','OK');
  GetIni(ini,LNG_MODE_ALL                 ,'UserMode','ALL');
  GetIni(ini,LNG_MODE_NONE                ,'UserMode','NONE');
  GetIni(ini,LNG_MODE_CANCEL              ,'UserMode','CANCEL');
  GetIni(ini,LNG_MODE_CAPTION             ,'UserMode','CAPTION');
  GetIni(ini,LNG_ST_BYTES                 ,'Status','ST_BYTES');
  GetIni(ini,LNG_ST_TIME                  ,'Status','ST_TIME');
  GetIni(ini,LNG_ST_LOCAL                 ,'Status','ST_LOCAL');
  GetIni(ini,LNG_ST_LOCALMAX              ,'Status','ST_LOCALMAX');
  GetIni(ini,LNG_ST_TOTAL                 ,'Status','ST_TOTAL');
  GetIni(ini,LNG_ST_TOTALMAX              ,'Status','ST_TOTALMAX');
  GetIni(ini,LNG_ST_LASTTRANSFER          ,'Status','ST_LASTTRANSFER');
  Getini(ini,LNG_ST_LASTDATA              ,'Status','ST_LASTDATA');
  GetIni(ini,LNG_ST_TOTALTRANSFER         ,'Status','ST_TOTALTRANSFER');
  GetIni(ini,LNG_ST_TOTALDATA             ,'Status','ST_TOTALDATA');
  GetIni(ini,LNG_ST_NOLINK                ,'Status','ST_NOLINK');
  GetIni(ini,LNG_ST_LINK                  ,'Status','ST_LINK');
  GetIni(ini,LNG_ST_BPS                   ,'Status','ST_BPS');
  GetIni(ini,LNG_ST_BANDWIDTHLIMIT        ,'Status','ST_BANDWIDTHLIMIT');
  GetIni(ini,LNG_REG_TRANSFERS            ,'Registered','TRANSFERS');
  GetIni(ini,LNG_REG_MUZZLED              ,'Registered','MUZZLED');
  GetIni(ini,LNG_REG_USER                 ,'Registered','REG_USER');
  GetIni(ini,LNG_REG_LEVEL                ,'Registered','REG_LEVEL');
  GetIni(ini,LNG_REG_TRANSFERS2           ,'Registered','REG_TRANSFERS');
  GetIni(ini,LNG_REG_IP                   ,'Registered','REG_IP');
  GetIni(ini,LNG_REG_TIME                 ,'Registered','REG_TIME');
  GetIni(ini,LNG_REG_LABEL                ,'Registered','LABEL');
  GetIni(ini,LNG_REG_BTN_MODS             ,'Registered','REG_BTN_MODS');
  GetIni(ini,LNG_REG_BTN_USERS            ,'Registered','REG_BTN_USERS');
  GetIni(ini,LNG_REG_BTN_LEECH            ,'Registered','REG_BTN_LEECH');
  GetIni(ini,LNG_REG_BTN_MUZZLED          ,'Registered','REG_BTN_MUZZLED');
  GetIni(ini,LNG_REG_BTN_REFRESH          ,'Registered','REG_BTN_REFRESH');
  GetIni(ini,LNG_REG_DEFREASON            ,'Registered','REG_DEFREASON');
  GetIni(ini,LNG_REG_REASONHINT           ,'Registered','REG_REASONHINT');
  Getini(ini,LNG_REG_BTN_NUKE             ,'Registered','REG_BTN_NUKE');
  GetIni(ini,LNG_REG_BTN_BAN              ,'Registered','REG_BTN_BAN');
  GetIni(ini,LNG_REG_BTN_BANIP            ,'Registered','REG_BTN_BANIP');
  GetIni(ini,LNG_REG_MENU_REFRESH         ,'Registered','REG_MENU_REFRESH');
  GetIni(ini,LNG_REG_MENU_NUKE            ,'Registered','REG_MENU_NUKE');
  GetIni(ini,LNG_REG_MENU_BAN             ,'Registered','REG_MENU_BAN');
  GetIni(ini,LNG_REG_MENU_BANIP           ,'Registered','REG_MENU_BANIP');
  GetIni(ini,LNG_REG_MENU_LEVEL           ,'Registered','REG_MENU_LEVEL');
  GetIni(ini,LNG_REG_MENU_SELALL          ,'Registered','REG_MENU_SELALL');
  GetIni(ini,LNG_REG_MENU_SELNONE         ,'Registered','REG_MENU_SELNONE');
  GetIni(ini,LNG_REG_MENU_COPYNAME        ,'Registered','REG_MENU_COPYNAME');
  GetIni(ini,LNG_REG_HINT_USER            ,'Registered','REG_HINT_USER');
  GetIni(ini,LNG_REG_HINT_PASSWORD        ,'Registered','REG_HINT_PASSWORD');
  GetIni(ini,LNG_REG_HINT_LEVEL           ,'Registered','REG_HINT_LEVEL');
  GetIni(ini,LNG_REG_BTN_REGISTER         ,'Registered','REG_BTN_REGISTER');
  GetIni(ini,LNG_REG_HINT_BAN             ,'Registered','REG_HINT_BAN');
  GetIni(ini,LNG_REG_EDIT_FILTER_HINT     ,'Registered','REG_EDIT_FILTER_HINT');
  GetIni(ini,LNG_REG_CLOAKED              ,'Registered','CLOAKED');
  GetIni(ini,LNG_CH_LABEL                 ,'Channels','LABEL');
  GetIni(ini,LNG_CLIST_NAME               ,'Channels','CLIST_NAME');
  GetIni(ini,LNG_CLIST_USERS              ,'Channels','CLIST_USERS');
  GetIni(ini,LNG_CLIST_MAXUSERS           ,'Channels','CLIST_MAXUSERS');
  GetIni(ini,LNG_CLIST_LEVEL              ,'Channels','CLIST_LEVEL');
  GetIni(ini,LNG_CLIST_STATUS             ,'Channels','CLIST_STATUS');
  GetIni(ini,LNG_CLIST_TOPIC              ,'Channels','CLIST_TOPIC');
  GetIni(ini,LNG_CLIST_BANS               ,'Channels','CLIST_BANS');
  GetIni(ini,LNG_CLIST_OPS                ,'Channels','CLIST_OPS');
  GetIni(ini,LNG_CLIST_VOICES             ,'Channels','CLIST_VOICES');
  GetIni(ini,LNG_CBTN_REFRESH             ,'Channels','CBTN_REFRESH');
  GetIni(ini,LNG_CBTN_JOIN                ,'Channels','CBTN_JOIN');
  GetIni(ini,LNG_CBTN_PROPS               ,'Channels','CBTN_PROPS');
  GetIni(ini,LNG_CBTN_ADD                 ,'Channels','CBTN_ADD');
  GetIni(ini,LNG_CBTN_DELETE              ,'Channels','CBTN_DELETE');
  GetIni(ini,LNG_CH_REASONHINT            ,'Channels','CH_REASONHINT');
  GetIni(ini,LNG_CH_REGISTERED            ,'Channels','CH_REGISTERED');
  GetIni(ini,LNG_CH_MODERATED             ,'Channels','CH_MODERATED');
  GetIni(ini,LNG_CH_PRIVATE               ,'Channels','CH_PRIVATE');
  GetIni(ini,LNG_CH_TOPIC                 ,'Channels','CH_TOPIC');
  GetIni(ini,LNG_CMENU_REFRESH            ,'Channels','CMENU_REFRESH');
  GetIni(ini,LNG_CMENU_JOIN               ,'Channels','CMENU_JOIN');
  GetIni(ini,LNG_CMENU_DELETE             ,'Channels','CMENU_DELETE');
  GetIni(ini,LNG_CMENU_CLEAR              ,'Channels','CMENU_CLEAR');
  GetIni(ini,LNG_CMENU_ADD                ,'Channels','CMENU_ADD');
  GetIni(ini,LNG_CMENU_PROPS              ,'Channels','CMENU_PROPS');
  GetIni(ini,LNG_CMENU_TOPIC              ,'Channels','CMENU_TOPIC');
  GetIni(ini,LNG_CMENU_SELECTALL          ,'Channels','CMENU_SELECTALL');
  GetIni(ini,LNG_CMENU_SELECTNONE         ,'Channels','CMENU_SELECTNONE');
  GetIni(ini,LNG_CMENU_COPYNAME           ,'Channels','CMENU_COPYNAME');
  GetIni(ini,LNG_CMENU_CLEARBANS          ,'Channels','CMENU_CLEARBANS');
  GetIni(ini,LNG_CH_CHTOPIC               ,'Channels','CHTOPIC');
  GetIni(ini,LNG_CH_JOIN                  ,'Channels','CHJOIN');
  GetIni(ini,LNG_CH_PART                  ,'Channels','CHPART');
  GetIni(ini,LNG_CH_USERLIST              ,'Channels','CHUSERLIST');
  GetIni(ini,LNG_CHMNU_IM                 ,'Channels','CHMNU_IM');
  GetIni(ini,LNG_CHMNU_WHOIS              ,'Channels','CHMNU_WHOIS');
  GetIni(ini,LNG_CHMNU_OP                 ,'Channels','CHMNU_OP');
  GetIni(ini,LNG_CHMNU_DEOP               ,'Channels','CHMNU_DEOP');
  GetIni(ini,LNG_CHMNU_VOICE              ,'Channels','CHMNU_VOICE');
  GetIni(ini,LNG_CHMNU_UNVOICE            ,'Channels','CHMNU_UNVOICE');
  GetIni(ini,LNG_CHMNU_BAN                ,'Channels','CHMNU_BAN');
  GetIni(ini,LNG_CHMNU_BANIP              ,'Channels','CHMNU_BANIP');
  GetIni(ini,LNG_CHMNU_KICK               ,'Channels','CHMNU_KICK');
  GetIni(ini,LNG_CHMNU_COPYNAME           ,'Channels','CHMNU_COPYNAME');
  GetIni(ini,LNG_NAPIGATOR_ERROR          ,'Napigator','ERROR');
  GetIni(ini,LNG_NAPIGATOR_REPLY          ,'Napigator','REPLY');
  GetIni(ini,LNG_NAPIGATOR_SEND           ,'Napigator','SEND');
  GetIni(ini,LNG_NAPIGATOR_DISCONNECT     ,'Napigator','DISCONNECT');
  GetIni(ini,LNG_NAPIGATOR_CONNECTED      ,'Napigator','CONNECTED');
  GetIni(ini,LNG_NAPIGATOR_CONNECTING     ,'Napigator','CONNECTING');
  GetIni(ini,LNG_NAPIGATOR_NOCONNECT      ,'Napigator','NOCONNECT');
  GetIni(ini,LNG_NAPIGATOR_NOWELCOME      ,'Napigator','NOWELCOME');
  GetIni(ini,LNG_NAPIGATOR_NORESOLVE      ,'Napigator','NORESOLVE');
  Getini(ini,LNG_NAPIGATOR_RESOLVED       ,'Napigator','RESOLVED');
  GetIni(ini,LNG_NAPIGATOR_AUTODISCONNECT ,'Napigator','AUTODISCONNECT');
  GetIni(ini,LNG_DAGSTA_ERROR             ,'Dagsta','ERROR');
  GetIni(ini,LNG_DAGSTA_REPLY             ,'Dagsta','REPLY');
  GetIni(ini,LNG_DAGSTA_SEND              ,'Dagsta','SEND');
  GetIni(ini,LNG_DAGSTA_DISCONNECT        ,'Dagsta','DISCONNECT');
  GetIni(ini,LNG_DAGSTA_CONNECTED         ,'Dagsta','CONNECTED');
  GetIni(ini,LNG_DAGSTA_CONNECTING        ,'Dagsta','CONNECTING');
  GetIni(ini,LNG_DAGSTA_NOCONNECT         ,'Dagsta','NOCONNECT');
  GetIni(ini,LNG_DAGSTA_NOWELCOME         ,'Dagsta','NOWELCOME');
  GetIni(ini,LNG_DAGSTA_NORESOLVE         ,'Dagsta','NORESOLVE');
  Getini(ini,LNG_DAGSTA_RESOLVED          ,'Dagsta','RESOLVED');
  GetIni(ini,LNG_DAGSTA_AUTODISCONNECT    ,'Dagsta','AUTODISCONNECT');
  GetIni(ini,LNG_EDIT_NAPIGATOR           ,'Edit','NAPIGATOR');
  GetIni(ini,LNG_EDIT_DAGSTA              ,'Edit','DAGSTA');
  GetIni(ini,LNG_EDIT_ADDCHANNEL          ,'Edit','ADDCHANNEL');
  GetIni(ini,LNG_EDITCH_CAPTION           ,'EditCh','EDITCH_CAPTION');
  GetIni(ini,LNG_EDITCH_TOPIC             ,'EditCh','EDITCH_TOPIC');
  GetIni(ini,LNG_EDITCH_LIMIT             ,'EditCh','EDITCH_LIMIT');
  GetIni(ini,LNG_EDITCH_LEVEL             ,'EditCh','EDITCH_LEVEL');
  GetIni(ini,LNG_EDITCH_MOTD              ,'EditCh','EDITCH_MOTD');
  GetIni(ini,LNG_EDITCH_OK                ,'EditCh','EDITCH_OK');
  GetIni(ini,LNG_EDITCH_CANCEL            ,'EditCh','EDITCH_CANCEL');
  GetIni(ini,LNG_EDITCH_ATTR              ,'EditCh','EDITCH_ATTR');
  GetIni(ini,LNG_EDITCH_REGISTERED        ,'EditCh','EDITCH_REGISTERED');
  Getini(ini,LNG_EDITCH_PRIVATE           ,'EditCh','EDITCH_PRIVATE');
  GetIni(ini,LNG_EDITCH_MODERATED         ,'EditCh','EDITCH_MODERATED');
  GetIni(ini,LNG_EDITCH_TOPICATTR         ,'EditCh','EDITCH_TOPICATTR');
  GetIni(ini,LNG_BANS_NEVER_EXPIRE        ,'Bans','BANS_NEVER_EXPIRE');
  GetIni(ini,LNG_BANS_LABEL               ,'Bans','LABEL');
  GetIni(ini,LNG_BBTN_REFRESH             ,'Bans','BBTN_REFRESH');
  GetIni(ini,LNG_BBTN_BAN                 ,'Bans','BBTN_BAN');
  GetIni(ini,LNG_BLIST_NAME               ,'Bans','BLIST_NAME');
  GetIni(ini,LNG_BLIST_IP                 ,'Bans','BLIST_IP');
  GetIni(ini,LNG_BLIST_ADMIN              ,'Bans','BLIST_ADMIN');
  GetIni(ini,LNG_BLIST_TIMESET            ,'Bans','BLIST_TIMESET');
  GetIni(ini,LNG_BLIST_EXPIRES            ,'Bans','BLIST_EXPIRES');
  GetIni(ini,LNG_BLIST_REASON             ,'Bans','BLIST_REASON');
  GetIni(ini,LNG_BANS_BANHINT             ,'Bans','BANS_BANHINT');
  GetIni(ini,LNG_BBTN_UNBAN               ,'Bans','BBTN_UNBAN');
  GetIni(ini,LNG_BANS_REASONHINT          ,'Bans','BANS_REASONHINT');
  GetIni(ini,LNG_BANS_TIME60              ,'Bans','BANS_TIME60');
  GetIni(ini,LNG_BANS_TIME300             ,'Bans','BANS_TIME300');
  GetIni(ini,LNG_BANS_TIME600             ,'Bans','BANS_TIME600');
  GetIni(ini,LNG_BANS_TIME1800            ,'Bans','BANS_TIME1800');
  GetIni(ini,LNG_BANS_TIME3600            ,'Bans','BANS_TIME3600');
  GetIni(ini,LNG_BANS_TIME10800           ,'Bans','BANS_TIME10800');
  GetIni(ini,LNG_BANS_TIME43200           ,'Bans','BANS_TIME43200');
  GetIni(ini,LNG_BANS_TIME86400           ,'Bans','BANS_TIME86400');
  GetIni(ini,LNG_BANS_TIME259200          ,'Bans','BANS_TIME259200');
  GetIni(ini,LNG_BANS_TIME604800          ,'Bans','BANS_TIME604800');
  GetIni(ini,LNG_BANS_TIME1209600         ,'Bans','BANS_TIME1209600');
  GetIni(ini,LNG_BANS_TIME2678400         ,'Bans','BANS_TIME2678400');
  GetIni(ini,LNG_BANS_TIME5184000         ,'Bans','BANS_TIME5184000');
  GetIni(ini,LNG_BANS_TIME7776000         ,'Bans','BANS_TIME7776000');
  GetIni(ini,LNG_BANS_TIME31536000        ,'Bans','BANS_TIME31536000');
  GetIni(ini,LNG_BMENU_REFRESH            ,'Bans','BMENU_REFRESH');
  GetIni(ini,LNG_BMENU_UNBAN              ,'Bans','BMENU_UNBAN');
  GetIni(ini,LNG_BMENU_COPYUSER           ,'Bans','BMENU_COPYUSER');
  GetIni(ini,LNG_BMENU_COPYIP             ,'Bans','BMENU_COPYIP');
  GetIni(ini,LNG_BMENU_COPYBAN            ,'Bans','BMENU_COPYBAN');
  GetIni(ini,LNG_BMENU_COPYADMIN          ,'Bans','BMENU_COPYADMIN');
  GetIni(ini,LNG_BMENU_COPYREASON         ,'Bans','BMENU_COPYREASON');
  GetIni(ini,LNG_BMENU_SELALL             ,'Bans','BMENU_SELALL');
  GetIni(ini,LNG_BMENU_SELNONE            ,'Bans','BMENU_SELNONE');
  GetIni(ini,LNG_SERVERS_LABEL            ,'Servers','LABEL');
  GetIni(ini,LNG_SLIST_HOST               ,'Servers','SLIST_HOST');
  GetIni(ini,LNG_SLIST_PORT               ,'Servers','SLIST_PORT');
  GetIni(ini,LNG_SLIST_STATUS             ,'Servers','SLIST_STATUS');
  GetIni(ini,LNG_SLIST_AUTH               ,'Servers','SLIST_AUTH');
  GetIni(ini,LNG_SLIST_RELINK             ,'Servers','SLIST_RELINK');
  GetIni(ini,LNG_SLIST_COMMENTS           ,'Servers','SLIST_COMMENTS');
  GetIni(ini,LNG_SLIST_USERS              ,'Servers','SLIST_USERS');
  GetIni(ini,LNG_SLIST_LAG                ,'Servers','SLIST_LAG');
  GetIni(ini,LNG_SLIST_LAGSEC             ,'Servers','SLIST_LAGSEC');
  GetIni(ini,LNG_SRV_DISCONNECTED         ,'Servers','SRV_DISCONNECTED');
  GetIni(ini,LNG_SRV_LOGGED               ,'Servers','SRV_LOGGED');
  GetIni(ini,LNG_SRV_HUB                  ,'Servers','SRV_HUB');
  GetIni(ini,LNG_SRV_CONNECTING           ,'Servers','SRV_CONNECTING');
  GetIni(ini,LNG_SRV_LOGGING              ,'Servers','SRV_LOGGING');
  GetIni(ini,LNG_SRV_RESOLVE              ,'Servers','SRV_RESOLVE');
  GetIni(ini,LNG_SRV_PASSWORD             ,'Servers','SRV_PASSWORD');
  GetIni(ini,LNG_SRV_RELINKTIME           ,'Servers','SRV_RELINKTIME');
  GetIni(ini,LNG_SBTN_REFRESH             ,'Servers','SBTN_REFRESH');
  GetIni(ini,LNG_SBTN_CONNECT2            ,'Servers','SBTN_CONNECT2');
  GetIni(ini,LNG_SBTN_DISCONNECT          ,'Servers','SBTN_DISCONNECT');
  GetIni(ini,LNG_SBTN_DELETE              ,'Servers','SBTN_DELETE');
  GetIni(ini,LNG_SBTN_ADD                 ,'Servers','SBTN_ADD');
  GetIni(ini,LNG_SBTN_PROPS               ,'Servers','SBTN_PROPS');
  GetIni(ini,LNG_SBTN_AUTOREFRESH         ,'Servers','SBTN_AUTOREFRESH');
  GetIni(ini,LNG_SHOST_HINT               ,'Servers','SHOST_HINT');
  GetIni(ini,LNG_SMENU_REFRESH            ,'Servers','SMENU_REFRESH');
  GetIni(ini,LNG_SMENU_CONNECT2           ,'Servers','SMENU_CONNECT2');
  GetIni(ini,LNG_SMENU_DISCONNECT         ,'Servers','SMENU_DISCONNECT');
  GetIni(ini,LNG_SMENU_DELETE             ,'Servers','SMENU_DELETE');
  GetIni(ini,LNG_SMENU_COMP               ,'Servers','SMENU_COMP');
  GetIni(ini,LNG_SMENU_COMP0              ,'Servers','SMENU_COMP0');
  GetIni(ini,LNG_SMENU_COMP1              ,'Servers','SMENU_COMP1');
  GetIni(ini,LNG_SMENU_COMP2              ,'Servers','SMENU_COMP2');
  GetIni(ini,LNG_SMENU_COMP3              ,'Servers','SMENU_COMP3');
  GetIni(ini,LNG_SMENU_STARTUP            ,'Servers','SMENU_STARTUP');
  GetIni(ini,LNG_SMENU_STARTUP2           ,'Servers','SMENU_STARTUP2');
  GetIni(ini,LNG_SMENU_LINK300            ,'Servers','SMENU_LINK300');
  GetIni(ini,LNG_SMENU_LINK600            ,'Servers','SMENU_LINK600');
  GetIni(ini,LNG_SMENU_LINK900            ,'Servers','SMENU_LINK900');
  GetIni(ini,LNG_SMENU_LINK1200           ,'Servers','SMENU_LINK1200');
  GetIni(ini,LNG_SMENU_LINK1800           ,'Servers','SMENU_LINK1800');
  GetIni(ini,LNG_SMENU_PROPS              ,'Servers','SMENU_PROPS');
  GetIni(ini,LNG_SMENU_SELECTALL          ,'Servers','SMENU_SELECTALL');
  GetIni(ini,LNG_SMENU_SELECTNONE         ,'Servers','SMENU_SELECTNONE');
  GetIni(ini,LNG_SMENU_COPYNAME           ,'Servers','SMENU_COPYNAME');
  GetIni(ini,LNG_EDITSRV_CAPTION          ,'EditServer','EDITSRV_CAPTION');
  GetIni(ini,LNG_EDITSRV_HOST             ,'EditServer','EDITSRV_HOST');
  GetIni(ini,LNG_EDITSRV_PORT             ,'EditServer','EDITSRV_PORT');
  GetIni(ini,LNG_EDITSRV_IPINFO           ,'EditServer','EDITSRV_IPINFO');
  GetIni(ini,LNG_EDITSRV_IPTEXT           ,'EditServer','EDITSRV_IPTEXT');
  GetIni(ini,LNG_EDITSRV_BOX              ,'EditServer','EDITSRV_BOX');
  Getini(ini,LNG_EDITSRV_RESOLVE          ,'EditServer','EDITSRV_RESOLVE');
  GetIni(ini,LNG_EDITSRV_PASSWORD         ,'EditServer','EDITSRV_PASSWORD');
  GetIni(ini,LNG_EDITSRV_MYPASS           ,'EditServer','EDITSRV_MYPASS');
  GetIni(ini,LNG_EDITSRV_REMOTEPASS       ,'EditServer','EDITSRV_REMOTEPASS');
  GetIni(ini,LNG_EDITSRV_BOX2             ,'EditServer','EDITSRV_BOX2');
  GetIni(ini,LNG_EDITSRV_COMP0            ,'EditServer','EDITSRV_COMP0');
  GetIni(ini,LNG_EDITSRV_COMP1            ,'EditServer','EDITSRV_COMP1');
  GetIni(ini,LNG_EDITSRV_COMP2            ,'EditServer','EDITSRV_COMP2');
  GetIni(ini,LNG_EDITSRV_COMP3            ,'EditServer','EDITSRV_COMP3');
  GetIni(ini,LNG_EDITSRV_COMMENTS         ,'EditServer','EDITSRV_COMMENTS');
  GetIni(ini,LNG_EDITSRV_RELINK           ,'EditServer','EDITSRV_RELINK');
  GetIni(ini,LNG_EDITSRV_OK               ,'EditServer','EDITSRV_OK');
  GetIni(ini,LNG_EDITSRV_CANCEL           ,'EditServer','EDITSRV_CANCEL');
  GetIni(ini,LNG_LBL_IGNORED              ,'Ignored','LABEL');
  GetIni(ini,LNG_IBTN_REFRESH             ,'Ignored','IBTN_REFRESH');
  GetIni(ini,LNG_IBTN_ADD                 ,'Ignored','IBTN_ADD');
  GetIni(ini,LNG_IBTN_REMOVE              ,'Ignored','IBTN_REMOVE');
  GetIni(ini,LNG_ILIST_USER               ,'Ignored','ILIST_USER');
  GetIni(ini,LNG_IEDIT_HINT               ,'Ignored','IEDIT_HINT');
  GetIni(ini,LNG_IMENU_REFRESH            ,'Ignored','IMENU_REFRESH');
  GetIni(ini,LNG_IMENU_DELETE             ,'Ignored','IMENU_DELETE');
  GetIni(ini,LNG_IMENU_SELALL             ,'Ignored','IMENU_SELALL');
  GetIni(ini,LNG_IMENU_SELNONE            ,'Ignored','IMENU_SELNONE');
  GetIni(ini,LNG_IMENU_COPYNAME           ,'Ignored','IMENU_COPYNAME');
  GetIni(ini,LNG_LBL_FRIENDS              ,'Friends','LABEL');
  GetIni(ini,LNG_FBTN_REFRESH             ,'Friends','FBTN_REFRESH');
  GetIni(ini,LNG_FBTN_ADD                 ,'Friends','FBTN_ADD');
  GetIni(ini,LNG_FBTN_REMOVE              ,'Friends','FBTN_REMOVE');
  GetIni(ini,LNG_FLIST_USER               ,'Friends','FLIST_USER');
  GetIni(ini,LNG_FEDIT_HINT               ,'Friends','FEDIT_HINT');
  GetIni(ini,LNG_FMENU_REFRESH            ,'Friends','FMENU_REFRESH');
  GetIni(ini,LNG_FMENU_DELETE             ,'Friends','FMENU_DELETE');
  GetIni(ini,LNG_FMENU_SELALL             ,'Friends','FMENU_SELALL');
  GetIni(ini,LNG_FMENU_SELNONE            ,'Friends','FMENU_SELNONE');
  GetIni(ini,LNG_FMENU_COPYNAME           ,'Friends','FMENU_COPYNAME');
  GetIni(ini,LNG_LBL_BLOCKS               ,'Blocks','LABEL');
  GetIni(ini,LNG_BLBTN_REFRESH            ,'Blocks','BLBTN_REFRESH');
  GetIni(ini,LNG_BLBTN_ADD                ,'Blocks','BLBTN_ADD');
  GetIni(ini,LNG_BLBTN_REMOVE             ,'Blocks','BLBTN_REMOVE');
  GetIni(ini,LNG_BLLIST_ITEM              ,'Blocks','BLLIST_ITEM');
  GetIni(ini,LNG_BLEDIT_HINT              ,'Blocks','BLEDIT_HINT');
  GetIni(ini,LNG_BMNU_REFRESH             ,'Blocks','BMNU_REFRESH');
  GetIni(ini,LNG_BMNU_DELETE              ,'Blocks','BMNU_DELETE');
  GetIni(ini,LNG_BMNU_SELALL              ,'Blocks','BMNU_SELALL');
  GetIni(ini,LNG_BMNU_SELNONE             ,'Blocks','BMNU_SELNONE');
  GetIni(ini,LNG_BMNU_COPYNAME            ,'Blocks','BMNU_COPYNAME');
  GetIni(ini,LNG_HLIST_NAME               ,'HotList','HLIST_NAME');
  GetIni(ini,LNG_HLIST_SERVER             ,'HotList','HLIST_SERVER');
  GetIni(ini,LNG_HLIST_SPEED              ,'HotList','HLIST_SPEED');
  GetIni(ini,LNG_HBTN_REFRESH             ,'HotList','HBTN_REFRESH');
  GetIni(ini,LNG_HBTN_ADD                 ,'HotList','HBTN_ADD');
  GetIni(ini,LNG_HBTN_DELETE              ,'HotList','HBTN_DELETE');
  GetIni(ini,LNG_HEDIT_HINT               ,'HotList','HEDIT_HINT');
  GetIni(ini,LNG_HLIST_OFFLINE            ,'HotList','HLIST_OFFLINE');
  GetIni(ini,LNG_LABEL_HOTLIST            ,'HotList','LABEL');
  GetIni(ini,LNG_HMENU_REFRESH            ,'HotList','HMENU_REFRESH');
  GetIni(ini,LNG_HMENU_IM                 ,'HotList','HMENU_IM');
  GetIni(ini,LNG_HMENU_WHOIS              ,'HotList','HMENU_WHOIS');
  GetIni(ini,LNG_HMENU_FRIEND             ,'HotList','HMENU_FRIEND');
  GetIni(ini,LNG_HMENU_DELETE             ,'HotList','HMENU_DELETE');
  GetIni(ini,LNG_HMENU_SELALL             ,'HotList','HMENU_SELALL');
  GetIni(ini,LNG_HMENU_SELNONE            ,'HotList','HMENU_SELNONE');
  GetIni(ini,LNG_HMENU_COPYNAME           ,'HotList','HMENU_COPYNAME');
  GetIni(ini,LNG_WHOIS_CAPTION            ,'Whois','CAPTION');
  GetIni(ini,LNG_WHOIS_USER               ,'Whois','USER');
  GetIni(ini,LNG_WHOIS_LEVEL              ,'Whois','LEVEL');
  GetIni(ini,LNG_WHOIS_TIME               ,'Whois','TIME');
  GetIni(ini,LNG_WHOIS_CHANNELS           ,'Whois','CHANNELS');
  GetIni(ini,LNG_WHOIS_STATUS             ,'Whois','STATUS');
  GetIni(ini,LNG_WHOIS_SHARED             ,'Whois','SHARED');
  GetIni(ini,LNG_WHOIS_TRANSFERS          ,'Whois','TRANSFERS');
  GetIni(ini,LNG_WHOIS_SPEED              ,'Whois','SPEED');
  GetIni(ini,LNG_WHOIS_SOFTWARE           ,'Whois','SOFTWARE');
  GetIni(ini,LNG_WHOIS_TOTAL              ,'Whois','TOTAL');
  GetIni(ini,LNG_WHOIS_IP                 ,'Whois','IP');
  GetIni(ini,LNG_WHOIS_PORT               ,'Whois','PORT');
  GetIni(ini,LNG_WHOIS_DATAPORT           ,'Whois','DATAPORT');
  GetIni(ini,LNG_WHOIS_SERVER             ,'Whois','SERVER');
  GetIni(ini,LNG_WHOIS_WHOWAS             ,'Whois','WHOWAS');
  GetIni(ini,LNG_WMENU_CLOSE              ,'Whois','WMENU_CLOSE');
  GetIni(ini,LNG_WMENU_HOTLIST            ,'Whois','WMENU_HOTLIST');
  GetIni(ini,LNG_WMENU_FRIEND             ,'Whois','WMENU_FRIEND');
  GetIni(ini,LNG_WMENU_IGNORE             ,'Whois','WMENU_IGNORE');
  GetIni(ini,LNG_WMENU_MESSAGE            ,'Whois','WMENU_MESSAGE');
  GetIni(ini,LNG_INV_CAPTION              ,'Invite','INV_CAPTION');
  GetIni(ini,LNG_INV_NAME                 ,'Invite','INV_NAME');
  GetIni(ini,LNG_INV_TOPIC                ,'Invite','INV_TOPIC');
  GetIni(ini,LNG_INV_ACCEPT               ,'Invite','INV_ACCEPT');
  GetIni(ini,LNG_INV_DENY                 ,'Invite','INV_DENY');
  GetIni(ini,LNG_INV_IGNORE               ,'Invite','INV_IGNORE');
  GetIni(ini,LNG_INV_WHOIS                ,'Invite','INV_WHOIS');
  GetIni(ini,LNG_INV_HOTLIST              ,'Invite','INV_HOTLIST');
  GetIni(ini,LNG_INV_PRIVMSG              ,'Invite','INV_PRIVMSG');
  GetIni(ini,LNG_INV_MESSAGE              ,'Invite','INV_MESSAGE');
  GetIni(ini,LNG_S_ITEM_MAIN              ,'Settings','S_ITEM_MAIN');
  GetIni(ini,LNG_S_TEXT_MAIN              ,'Settings','S_TEXT_MAIN');
  GetIni(ini,LNG_S_ITEM_USERS             ,'Settings','S_ITEM_USERS');
  GetIni(ini,LNG_S_TEXT_USERS             ,'Settings','S_TEXT_USERS');
  GetIni(ini,LNG_S_ITEM_LIMITS            ,'Settings','S_ITEM_LIMITS');
  GetIni(ini,LNG_S_TEXT_LIMITS            ,'Settings','S_TEXT_LIMITS');
  GetIni(ini,LNG_S_ITEM_INTERFACE         ,'Settings','S_ITEM_INTERFACE');
  GetIni(ini,LNG_S_TEXT_INTERFACE         ,'Settings','S_TEXT_INTERFACE');
  GetIni(ini,LNG_S_ITEM_LOG               ,'Settings','S_ITEM_LOG');
  GetIni(ini,LNG_S_TEXT_LOG               ,'Settings','S_TEXT_LOG');
  GetIni(ini,LNG_S_ITEM_SHARE             ,'Settings','S_ITEM_SHARE');
  GetIni(ini,LNG_S_TEXT_SHARE             ,'Settings','S_TEXT_SHARE');
  GetIni(ini,LNG_S_ITEM_SHARE_MP3         ,'Settings','S_ITEM_SHARE_MP3');
  GetIni(ini,LNG_S_TEXT_SHARE_MP3         ,'Settings','S_TEXT_SHARE_MP3');
  GetIni(ini,LNG_S_ITEM_SHARE_AUDIO       ,'Settings','S_ITEM_SHARE_AUDIO');
  GetIni(ini,LNG_S_TEXT_SHARE_AUDIO       ,'Settings','S_TEXT_SHARE_AUDIO');
  GetIni(ini,LNG_S_ITEM_SHARE_VIDEO       ,'Settings','S_ITEM_SHARE_VIDEO');
  GetIni(ini,LNG_S_TEXT_SHARE_VIDEO       ,'Settings','S_TEXT_SHARE_VIDEO');
  GetIni(ini,LNG_S_ITEM_SHARE_IMAGES      ,'Settings','S_ITEM_SHARE_IMAGES');
  GetIni(ini,LNG_S_TEXT_SHARE_IMAGES      ,'Settings','S_TEXT_SHARE_IMAGES');
  GetIni(ini,LNG_S_ITEM_SHARE_APP         ,'Settings','S_ITEM_SHARE_APP');
  GetIni(ini,LNG_S_TEXT_SHARE_APP         ,'Settings','S_TEXT_SHARE_APP');
  GetIni(ini,LNG_S_ITEM_SHARE_CD          ,'Settings','S_ITEM_SHARE_CD');
  GetIni(ini,LNG_S_TEXT_SHARE_CD          ,'Settings','S_TEXT_SHARE_CD');
  GetIni(ini,LNG_S_ITEM_SHARE_TEXT        ,'Settings','S_ITEM_SHARE_TEXT');
  GetIni(ini,LNG_S_TEXT_SHARE_TEXT        ,'Settings','S_TEXT_SHARE_TEXT');
  GetIni(ini,LNG_S_ITEM_NAPIGATOR         ,'Settings','S_ITEM_NAPIGATOR');
  GetIni(ini,LNG_S_TEXT_NAPIGATOR         ,'Settings','S_TEXT_NAPIGATOR');
  GetIni(ini,LNG_S_ITEM_DAGSTA            ,'Settings','S_ITEM_DAGSTA');
  GetIni(ini,LNG_S_TEXT_DAGSTA            ,'Settings','S_TEXT_DAGSTA');
  GetIni(ini,LNG_S_ITEM_SEARCH            ,'Settings','S_ITEM_SEARCH');
  GetIni(ini,LNG_S_TEXT_SEARCH            ,'Settings','S_TEXT_SEARCH');
  GetIni(ini,LNG_S_ITEM_LEVELS            ,'Settings','S_ITEM_LEVELS');
  GetIni(ini,LNG_S_TEXT_LEVELS            ,'Settings','S_TEXT_LEVELS');
  GetIni(ini,LNG_S_ITEM_CHANNELS          ,'Settings','S_ITEM_CHANNELS');
  GetIni(ini,LNG_S_TEXT_CHANNELS          ,'Settings','S_TEXT_CHANNELS');
  GetIni(ini,LNG_S_ITEM_CONSOLE           ,'Settings','S_ITEM_CONSOLE');
  GetIni(ini,LNG_S_TEXT_CONSOLE           ,'Settings','S_TEXT_CONSOLE');
  GetIni(ini,LNG_S_ITEM_BLOCKED           ,'Settings','S_ITEM_BLOCKED');
  GetIni(ini,LNG_S_TEXT_BLOCKED           ,'Settings','S_TEXT_BLOCKED');
  GetIni(ini,LNG_S_ITEM_LINKS             ,'Settings','S_ITEM_LINKS');
  GetIni(ini,LNG_S_TEXT_LINKS             ,'Settings','S_TEXT_LINKS');
  GetIni(ini,LNG_S_ITEM_LINKS2            ,'Settings','S_ITEM_LINKS2');
  GetIni(ini,LNG_S_TEXT_LINKS2            ,'Settings','S_TEXT_LINKS2');
  GetIni(ini,LNG_S_ITEM_SOCKETS           ,'Settings','S_ITEM_SOCKETS');
  GetIni(ini,LNG_S_TEXT_SOCKETS           ,'Settings','S_TEXT_SOCKETS');
  GetIni(ini,LNG_S_ITEM_OTHER             ,'Settings','S_ITEM_OTHER');
  GetIni(ini,LNG_S_TEXT_OTHER             ,'Settings','S_TEXT_OTHER');
  GetIni(ini,LNG_S_ITEM_REPORT            ,'Settings','S_ITEM_REPORT');
  GetIni(ini,LNG_S_TEXT_REPORT            ,'Settings','S_TEXT_REPORT');
  GetIni(ini,LNG_S_ITEM_MINSHARE          ,'Settings','S_ITEM_MINSHARE');
  GetIni(ini,LNG_S_TEXT_MINSHARE          ,'Settings','S_TEXT_MINSHARE');
  GetIni(ini,LNG_S_ITEM_MOTD              ,'Settings','S_ITEM_MOTD');
  GetIni(ini,LNG_S_TEXT_MOTD              ,'Settings','S_TEXT_MOTD');
  GetIni(ini,LNG_S_ITEM_COLORS            ,'Settings','S_ITEM_COLORS');
  GetIni(ini,LNG_S_TEXT_COLORS            ,'Settings','S_TEXT_COLORS');
  Getini(ini,LNG_S_CAPTION                ,'Settings','S_CAPTION');
  GetIni(ini,LNG_S_BTN_CHANGE             ,'Settings','S_BTN_CHANGE');
  GetIni(ini,LNG_S_BTN_SAVE               ,'Settings','S_BTN_SAVE');
  GetIni(ini,LNG_S_BTN_RESTORE            ,'Settings','S_BTN_RESTORE');
  GetIni(ini,LNG_S_BTN_CLOSE              ,'Settings','S_BTN_CLOSE');
  GetIni(ini,LNG_S_LBL_NOTE               ,'Settings','S_LBL_NOTE');
  Getini(ini,LNG_S_LBL_CHANGE             ,'Settings','S_LBL_CHANGE');
  GetIni(ini,LNG_S_LBL_SAVE               ,'Settings','S_LBL_SAVE');
  ini.Free;
  except
 end;
 try // client messages
  ini:=TIniFile.Create(ApplicationDir+name+'.msg');
  GetIni(ini,LNG_INVALIDCOMMAND           ,'Main','INVALIDCOMMAND');
  SetConstant(LNG_INVALIDARGS             ,'̐ł');
  GetIni(ini,LNG_ACCESS                   ,'Main','ACCESS');
  GetIni(ini,LNG_ACCESSREG                ,'Main','ACCESSREG');
  GetIni(ini,LNG_NOTLOGGED                ,'Main','NOTLOGGED');
  GetIni(ini,LNG_LOGGED                   ,'Main','LOGGED');
  GetIni(ini,LNG_NOUSER                   ,'Main','NOUSER');
  SetConstant(LNG_OFFLINE                 ,'̃[U[̓ItCł');
  GetIni(ini,LNG_REMOTE                   ,'Main','REMOTE');
  GetIni(ini,LNG_GHOST                    ,'Main','GHOST');
  GetIni(ini,LNG_INVALIDNICK              ,'Main','INVALIDNICK');
  GetIni(ini,LNG_INVALIDPASS              ,'Main','INVALIDPASS');
  GetIni(ini,LNG_REGISTERED               ,'Main','REGISTERED');
  GetIni(ini,LNG_USERSLIMIT               ,'Main','USERSLIMIT');
  GetIni(ini,LNG_INVSPEED                 ,'Main','INVSPEED');
  GetIni(ini,LNG_REGISTEREDONLY           ,'Main','REGISTEREDONLY');
  GetIni(ini,LNG_LEVEL                    ,'Main','LEVEL');
  GetIni(ini,LNG_BANNED2                  ,'Main','BANNED2');
  GetIni(ini,LNG_BANNED3                  ,'Main','BANNED3');
  GetIni(ini,LNG_MAXCLONES                ,'Main','MAXCLONES');
  GetIni(ini,LNG_INVALIDLEVEL             ,'Main','INVALIDLEVEL');
  GetIni(ini,LNG_LEVEL1                   ,'Main','LEVEL1');
  GetIni(ini,LNG_FRIENDLOGIN              ,'Main','FRIENDLOGIN');
  GetIni(ini,LNG_LEVEL2                   ,'Main','LEVEL2');
  GetIni(ini,LNG_LEVEL3                   ,'Main','LEVEL3');
  GetIni(ini,LNG_KICK                     ,'Main','KICK');
  SetConstant(LNG_NUKE                    ,'<$1> $2̃AJEg폜܂BR: $3');
  GetIni(ini,LNG_NUKEMSG                  ,'Main','NUKEMSG');
  GetIni(ini,LNG_KICKMSG                  ,'Main','KICKMSG');
  GetIni(ini,LNG_KICKMSG2                 ,'Main','KICKMSG2');
  GetIni(ini,LNG_MEMORYLIMIT              ,'Main','MEMORYLIMIT');
  GetIni(ini,LNG_BANDWIDTHLIMIT           ,'Main','BANDWIDTHLIMIT');
  GetIni(ini,LNG_FIREWALL                 ,'Main','FIREWALL');
  GetIni(ini,LNG_BROWSEMOD                ,'Main','BROWSEMOD');
  GetIni(ini,LNG_WHOISMOD                 ,'Main','WHOISMOD');
  GetIni(ini,LNG_IPREQMOD                 ,'Main','IPREQMOD');
  GetIni(ini,LNG_SHAREFILESFIRST          ,'Main','SHAREFILESFIRST');
  GetIni(ini,LNG_SHAREMEGSFIRST          ,'Main','SHAREMEGSFIRST');
  GetIni(ini,LNG_BANREASONCHANGE          ,'Main','BANREASONCHANGE');
  GetIni(ini,LNG_BANEXPCHANGE             ,'Main','BANEXPCHANGE');
  GetIni(ini,LNG_MUZZLE1                  ,'Main','MUZZLE1');
  GetIni(ini,LNG_UNMUZZLE1                ,'Main','UNMUZZLE1');
  GetIni(ini,LNG_MUZZLE3                  ,'Main','MUZZLE3');
  GetIni(ini,LNG_UNMUZZLE3                ,'Main','UNMUZZLE3');
  GetIni(ini,LNG_MUZZLE                   ,'Main','MUZZLE');
  GetIni(ini,LNG_FLOODMUZZLE              ,'Main','FLOODMUZZLE');
  GetIni(ini,LNG_UNMUZZLE                 ,'Main','UNMUZZLE');
  GetIni(ini,LNG_MUZZLEEXPIRE             ,'Main','MUZZLEEXPIRE');
  GetIni(ini,LNG_CANTTALK                 ,'Main','CANTTALK');
  SetConstant(LNG_ALTERSPEED              ,'<$1> $2̉x$3ɕύX܂B');
  GetIni(ini,LNG_ERRCLOAKED               ,'Main','ERRCLOAKED');
  GetIni(ini,LNG_ERRUNCLOAK               ,'Main','ERRUNCLOAK');
  GetIni(ini,LNG_CLOAKED                  ,'Main','CLOAKED');
  GetIni(ini,LNG_UNCLOAKED                ,'Main','UNCLOAKED');
  SetConstant(LNG_CHPASS2                 ,'<$1> $2̃pX[hύX܂: $3');
  GetIni(ini,LNG_NOVAR                    ,'Main','NOVAR');
  GetIni(ini,LNG_BADVAR                   ,'Main','BADVAR');
  GetIni(ini,LNG_CHANGEVAR                ,'Main','CHANGEVAR');
  GetIni(ini,LNG_USERSERVER               ,'Main','USERSERVER');
  GetIni(ini,LNG_REGEXISTS                ,'Main','REGEXISTS');
  GetIni(ini,LNG_REGOK2                   ,'Main','REGOK2');
  GetIni(ini,LNG_INVALIDNICK2             ,'Main','INVALIDNICK2');
  GetIni(ini,LNG_ADDFRIEND                ,'Main','ADDFRIEND');
  GetIni(ini,LNG_REMOVEFRIEND             ,'Main','REMOVEFRIEND');
  GetIni(ini,LNG_CLIENTBLOCK              ,'Main','CLIENTBLOCK');
  GetIni(ini,LNG_LINKED                   ,'Main','LINKED');
  GetIni(ini,LNG_LINKREQ                  ,'Main','LINKREQ');
  GetIni(ini,LNG_LINKREQ2                 ,'Main','LINKREQ2');
  GetIni(ini,LNG_DELINK                   ,'Main','DELINK');
  GetIni(ini,LNG_DELINK2                  ,'Main','DELINK2');
  GetIni(ini,LNG_LINKERRRESOLVE           ,'Main','LINKERRRESOLVE');
  GetIni(ini,LNG_LINKERRCONNECT           ,'Main','LINKERRCONNECT');
  GetIni(ini,LNG_LINKCONNECTED            ,'Main','LINKCONNECTED');
  GetIni(ini,LNG_LINKBADVERSION           ,'Main','LINKBADVERSION');
  GetIni(ini,LNG_LINKBADVERSION2          ,'Main','LINKBADVERSION2');
  GetIni(ini,LNG_LINKNOLIST               ,'Main','LINKNOLIST');
  GetIni(ini,LNG_LINKNOLIST1              ,'Main','LINKNOLIST1');
  GetIni(ini,LNG_LINKNOLIST2              ,'Main','LINKNOLIST2');
  GetIni(ini,LNG_LINKNOLIST3              ,'Main','LINKNOLIST3');
  GetIni(ini,LNG_LINKLOGGED               ,'Main','LINKLOGGED');
  GetIni(ini,LNG_LINKLOGGED2              ,'Main','LINKLOGGED2');
  GetIni(ini,LNG_LINKLOGGING              ,'Main','LINKLOGGING');
  GetIni(ini,LNG_LINKLOGGING2             ,'Main','LINKLOGGING2');
  GetIni(ini,LNG_LINKNOLINK               ,'Main','LINKNOLINK');
  GetIni(ini,LNG_LINKNOLINK2              ,'Main','LINKNOLINK2');
  GetIni(ini,LNG_LINKINVHANDLE            ,'Main','LINKINVHANDLE');
  GetIni(ini,LNG_LINKINVHANDLE2           ,'Main','LINKINVHANDLE2');
  GetIni(ini,LNG_LINKINVHANDLE3           ,'Main','LINKINVHANDLE3');
  GetIni(ini,LNG_LINKINVIP                ,'Main','LINKINVIP');
  GetIni(ini,LNG_LINKINVIP2               ,'Main','LINKINVIP2');
  GetIni(ini,LNG_LINKERRLOGIN             ,'Main','LINKERRLOGIN');
  GetIni(ini,LNG_DELINKHUB                ,'Main','DELINKHUB');
  GetIni(ini,LNG_LINKINVPASS              ,'Main','LINKINVPASS');
  GetIni(ini,LNG_LINKINVPASS2             ,'Main','LINKINVPASS2');
  GetIni(ini,LNG_LINKSRVLOGGED            ,'Main','LINKSRVLOGGED');
  GetIni(ini,LNG_LINKSRVLOGGED2           ,'Main','LINKSRVLOGGED2');
  GetIni(ini,LNG_LINKLOGINERR             ,'Main','LINKLOGINERR');
  GetIni(ini,LNG_LINKINVCONSOLE           ,'Main','LINKINVCONSOLE');
  GetIni(ini,LNG_NOSUCHSERVER             ,'Main','NOSUCHSERVER');
  GetIni(ini,LNG_CANTDELINK               ,'Main','CANTDELINK');
  GetIni(ini,LNG_DELINKREQ                ,'Main','DELINKREQ');
  GetIni(ini,LNG_INVLINKHANDLE            ,'Main','INVLINKHANDLE');
  GetIni(ini,LNG_LINKSRVLOGGED3           ,'Main','LINKSRVLOGGED3');
  GetIni(ini,LNG_LINKINVHANDLE4           ,'Main','LINKINVHANDLE4');
  GetIni(ini,LNG_CANTREMOVE               ,'Main','CANTREMOVE');
  GetIni(ini,LNG_CANTKILL                 ,'Main','CANTKILL');
  GetIni(ini,LNG_KILLSERVER               ,'Main','KILLSERVER');
  GetIni(ini,LNG_REMOVESERVER             ,'Main','REMOVESERVER');
  GetIni(ini,LNG_MINSHARE                 ,'Main','MINSHARE');
  GetIni(ini,LNG_MINSHARE3                ,'Main','MINSHARE3');
  GetIni(ini,LNG_BLOCKEDWINMX             ,'Main','BLOCKEDWINMX');
  GetIni(ini,LNG_OUTGOINGRESTRICTED       ,'Main','OUTGOINGRESTRICTED');
  GetIni(ini,LNG_RECONNECT                ,'Main','RECONNECT');
  GetIni(ini,LNG_LINKINVCONSOLE2          ,'Main','LINKINVCONSOLE2');
  GetIni(ini,LNG_LINKINVCONSOLE3          ,'Main','LINKINVCONSOLE3');
  SetConstant(LNG_BROWSEFAIL              ,'QƎs: ̂悤ȃ[U[͂܂');
  SetConstant(LNG_BROWSELEECH             ,'ANZX: Ȃ'+levels[0]+'ł');
  SetConstant(LNG_BROWSEFIREWALL          ,'Ȃ$1͗Ƃt@CA[EH[̓ɂ܂B̐lBɑ΂Ă͎Q/DLł܂B');
  SetConstant(LNG_OFFLINE2                ,'[U[$1̓ItCł');
  GetIni(ini,LNG_LINKING                  ,'Main','LINKING');
  GetIni(ini,LNG_INVALIDSOFTWARE          ,'Main','INVALIDSOFTWARE');
  GetIni(ini,LNG_ALREADYREGISTERED        ,'Main','ALREADYREGISTERED');
  GetIni(ini,LNG_CHANNELMODERATED         ,'Channels','CHANNELMODERATED');
  GetIni(ini,LNG_CHANNELOPERATOR          ,'Channels','CHANNELOPERATOR');
  GetIni(ini,LNG_CHANNELOPERATOR2         ,'Channels','CHANNELOPERATOR2');
  GetIni(ini,LNG_INVALIDCHANNEL           ,'Channels','INVALIDCHANNEL');
  GetIni(ini,LNG_NOCREATE                 ,'Channels','NOCREATE');
  GetIni(ini,LNG_CHANNELLIMIT2            ,'Channels','CHANNELLIMIT2');
  GetIni(ini,LNG_CHANNELLIMIT             ,'Channels','CHANNELLIMIT');
  SetConstant(LNG_NOCHANNEL               ,'̂悤ȃ`l͂܂');
  SetConstant(LNG_CHALREADYBANNED         ,'łBanĂ܂');
  GetIni(ini,LNG_CHBANNED                 ,'Channels','CHBANNED');
  GetIni(ini,LNG_CHUNBANNED               ,'Channels','CHUNBANNED');
  GetIni(ini,LNG_CHJOINED                 ,'Channels','CHJOINED');
  GetIni(ini,LNG_INVITE                   ,'Channels','INVITE');
  Getini(ini,LNG_CLEARCHANNEL             ,'Channels','CLEARCHANNEL');
  GetIni(ini,LNG_CHLEVEL                  ,'Channels','CHLEVEL');
  GetIni(ini,LNG_LIMIT                    ,'Channels','LIMIT');
  GetIni(ini,LNG_CHKICK                   ,'Channels','CHKICK');
  GetIni(ini,LNG_CHNOOPS                  ,'Channels','CHNOOPS');
  GetIni(ini,LNG_CHANOP                   ,'Channels','CHANOP');
  GetIni(ini,LNG_CHANOP2                  ,'Channels','CHANOP2');
  GetIni(ini,LNG_CHANOP3                  ,'Channels','CHANOP3');
  GetIni(ini,LNG_CHANDEOP                 ,'Channels','CHANDEOP');
  GetIni(ini,LNG_CHANDEOP2                ,'Channels','CHANDEOP2');
  GetIni(ini,LNG_CHANDEOP3                ,'Channels','CHANDEOP3');
  GetIni(ini,LNG_CHANDEOP4                ,'Channels','CHANDEOP4');
  GetIni(ini,LNG_DROPCHANNEL              ,'Channels','DROPCHANNEL');
  GetIni(ini,LNG_UNKNOWNCHMODE            ,'Channels','UNKNOWNCHMODE');
  GetIni(ini,LNG_NOMODERATE               ,'Channels','NOMODERATE');
  GetIni(ini,LNG_VOICE                    ,'Channels','VOICE');
  GetIni(ini,LNG_VOICE2                   ,'Channels','VOICE2');
  GetIni(ini,LNG_VOICE3                   ,'Channels','VOICE3');
  GetIni(ini,LNG_VOICE4                   ,'Channels','VOICE4');
  GetIni(ini,LNG_DEVOICE                  ,'Channels','DEVOICE');
  GetIni(ini,LNG_DEVOICE2                 ,'Channels','DEVOICE2');
  GetIni(ini,LNG_DEVOICE3                 ,'Channels','DEVOICE3');
  GetIni(ini,LNG_DEVOICE4                 ,'Channels','DEVOICE4');
  GetIni(ini,LNG_DEVOICE5                 ,'Channels','DEVOICE5');
  GetIni(ini,LNG_CHLIMIT                  ,'Channels','CHLIMIT');
  GetIni(ini,LNG_CHLEVEL2                 ,'Channels','CHLEVEL2');
  GetIni(ini,LNG_CHCREATED                ,'Channels','CHCREATED');
  GetIni(ini,LNG_VOICE5                   ,'Channels','VOICE5');
  GetIni(ini,LNG_VOICE6                   ,'Channels','VOICE6');
  GetIni(ini,LNG_CHANOP4                  ,'Channels','CHANOP4');
  GetIni(ini,LNG_FLOODWARN                ,'Channels','FLOODWARN');
  GetIni(ini,LNG_FLOODMUZZLE1             ,'Channels','FLOODMUZZLE1');
  GetIni(ini,LNG_FLOODMUZZLE2             ,'Channels','FLOODMUZZLE2');
  GetIni(ini,LNG_CHTOPIC                  ,'Channels','CHTOPIC');
  GetIni(ini,LNG_SHARE_ERROR              ,'Share','SHARE_ERROR');
  Getini(ini,LNG_SHARE_SHORT              ,'Share','SHARE_SHORT');
  GetIni(ini,LNG_SHARE_BITRATE            ,'Share','SHARE_BITRATE');
  Getini(ini,LNG_SHARE_FREQ               ,'Share','SHARE_FREQ');
  GetIni(ini,LNG_SHARE_TIME               ,'Share','SHARE_TIME');
  GetIni(ini,LNG_SHARE_LIMIT              ,'Share','SHARE_LIMIT');
  GetIni(ini,LNG_SHARE_TOTAL_LIMIT        ,'Share','SHARE_TOTAL_LIMIT');
  GetIni(ini,LNG_SHARE_MEMORY_LIMIT       ,'Share','SHARE_MEMORY_LIMIT');
  GetIni(ini,LNG_SHARE_SMALL              ,'Share','SHARE_SMALL');
  GetIni(ini,LNG_SHARE_LARGE              ,'Share','SHARE_LARGE');
  GetIni(ini,LNG_NOSHARE_BITRATE          ,'Share','NOSHARE_BITRATE');
  GetIni(ini,LNG_SHARE_10300              ,'Share','SHARE_10300');
  ini.Free;
  except
 end;
end;

// from main thread

function  GetLangT(id: Integer): String;
begin
 try
   if (language_t=nil) or (id>LNG_MAX) or (id<0) then
   begin
    Result:='';
    exit;
   end;
   Result:=UnEscape(language_t.Strings[id]);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangT(id: Integer; arg: String): String;
var
 i: Integer;
 str: String;
begin
 try
   if (language_t=nil) or (id>LNG_MAX) or (id<0) then
   begin
    Result:='';
    exit;
   end;
   str:=UnEscape(language_t.Strings[id]);
   i:=pos('$1',str);
   if i>0 then
   begin
    system.delete(str,i,2);
    system.insert(arg,str,i);
   end;
   Result:=str;
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangT(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String;
begin
 try
  if (language_t=nil) or (id>LNG_MAX) or (id<0) then
  begin
   Result:='';
   exit;
  end;
  Result:=GetLangEx(UnEscape(language_t.Strings[id]),arg1,arg2,arg3,arg4,arg5);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

// from inertface

function  GetLangI(id: Integer): String;
begin
 try
  if (language_i=nil) or (id>LNG_MAX) or (id<0) then
  begin
   Result:='';
   exit;
  end;
  Result:=UnEscape(language_i.Strings[id]);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangI(id: Integer; arg: String): String;
var
 i: Integer;
 str: String;
begin
 try
  if (language_i=nil) or (id>LNG_MAX) or (id<0) then
  begin
   Result:='';
   exit;
  end;
  str:=UnEscape(language_i.Strings[id]);
  i:=pos('$1',str);
  if i>0 then
  begin
   system.delete(str,i,2);
   system.insert(arg,str,i);
  end;
  Result:=str;
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangI(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String;
begin
 try
  if (language_i=nil) or (id>LNG_MAX) or (id<0) then
  begin
   Result:='';
   exit;
  end;
  Result:=GetLangEx(UnEscape(language_i.Strings[id]),arg1,arg2,arg3,arg4,arg5);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

// from other threads

function  GetLangE(id: Integer): String;
begin
 try
   if (language_e=nil) or (id>LNG_MAX) or (id<0) then
   begin
     Result:='';
     exit;
   end;
   Result:=UnEscape(language_e.Strings[id]);
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangE(id: Integer; arg: String): String;
var
 i: Integer;
 str: String;
begin
 try
   if (language_e=nil) or (id>LNG_MAX) or (id<0) then
   begin
     Result:='';
     exit;
   end;
   str:=UnEscape(language_e.Strings[id]);
   i:=pos('$1',str);
   if i>0 then
   begin
     system.delete(str,i,2);
     system.insert(arg,str,i);
   end;
   Result:=str;
  except
   Result:=LNG_UNKNOWN;
 end;
end;

function  GetLangE(id: Integer; arg1: String; arg2: String; arg3: string=''; arg4: string=''; arg5: String=''): String;
begin
 if (language_e=nil) or (id>LNG_MAX) or (id<0) then
 begin
   Result:='';
   exit;
 end;
 try
   Result:=GetLangEx(UnEscape(language_e.Strings[id]),arg1,arg2,arg3,arg4,arg5);
  except
   Result:=LNG_UNKNOWN;
 end;
end;


initialization
begin
 InitLanguage;
end;

finalization
begin
 DestroyLanguage;
end;

end.

