{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: settings

 Settings window

*********************************************************}
unit settings;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, OfficePanel, ComCtrls, StdCtrls, inifiles, registry,
  SpectrumCombo, ShellApi, Buttons, Spin, basecombo, Pages, Classes,
  ActiveX, ShlObj, slavastrings;

type
  TSlavaNapSettings = class(TForm)
    Panel1: TPanel;
    ksoOfficePanel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    header: TPaintBox;
    tree: TTreeView;
    pages: TPageControl;
    sh_main: TTabSheet;
    btn_change: TButton;
    btn_restore: TButton;
    btn_close: TButton;
    lbl_note: TLabel;
    lbl_change: TLabel;
    Label1: TLabel;
    edit_main_ports: TEdit;
    Label3: TLabel;
    edit_main_host: TEdit;
    Label4: TLabel;
    sh_users: TTabSheet;
    cb_users_reg_only: TCheckBox;
    cb_users_reg_allow: TCheckBox;
    Label5: TLabel;
    edit_users_limit: TSpinEdit;
    sh_limits: TTabSheet;
    Label6: TLabel;
    edit_limits_stats: TSpinEdit;
    Label7: TLabel;
    Label8: TLabel;
    edit_limits_hotlist: TSpinEdit;
    edit_limits_ignored: TSpinEdit;
    Label9: TLabel;
    edit_users_clones: TSpinEdit;
    Label12: TLabel;
    edit_users_logintimeout: TSpinEdit;
    sh_interface: TTabSheet;
    sh_log: TTabSheet;
    cb_log_login: TCheckBox;
    cb_log_napigator: TCheckBox;
    cb_log_search: TCheckBox;
    cb_log_transfers: TCheckBox;
    cb_log_users: TCheckBox;
    cb_log_save: TCheckBox;
    cb_log_servers: TCheckBox;
    sh_share: TTabSheet;
    cb_share_disable: TCheckBox;
    cb_share_inform: TCheckBox;
    cb_share_nomodem: TCheckBox;
    Label13: TLabel;
    Label14: TLabel;
    edit_share_max: TSpinEdit;
    edit_share_maxtotal: TSpinEdit;
    Label15: TLabel;
    Label16: TLabel;
    edit_share_filename: TSpinEdit;
    edit_share_duration: TSpinEdit;
    sh_share_mp3: TTabSheet;
    Label17: TLabel;
    edit_mp3_ext: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    edit_mp3_max: TSpinEdit;
    edit_mp3_maxsize: TSpinEdit;
    edit_mp3_minsize: TSpinEdit;
    sh_share_audio: TTabSheet;
    Label21: TLabel;
    edit_audio_ext: TEdit;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    edit_audio_maxsize: TSpinEdit;
    edit_audio_minsize: TSpinEdit;
    edit_audio_max: TSpinEdit;
    sh_share_video: TTabSheet;
    Label25: TLabel;
    edit_video_ext: TEdit;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    edit_video_maxsize: TSpinEdit;
    edit_video_minsize: TSpinEdit;
    edit_video_max: TSpinEdit;
    sh_share_images: TTabSheet;
    Label29: TLabel;
    edit_images_ext: TEdit;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    edit_images_maxsize: TSpinEdit;
    edit_images_minsize: TSpinEdit;
    edit_images_max: TSpinEdit;
    sh_share_apps: TTabSheet;
    Label33: TLabel;
    edit_apps_ext: TEdit;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    edit_apps_maxsize: TSpinEdit;
    edit_apps_minsize: TSpinEdit;
    edit_apps_max: TSpinEdit;
    sh_share_cd: TTabSheet;
    Label37: TLabel;
    edit_cd_ext: TEdit;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    edit_cd_maxsize: TSpinEdit;
    edit_cd_minsize: TSpinEdit;
    edit_cd_max: TSpinEdit;
    sh_share_text: TTabSheet;
    Label41: TLabel;
    edit_text_ext: TEdit;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    edit_text_maxsize: TSpinEdit;
    edit_text_minsize: TSpinEdit;
    edit_text_max: TSpinEdit;
    Label45: TLabel;
    cb_mp3_320: TCheckBox;
    cb_mp3_256: TCheckBox;
    cb_mp3_224: TCheckBox;
    cb_mp3_192: TCheckBox;
    cb_mp3_160: TCheckBox;
    cb_mp3_128: TCheckBox;
    cb_mp3_112: TCheckBox;
    cb_mp3_96: TCheckBox;
    cb_mp3_80: TCheckBox;
    cb_mp3_64: TCheckBox;
    cb_mp3_56: TCheckBox;
    cb_mp3_48: TCheckBox;
    cb_mp3_40: TCheckBox;
    cb_mp3_32: TCheckBox;
    cb_mp3_24: TCheckBox;
    cb_mp3_0: TCheckBox;
    Label46: TLabel;
    sh_napigator: TTabSheet;
    sh_search: TTabSheet;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    edit_search_defsearch: TSpinEdit;
    edit_search_maxsearch: TSpinEdit;
    edit_search_maxbrowse: TSpinEdit;
    edit_search_searchespm: TSpinEdit;
    sh_levels: TTabSheet;
    sh_channels: TTabSheet;
    cb_channels_allowcreate: TCheckBox;
    Label52: TLabel;
    Label53: TLabel;
    edit_channels_max: TSpinEdit;
    edit_channels_max2: TSpinEdit;
    cb_channels_blockcqex: TCheckBox;
    cb_interface_startup: TCheckBox;
    Label54: TLabel;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    edit_level_0: TEdit;
    edit_level_1: TEdit;
    edit_level_2: TEdit;
    edit_level_3: TEdit;
    edit_level_4: TEdit;
    btn_level_default: TButton;
    Label61: TLabel;
    Label62: TLabel;
    Label63: TLabel;
    Label64: TLabel;
    Label65: TLabel;
    edit_napigator_host: TEdit;
    edit_napigator_port: TSpinEdit;
    edit_napigator_user: TEdit;
    btn_napigator_password: TButton;
    cb_napigator_enabled: TCheckBox;
    btn_napigator_disconnect: TButton;
    Label66: TLabel;
    Label67: TLabel;
    edit_main_listenip: TEdit;
    cb_log_serverstats: TCheckBox;
    sh_console: TTabSheet;
    sh_blocked: TTabSheet;
    Label68: TLabel;
    cb_block_napster: TCheckBox;
    cb_block_audiognome: TCheckBox;
    cb_block_gnomeplus: TCheckBox;
    cb_block_amster: TCheckBox;
    cb_block_filenavigator: TCheckBox;
    cb_block_cqex: TCheckBox;
    cb_block_sunshineun: TCheckBox;
    cb_block_teknap: TCheckBox;
    cb_block_nap: TCheckBox;
    cb_block_macnap: TCheckBox;
    cb_block_mp3rage: TCheckBox;
    cb_block_xnap: TCheckBox;
    cb_block_spotlight: TCheckBox;
    cb_block_nfs: TCheckBox;
    cb_block_dmnapster: TCheckBox;
    cb_block_knapster: TCheckBox;
    cb_block_lopster: TCheckBox;
    cb_block_rapigator: TCheckBox;
    cb_block_swaptor: TCheckBox;
    cb_block_other: TCheckBox;
    Label69: TLabel;
    Label70: TLabel;
    edit_console_user: TEdit;
    edit_console_speed: TComboBox;
    Label71: TLabel;
    Label72: TLabel;
    edit_search_maxremotebrowse: TSpinEdit;
    cb_log_clearserverstats: TCheckBox;
    cb_log_clearclientstats: TCheckBox;
    panel_block_other: TPanel;
    Label74: TLabel;
    edit_block_sign0: TEdit;
    edit_block_sign1: TEdit;
    edit_block_sign2: TEdit;
    Label75: TLabel;
    Label76: TLabel;
    edit_main_handle: TSpinEdit;
    lbl_handle: TLabel;
    sh_links: TTabSheet;
    ksoOfficePanel2: TPanel;
    cb_link_all: TRadioButton;
    cb_link_list: TRadioButton;
    cb_link_none: TRadioButton;
    Label77: TLabel;
    edit_interface_cpu: TSpinEdit;
    Label78: TLabel;
    cb_search_disable_remote: TCheckBox;
    edit_search_maxremote: TSpinEdit;
    lbl_search_maxremote: TLabel;
    cb_channels_oldwallop: TCheckBox;
    Label79: TLabel;
    edit_users_maxaccept: TSpinEdit;
    cb_interface_noswitch: TCheckBox;
    cb_block_dagsta: TCheckBox;
    cb_users_noremote: TCheckBox;
    sh_sockets: TTabSheet;
    cb_sockets_users_def: TCheckBox;
    edit_sockets_users_send: TSpinEdit;
    edit_sockets_users_recv: TSpinEdit;
    cb_sockets_servers_def: TCheckBox;
    edit_sockets_servers_send: TSpinEdit;
    edit_sockets_servers_recv: TSpinEdit;
    lbl_sockets_users_send: TLabel;
    lbl_sockets_users_recv: TLabel;
    lbl_sockets_servers_send: TLabel;
    lbl_sockets_servers_recv: TLabel;
    Label81: TLabel;
    Label82: TLabel;
    Label83: TLabel;
    edit_channels_maxmessage: TSpinEdit;
    edit_channels_maxprivmessage: TSpinEdit;
    sh_report: TTabSheet;
    sh_other: TTabSheet;
    Label84: TLabel;
    ksoOfficeGroupBox1: TGroupBox;
    Label85: TLabel;
    cb_ann_enable: TCheckBox;
    Label86: TLabel;
    edit_ann_delay: TSpinEdit;
    edit_ann_messages: TMemo;
    Label87: TLabel;
    Label88: TLabel;
    edit_ann_user: TEdit;
    ksoOfficeGroupBox2: TGroupBox;
    cb_report_old_enable: TCheckBox;
    Label89: TLabel;
    edit_report_old_port: TSpinEdit;
    ksoOfficeGroupBox3: TGroupBox;
    cb_report_new_enabled: TCheckBox;
    edit_report_new_port: TSpinEdit;
    cb_report_new_hidehub: TCheckBox;
    Label90: TLabel;
    sh_minshare: TTabSheet;
    Label91: TLabel;
    edit_minshare_minshare: TSpinEdit;
    Label92: TLabel;
    Label93: TLabel;
    edit_minshare_delay: TSpinEdit;
    Label94: TLabel;
    cb_minshare_ban: TCheckBox;
    edit_minshare_bantime: TSpinEdit;
    Label95: TLabel;
    edit_minshare_minsharesize: TSpinEdit;
    cb_minshare_onlyfull: TCheckBox;
    cb_minshare_banip: TCheckBox;
    cb_minshare_full10: TCheckBox;
    Label73: TLabel;
    edit_napigator_myip: TEdit;
    cb_channels_showops: TCheckBox;
    sh_motd: TTabSheet;
    Label96: TLabel;
    edit_motd: TMemo;
    cb_minshare_kickchat: TCheckBox;
    cb_napigator_autodisconnect: TCheckBox;
    Label97: TLabel;
    cb_link_hub: TCheckBox;
    Label98: TLabel;
    cb_minshare_wallop: TCheckBox;
    cb_block_floodster: TCheckBox;
    cb_users_redirectcqex: TCheckBox;
    cb_link_syncreg: TCheckBox;
    cb_channels_timestamp: TCheckBox;
    cb_channels_low: TCheckBox;
    cb_link_noautoconnect: TCheckBox;
    Label99: TLabel;
    Label100: TLabel;
    edit_limits_maxdown: TSpinEdit;
    edit_limits_maxup: TSpinEdit;
    cb_limits_limitservers: TCheckBox;
    cb_block_drumbeat: TCheckBox;
    Label101: TLabel;
    edit_share_maxindex: TSpinEdit;
    cb_channels_preventshout: TCheckBox;
    cb_interface_chatflash: TCheckBox;
    edit_channels_flood_user: TSpinEdit;
    edit_channels_flood_same: TSpinEdit;
    cb_channels_flood_warn: TCheckBox;
    lbl_flood1: TLabel;
    lbl_flood2: TLabel;
    sh_colors: TTabSheet;
    edit_color_bg: TksoSpectrumComboBox;
    Label104: TLabel;
    Label105: TLabel;
    edit_color_text: TksoSpectrumComboBox;
    Label106: TLabel;
    Label107: TLabel;
    Label108: TLabel;
    Label109: TLabel;
    Label110: TLabel;
    Label111: TLabel;
    Label112: TLabel;
    Label113: TLabel;
    edit_color_chat: TksoSpectrumComboBox;
    edit_color_mychat: TksoSpectrumComboBox;
    edit_color_channelchat: TksoSpectrumComboBox;
    edit_color_mychannelchat: TksoSpectrumComboBox;
    edit_color_emote: TksoSpectrumComboBox;
    edit_color_myemote: TksoSpectrumComboBox;
    edit_color_join: TksoSpectrumComboBox;
    edit_color_part: TksoSpectrumComboBox;
    Label114: TLabel;
    edit_color_topic: TksoSpectrumComboBox;
    Label115: TLabel;
    Label116: TLabel;
    Label117: TLabel;
    Label118: TLabel;
    Label119: TLabel;
    Label120: TLabel;
    Label121: TLabel;
    Label122: TLabel;
    Label123: TLabel;
    Label124: TLabel;
    Label125: TLabel;
    edit_color_debug: TksoSpectrumComboBox;
    edit_color_error: TksoSpectrumComboBox;
    edit_color_wallop: TksoSpectrumComboBox;
    edit_color_announce: TksoSpectrumComboBox;
    edit_color_online: TksoSpectrumComboBox;
    edit_color_offline: TksoSpectrumComboBox;
    edit_color_search: TksoSpectrumComboBox;
    edit_color_transfer: TksoSpectrumComboBox;
    edit_color_napigator: TksoSpectrumComboBox;
    edit_color_pong: TksoSpectrumComboBox;
    edit_color_whowas: TksoSpectrumComboBox;
    btn_colors_default: TButton;
    cd: TColorDialog;
    btn_color_ch1: TSpeedButton;
    btn_color_ch2: TSpeedButton;
    btn_color_ch3: TSpeedButton;
    btn_color_ch4: TSpeedButton;
    btn_color_ch5: TSpeedButton;
    btn_color_ch6: TSpeedButton;
    btn_color_ch7: TSpeedButton;
    btn_color_ch8: TSpeedButton;
    btn_color_ch9: TSpeedButton;
    btn_color_ch10: TSpeedButton;
    btn_color_ch11: TSpeedButton;
    btn_color_ch12: TSpeedButton;
    btn_color_ch13: TSpeedButton;
    btn_color_ch14: TSpeedButton;
    btn_color_ch15: TSpeedButton;
    btn_color_ch16: TSpeedButton;
    btn_color_ch17: TSpeedButton;
    btn_color_ch18: TSpeedButton;
    btn_color_ch19: TSpeedButton;
    btn_color_ch20: TSpeedButton;
    btn_color_ch21: TSpeedButton;
    btn_color_ch22: TSpeedButton;
    Label10: TLabel;
    edit_limits_memory: TSpinEdit;
    Label11: TLabel;
    Label2: TLabel;
    edit_users_banmail: TEdit;
    edit_napigator_delay: TSpinEdit;
    Label126: TLabel;
    edit_block_sign3: TEdit;
    edit_block_sign4: TEdit;
    edit_block_sign5: TEdit;
    panel_block_message: TPanel;
    lbl_block_message: TLabel;
    edit_block_message: TEdit;
    cb_block_custommessage: TRadioButton;
    cb_block_defaultmessage: TRadioButton;
    cb_block_nomessage: TRadioButton;
    cb_link_syncban: TCheckBox;
    Label127: TLabel;
    edit_main_remoteadmin: TEdit;
    cb_link_list2: TRadioButton;
    edit_link_list: TEdit;
    sh_links2: TTabSheet;
    Label80: TLabel;
    cb_link2_lagnosearch: TCheckBox;
    cb_link2_lagnosearchreq: TCheckBox;
    cb_link2_lagnobrowse: TCheckBox;
    cb_link2_lagnobrowsereq: TCheckBox;
    edit_link_outgoinglist: TEdit;
    cb_link_restrictoutgoing: TCheckBox;
    Label128: TLabel;
    edit_users_redirecturl: TEdit;
    cb_interface_systray: TCheckBox;
    cb_users_reconnect: TCheckBox;
    cb_channels_floodenable: TCheckBox;
    Label102: TLabel;
    edit_level_5: TEdit;
    cb_interface_chatmini: TCheckBox;
    cb_interface_wallop: TCheckBox;
    cb_log_console: TCheckBox;
    cb_log_dagsta: TCheckBox;
    sh_dagsta: TTabSheet;
    Label103: TLabel;
    edit_dagsta_host: TEdit;
    edit_dagsta_port: TSpinEdit;
    edit_dagsta_user: TEdit;
    btn_dagsta_password: TButton;
    Label129: TLabel;
    Label130: TLabel;
    Label131: TLabel;
    Label132: TLabel;
    Label133: TLabel;
    edit_dagsta_myip: TEdit;
    edit_dagsta_delay: TSpinEdit;
    Label134: TLabel;
    cb_dagsta_enabled: TCheckBox;
    btn_dagsta_disconnect: TButton;
    cb_dagsta_autodisconnect: TCheckBox;
    Label135: TLabel;
    Label136: TLabel;
    edit_color_dagsta: TksoSpectrumComboBox;
    edit_color_ch23: TSpeedButton;
    Label137: TLabel;
    edit_color_browse: TksoSpectrumComboBox;
    btn_color_ch24: TSpeedButton;
    Label51: TLabel;
    cb_share_checkdup: TCheckBox;
    cb_interface_nocpu: TCheckBox;
    edit_main_alias: TEdit;
    Label138: TLabel;
    cb_meta_enabled: TCheckBox;
    Label139: TLabel;
    Label141: TLabel;
    edit_meta_port: TSpinEdit;
    sh_blocked_winmx: TTabSheet;
    Label140: TLabel;
    cb_blockmx_normal: TCheckBox;
    cb_blockmx_limit: TCheckBox;
    cb_blockmx_detect: TCheckBox;
    edit_blockmx_quota: TSpinEdit;
    lbl_blockmx_percentage: TLabel;
    Label142: TLabel;
    edit_blockmx_bantime: TSpinEdit;
    Label143: TLabel;
    cb_log_browse: TCheckBox;
    list_napigator_myport: TComboBox;
    list_dagsta_myport: TComboBox;
    cb_block_mldonkey: TCheckBox;
    cb_block_Napigator: TCheckBox;
    cb_block_nap08: TCheckBox;
    cb_block_opennap: TCheckBox;
    cb_blockmx_jap: TCheckBox;
    cb_blockmx_pong: TCheckBox;
    sh_blocks: TTabSheet;
    cb_blocks_allow_share: TCheckBox;
    cb_blocks_allow_share_admins: TCheckBox;
    cb_blocks_checkmods: TCheckBox;
    Label144: TLabel;
    Edit_cons_autojoin1: TEdit;
    Label145: TLabel;
    Label146: TLabel;
    Edit_cons_autojoin2: TEdit;
    Edit_cons_autojoin3: TEdit;
    Label147: TLabel;
    cb_link_syncblock: TCheckBox;
    Label148: TLabel;
    cb_report_truestats: TCheckBox;
    cb_share_friendadd: TCheckBox;
    edit_share_friendadd: TSpinEdit;
    Label149: TLabel;
    Label150: TLabel;
    cb_link_maxservers: TCheckBox;
    edit_link_maxservers: TSpinEdit;
    Label151: TLabel;
    cb_interface_wallopsound: TCheckBox;
    cb_interface_remoteadminok: TCheckBox;
    Label152: TLabel;
    edit_interface_remotepass: TEdit;
    cb_blockmx_ban: TCheckBox;
    sh_other2: TTabSheet;
    gb_searchblock: TGroupBox;
    cb_searchblock_chkfiles: TCheckBox;
    cb_searchblock_chksize: TCheckBox;
    rd_searchblock_hard: TRadioButton;
    rd_searchblock_normal: TRadioButton;
    edit_searchblock_files: TSpinEdit;
    edit_searchblock_size: TSpinEdit;
    gb_domblock: TGroupBox;
    cb_domblock_chkfiles: TCheckBox;
    cb_domblock_chksize: TCheckBox;
    rd_domblock_hard: TRadioButton;
    rd_domblock_normal: TRadioButton;
    edit_domblock_files: TSpinEdit;
    edit_domblock_size: TSpinEdit;
    Label153: TLabel;
    Label154: TLabel;
    gb_dlfloodblock: TGroupBox;
    rd_dlfloodblock_block: TRadioButton;
    rd_dlfloodblock_leech: TRadioButton;
    rd_dlfloodblock_ban: TRadioButton;
    edit_dlfloodblock: TSpinEdit;
    edit_dlfloodblock_bantime: TComboBox;
    gb_wqfloodblock: TGroupBox;
    rd_wqfloodblock_block: TRadioButton;
    rd_wqfloodblock_leech: TRadioButton;
    rd_wqfloodblock_ban: TRadioButton;
    edit_wqfloodblock: TSpinEdit;
    edit_wqfloodblock_bantime: TComboBox;
    cb_nocount_text: TCheckBox;
    cb_autoban_incomplete: TCheckBox;
    cb_disable_fakeext: TCheckBox;
    edit_fakeext: TEdit;
    cb_enable_trapport: TCheckBox;
    edit_trapport: TEdit;
    cb_block_transferport: TCheckBox;
    edit_blocked_transferport: TEdit;
    cb_share_matchedfile_only: TCheckBox;
    sh_other3: TTabSheet;
    GroupBox1: TGroupBox;
    cb_enable_loginim: TCheckBox;
    Label155: TLabel;
    edit_loginimbot: TEdit;
    edit_loginim: TMemo;
    cb_channels_forceenter: TCheckBox;
    edit_channels_forceenter: TEdit;
    Label156: TLabel;
    cb_allow_2bytename: TCheckBox;
    cb_check_loginpass: TCheckBox;
    edit_loginpass: TEdit;
    Label157: TLabel;
    cb_enable_msgserv: TCheckBox;
    cb_restrict_hitperuser: TCheckBox;
    edit_hitperuser: TSpinEdit;
    Label158: TLabel;
    cb_refresh_servers: TCheckBox;
    edit_servreftime: TSpinEdit;
    Label159: TLabel;
    rd_xbutton_attr: TRadioGroup;
    Label160: TLabel;
    cb_minshare_noblockact: TCheckBox;
    sh_other4: TTabSheet;
    cb_regsoft_only: TCheckBox;
    cb_allow_napster: TCheckBox;
    cb_allow_winmx: TCheckBox;
    cb_allow_napchan: TCheckBox;
    cb_allow_lopster: TCheckBox;
    cb_allow_xnap: TCheckBox;
    cb_allow_utatane: TCheckBox;
    cb_allow_2get: TCheckBox;
    cb_allow_other: TCheckBox;
    edit_allow_sign0: TEdit;
    edit_allow_sign1: TEdit;
    edit_allow_sign2: TEdit;
    edit_allow_sign3: TEdit;
    edit_allow_sign4: TEdit;
    cb_allow_teknap: TCheckBox;
    cb_kill_idleuser: TCheckBox;
    cb_deny_listall_for_users: TCheckBox;
    cb_block_weird_xnapfile: TCheckBox;
    edit_kill_idleuser_time: TSpinEdit;
    Label161: TLabel;
    Label162: TLabel;
    cb_suggest_dbrowse: TCheckBox;
    edit_log_folder: TEdit;
    btn_log_folder: TButton;
    Label163: TLabel;
    procedure Panel3Resize(Sender: TObject);
    procedure headerPaint(Sender: TObject);
    procedure SetTopText(str: String);
    procedure btn_closeClick(Sender: TObject);
    procedure btn_restoreClick(Sender: TObject);
    procedure SetChange(change: Boolean);
    procedure CreateParams(Var params: TCreateParams);override;
    procedure treeChange(Sender: TObject; Node: TTreeNode);
    procedure sh_mainShow(Sender: TObject);
    procedure sh_usersShow(Sender: TObject);
    procedure cb_users_reg_onlyClick(Sender: TObject);
    procedure sh_limitsShow(Sender: TObject);
    procedure sh_interfaceShow(Sender: TObject);
    procedure sh_logShow(Sender: TObject);
    procedure cb_log_saveClick(Sender: TObject);
    procedure sh_shareShow(Sender: TObject);
    procedure sh_share_mp3Show(Sender: TObject);
    procedure sh_share_audioShow(Sender: TObject);
    procedure sh_share_videoShow(Sender: TObject);
    procedure sh_share_imagesShow(Sender: TObject);
    procedure sh_share_appsShow(Sender: TObject);
    procedure sh_share_cdShow(Sender: TObject);
    procedure sh_share_textShow(Sender: TObject);
    procedure sh_napigatorShow(Sender: TObject);
    procedure sh_searchShow(Sender: TObject);
    procedure sh_levelsShow(Sender: TObject);
    procedure btn_changeClick(Sender: TObject);
    procedure sh_channelsShow(Sender: TObject);
    procedure btn_level_defaultClick(Sender: TObject);
    procedure btn_napigator_disconnectClick(Sender: TObject);
    procedure btn_napigator_passwordClick(Sender: TObject);
    procedure sh_consoleShow(Sender: TObject);
    procedure sh_blockedShow(Sender: TObject);
    procedure cb_log_serverstatsClick(Sender: TObject);
    procedure cb_block_custommessageClick(Sender: TObject);
    procedure sh_linksShow(Sender: TObject);
    procedure cb_search_disable_remoteClick(Sender: TObject);
    procedure sh_socketsShow(Sender: TObject);
    procedure cb_sockets_users_defClick(Sender: TObject);
    procedure cb_sockets_servers_defClick(Sender: TObject);
    procedure sh_reportShow(Sender: TObject);
    procedure sh_otherShow(Sender: TObject);
    procedure sh_minshareShow(Sender: TObject);
    procedure cb_minshare_onlyfullClick(Sender: TObject);
    procedure sh_motdShow(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sh_colorsShow(Sender: TObject);
    procedure btn_colors_defaultClick(Sender: TObject);
    procedure btn_color_chClick(Sender: TObject);
    procedure sh_links2Show(Sender: TObject);
    procedure cb_channels_floodenableClick(Sender: TObject);
    procedure sh_dagstaShow(Sender: TObject);
    procedure btn_dagsta_disconnectClick(Sender: TObject);
    procedure Label137Click(Sender: TObject);
    procedure cb_blockmx_limitClick(Sender: TObject);
    procedure sh_blocked_winmxShow(Sender: TObject);
    procedure edit_main_aliasChange(Sender: TObject);
    procedure sh_blocksShow(Sender: TObject);
    procedure cb_share_friendaddClick(Sender: TObject);
    procedure cb_link_maxserversClick(Sender: TObject);
    procedure cb_interface_remoteadminokClick(Sender: TObject);
    procedure cb_blockmx_detectClick(Sender: TObject);
    procedure cb_blockmx_banClick(Sender: TObject);
    procedure sh_other2Show(Sender: TObject);
    procedure cb_searchblock_chkfilesClick(Sender: TObject);
    procedure cb_searchblock_chksizeClick(Sender: TObject);
    procedure cb_domblock_chkfilesClick(Sender: TObject);
    procedure cb_domblock_chksizeClick(Sender: TObject);
    procedure rd_dlfloodblock_banClick(Sender: TObject);
    procedure rd_dlfloodblock_blockClick(Sender: TObject);
    procedure rd_dlfloodblock_leechClick(Sender: TObject);
    procedure rd_wqfloodblock_banClick(Sender: TObject);
    procedure rd_wqfloodblock_blockClick(Sender: TObject);
    procedure rd_wqfloodblock_leechClick(Sender: TObject);
    procedure cb_disable_fakeextClick(Sender: TObject);
    procedure cb_enable_trapportClick(Sender: TObject);
    procedure cb_block_transferportClick(Sender: TObject);
    procedure sh_other3Show(Sender: TObject);
    procedure cb_channels_forceenterClick(Sender: TObject);
    procedure cb_check_loginpassClick(Sender: TObject);
    procedure cb_restrict_hitperuserClick(Sender: TObject);
    procedure cb_refresh_serversClick(Sender: TObject);
    procedure cb_minshare_banClick(Sender: TObject);
    procedure cb_allow_otherClick(Sender: TObject);
    procedure sh_other4Show(Sender: TObject);
    procedure cb_kill_idleuserClick(Sender: TObject);
    procedure btn_log_folderClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetBanItems(control: TComboBox);
    function  GetBanID(control: TComboBox): Integer;
    function  GetBanIndex(t: Integer): Integer;
  public
    { Public declarations }
    top_text: String;
    procedure ChangeColors;
    procedure ChangeInterface;
  end;

function BrowseCallbackProc(hWnd: HWND; uMsg: UINT; lParam, lpData: lParam): Integer stdCall;

var
  SlavaNapSettings: TSlavaNapSettings;
  BrowseInfo: TBrowseInfo;

implementation

uses
 stypes, vars, constants, mainform, bans, handler, lang, users, editdialog,
 servers, channels, winsock, blcksock, memory_manager, languages;

{$R *.DFM}

const
 DATA_MAIN          = pointer(1);
 DATA_SOCKETS       = pointer(2);
 DATA_USERS         = pointer(3);
 DATA_LIMITS        = pointer(4);
 DATA_SEARCH        = pointer(5);
 DATA_CHANNELS      = pointer(6);
 DATA_LINKS         = pointer(7);
 DATA_NAPIGATOR     = pointer(8);
 DATA_LEVELS        = pointer(9);
 DATA_BLOCKED       = pointer(10);
 DATA_MOTD          = pointer(11);
 DATA_INTERFACE     = pointer(12);
 DATA_CONSOLE       = pointer(13);
 DATA_LOG           = pointer(14);
 DATA_SHARE         = pointer(15);
 DATA_SHARE_MP3     = pointer(16);
 DATA_SHARE_AUDIO   = pointer(17);
 DATA_SHARE_VIDEO   = pointer(18);
 DATA_SHARE_IMAGES  = pointer(19);
 DATA_SHARE_APP     = pointer(20);
 DATA_SHARE_CD      = pointer(21);
 DATA_SHARE_TEXT    = pointer(22);
 DATA_SHARE_MINSHARE = pointer(23);
 DATA_OTHER         = pointer(24);
 DATA_REPORT        = pointer(25);
 DATA_COLORS        = pointer(26);
 DATA_LINKS2        = pointer(27);
 DATA_DAGSTA        = pointer(28);
 DATA_BLOCKEDMX     = pointer(29);
 DATA_BLOCKS        = pointer(30);
 DATA_OTHER2        = pointer(31);
 DATA_OTHER3        = pointer(32);
 DATA_OTHER4        = pointer(33);

procedure TSlavaNapSettings.CreateParams(Var params: TCreateParams);
begin
  inherited CreateParams( params );
  params.ExStyle := params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapSettings.Panel3Resize(Sender: TObject);
begin
 header.Width:=Panel3.Width - 16;
end;

procedure TSlavaNapSettings.headerPaint(Sender: TObject);
var
 b,b1: TBitmap;
 i,j,w,h,x: Integer;
 c,c1,c2: TColor;
 r: TRect;
begin
 try
  w:=header.Width;
  h:=header.Height;
  r:=Rect(0,0,w,h);
  b:=CreateTBitmap;
  b1:=CreateTBitmap;
  try
    b.Width:=w;
    b.Height:=h;
    b1.Width:=w;
    b1.Height:=h;
    stypes.GradientFill(b.canvas.handle,r,$00C04B94,clBtnFace,128,false);
    b.Canvas.Pen.Color:=clBtnFace;
    b.Canvas.MoveTo(0,0);
    b.Canvas.LineTo(w-1,0);
    b.Canvas.MoveTo(w-1,h-1);
    b.Canvas.LineTo(0,h-1);
    b.Canvas.LineTo(0,h-2);
    b.Canvas.Pen.Color:=countcolor(b.Canvas.Pixels[1,0],$00C04B94,1,1);
    b.Canvas.LineTo(0,0);
    b.Canvas.font.Assign(header.font);
    b.Canvas.Brush.Style:=bsClear;
    b.Canvas.Font.Color:=CountColor($00C04B94,clBlack,1,1);
    b.Canvas.TextOut(11,5,top_text);
    b1.Canvas.CopyRect(r,b.canvas,r);
    x:=b.Canvas.TextWidth(top_text)+15;
    for i:=2 to x do // blur (my own, not gaussian)  ;-)
     for j:=2 to h-3 do
     begin
       c:=b1.Canvas.Pixels[i,j];
       c1:=countcolor(b1.Canvas.Pixels[i+1,j],b1.Canvas.Pixels[i-1,j],1,1);
       c2:=countcolor(b1.Canvas.Pixels[i,j+1],b1.Canvas.Pixels[i,j-1],1,1);
       c1:=countcolor(c1,c2,1,1);
       b.Canvas.Pixels[i,j]:=countcolor(c,c1,1,4);
     end;
    // blur borders
    for i:=1 to w-2 do
    begin
      // top
      c:=b1.Canvas.Pixels[i,0];
      c1:=countcolor(b1.Canvas.Pixels[i+1,1],b1.Canvas.Pixels[i-1,1],1,1);
      c2:=countcolor(b1.Canvas.Pixels[i,2],b1.Canvas.Pixels[i,0],1,1);
      c1:=countcolor(c1,c2,1,1);
      b.Canvas.Pixels[i,1]:=countcolor(c,c1,1,4);
      // bottom
      c:=b1.Canvas.Pixels[i,h-1];
      c1:=countcolor(b1.Canvas.Pixels[i+1,h-2],b1.Canvas.Pixels[i-1,h-2],1,1);
      c2:=countcolor(b1.Canvas.Pixels[i,h-3],b1.Canvas.Pixels[i,h-1],1,1);
      c1:=countcolor(c1,c2,1,1);
      b.Canvas.Pixels[i,h-2]:=countcolor(c,c1,1,4);
    end;
    b.Canvas.Font.Color:=clWhite;
    b.Canvas.TextOut(10,4,top_text);
    header.Canvas.CopyRect(r,b.canvas,r);
   except
  end;
  FreeTBitmap(b);
  FreeTBitmap(b1);
  except
 end;
end;

procedure TSlavaNapSettings.SetTopText(str: String);
begin
 if top_text=str then exit;
 top_text:=str;
 try
  headerPaint(header);
  except
 end;
end;

procedure TSlavaNapSettings.FormCreate(Sender: TObject);
var
 i: Integer;
begin
 Height:=Height-90;
 for i:=0 to Ord(napSpeedT3) do
  edit_console_speed.Items.Add(Speed2Str(TNapSpeed(i)));
 SetBanItems(edit_dlfloodblock_bantime);
 SetBanItems(edit_wqfloodblock_bantime);
end;

procedure TSlavaNapSettings.FormShow(Sender: TObject);
var
 t,item,it1: TTreeNode;
begin
 ChangeInterface;
 Caption:=GetLangI(LNG_S_CAPTION);
 btn_restore.Caption:=GetLangI(LNG_S_BTN_RESTORE);
 btn_close.Caption:=GetLangI(LNG_S_BTN_CLOSE);
 lbl_change.Caption:=GetLangI(LNG_S_LBL_NOTE);
 pages.ActivePage:=sh_main;
 sh_mainShow(nil);
 ChangeColors;
 tree.Items.Clear;
 item:=tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_MAIN));
 item.Data:=DATA_MAIN;
 it1:=item;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SOCKETS));
       t.data:=DATA_SOCKETS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_USERS));
       t.data:=DATA_USERS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_LIMITS));
       t.data:=DATA_LIMITS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SEARCH));
       t.data:=DATA_SEARCH;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_CHANNELS));
       t.data:=DATA_CHANNELS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_LINKS));
       t.data:=DATA_LINKS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_LINKS2));
       t.data:=DATA_LINKS2;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_NAPIGATOR));
       t.data:=DATA_NAPIGATOR;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_DAGSTA));
       t.data:=DATA_DAGSTA;
       t:=tree.Items.Addchild(item,GetLangI(LNG_S_ITEM_LEVELS));
       t.data:=DATA_LEVELS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_BLOCKED));
       t.data:=DATA_BLOCKED;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_BLOCKEDMX));
       t.data:=DATA_BLOCKEDMX;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_MOTD));
       t.data:=DATA_MOTD;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_BLOCKS));
       t.data:=DATA_BLOCKS;
 item:=tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_INTERFACE));
       item.data:=DATA_INTERFACE;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_CONSOLE));
       t.data:=DATA_CONSOLE;
       t:=tree.Items.Addchild(item,GetLangI(LNG_S_ITEM_COLORS));
       t.data:=DATA_COLORS;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_LOG));
       t.data:=DATA_LOG;
 item.Expand(true);
 item:=tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_SHARE));
       item.data:=DATA_SHARE;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_MP3));
       t.data:=DATA_SHARE_MP3;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_AUDIO));
       t.data:=DATA_SHARE_AUDIO;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_VIDEO));
       t.data:=DATA_SHARE_VIDEO;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_IMAGES));
       t.data:=DATA_SHARE_IMAGES;
       t:=tree.Items.Addchild(item,GetLangI(LNG_S_ITEM_SHARE_APP));
       t.data:=DATA_SHARE_APP;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_CD));
       t.data:=DATA_SHARE_CD;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_SHARE_TEXT));
       t.data:=DATA_SHARE_TEXT;
       t:=tree.Items.Addchild(item,GetLangI(LNG_S_ITEM_MINSHARE));
       t.data:=DATA_SHARE_MINSHARE;
 item.Expand(true);
 item:=tree.Items.AddChild(nil, GetLangI(LNG_S_ITEM_OTHER));
       item.data:=DATA_OTHER;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_REPORT));
       t.data:=DATA_REPORT;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_OTHER2));
       t.Data:=DATA_OTHER2;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_OTHER3));
       t.Data:=DATA_OTHER3;
       t:=tree.Items.AddChild(item,GetLangI(LNG_S_ITEM_OTHER4));
       t.Data:=DATA_OTHER4;
 item.Expand(true);
 it1.Expand(true); // expand first item and focus it
end;

procedure TSlavaNapSettings.btn_closeClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapSettings.btn_restoreClick(Sender: TObject);
begin
 if assigned(pages.ActivePage.OnShow) then
  pages.ActivePage.OnShow(nil);
end;

procedure TSlavaNapSettings.SetChange(change: Boolean);
begin
 if change then
 begin
   btn_change.Caption:=GetLangI(LNG_S_BTN_CHANGE);
   lbl_note.Caption:=GetLangI(LNG_S_LBL_CHANGE);
   lbl_change.Visible:=false;
 end
 else
 begin
   btn_change.Caption:=GetLangI(LNG_S_BTN_SAVE);;
   lbl_note.Caption:=GetLangI(LNG_S_LBL_SAVE);;
   lbl_change.Visible:=true;
 end;
end;

procedure TSlavaNapSettings.treeChange(Sender: TObject; Node: TTreeNode);
begin
 if node=nil then exit;
 if not node.Selected then exit;
 if node.data=DATA_MAIN then pages.ActivePage:=sh_main
 else if node.data=DATA_USERS then pages.ActivePage:=sh_users
 else if node.data=DATA_LIMITS then pages.ActivePage:=sh_limits
 else if node.data=DATA_INTERFACE then pages.ActivePage:=sh_interface
 else if node.data=DATA_LOG then pages.ActivePage:=sh_log
 else if node.data=DATA_SHARE then pages.ActivePage:=sh_share
 else if node.data=DATA_SHARE_MP3 then pages.ActivePage:=sh_share_mp3
 else if node.data=DATA_SHARE_AUDIO then pages.ActivePage:=sh_share_audio
 else if node.data=DATA_SHARE_VIDEO then pages.ActivePage:=sh_share_video
 else if node.data=DATA_SHARE_IMAGES then pages.ActivePage:=sh_share_images
 else if node.data=DATA_SHARE_APP then pages.ActivePage:=sh_share_apps
 else if node.data=DATA_SHARE_CD then pages.ActivePage:=sh_share_cd
 else if node.data=DATA_SHARE_TEXT then pages.ActivePage:=sh_share_text
 else if node.data=DATA_NAPIGATOR then pages.ActivePage:=sh_napigator
 else if node.data=DATA_DAGSTA then pages.ActivePage:=sh_dagsta
 else if node.data=DATA_SEARCH then pages.ActivePage:=sh_search
 else if node.data=DATA_LEVELS then pages.ActivePage:=sh_levels
 else if node.data=DATA_CHANNELS then pages.ActivePage:=sh_channels
 else if node.data=DATA_CONSOLE then pages.ActivePage:=sh_console
 else if node.data=DATA_BLOCKED then pages.ActivePage:=sh_blocked
 else if node.data=DATA_BLOCKEDMX then pages.ActivePage:=sh_blocked_winmx
 else if node.data=DATA_BLOCKS then pages.ActivePage:=sh_blocks
 else if node.data=DATA_LINKS then pages.ActivePage:=sh_links
 else if node.data=DATA_SOCKETS then pages.ActivePage:=sh_sockets
 else if node.data=DATA_OTHER then pages.ActivePage:=sh_other
 else if node.data=DATA_REPORT then pages.ActivePage:=sh_report
 else if node.data=DATA_SHARE_MINSHARE then pages.ActivePage:=sh_minshare
 else if node.data=DATA_MOTD then pages.ActivePage:=sh_motd
 else if node.data=DATA_COLORS then pages.ActivePage:=sh_colors
 else if node.data=DATA_LINKS2 then pages.ActivePage:=sh_links2
 else if node.data=DATA_OTHER2 then pages.ActivePage:=sh_other2
 else if node.data=DATA_OTHER3 then pages.ActivePage:=sh_other3
 else if node.data=DATA_OTHER4 then pages.ActivePage:=sh_other4;
end;

procedure TSlavaNapSettings.cb_users_reg_onlyClick(Sender: TObject);
begin
 cb_users_reg_allow.Visible:=cb_users_reg_only.Checked;
end;

procedure TSlavaNapSettings.cb_log_saveClick(Sender: TObject);
begin
 cb_log_users.Visible:=cb_log_save.Checked;
 cb_log_servers.Visible:=cb_log_save.Checked;
end;

procedure TSlavaNapSettings.sh_mainShow(Sender: TObject);
var
 ini: TIniFile;
begin
 SetTopText(GetLangI(LNG_S_TEXT_MAIN));
 SetChange(false);
 lbl_handle.Caption:='(current handle = '+IntToStr(myserverhandle)+')';
 lbl_handle.Font.Color:=clPurple;
 edit_main_remoteadmin.Text:=cons_reg_user;
 try
  ini:=TIniFile.Create(ApplicationDir+'config');
  except
  exit;
 end;
 edit_main_ports.Text:=ini.ReadString('Server','Ports',DEF_LISTEN_PORTS);
 edit_main_host.Text:=ini.ReadString('Server','ReportHost','localhost');
 edit_main_handle.Value:=ini.ReadInteger('Server','ServerHandle',0);
 edit_main_listenip.Text:=ini.ReadString('Server','SocketsInterface','0.0.0.0');
 edit_main_alias.Text:=trim(ini.ReadString('Server','Alias',''));
 ini.Free;
end;

procedure TSlavaNapSettings.sh_usersShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_USERS));
 SetChange(true);
 cb_users_reg_only.Visible:=not network_hub;
 cb_users_reg_only.Checked:=registered_only;
 cb_users_reg_allow.Checked:=allow_register;
 cb_users_reg_allow.Visible:=cb_users_reg_only.Checked;
 cb_users_noremote.Checked:=not accept_remote_users;
 edit_users_limit.Value:=max_users;
 edit_users_clones.Value:=max_clones;
 edit_users_logintimeout.Value:=timeout_login div 1000;
 edit_users_maxaccept.Value:=max_users_per_minute;
 cb_users_redirectcqex.Checked:=redirect_cqex;
 edit_users_banmail.Text:=banmail;
 edit_users_redirecturl.Text:=redirect_url;
 cb_users_reconnect.Checked:=reconnect_delay;
end;

procedure TSlavaNapSettings.sh_limitsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LIMITS));
 SetChange(true);
 edit_limits_stats.Value:=stats_delay div 1000;
 edit_limits_hotlist.Value:=max_hotlist;
 edit_limits_ignored.Value:=max_ignorelist;
 cb_limits_limitservers.Checked:=not bandwidth_limitservers;
 edit_limits_maxdown.Value:=bandwidth_maxdown;
 edit_limits_maxup.Value:=bandwidth_maxup;
 if win98 then 
  edit_limits_memory.Value:=memory_limit div 1048576
 else
  edit_limits_memory.Value:=0;
end;

procedure TSlavaNapSettings.sh_interfaceShow(Sender: TObject);
var
 reg: TRegistry;
 b: Boolean;
 str: String;
begin
 SetTopText(GetLangI(LNG_S_TEXT_INTERFACE));
 SetChange(true);
 edit_interface_remotepass.Text:=remote_adminpass;
 cb_interface_remoteadminok.Checked:=remote_admin_ok;
 edit_interface_remotepass.Visible:=remote_admin_ok;
 edit_interface_cpu.Value:=cpu_usage;
 cb_interface_nocpu.checked:=cpu_disable;
 cb_interface_noswitch.Checked:=not switch_chat;
 cb_interface_chatflash.Checked:=chat_flash;
 cb_interface_systray.Checked:=SlavaNapwindow.tray.active;
 cb_interface_chatmini.Checked:=chat_mini;
 cb_interface_wallop.Checked:=wallop_im;
 cb_interface_wallopsound.Checked:=wallop_sound;
 reg:=TRegistry.Create;
 b:=false;
 try
  reg.RootKey:=HKEY_LOCAL_MACHINE;
  reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run',true);
  str:=reg.ReadString('SlavaNap');
  if str<>'' then b:=true;
  except
 end;
 reg.Free;
 cb_interface_startup.Checked:=b;
end;

procedure TSlavaNapSettings.sh_logShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LOG));
 SetChange(true);
 cb_log_login.Checked:=log_login;
 cb_log_napigator.Checked:=log_napigator;
 cb_log_dagsta.Checked:=log_dagsta;
 cb_log_search.Checked:=log_search;
 cb_log_browse.Checked:=log_browse;
 cb_log_transfers.Checked:=log_transfers;
// cb_log_links.Checked:=log_links;
 cb_log_save.Checked:=log_to_file;
 cb_log_saveClick(nil);
 cb_log_users.Checked:=log_commands;
 cb_log_servers.Checked:=log_servercommands;
 cb_log_serverstats.Checked:=save_stats;
 cb_log_serverstatsClick(nil);
 cb_log_clearserverstats.Checked:=clear_serverstats;
 cb_log_clearclientstats.Checked:=clear_clientstats;
 cb_log_console.Checked:=log_console_data;
end;


procedure TSlavaNapSettings.sh_shareShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE));
 SetChange(true);
 edit_share_friendadd.Value:=share_auto_friendadd_minimum;
 edit_share_max.Value:=maxshare;
 edit_share_maxtotal.Value:=maxshare_total;
 edit_share_filename.Value:=minfilename;
 edit_share_duration.Value:=minduration;
 cb_share_friendadd.Checked:=auto_friendadd;
 label149.Visible:=cb_share_friendadd.Checked;
 label150.Visible:=cb_share_friendadd.Checked;
 edit_share_friendadd.Visible:=cb_share_friendadd.Checked;
 cb_share_disable.checked:=not allow_share;
 cb_share_inform.Checked:=shareinform;
 cb_share_nomodem.Checked:=share_nomodem;
 edit_share_maxindex.Value:=maxshareindex;
 cb_share_checkdup.Checked:=share_checkdup;
end;

procedure TSlavaNapSettings.sh_share_mp3Show(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_MP3));
 SetChange(true);
 edit_mp3_ext.Text:=ext_mp3;
 edit_mp3_max.Value:=maxshare_mp3;
 edit_mp3_minsize.Value:=minfilesize_mp3 div 1024;
 edit_mp3_maxsize.Value:=maxfilesize_mp3 div 1024;
 cb_mp3_320.Checked:=share_320;
 cb_mp3_256.checked:=share_256;
 cb_mp3_224.checked:=share_224;
 cb_mp3_192.checked:=share_192;
 cb_mp3_160.checked:=share_160;
 cb_mp3_128.checked:=share_128;
 cb_mp3_112.checked:=share_112;
 cb_mp3_96.checked:=share_96;
 cb_mp3_80.checked:=share_80;
 cb_mp3_64.checked:=share_64;
 cb_mp3_56.checked:=share_56;
 cb_mp3_48.checked:=share_48;
 cb_mp3_40.checked:=share_40;
 cb_mp3_32.checked:=share_32;
 cb_mp3_24.checked:=share_24;
 cb_mp3_0.checked:=share_unknown;
end;

procedure TSlavaNapSettings.sh_share_audioShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_AUDIO));
 SetChange(true);
 edit_audio_ext.Text:=ext_audio;
 edit_audio_max.Value:=maxshare_audio;
 edit_audio_minsize.Value:=minfilesize_audio div 1024;
 edit_audio_maxsize.Value:=maxfilesize_audio div 1024;
end;

procedure TSlavaNapSettings.sh_share_videoShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_VIDEO));
 SetChange(true);
 edit_video_ext.Text:=ext_video;
 edit_video_max.Value:=maxshare_video;
 edit_video_minsize.Value:=minfilesize_video div 1024;
 edit_video_maxsize.Value:=maxfilesize_video div 1024;
end;

procedure TSlavaNapSettings.sh_share_imagesShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_IMAGES));
 SetChange(true);
 edit_images_ext.Text:=ext_image;
 edit_images_max.Value:=maxshare_image;
 edit_images_minsize.Value:=minfilesize_image div 1024;
 edit_images_maxsize.Value:=maxfilesize_image div 1024;
end;

procedure TSlavaNapSettings.sh_share_appsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_APP));
 SetChange(true);
 edit_apps_ext.Text:=ext_app;
 edit_apps_max.Value:=maxshare_app;
 edit_apps_minsize.Value:=minfilesize_app div 1024;
 edit_apps_maxsize.Value:=maxfilesize_app div 1024;
end;

procedure TSlavaNapSettings.sh_share_cdShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_CD));
 SetChange(true);
 edit_cd_ext.Text:=ext_cd;
 edit_cd_max.Value:=maxshare_cd;
 edit_cd_minsize.Value:=minfilesize_cd div 1024;
 edit_cd_maxsize.Value:=maxfilesize_cd div 1024;
end;

procedure TSlavaNapSettings.sh_share_textShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SHARE_TEXT));
 SetChange(true);
 edit_text_ext.Text:=ext_text;
 edit_text_max.Value:=maxshare_text;
 edit_text_minsize.Value:=minfilesize_text div 1024;
 edit_text_maxsize.Value:=maxfilesize_text div 1024;
end;

procedure TSlavaNapSettings.sh_napigatorShow(Sender: TObject);
var
 i,j: Integer;
begin
 SetTopText(GetLangI(LNG_S_TEXT_NAPIGATOR));
 SetChange(true);
 edit_napigator_host.Text:=napigator_host;
 edit_napigator_port.Text:=napigator_port;
 edit_napigator_user.Text:=napigator_user;
 edit_napigator_myip.Text:=napigator_myip;
 cb_napigator_enabled.Checked:=napigator_enabled;
 cb_napigator_autodisconnect.Checked:=napigator_autodisconnect;
 edit_napigator_delay.Value:=napigator_delay div 60000;
 // setting up list of ports
 j:=0;
 list_napigator_myport.Items.Clear;
 for i:=0 to MAX_LISTEN_SOCKET do
 if server_port[i]<>0 then
 begin
  list_napigator_myport.Items.Add(IntToStr(server_port[i]));
  if server_port[i]=napigator_myport then j:=list_napigator_myport.Items.Count-1;
 end;
 if meta_enabled then
 begin
  list_napigator_myport.Items.Add(IntToStr(meta_port));
  if meta_port=napigator_myport then j:=list_napigator_myport.Items.Count-1;
 end;
 list_napigator_myport.ItemIndex:=j;
 list_napigator_myport.DropDownCount:=list_napigator_myport.Items.Count;
end;

procedure TSlavaNapSettings.sh_dagstaShow(Sender: TObject);
var
 i,j: Integer;
begin
 SetTopText(GetLangI(LNG_S_TEXT_DAGSTA));
 SetChange(true);
 edit_dagsta_host.Text:=dagsta_host;
 edit_dagsta_port.Text:=dagsta_port;
 edit_dagsta_user.Text:=dagsta_user;
 edit_dagsta_myip.Text:=dagsta_myip;
 cb_dagsta_enabled.Checked:=dagsta_enabled;
 cb_dagsta_autodisconnect.Checked:=dagsta_autodisconnect;
 edit_dagsta_delay.Value:=dagsta_delay div 60000;
 // setting up list of ports
 j:=0;
 list_dagsta_myport.Items.Clear;
 for i:=0 to MAX_LISTEN_SOCKET do
 if server_port[i]<>0 then
 begin
  list_dagsta_myport.Items.Add(IntToStr(server_port[i]));
  if server_port[i]=dagsta_myport then j:=list_dagsta_myport.Items.Count-1;
 end;
 if meta_enabled then
 begin
  list_dagsta_myport.Items.Add(IntToStr(meta_port));
  if meta_port=dagsta_myport then j:=list_dagsta_myport.Items.Count-1;
 end;
 list_dagsta_myport.ItemIndex:=j;
 list_dagsta_myport.DropDownCount:=list_dagsta_myport.Items.Count;
end;

procedure TSlavaNapSettings.sh_searchShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SEARCH));
 SetChange(true);
 edit_search_defsearch.Value:=defsearchresults;
 edit_search_maxsearch.Value:=maxsearchresults;
 edit_search_maxbrowse.Value:=maxbrowseresults;
 edit_search_maxremotebrowse.Value:=maxremotebrowse;
 edit_search_maxremote.Value:=maxremotesearchresults;
 edit_search_searchespm.Value:=flood_max_searches;
 cb_search_disable_remote.Checked:=disableremotesearch;
 cb_search_disable_remoteClick(nil);
end;

procedure TSlavaNapSettings.sh_levelsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LEVELS));
 SetChange(true);
 edit_level_0.Text:=levels[0];
 edit_level_1.Text:=levels[1];
 edit_level_2.Text:=levels[2];
 edit_level_3.Text:=levels[3];
 edit_level_4.Text:=levels[4];
 edit_level_5.Text:=levels[5];
end;

procedure TSlavaNapSettings.sh_channelsShow(Sender: TObject);
var
 ini: TIniFile;
begin
 SetTopText(GetLangI(LNG_S_TEXT_CHANNELS));
 SetChange(true);
 cb_channels_allowcreate.Checked:=allow_create_channels;
 edit_channels_max.Value:=max_channels;
 edit_channels_max2.Value:=max_channels_total;
 cb_channels_blockcqex.Checked:=block_cqex_chat;
 cb_channels_oldwallop.Checked:=old_opsay;
 edit_channels_maxprivmessage.Value:=max_privmsg_len;
 edit_channels_maxmessage.Value:=max_channelmsg_len;
 cb_channels_showops.checked:=show_operators;
 cb_channels_preventshout.Checked:=prevent_shouting;
 edit_channels_flood_user.Value:=flood_max_user_message;
 edit_channels_flood_same.Value:=flood_max_same_message;
 cb_channels_flood_warn.Checked:=flood_warning;
 cb_channels_floodenable.Checked:=flood_enable;
 cb_channels_floodenableClick(nil);
 try
  ini:=TIniFile.Create(ApplicationDir+'config');
  except
  exit;
 end;
 cb_channels_timestamp.Checked:=ini.ReadBool('Channels','TimeStamp',false);
 cb_channels_low.Checked:=ini.ReadBool('Channels','LowerCase',false);
 ini.Free;
end;

procedure TSlavaNapSettings.sh_consoleShow(Sender: TObject);
var
 ini: TIniFile;
begin
 SetTopText(GetLangI(LNG_S_TEXT_CONSOLE));
 SetChange(false);
 try
  ini:=TIniFile.Create(ApplicationDir+'config');
  except
  exit;
 end;
 edit_console_user.Text:=ini.ReadString('Console','User','Admin');
 if running then edit_console_speed.ItemIndex:=Ord(cons.data^.speed);
 edit_cons_autojoin1.text:=ini.ReadString('Console','AutoJoinRoom1','');
 edit_cons_autojoin2.text:=ini.ReadString('Console','AutoJoinRoom2','');
 edit_cons_autojoin3.text:=ini.ReadString('Console','AutoJoinRoom3','');
 ini.Free;
end;

procedure TSlavaNapSettings.sh_blockedShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_BLOCKED));
 SetChange(true);
 cb_block_napster.Checked:=blocked_clients[softNapster];
 cb_block_audiognome.Checked:=blocked_clients[softAudioGnome];
 cb_block_gnomeplus.Checked:=blocked_clients[softGnomePlus];
 cb_block_amster.Checked:=blocked_clients[softAmster];
 cb_block_filenavigator.Checked:=blocked_clients[softFileNavigator];
 cb_block_cqex.Checked:=blocked_clients[softCQEX];
 cb_block_sunshineun.checked:=blocked_clients[softSunshineUN];
 cb_block_teknap.checked:=blocked_clients[softTekNap];
 cb_block_nap.Checked:=blocked_clients[softNap];
 cb_block_macnap.Checked:=blocked_clients[softMacNap];
 cb_block_mp3rage.Checked:=blocked_clients[softMP3Rage];
 cb_block_xnap.Checked:=blocked_clients[softXNap];
 cb_block_spotlight.Checked:=blocked_clients[softSpotlight];
 cb_block_nfs.Checked:=blocked_clients[softNFS];
 cb_block_dmnapster.checked:=blocked_clients[softDMNapster];
 cb_block_knapster.Checked:=blocked_clients[softKNapster];
 cb_block_lopster.Checked:=blocked_clients[softLopster];
 cb_block_rapigator.Checked:=blocked_clients[softRapigator];
 cb_block_swaptor.Checked:=blocked_clients[softSwaptor];
 cb_block_dagsta.Checked:=blocked_clients[softDagsta];
 cb_block_drumbeat.Checked:=blocked_clients[softDrumbeat];
 cb_block_floodster.Checked:=blocked_clients[softFloodster];
 cb_block_mldonkey.Checked:=blocked_clients[softMlDonkey];
 cb_block_opennap.Checked:=blocked_clients[softOpennap];
 cb_block_napigator.Checked:=blocked_clients[softNapigator];
 cb_block_nap08.Checked:=blocked_clients[softNap08];
 cb_block_other.checked:=blocked_clients[softUnknown];
 case blocked_messagetype of
  blckCustom:  cb_block_custommessage.Checked:=true;
  blckNone:    cb_block_nomessage.Checked:=true;
  else cb_block_defaultmessage.Checked:=true;
 end;
 edit_block_message.Text:=blocked_message;
 edit_block_sign0.Text:=blocked_custom[0];
 edit_block_sign1.Text:=blocked_custom[1];
 edit_block_sign2.Text:=blocked_custom[2];
 edit_block_sign3.Text:=blocked_custom[3];
 edit_block_sign4.Text:=blocked_custom[4];
 edit_block_sign5.text:=blocked_custom[5];
 cb_block_custommessageClick(nil);
end;

procedure TSlavaNapSettings.sh_linksShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LINKS));
 SetChange(true);
  case allow_link of
   linkAll: cb_link_all.checked:=true;
   linkNone: cb_link_none.Checked:=true;
   linkCustom: cb_link_list2.Checked:=true;
   else cb_link_list.Checked:=true;
 end;
 edit_link_list.Text:=allowed_servers;
 cb_link_hub.Checked:=network_hub;
 cb_link_syncban.Checked:=hub_syncban;
 cb_link_syncreg.Checked:=hub_syncreg;
 cb_link_syncblock.Checked:=hub_syncblock;
 cb_link_noautoconnect.Checked:=autolink_only1;
 cb_link_restrictoutgoing.Checked:=restrict_outgoing;
 edit_link_outgoinglist.Text:=outgoing_list;
 cb_meta_enabled.checked:=meta_enabled;
 edit_meta_port.value:=meta_port;
 cb_link_maxservers.Checked:=max_servers_enabled;
 label151.Visible:=max_servers_enabled;
 edit_link_maxservers.Visible:=max_servers_enabled;
 edit_link_maxservers.Value:=max_servers;
 end;

procedure TSlavaNapSettings.sh_links2Show(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_LINKS2));
 SetChange(true);
 cb_link2_lagnosearch.Checked:=search_noforward_results;
 cb_link2_lagnosearchreq.Checked:=search_noforward_requests;
 cb_link2_lagnobrowse.Checked:=browse_noforward_results;
 cb_link2_lagnobrowsereq.Checked:=browse_noforward_requests;
end;

procedure TSlavaNapSettings.sh_socketsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_SOCKETS));
 SetChange(true);
 cb_sockets_users_def.Checked:=sockets_users_default;
 edit_sockets_users_send.Value:=sockets_users_send;
 edit_sockets_users_recv.Value:=sockets_users_recv;
 cb_sockets_users_defClick(nil);
 cb_sockets_servers_def.Checked:=sockets_servers_default;
 edit_sockets_servers_send.Value:=sockets_servers_send;
 edit_sockets_servers_recv.Value:=sockets_servers_recv;
 cb_sockets_servers_defClick(nil);
end;

procedure TSlavaNapSettings.sh_otherShow(Sender: TObject);
var
 i: Integer;
begin
 SetTopText(GetLangI(LNG_S_TEXT_OTHER));
 SetChange(true);
 cb_ann_enable.Checked:=ann_enabled;
 edit_ann_delay.Value:=ann_delay;
 edit_ann_user.Text:=ann_user;
 edit_ann_messages.Lines.Clear;
 for i:=0 to max_announcement do
  if ann_messages[i]<>'' then
   edit_ann_messages.Lines.Add(ann_messages[i]);
end;

procedure TSlavaNapSettings.sh_other2Show(Sender: TObject);
var
  ini: TIniFile;
begin
 SetTopText(GetLangI(LNG_S_TEXT_OTHER2));
 SetChange(true);

 cb_searchblock_chkfiles.Checked:=searchblock_chkfiles;
 cb_searchblock_chksize.Checked:=searchblock_chksize;
 edit_searchblock_files.Value:=searchblock_files;
 edit_searchblock_size.Value:=searchblock_size div MegaByte;
 rd_searchblock_hard.Enabled:=searchblock_chkfiles and searchblock_chksize;
 rd_searchblock_hard.Enabled:=searchblock_chkfiles and searchblock_chksize;
 rd_searchblock_hard.Checked:=searchblock_hard;
 rd_searchblock_normal.Checked:=not searchblock_hard;

 cb_domblock_chkfiles.Checked:=domblock_chkfiles;
 cb_domblock_chksize.Checked:=domblock_chksize;
 edit_domblock_files.Value:=domblock_files;
 edit_domblock_size.Value:=domblock_size div MegaByte;
 rd_domblock_hard.Enabled:=domblock_chkfiles and domblock_chksize;
 rd_domblock_hard.Enabled:=domblock_chkfiles and domblock_chksize;
 rd_domblock_hard.Checked:=domblock_hard;
 rd_domblock_normal.Checked:=not domblock_hard;

 case dlfloodblock_method of
   block: rd_dlfloodblock_block.Checked:=True;
   leech: rd_dlfloodblock_leech.Checked:=True;
   ban  : rd_dlfloodblock_ban.Checked:=True;
 end;
 edit_dlfloodblock.Value:=dlfloodblock_count;
 edit_dlfloodblock_bantime.Visible:=rd_dlfloodblock_ban.Checked;
 edit_dlfloodblock_bantime.ItemIndex:=GetBanIndex(dlfloodblock_bantime);

 case wqfloodblock_method of
   block: rd_wqfloodblock_block.Checked:=True;
   leech: rd_wqfloodblock_leech.Checked:=True;
   ban  : rd_wqfloodblock_ban.Checked:=True;
 end;
 edit_wqfloodblock.Value:=wqfloodblock_count;
 edit_wqfloodblock_bantime.Visible:=rd_wqfloodblock_ban.Checked;
 edit_wqfloodblock_bantime.ItemIndex:=GetBanIndex(wqfloodblock_bantime);

 cb_nocount_text.Checked:=nocount_text;
 cb_autoban_incomplete.Checked:=autoban_incomplete;
 cb_disable_fakeext.Checked:=disable_fakeext;
 edit_fakeext.Visible:=cb_disable_fakeext.Checked;
 edit_fakeext.Text:=fakeext;
 cb_enable_trapport.Checked:=enable_trapport;
 ini:=TIniFile.Create(Applicationdir+'config');
 try
   edit_trapport.Text:=ini.ReadString('Other2','TrapPort','8888 8875 7743');
  finally
   ini.Free;
 end;
 cb_block_transferport.Checked:=block_transferport;
 edit_blocked_transferport.Visible:=cb_block_transferport.Checked;
 edit_blocked_transferport.Text:=blocked_transferport;
 cb_share_matchedfile_only.Checked:=share_matchedfile_only;
end;

procedure TSlavaNapSettings.sh_other3Show(Sender: TObject);
var
  i: Integer;
begin
 SetTopText(GetLangI(LNG_S_TEXT_OTHER3));
 SetChange(true);
 cb_enable_loginim.Checked:=enable_loginim;
 edit_loginimbot.Text:=loginimbot;
 edit_loginim.Lines.Clear;
 for i:=0 to MAX_LOGINIM do
   if loginim[i]<>'' then
     edit_loginim.Lines.Add(loginim[i]);
 cb_channels_forceenter.Checked:=force_enter;
 edit_channels_forceenter.Text:=force_enter_channel;
 cb_allow_2bytename.Checked:=allow_2bytename;
 cb_check_loginpass.Checked:=check_loginpass;
 edit_loginpass.Text:=loginpass;
 edit_loginpass.Visible:=cb_check_loginpass.Checked;
 Label157.Visible:=cb_check_loginpass.Checked;
 cb_enable_msgserv.Checked:=enable_msgserv;
 cb_restrict_hitperuser.Checked:=restrict_hitperuser;
 edit_hitperuser.Value:=maxhitperuser;
 edit_hitperuser.Visible:=cb_restrict_hitperuser.Checked;
 Label158.Visible:=cb_restrict_hitperuser.Checked;
 cb_refresh_servers.Checked:=SlavaNapWindow.cb_servers_refresh.Checked;
 edit_servreftime.Value:=SlavaNapWindow.Timer3.Interval div 1000;
 edit_servreftime.Visible:=cb_refresh_servers.Checked;
 Label159.Visible:=cb_refresh_servers.Checked;
 case b3_canclose of
   Unknown3: rd_xbutton_attr.ItemIndex:=0;
   True3:    rd_xbutton_attr.ItemIndex:=1;
   False3:   rd_xbutton_attr.ItemIndex:=2;
 end;
 cb_minshare_noblockact.Checked:=minshare_noblockact;
 cb_kill_idleuser.Checked:=kill_idleuser;
 edit_kill_idleuser_time.Value:=kill_idleuser_time div 60000;
 Label161.Visible:=cb_kill_idleuser.Checked;
 Label162.Visible:=cb_kill_idleuser.Checked;
 edit_kill_idleuser_time.Visible:=cb_kill_idleuser.Checked;
 cb_deny_listall_for_users.Checked:=not listall_for_users;
 cb_block_weird_xnapfile.Checked:=block_weird_xnapfile;
 cb_suggest_dbrowse.Checked:=suggest_dbrowse;
end;

procedure TSlavaNapSettings.sh_other4Show(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_OTHER4));
 SetChange(true);
 cb_regsoft_only.Checked:=regsoft_only;
 cb_allow_2get.Checked   :=allowed_clients[soft2get];
 cb_allow_lopster.Checked:=allowed_clients[softLopster];
 cb_allow_napchan.Checked:=allowed_clients[softNapchan];
 cb_allow_napster.Checked:=allowed_clients[softNapster];
 cb_allow_teknap.Checked :=allowed_clients[softTekNap];
 cb_allow_utatane.Checked:=allowed_clients[softUtatane];
 cb_allow_winmx.Checked  :=allowed_clients[softWinMXNormal];
 cb_allow_xnap.Checked   :=allowed_clients[softXNap];
 cb_allow_other.checked:=allowed_clients[softUnknown];
 edit_allow_sign0.Text:=allowed_custom[0];
 edit_allow_sign1.Text:=allowed_custom[1];
 edit_allow_sign2.Text:=allowed_custom[2];
 edit_allow_sign3.Text:=allowed_custom[3];
 edit_allow_sign4.Text:=allowed_custom[4];
 edit_allow_sign0.Visible:=cb_allow_other.Checked;
 edit_allow_sign1.Visible:=cb_allow_other.Checked;
 edit_allow_sign2.Visible:=cb_allow_other.Checked;
 edit_allow_sign3.Visible:=cb_allow_other.Checked;
 edit_allow_sign4.Visible:=cb_allow_other.Checked;
 edit_log_folder.Text:=log_folder;
end;

procedure TSlavaNapSettings.sh_reportShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_REPORT));
 SetChange(true);
 cb_report_old_enable.Checked:=old_report_enabled;
 edit_report_old_port.Value:=old_report_port;
 cb_report_new_enabled.Checked:=new_report_enabled;
 edit_report_new_port.Value:=new_report_port;
 cb_report_new_hidehub.Checked:=new_report_hide_hub;
 cb_report_truestats.Checked:=true_stats;
end;

procedure TSlavaNapSettings.sh_minshareShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_MINSHARE));
 SetChange(true);
 edit_minshare_minshare.Value:=minshare;
 edit_minshare_delay.Value:=minshare_delay div 60000;
 cb_minshare_ban.Checked:=minshare_ban;
 cb_minshare_banip.Checked:=minshare_banip;
 Label160.Visible:=cb_minshare_ban.Checked;
 edit_minshare_bantime.Visible:=cb_minshare_ban.Checked;
 edit_minshare_bantime.Value:=minshare_bantime div 60;
 cb_minshare_onlyfull.checked:=minshare_fullonly;
 cb_minshare_full10.Checked:=minshare_only10;
 edit_minshare_minsharesize.Value:=minshare_size div MegaByte;
 cb_minshare_onlyfullClick(nil);
 cb_minshare_kickchat.Checked:=minshare_kickchat;
 cb_minshare_wallop.Checked:=wallop_serverban;
end;

procedure TSlavaNapSettings.sh_motdShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_MOTD));
 SetChange(true);
 edit_motd.Lines.Clear;
 try
  edit_motd.Lines.LoadFromFile(ApplicationDir+'motd');
  except
 end;
end;

procedure TSlavaNapSettings.sh_colorsShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_COLORS));
 SetChange(true);
 edit_color_bg.ColorValue:=slBackground;
 edit_color_text.ColorValue:=slText;
 edit_color_chat.ColorValue:=slChatMessage;
 edit_color_mychat.ColorValue:=slChatMyMessage;
 edit_color_channelchat.ColorValue:=slChannelMessage;
 edit_color_mychannelchat.ColorValue:=slChannelMyMessage;
 edit_color_emote.ColorValue:=slChannelEmote;
 edit_color_myemote.ColorValue:=slChannelMyEmote;
 edit_color_join.ColorValue:=slChannelJoin;
 edit_color_part.ColorValue:=slChannelPart;
 edit_color_topic.ColorValue:=slTopic;
 edit_color_debug.ColorValue:=slDebugData;
 edit_color_error.ColorValue:=slError;
 edit_color_wallop.ColorValue:=slWallop;
 edit_color_announce.ColorValue:=slAnnounce;
 edit_color_online.ColorValue:=slOnline;
 edit_color_offline.ColorValue:=slOffline;
 edit_color_search.ColorValue:=slSearch;
 edit_color_browse.ColorValue:=slBrowse;
 edit_color_transfer.ColorValue:=slTransfer;
 edit_color_napigator.ColorValue:=slNapigator;
 edit_color_dagsta.ColorValue:=slDagsta;
 edit_color_pong.ColorValue:=slPong;
 edit_color_whowas.ColorValue:=slWhoWas;
end;

procedure TSlavaNapSettings.btn_changeClick(Sender: TObject);
var
 ini: TIniFile;
 reg: TRegistry;
 i: Integer;
 logfilename: String;
 p: PStringHashItem;
 ch: TChannel;
begin
 if pages.ActivePage=sh_main then
 try
   listen_interface:=edit_main_listenip.Text;
   cons_reg_user:=edit_main_remoteadmin.Text;
   ini:=TIniFile.Create(ApplicationDir+'config');
   ini.WriteString('Server','Ports',edit_main_ports.Text);
   ini.WriteString('Server','ReportHost',edit_main_host.Text);
   ini.WriteInteger('Server','ServerHandle',edit_main_handle.Value);
   ini.WriteString('Server','SocketsInterface',listen_interface);
   if edit_main_alias.Text=servername_i then
    ini.DeleteKey('Server','Alias')
   else
    ini.WriteString('Server','Alias',edit_main_alias.Text);
   ini.Free;
  except
 end else if pages.ActivePage=sh_colors then
 try
   slBackground:=edit_color_bg.ColorValue;
   slText:=edit_color_text.ColorValue;
   slChatMessage:=edit_color_chat.ColorValue;
   slChatMyMessage:=edit_color_mychat.ColorValue;
   slChannelMessage:=edit_color_channelchat.ColorValue;
   slChannelMyMessage:=edit_color_mychannelchat.ColorValue;
   slChannelEmote:=edit_color_emote.ColorValue;
   slChannelMyEmote:=edit_color_myemote.ColorValue;
   slChannelJoin:=edit_color_join.ColorValue;
   slChannelPart:=edit_color_part.ColorValue;
   slTopic:=edit_color_topic.ColorValue;
   slDebugData:=edit_color_debug.ColorValue;
   slError:=edit_color_error.ColorValue;
   slWallop:=edit_color_wallop.ColorValue;
   slAnnounce:=edit_color_announce.ColorValue;
   slOnline:=edit_color_online.ColorValue;
   slOffline:=edit_color_offline.ColorValue;
   slSearch:=edit_color_search.ColorValue;
   slBrowse:=edit_color_browse.ColorValue;
   slTransfer:=edit_color_transfer.ColorValue;
   slNapigator:=edit_color_napigator.ColorValue;
   slDagsta:=edit_color_dagsta.ColorValue;
   slPong:=edit_color_pong.ColorValue;
   slWhoWas:=edit_color_whowas.ColorValue;
   ChangeColors;
   if running then SlavaNapWindow.SetColors(true);
  except
 end else if pages.ActivePage=sh_users then
 try
   registered_only:=cb_users_reg_only.Checked;
   allow_register:=cb_users_reg_allow.Checked;
   max_users:=edit_users_limit.Value;
   max_clones:=edit_users_clones.Value;
   timeout_login:=Int64(edit_users_logintimeout.Value) * 1000;
   max_users_per_minute:=edit_users_maxaccept.Value;
   accept_remote_users:=not cb_users_noremote.Checked;
   redirect_cqex:=cb_users_redirectcqex.Checked;
   banmail:=edit_users_banmail.Text;
   redirect_url:=edit_users_redirecturl.Text;
   reconnect_delay:=cb_users_reconnect.Checked;
  except
 end else if pages.ActivePage=sh_limits then
 try
   stats_delay:=Int64(edit_limits_stats.Value) * 1000;
   max_hotlist:=edit_limits_hotlist.Value;
   max_ignorelist:=edit_limits_ignored.Value;
   bandwidth_maxdown:=edit_limits_maxdown.Value;
   bandwidth_maxup:=edit_limits_maxup.Value;
   bandwidth_limitservers:=not cb_limits_limitservers.Checked;
   if win98 then
    memory_limit:=1048576 * Int64(edit_limits_memory.Value)
   else
    memory_limit:=0;
  except
 end else if pages.ActivePage=sh_log then
 try
   log_login:=cb_log_login.Checked;
   log_napigator:=cb_log_napigator.Checked;
   log_dagsta:=cb_log_dagsta.Checked;
   log_search:=cb_log_search.Checked;
   log_browse:=cb_log_browse.Checked;
   log_transfers:=cb_log_transfers.Checked;
//   log_links:=cb_log_links.Checked;
   log_to_file:=cb_log_save.Checked;
   log_commands:=cb_log_users.Checked;
   log_servercommands:=cb_log_servers.Checked;
   save_stats:=cb_log_serverstats.Checked;
   clear_serverstats:=cb_log_clearserverstats.Checked;
   clear_clientstats:=cb_log_clearclientstats.Checked;
   log_console_data:=cb_log_console.Checked;
  except
 end else if pages.ActivePage=sh_share then
 try
   maxshare:=edit_share_max.Value;
   maxshare_total:=edit_share_maxtotal.Value;
   minfilename:=edit_share_filename.Value;
   minduration:=edit_share_duration.Value;
   share_auto_friendadd_minimum:=edit_share_friendadd.Value;
   auto_friendadd:=cb_share_friendadd.Checked;
   allow_share:=not cb_share_disable.checked;
   shareinform:=cb_share_inform.Checked;
   share_nomodem:=cb_share_nomodem.Checked;
   maxshareindex:=edit_share_maxindex.Value;
   share_checkdup:=cb_share_checkdup.Checked;
  except
 end else if pages.ActivePage=sh_share_mp3 then
 try
   ext_mp3:=edit_mp3_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_mp3:=edit_mp3_max.Value;
   minfilesize_mp3:=Int64(edit_mp3_minsize.Value) * 1024;
   maxfilesize_mp3:=Int64(edit_mp3_maxsize.Value) * 1024;
   share_320:=cb_mp3_320.Checked;
   share_256:=cb_mp3_256.checked;
   share_224:=cb_mp3_224.checked;
   share_192:=cb_mp3_192.checked;
   share_160:=cb_mp3_160.checked;
   share_128:=cb_mp3_128.checked;
   share_112:=cb_mp3_112.checked;
   share_96:=cb_mp3_96.checked;
   share_80:=cb_mp3_80.checked;
   share_64:=cb_mp3_64.checked;
   share_56:=cb_mp3_56.checked;
   share_48:=cb_mp3_48.checked;
   share_40:=cb_mp3_40.checked;
   share_32:=cb_mp3_32.checked;
   share_24:=cb_mp3_24.checked;
   share_unknown:=cb_mp3_0.checked;
  except
 end else if pages.ActivePage=sh_share_audio then
 try
   ext_audio:=edit_audio_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_audio:=edit_audio_max.Value;
   minfilesize_audio:=Int64(edit_audio_minsize.Value) * 1024;
   maxfilesize_audio:=Int64(edit_audio_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_video then
 try
   ext_video:=edit_video_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_video:=edit_video_max.Value;
   minfilesize_video:=Int64(edit_video_minsize.Value) * 1024;
   maxfilesize_video:=Int64(edit_video_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_images then
 try
   ext_image:=edit_images_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_image:=edit_images_max.Value;
   minfilesize_image:=Int64(edit_images_minsize.Value) * 1024;
   maxfilesize_image:=Int64(edit_images_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_apps then
 try
   ext_app:=edit_apps_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_app:=edit_apps_max.Value;
   minfilesize_app:=Int64(edit_apps_minsize.Value) * 1024;
   maxfilesize_app:=Int64(edit_apps_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_cd then
 try
   ext_cd:=edit_cd_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_cd:=edit_cd_max.Value;
   minfilesize_cd:=Int64(edit_cd_minsize.Value) * 1024;
   maxfilesize_cd:=Int64(edit_cd_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_share_text then
 try
   ext_text:=edit_text_ext.Text;
   if running then cmd_list.AddDoublecmd(MSG_CMD_REFRESHTYPES,0,'','');
   maxshare_text:=edit_text_max.Value;
   minfilesize_text:=Int64(edit_text_minsize.Value) * 1024;
   maxfilesize_text:=Int64(edit_text_maxsize.Value) * 1024;
  except
 end else if pages.ActivePage=sh_search then
 try
   defsearchresults:=edit_search_defsearch.Value;
   maxsearchresults:=edit_search_maxsearch.Value;
   maxbrowseresults:=edit_search_maxbrowse.Value;
   maxremotebrowse:=edit_search_maxremotebrowse.Value;
   flood_max_searches:=edit_search_searchespm.Value;
   disableremotesearch:=cb_search_disable_remote.Checked;
   maxremotesearchresults:=edit_search_maxremote.Value;
  except
 end else if pages.ActivePage=sh_channels then
 try
   allow_create_channels:=cb_channels_allowcreate.Checked;
   max_channels:=edit_channels_max.Value;
   max_channels_total:=edit_channels_max2.Value;
   block_cqex_chat:=cb_channels_blockcqex.Checked;
   old_opsay:=cb_channels_oldwallop.Checked;
   channels_timestamp:=cb_channels_timestamp.Checked;
   max_privmsg_len:=edit_channels_maxprivmessage.Value;
   max_channelmsg_len:=edit_channels_maxmessage.Value;
   show_operators:=cb_channels_showops.checked;
   prevent_shouting:=cb_channels_preventshout.Checked;
   flood_enable:=cb_channels_floodenable.Checked;
   flood_max_user_message:=edit_channels_flood_user.Value;
   flood_max_same_message:=edit_channels_flood_same.Value;
   flood_warning:=cb_channels_flood_warn.Checked;
   ini:=TIniFile.Create(ApplicationDir+'config');
   ini.WriteBool('Channels','TimeStamp',cb_channels_timestamp.Checked);
   ini.WriteBool('Channels','LowerCase',cb_channels_low.Checked);
   ini.Free;
  except
 end else if pages.ActivePage=sh_interface then
 try
   remote_admin_ok:=cb_interface_remoteadminok.Checked;
   remote_adminpass:=edit_interface_remotepass.Text;
   cpu_usage:=edit_interface_cpu.Value;
   cpu_disable:=cb_interface_nocpu.Checked;
   switch_chat:=not cb_interface_noswitch.Checked;
   chat_flash:=cb_interface_chatflash.Checked;
   chat_mini:=cb_interface_chatmini.Checked;
   wallop_im:=cb_interface_wallop.Checked;
   wallop_sound:=cb_interface_wallopsound.Checked;
   if cb_interface_systray.Checked<>SlavaNapwindow.tray.active then
   begin
     SlavaNapWindow.tray.active:=cb_interface_systray.Checked;
     if not SlavaNapWindow.Visible then
      SlavaNapWindow.Show;
   end;
   reg:=TRegistry.Create;
   try
    reg.RootKey:=HKEY_LOCAL_MACHINE;
    reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run',true);
    if cb_interface_startup.Checked then reg.WriteString('SlavaNap',Application.Exename+' -hide')
    else reg.DeleteValue('SlavaNap');
    except
   end;
   reg.Free;
  except
 end else if pages.ActivePage=sh_levels then
 try
   levels[0]:=edit_level_0.Text;
   levels[1]:=edit_level_1.Text;
   levels[2]:=edit_level_2.Text;
   levels[3]:=edit_level_3.Text;
   levels[4]:=edit_level_4.Text;
   levels[5]:=edit_level_5.Text;
  except
 end else if pages.ActivePage=sh_napigator then
 try
   napigator_host:=edit_napigator_host.Text;
   napigator_port:=edit_napigator_port.Text;
   napigator_user:=edit_napigator_user.Text;
   if list_napigator_myport.ItemIndex<>-1 then
    napigator_myport:=StrToIntDef(list_napigator_myport.Items.Strings[list_napigator_myport.ItemIndex],napigator_myport);
   napigator_enabled:=cb_napigator_enabled.Checked;
   napigator_myip:=trim(edit_napigator_myip.Text);
   napigator_autodisconnect:=cb_napigator_autodisconnect.Checked;
   napigator_delay:=edit_napigator_delay.Value * 60000;
  except
 end else if pages.ActivePage=sh_dagsta then
 try
   dagsta_host:=edit_dagsta_host.Text;
   dagsta_port:=edit_dagsta_port.Text;
   dagsta_user:=edit_dagsta_user.Text;
   if list_dagsta_myport.ItemIndex<>-1 then
    dagsta_myport:=StrToIntDef(list_dagsta_myport.Items.Strings[list_dagsta_myport.ItemIndex],dagsta_myport);
   dagsta_enabled:=cb_dagsta_enabled.Checked;
   dagsta_myip:=trim(edit_dagsta_myip.Text);
   dagsta_autodisconnect:=cb_dagsta_autodisconnect.Checked;
   dagsta_delay:=edit_dagsta_delay.Value * 60000;
  except
 end else if pages.ActivePage=sh_blocked then
 try
   blocked_clients[softNapster]:=cb_block_napster.Checked;
   blocked_clients[softAudioGnome]:=cb_block_audiognome.Checked;
   blocked_clients[softGnomePlus]:=cb_block_gnomeplus.Checked;
   blocked_clients[softAmster]:=cb_block_amster.Checked;
   blocked_clients[softFileNavigator]:=cb_block_filenavigator.Checked;
   blocked_clients[softCQEX]:=cb_block_cqex.Checked;
   blocked_clients[softSunshineUN]:=cb_block_sunshineun.checked;
   blocked_clients[softTekNap]:=cb_block_teknap.checked;
   blocked_clients[softNap]:=cb_block_nap.Checked;
   blocked_clients[softMacNap]:=cb_block_macnap.Checked;
   blocked_clients[softMP3Rage]:=cb_block_mp3rage.Checked;
   blocked_clients[softXNap]:=cb_block_xnap.Checked;
   blocked_clients[softSpotlight]:=cb_block_spotlight.Checked;
   blocked_clients[softNFS]:=cb_block_nfs.Checked;
   blocked_clients[softDMNapster]:=cb_block_dmnapster.checked;
   blocked_clients[softKNapster]:=cb_block_knapster.Checked;
   blocked_clients[softLopster]:=cb_block_lopster.Checked;
   blocked_clients[softRapigator]:=cb_block_rapigator.Checked;
   blocked_clients[softSwaptor]:=cb_block_swaptor.Checked;
   blocked_clients[softDagsta]:=cb_block_dagsta.Checked;
   blocked_clients[softDrumbeat]:=cb_block_drumbeat.Checked;
   blocked_clients[softFloodster]:=cb_block_floodster.Checked;
   blocked_clients[softMlDonkey]:=cb_block_mldonkey.Checked;
   blocked_clients[softOpennap]:=cb_block_opennap.Checked;
   blocked_clients[softNapigator]:=cb_block_napigator.Checked;
   blocked_clients[softNap08]:=cb_block_nap08.Checked;
   blocked_clients[softUnknown]:=cb_block_other.checked;
   blocked_message:=edit_block_message.Text;
   blocked_custom[0]:=AnsiLowerCase(edit_block_sign0.Text);
   blocked_custom[1]:=AnsiLowerCase(edit_block_sign1.Text);
   blocked_custom[2]:=AnsiLowerCase(edit_block_sign2.Text);
   blocked_custom[3]:=AnsiLowerCase(edit_block_sign3.Text);
   blocked_custom[4]:=AnsiLowerCase(edit_block_sign4.Text);
   blocked_custom[5]:=AnsiLowerCase(edit_block_sign5.Text);
   if cb_block_custommessage.Checked then blocked_messagetype:=blckCustom
   else if cb_block_nomessage.Checked then blocked_messagetype:=blckNone
   else blocked_messagetype:=blckDefault;
  except
 end else if pages.ActivePage=sh_blocked_winmx then
 try
   blocked_clients[softWinMXNormal]:=cb_blockmx_normal.Checked;
   blocked_clients[softWinMXJap]:=cb_blockmx_jap.Checked;
   blocked_clients[softWinMXHidden]:=cb_blockmx_detect.Checked;
   ban_fakemx:=cb_blockmx_ban.Checked;
   mx_ban:=edit_blockmx_bantime.Value*3600;
   mx_useping:=cb_blockmx_pong.Checked;
   limit_mx:=cb_blockmx_limit.Checked;
   quota_mx:=edit_blockmx_quota.Value;
  except
 end else if pages.ActivePage=sh_blocks then
 try
   block_allowshare:=cb_blocks_allow_share.Checked;
   block_allowshare_admins:=cb_blocks_allow_share_admins.Checked;
   block_checkmods:=cb_blocks_checkmods.Checked;
  except
 end else if pages.ActivePage=sh_console then
 try
   if not check_name(edit_console_user.Text,true) then
   begin
     ShowMessage('sȃ[U[ł');
     exit;
   end;
   ini:=TIniFile.Create(ApplicationDir+'config');
   ini.WriteString('Console','User',edit_console_user.Text);
   ini.WriteString('Console','AutoJoinRoom1',edit_cons_autojoin1.Text);
   ini.WriteString('Console','AutoJoinRoom2',edit_cons_autojoin2.Text);
   ini.WriteString('Console','AutoJoinRoom3',edit_cons_autojoin3.Text);
   ini.Free;
   if running then
   if Ord(cons.data^.speed)<>edit_console_speed.ItemIndex then
    cmd_list.AddDoubleCmd(MSG_CLIENT_CHANGE_SPEED,0,IntToStr(edit_console_speed.ItemIndex),'');
  except
 end else if pages.ActivePage=sh_links then
 try
   if cb_link_all.checked then allow_link:=linkAll
   else if cb_link_none.checked then allow_link:=linkNone
   else if cb_link_list2.Checked then allow_link:=linkCustom
   else allow_link:=linkList;
   allowed_servers:=lowercase(edit_link_list.Text);
   network_hub:=cb_link_hub.Checked;
   if network_hub then
    registered_only:=false;
   hub_syncreg:=cb_link_syncreg.Checked;
   hub_syncban:=cb_link_syncban.Checked;
   hub_syncblock:=cb_link_syncblock.Checked;
   autolink_only1:=cb_link_noautoconnect.Checked;
   restrict_outgoing:=cb_link_restrictoutgoing.Checked;
   outgoing_list:=lowercase(edit_link_outgoinglist.Text);
   meta_enabled:=cb_meta_enabled.checked;
   meta_port:=edit_meta_port.value;
   max_servers_enabled:=cb_link_maxservers.Checked;
   max_servers:=edit_link_maxservers.Value;
  except
 end else if pages.ActivePage=sh_links2 then
 try
   search_noforward_results:=cb_link2_lagnosearch.Checked;
   search_noforward_requests:=cb_link2_lagnosearchreq.Checked;
   browse_noforward_results:=cb_link2_lagnobrowse.Checked;
   browse_noforward_requests:=cb_link2_lagnobrowsereq.Checked;
  except
 end else if pages.ActivePage=sh_sockets then
 try
   sockets_users_default:=cb_sockets_users_def.Checked;
   sockets_users_send:=edit_sockets_users_send.Value;
   sockets_users_recv:=edit_sockets_users_recv.Value;
   sockets_servers_default:=cb_sockets_servers_def.Checked;
   sockets_servers_send:=edit_sockets_servers_send.Value;
   sockets_servers_recv:=edit_sockets_servers_recv.Value;
  except
 end else if pages.ActivePage=sh_other then
 try
   ann_enabled:=cb_ann_enable.Checked;
   ann_delay:=edit_ann_delay.Value;
   ann_user:=edit_ann_user.Text;
   for i:=0 to max_announcement do
    ann_messages[i]:='';
   for i:=0 to edit_ann_messages.Lines.Count-1 do
    if Trim(edit_ann_messages.Lines.Strings[i])<>'' then
     ann_messages[i]:=Trim(edit_ann_messages.Lines.Strings[i]);
  except
 end else if pages.ActivePage=sh_report then
 try
   old_report_enabled:=cb_report_old_enable.Checked;
   old_report_port:=edit_report_old_port.Value;
   new_report_enabled:=cb_report_new_enabled.Checked;
   new_report_port:=edit_report_new_port.Value;
   new_report_hide_hub:=cb_report_new_hidehub.Checked;
   true_stats:=cb_report_truestats.Checked;
  except
 end else if pages.ActivePage=sh_minshare then
 try
   minshare:=edit_minshare_minshare.Value;
   minshare_delay:=Int64(edit_minshare_delay.Value) * 60000;
   minshare_ban:=cb_minshare_ban.Checked;
   minshare_banip:=cb_minshare_banip.Checked;
   minshare_bantime:=edit_minshare_bantime.Value * 60;
   minshare_fullonly:=cb_minshare_onlyfull.checked;
   minshare_size:=Int64(edit_minshare_minsharesize.Value) * MegaByte;
   minshare_only10:=cb_minshare_full10.Checked;
   minshare_kickchat:=cb_minshare_kickchat.Checked;
   wallop_serverban:=cb_minshare_wallop.Checked;
  except
 end else if pages.ActivePage=sh_motd then
 try
   edit_motd.Lines.SaveToFile(ApplicationDir+'motd');
   if running then
    cmd_list.AddDoubleCmd(MSG_CMD_MOTDCHANGE,0,'','');
  except
 end else if pages.ActivePage=sh_other2 then
 try
   searchblock_chkfiles:=cb_searchblock_chkfiles.Checked;
   searchblock_chksize:=cb_searchblock_chksize.Checked;
   searchblock_files:=edit_searchblock_files.Value;
   searchblock_size:=edit_searchblock_size.Value * MegaByte;
   searchblock_hard:=rd_searchblock_hard.Checked;

   domblock_chkfiles:=cb_domblock_chkfiles.Checked;
   domblock_chksize:=cb_domblock_chksize.Checked;
   domblock_files:=edit_domblock_files.Value;
   domblock_size:=edit_domblock_size.Value * MegaByte;
   domblock_hard:=rd_domblock_hard.Checked;

   if rd_dlfloodblock_leech.Checked then
     dlfloodblock_method:=leech
   else if rd_dlfloodblock_ban.Checked then
     dlfloodblock_method:=ban
   else
     dlfloodblock_method:=block;
   dlfloodblock_count:=edit_dlfloodblock.Value;
   dlfloodblock_bantime:=GetBanID(edit_dlfloodblock_bantime);

   if rd_wqfloodblock_leech.Checked then
     wqfloodblock_method:=leech
   else if rd_wqfloodblock_ban.Checked then
     wqfloodblock_method:=ban
   else
     wqfloodblock_method:=block;
   wqfloodblock_count:=edit_wqfloodblock.Value;
   wqfloodblock_bantime:=GetBanID(edit_wqfloodblock_bantime);

   nocount_text:=cb_nocount_text.Checked;
   autoban_incomplete:=cb_autoban_incomplete.Checked;
   disable_fakeext:=cb_disable_fakeext.Checked;
   fakeext:=edit_fakeext.Text;
   enable_trapport:=cb_enable_trapport.Checked;
   ini:=TIniFile.Create(Applicationdir+'config');
   try
     ini.WriteString('Other2','TrapPort',edit_trapport.Text);
    finally
     ini.Free;
   end;
   block_transferport:=cb_block_transferport.Checked;
   blocked_transferport:=edit_blocked_transferport.Text;
   StrHash_Reset(blocked_transferport_list);
   SplitString(blocked_transferport,blocked_transferport_list);

   share_matchedfile_only:=cb_share_matchedfile_only.Checked;
  except
 end else if pages.ActivePage=sh_other3 then
 try
   enable_loginim:=cb_enable_loginim.Checked;
   loginimbot:=edit_loginimbot.Text;
   for i:=0 to max_loginim do
     loginim[i]:='';
   for i:=0 to edit_loginim.Lines.Count-1 do
     if Trim(edit_loginim.Lines.Strings[i])<>'' then
       loginim[i]:=Trim(edit_loginim.Lines.Strings[i]);
   force_enter:=cb_channels_forceenter.Checked;
   force_enter_channel:=edit_channels_forceenter.Text;
   StrHash_Reset(force_enter_channel_list);
   SplitString(force_enter_channel,force_enter_channel_list);
   if force_enter then
   begin
     p:=force_enter_channel_list.first;
     while p<>nil do
     begin
       if FindChannel(p^.data)=nil then
       begin
         ch:=TChannel.Create(p^.data);
         Include(ch.state,chRegistered);
         db_channels.Add(ch);
       end;
       p:=p^.next;
     end;
   end;
   allow_2bytename:=cb_allow_2bytename.Checked;
   check_loginpass:=cb_check_loginpass.Checked;
   loginpass:=edit_loginpass.Text;
   enable_msgserv:=cb_enable_msgserv.Checked;
   restrict_hitperuser:=cb_restrict_hitperuser.Checked;
   maxhitperuser:=edit_hitperuser.Value;
   with SlavaNapWindow do
   begin
     cb_servers_refresh.Checked:=cb_refresh_servers.Checked;
     Timer3.Interval:=edit_servreftime.Value*1000;
     cb_servers_refresh.Caption:=GetLangI(LNG_SBTN_AUTOREFRESH,edit_servreftime.Value);
   end;
   case rd_xbutton_attr.ItemIndex of
     0: b3_canclose:=Unknown3;
     1: b3_canclose:=True3;
     2: b3_canclose:=False3;
   end;
   minshare_noblockact:=cb_minshare_noblockact.Checked;
   kill_idleuser:=cb_kill_idleuser.Checked;
   kill_idleuser_time:=edit_kill_idleuser_time.Value*60000;
   listall_for_users:=not cb_deny_listall_for_users.Checked;
   block_weird_xnapfile:=cb_block_weird_xnapfile.Checked;
   suggest_dbrowse:=cb_suggest_dbrowse.Checked;
  except
 end else if pages.ActivePage=sh_other4 then
 try
   regsoft_only:=cb_regsoft_only.Checked;
   allowed_clients[soft2get]       :=cb_allow_2get.Checked;
   allowed_clients[softLopster]    :=cb_allow_lopster.Checked;
   allowed_clients[softNapchan]    :=cb_allow_napchan.Checked;
   allowed_clients[softNapster]    :=cb_allow_napster.Checked;
   allowed_clients[softTekNap]     :=cb_allow_teknap.Checked;
   allowed_clients[softUtatane]    :=cb_allow_utatane.Checked;
   allowed_clients[softWinMXNormal]:=cb_allow_winmx.Checked;
   allowed_clients[softWinMXJap]   :=cb_allow_winmx.Checked;//`FbN{bNXőΉ
   allowed_clients[softXNap]       :=cb_allow_xnap.Checked;
   allowed_clients[softUnknown]    :=cb_allow_other.Checked;
   allowed_custom[0]:=edit_allow_sign0.Text;
   allowed_custom[1]:=edit_allow_sign1.Text;
   allowed_custom[2]:=edit_allow_sign2.Text;
   allowed_custom[3]:=edit_allow_sign3.Text;
   allowed_custom[4]:=edit_allow_sign4.Text;
   if log_folder<>edit_log_folder.Text then
   begin
     log_file.Free;
     ShortDateFormat := 'yyyymmdd';
     //logfilename:=ApplicationDir+'server-'+DateToStr(now)+'.log';
     logfilename:=edit_log_folder.Text+'server-'+DateToStr(now)+'.log';
     ShortDateFormat := 'yyyy/mm/dd';
     if not FileExists(logfilename) then
       try
        log_file:=TFileStream.Create(logfilename,fmCreate);
        log_file.Free;
        except
       end;
     try
       log_file:=TFileStream.Create(logfilename,fmOpenWrite or fmShareDenyWrite);
       log_file.Seek(0,soFromEnd);
      except
       log_file:=nil;
       LogStartup('settings::btn_changeClick: cannot open "'+logfilename+'" !!!');
       DebugLog('Error: cannot open file '+logfilename);
     end;
   end;
   log_folder:=edit_log_folder.Text;
  except
 end;
 btn_restoreClick(nil);
end;

procedure TSlavaNapSettings.btn_level_defaultClick(Sender: TObject);
begin
 edit_level_0.Text:='Leech';
 edit_level_1.Text:='User';
 edit_level_2.Text:='Moderator';
 edit_level_3.Text:='Admin';
 edit_level_4.Text:='Elite';
 edit_level_5.Text:='Console';
 btn_changeClick(nil);
end;

procedure TSlavaNapSettings.btn_napigator_disconnectClick(Sender: TObject);
begin
 if not running then exit;
 if napigator_socket<>INVALID_SOCKET then
 begin
   DoCloseSocket(napigator_socket);
   napigator_socket:=INVALID_SOCKET;
 end;
end;

procedure TSlavaNapSettings.btn_napigator_passwordClick(Sender: TObject);
begin
 if Sender=btn_napigator_password then
  SlavaNapEdit.Ask(SE_NAPIGATORPASS)
 else
  SlavaNapEdit.Ask(SE_DAGSTAPASS); 
end;

procedure TSlavaNapSettings.cb_log_serverstatsClick(Sender: TObject);
begin
 cb_log_clearserverstats.Visible:=cb_log_serverstats.Checked;
end;

procedure TSlavaNapSettings.cb_block_custommessageClick(Sender: TObject);
begin
 lbl_block_message.Visible:=cb_block_custommessage.Checked;
 edit_block_message.Visible:=cb_block_custommessage.checked;
end;

procedure TSlavaNapSettings.cb_search_disable_remoteClick(Sender: TObject);
begin
 lbl_search_maxremote.Visible:=not cb_search_disable_remote.Checked;
 edit_search_maxremote.Visible:=not cb_search_disable_remote.Checked;
end;

procedure TSlavaNapSettings.cb_sockets_users_defClick(Sender: TObject);
begin
 edit_sockets_users_send.Visible:=not cb_sockets_users_def.Checked;
 edit_sockets_users_recv.Visible:=not cb_sockets_users_def.Checked;
 lbl_sockets_users_send.Visible:=not cb_sockets_users_def.Checked;
 lbl_sockets_users_recv.Visible:=not cb_sockets_users_def.Checked;
end;

procedure TSlavaNapSettings.cb_sockets_servers_defClick(Sender: TObject);
begin
 edit_sockets_servers_send.Visible:=not cb_sockets_servers_def.Checked;
 edit_sockets_servers_recv.Visible:=not cb_sockets_servers_def.Checked;
 lbl_sockets_servers_send.Visible:=not cb_sockets_servers_def.Checked;
 lbl_sockets_servers_recv.Visible:=not cb_sockets_servers_def.Checked;
end;

procedure TSlavaNapSettings.cb_minshare_onlyfullClick(Sender: TObject);
begin
 cb_minshare_full10.Visible:=cb_minshare_onlyfull.Checked;
end;

procedure TSlavaNapSettings.ChangeColors;
begin
 tree.Color:=slBackground;
 tree.Font.Color:=slText;
end;

procedure TSlavaNapSettings.btn_colors_defaultClick(Sender: TObject);
begin
 slBackground:=$FFFFFF;
 slText:=0;
 slError:=$0000FF;
 slWallop:=$A06000;
 slAnnounce:=$A00060;
 slWhowas:=$600060;
 slPong:=$600060;
 slOffline:=$603000;
 slOnline:=$A06000;
 slDebugData:=$000060;
 slNapigator:=$006000;
 slDagsta:=$008000;
 slSearch:=$A000A0;
 slBrowse:=$E000E0;
 slTransfer:=$600060;
 slTopic:=$B00060;
 slChannelMessage:=0;
 slChannelMyMessage:=$404040;
 slChannelEmote:=$606000;
 slChannelMyEmote:=$808000;
 slChannelJoin:=$A06000;
 slChannelPart:=$603000;
 slChatMessage:=$A00000;
 slChatMyMessage:=0;
 ChangeColors;
 if running then SlavaNapWindow.SetColors(true);
 btn_restoreClick(nil);
end;

procedure TSlavaNapSettings.btn_color_chClick(Sender: TObject);
var
 i: Integer;
 c: TColor;
begin
 if not (Sender is TSpeedButton) then exit;
 i:=(Sender as TSpeedButton).tag;
 if i=0 then exit;
 cd.tag:=i;
 case i of
   1:   c:=edit_color_bg.ColorValue;
   2:   c:=edit_color_chat.ColorValue;
   3:   c:=edit_color_mychat.ColorValue;
   4:   c:=edit_color_channelchat.ColorValue;
   5:   c:=edit_color_mychannelchat.ColorValue;
   6:   c:=edit_color_emote.ColorValue;
   7:   c:=edit_color_myemote.ColorValue;
   8:   c:=edit_color_join.ColorValue;
   9:   c:=edit_color_part.ColorValue;
   10:  c:=edit_color_topic.ColorValue;
   11:  c:=edit_color_debug.ColorValue;
   12:  c:=edit_color_text.ColorValue;
   13:  c:=edit_color_error.ColorValue;
   14:  c:=edit_color_wallop.ColorValue;
   15:  c:=edit_color_announce.ColorValue;
   16:  c:=edit_color_online.ColorValue;
   17:  c:=edit_color_offline.ColorValue;
   18:  c:=edit_color_search.ColorValue;
   19:  c:=edit_color_transfer.ColorValue;
   20:  c:=edit_color_napigator.ColorValue;
   21:  c:=edit_color_pong.ColorValue;
   22:  c:=edit_color_whowas.ColorValue;
   23:  c:=edit_color_dagsta.ColorValue;
   24:  c:=edit_color_browse.ColorValue;
   else exit;
 end;
 cd.color:=c;
 if not cd.Execute then exit;
 c:=cd.color;
 case cd.tag of
   1:   edit_color_bg.ColorValue:=c;
   2:   edit_color_chat.ColorValue:=c;
   3:   edit_color_mychat.ColorValue:=c;
   4:   edit_color_channelchat.ColorValue:=c;
   5:   edit_color_mychannelchat.ColorValue:=c;
   6:   edit_color_emote.ColorValue:=c;
   7:   edit_color_myemote.ColorValue:=c;
   8:   edit_color_join.ColorValue:=c;
   9:   edit_color_part.ColorValue:=c;
   10:  edit_color_topic.ColorValue:=c;
   11:  edit_color_debug.ColorValue:=c;
   12:  edit_color_text.ColorValue:=c;
   13:  edit_color_error.ColorValue:=c;
   14:  edit_color_wallop.ColorValue:=c;
   15:  edit_color_announce.ColorValue:=c;
   16:  edit_color_online.ColorValue:=c;
   17:  edit_color_offline.ColorValue:=c;
   18:  edit_color_search.ColorValue:=c;
   19:  edit_color_transfer.ColorValue:=c;
   20:  edit_color_napigator.ColorValue:=c;
   21:  edit_color_pong.ColorValue:=c;
   22:  edit_color_whowas.ColorValue:=c;
   23:  edit_color_dagsta.ColorValue:=c;
   24:  edit_color_browse.ColorValue:=c;
   else exit;
 end;
end;

procedure TSlavaNapSettings.cb_channels_floodenableClick(Sender: TObject);
begin
 lbl_flood1.Visible:=cb_channels_floodenable.Checked;
 lbl_flood2.Visible:=cb_channels_floodenable.Checked;
 edit_channels_flood_user.Visible:=cb_channels_floodenable.Checked;
 edit_channels_flood_same.Visible:=cb_channels_floodenable.Checked;
 cb_channels_flood_warn.Visible:=cb_channels_floodenable.Checked;
end;


procedure TSlavaNapSettings.btn_dagsta_disconnectClick(Sender: TObject);
begin
 if not running then exit;
 if dagsta_socket<>INVALID_SOCKET then
 begin
   DoCloseSocket(dagsta_socket);
   dagsta_socket:=INVALID_SOCKET;
 end;
end;

procedure TSlavaNapSettings.Label137Click(Sender: TObject);
begin
 ShellExecute(Handle,PChar('open'),PChar('http://www.dagsta.com/?register'),nil,nil,SW_ShowNormal);
end;

procedure TSlavaNapSettings.cb_blockmx_limitClick(Sender: TObject);
begin
 lbl_blockmx_percentage.Visible:=cb_blockmx_limit.checked;
 edit_blockmx_quota.Visible:=cb_blockmx_limit.checked;
end;

procedure TSlavaNapSettings.sh_blocked_winmxShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_BLOCKED));
 SetChange(true);
 cb_blockmx_normal.Checked:=blocked_clients[softWinMXNormal];
 cb_blockmx_jap.Checked:=blocked_clients[softWinMXJap];
 cb_blockmx_detect.Checked:=blocked_clients[softWinMXHidden];
 cb_blockmx_ban.Visible:=blocked_clients[softWinMXHidden];
 //cb_blockmx_pong.Visible:=blocked_clients[softWinMXHidden];
 Label142.Visible:=ban_fakemx;
 cb_blockmx_ban.Checked:=ban_fakemx;
 edit_blockmx_bantime.Visible:=ban_fakemx;
 edit_blockmx_bantime.Value:=mx_ban div 3600;
 cb_blockmx_limit.Checked:=limit_mx;
 edit_blockmx_quota.Value:=quota_mx;
 cb_blockmx_pong.Checked:=mx_useping;
 cb_blockmx_limitClick(nil);
end;

procedure TSlavaNapSettings.edit_main_aliasChange(Sender: TObject);
var
 i : Integer;
 str : string;
begin
 str:=edit_main_alias.text;
 if Length(str)>0 then
  for i:=0 to edit_main_alias.GetTextLen do
    if str[i] = ' ' then str[i]:='_';
  edit_main_alias.text:=str;
end;

procedure TSlavaNapSettings.sh_blocksShow(Sender: TObject);
begin
 SetTopText(GetLangI(LNG_S_TEXT_BLOCKS));
 SetChange(true);
 cb_blocks_allow_share.Checked:=block_allowshare;
 cb_blocks_allow_share_admins.Checked:=block_allowshare_admins;
 cb_blocks_checkmods.Checked:=block_checkmods;
end;

procedure TSlavaNapSettings.cb_share_friendaddClick(Sender: TObject);
begin
 edit_share_friendadd.Visible:=cb_share_friendadd.Checked;
 label149.Visible:=cb_share_friendadd.Checked;
 label150.Visible:=cb_share_friendadd.Checked;
end;

procedure TSlavaNapSettings.cb_link_maxserversClick(Sender: TObject);
begin
 label151.Visible:=cb_link_maxservers.Checked;
 edit_link_maxservers.Visible:=cb_link_maxservers.Checked;
end;

procedure TSlavaNapSettings.cb_interface_remoteadminokClick(
  Sender: TObject);
begin
 edit_interface_remotepass.Visible:=cb_interface_remoteadminok.Checked;
end;

procedure TSlavaNapSettings.cb_blockmx_detectClick(Sender: TObject);
begin
 Label142.Visible:=cb_blockmx_detect.Checked and cb_blockmx_ban.Checked;
 cb_blockmx_ban.Visible:=cb_blockmx_detect.Checked;
 edit_blockmx_bantime.Visible:=cb_blockmx_detect.Checked and cb_blockmx_ban.Checked;
 //cb_blockmx_pong.Visible:=cb_blockmx_detect.Checked;
end;

procedure TSlavaNapSettings.cb_blockmx_banClick(Sender: TObject);
begin
 Label142.Visible:=cb_blockmx_ban.Checked;
 edit_blockmx_bantime.Visible:=cb_blockmx_ban.Checked;
end;

procedure TSlavaNapSettings.cb_searchblock_chkfilesClick(Sender: TObject);
begin
  edit_searchblock_files.Enabled:=cb_searchblock_chkfiles.Checked;
  rd_searchblock_hard.Enabled   :=cb_searchblock_chkfiles.Checked and cb_searchblock_chksize.Checked;
  rd_searchblock_normal.Enabled :=cb_searchblock_chkfiles.Checked and cb_searchblock_chksize.Checked;
end;

procedure TSlavaNapSettings.cb_searchblock_chksizeClick(Sender: TObject);
begin
  edit_searchblock_size.Enabled :=cb_searchblock_chksize.Checked;
  rd_searchblock_hard.Enabled   :=cb_searchblock_chkfiles.Checked and cb_searchblock_chksize.Checked;
  rd_searchblock_normal.Enabled :=cb_searchblock_chkfiles.Checked and cb_searchblock_chksize.Checked;
end;

procedure TSlavaNapSettings.cb_domblock_chkfilesClick(Sender: TObject);
begin
  edit_domblock_files.Enabled   :=cb_domblock_chkfiles.Checked;
  rd_domblock_hard.Enabled      :=cb_domblock_chkfiles.Checked and cb_domblock_chksize.Checked;
  rd_domblock_normal.Enabled    :=cb_domblock_chkfiles.Checked and cb_domblock_chksize.Checked;
end;

procedure TSlavaNapSettings.cb_domblock_chksizeClick(Sender: TObject);
begin
  edit_domblock_size.Enabled    :=cb_domblock_chksize.Checked;
  rd_domblock_hard.Enabled      :=cb_domblock_chkfiles.Checked and cb_domblock_chksize.Checked;
  rd_domblock_normal.Enabled    :=cb_domblock_chkfiles.Checked and cb_domblock_chksize.Checked;
end;

procedure TSlavaNapSettings.rd_dlfloodblock_banClick(Sender: TObject);
begin
  edit_dlfloodblock_bantime.Visible:=True;
end;

procedure TSlavaNapSettings.rd_dlfloodblock_blockClick(Sender: TObject);
begin
  edit_dlfloodblock_bantime.Visible:=False;
end;

procedure TSlavaNapSettings.rd_dlfloodblock_leechClick(Sender: TObject);
begin
  edit_dlfloodblock_bantime.Visible:=False;
end;

procedure TSlavaNapSettings.rd_wqfloodblock_banClick(Sender: TObject);
begin
  edit_wqfloodblock_bantime.Visible:=True;
end;

procedure TSlavaNapSettings.rd_wqfloodblock_blockClick(Sender: TObject);
begin
  edit_wqfloodblock_bantime.Visible:=False;
end;

procedure TSlavaNapSettings.rd_wqfloodblock_leechClick(Sender: TObject);
begin
  edit_wqfloodblock_bantime.Visible:=False;
end;

procedure TSlavaNapSettings.SetBanItems(control: TComboBox);
begin
  control.Items.Clear;
  control.Items.Add(GetLangI(LNG_BANS_TIME60));
  control.Items.Add(GetLangI(LNG_BANS_TIME300));
  control.Items.Add(GetLangI(LNG_BANS_TIME600));
  control.Items.Add(GetLangI(LNG_BANS_TIME1800));
  control.Items.Add(GetLangI(LNG_BANS_TIME3600));
  control.Items.Add(GetLangI(LNG_BANS_TIME10800));
  control.Items.Add(GetLangI(LNG_BANS_TIME43200));
  control.Items.Add(GetLangI(LNG_BANS_TIME86400));
  control.Items.Add(GetLangI(LNG_BANS_TIME259200));
  control.Items.Add(GetLangI(LNG_BANS_TIME604800));
  control.Items.Add(GetLangI(LNG_BANS_TIME1209600));
  control.Items.Add(GetLangI(LNG_BANS_TIME2678400));
  control.ItemIndex:=control.Items.Count-1;
  control.Items.Add(GetLangI(LNG_BANS_TIME5184000));
  control.Items.Add(GetLangI(LNG_BANS_TIME7776000));
  control.Items.Add(GetLangI(LNG_BANS_TIME31536000));
  control.Items.Add('');
  control.DropDownCount:=control.Items.Count;
end;

function  TSlavaNapSettings.GetBanID(control: TComboBox): Integer;
var
  t: Integer;
begin
  case control.ItemIndex of
     0: t:=60;
     1: t:=300;
     2: t:=600;
     3: t:=1800;
     4: t:=3600;
     5: t:=10800;
     6: t:=43200;
     7: t:=86400;
     8: t:=259200;
     9: t:=604800;
    10: t:=1209600;
    11: t:=2678400;
    12: t:=5184000;
    13: t:=7776000;
    14: t:=31536000;
    15: t:=0;
    else t:=def_ban_timeout;
  end;
  Result:=t;
end;

function  TSlavaNapSettings.GetBanIndex(t: Integer): Integer;
var
  itemindex: Integer;
begin
  case t of
          60: itemindex:=0;
         300: itemindex:=1;
         600: itemindex:=2;
        1800: itemindex:=3;
        3600: itemindex:=4;
       10800: itemindex:=5;
       43200: itemindex:=6;
       86400: itemindex:=7;
      259200: itemindex:=8;
      604800: itemindex:=9;
     1209600: itemindex:=10;
     2678400: itemindex:=11;
     5184000: itemindex:=12;
     7776000: itemindex:=13;
    31536000: itemindex:=14;
           0: itemindex:=15;
    else itemindex:=7;//1
  end;
  Result:=itemindex;
end;

procedure TSlavaNapSettings.cb_disable_fakeextClick(Sender: TObject);
begin
  edit_fakeext.Visible:=cb_disable_fakeext.Checked;
end;

procedure TSlavaNapSettings.cb_enable_trapportClick(Sender: TObject);
begin
  edit_trapport.Visible:=cb_enable_trapport.Checked;
end;

procedure TSlavaNapSettings.cb_block_transferportClick(Sender: TObject);
begin
  edit_blocked_transferport.Visible:=cb_block_transferport.Checked;
end;

procedure TSlavaNapSettings.cb_channels_forceenterClick(Sender: TObject);
begin
  Label156.Visible:=cb_channels_forceenter.Checked;
  edit_channels_forceenter.Visible:=cb_channels_forceenter.Checked;
end;

procedure TSlavaNapSettings.cb_check_loginpassClick(Sender: TObject);
begin
  edit_loginpass.Visible:=cb_check_loginpass.Checked;
  Label157.Visible:=cb_check_loginpass.Checked;
end;

procedure TSlavaNapSettings.cb_restrict_hitperuserClick(
  Sender: TObject);
begin
  edit_hitperuser.Visible:=cb_restrict_hitperuser.Checked;
  Label158.Visible:=cb_restrict_hitperuser.Checked;
end;

procedure TSlavaNapSettings.cb_refresh_serversClick(Sender: TObject);
begin
  edit_servreftime.Visible:=cb_refresh_servers.Checked;
  Label159.Visible:=cb_refresh_servers.Checked;
end;

procedure TSlavaNapSettings.cb_minshare_banClick(Sender: TObject);
begin
  Label160.Visible:=cb_minshare_ban.Checked;
  edit_minshare_bantime.Visible:=cb_minshare_ban.Checked;
end;

procedure TSlavaNapSettings.ChangeInterface;
begin
  SetFont(Self.Font);
  SetFont(tree.Font);
  SetFont(header.Font,10);
  SetFont(lbl_change.Font,10);
  SetFont(lbl_note.Font,9);
  SetFont(Label55.Font);
  SetFont(lbl_handle.Font);
  SetFont(Label137.Font);
  //sh_main
  Label1.Caption                       :=GetLangI(LNG_S_SHMAIN_LABEL1);
  Label3.Caption                       :=GetLangI(LNG_S_SHMAIN_LABEL3);
  Label4.Caption                       :=GetLangI(LNG_S_SHMAIN_LABEL4);
  Label66.Caption                      :=GetLangI(LNG_S_SHMAIN_LABEL66);
  Label67.Caption                      :=GetLangI(LNG_S_SHMAIN_LABEL67);
  Label75.Caption                      :=GetLangI(LNG_S_SHMAIN_LABEL75);
  Label76.Caption                      :=GetLangI(LNG_S_SHMAIN_LABEL76);
  lbl_handle.Caption                   :=GetLangI(LNG_S_SHMAIN_LBL_HANDLE);
  Label127.Caption                     :=GetLangI(LNG_S_SHMAIN_LABEL127);
  Label138.Caption                     :=GetLangI(LNG_S_SHMAIN_LABEL138);
  //sh_users
  Label5.Caption                       :=GetLangI(LNG_S_SHUSERS_LABEL5);
  Label9.Caption                       :=GetLangI(LNG_S_SHUSERS_LABEL9);
  Label12.Caption                      :=GetLangI(LNG_S_SHUSERS_LABEL12);
  Label79.Caption                      :=GetLangI(LNG_S_SHUSERS_LABEL79);
  Label2.Caption                       :=GetLangI(LNG_S_SHUSERS_LABEL2);
  Label128.Caption                     :=GetLangI(LNG_S_SHUSERS_LABEL128);
  cb_users_reg_only.Caption            :=GetLangI(LNG_S_SHUSERS_CB_USERS_REG_ONLY);
  cb_users_reg_allow.Caption           :=GetLangI(LNG_S_SHUSERS_CB_USERS_REG_ALLOW);
  cb_users_noremote.Caption            :=GetLangI(LNG_S_SHUSERS_CB_USERS_NOREMOTE);
  cb_users_redirectcqex.Caption        :=GetLangI(LNG_S_SHUSERS_CB_USERS_REDIRECTCQEX);
  cb_users_reconnect.Caption           :=GetLangI(LNG_S_SHUSERS_CB_USERS_RECONNECT);
  //sh_limits
  Label6.Caption                       :=GetLangI(LNG_S_SHLIMITS_LABEL6);
  Label7.Caption                       :=GetLangI(LNG_S_SHLIMITS_LABEL7);
  Label8.Caption                       :=GetLangI(LNG_S_SHLIMITS_LABEL8);
  Label99.Caption                      :=GetLangI(LNG_S_SHLIMITS_LABEL99);
  Label100.Caption                     :=GetLangI(LNG_S_SHLIMITS_LABEL100);
  Label10.Caption                      :=GetLangI(LNG_S_SHLIMITS_LABEL10);
  Label11.Caption                      :=GetLangI(LNG_S_SHLIMITS_LABEL11);
  cb_limits_limitservers.Caption       :=GetLangI(LNG_S_SHLIMITS_CB_LIMITS_LIMITSERVERS);
  //sh_interface
  Label77.Caption                      :=GetLangI(LNG_S_SHINTERFACE_LABEL77);
  Label78.Caption                      :=GetLangI(LNG_S_SHINTERFACE_LABEL78);
  Label152.Caption                     :=GetLangI(LNG_S_SHINTERFACE_LABEL152);
  cb_interface_startup.Caption         :=GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_STARTUP);
  cb_interface_noswitch.Caption        :=GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_NOSWITCH);
  cb_interface_chatflash.Caption       :=GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_CHATFLASH);
  cb_interface_systray.Caption         :=GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_SYSTRAY);
  cb_interface_chatmini.Caption        :=GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_CHATMINI);
  cb_interface_wallop.Caption          :=GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_WALLOP);
  cb_interface_nocpu.Caption           :=GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_NOCPU);
  cb_interface_wallopsound.Caption     :=GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_WALLOPSOUND);
  cb_interface_remoteadminok.Caption   :=GetLangI(LNG_S_SHINTERFACE_CB_INTERFACE_REMOTEADMINOK);
  //sh_log
  cb_log_login.Caption                 :=GetLangI(LNG_S_SHLOG_CB_LOG_LOGIN);
  cb_log_napigator.Caption             :=GetLangI(LNG_S_SHLOG_CB_LOG_NAPIGATOR);
  cb_log_search.Caption                :=GetLangI(LNG_S_SHLOG_CB_LOG_SEARCH);
  cb_log_transfers.Caption             :=GetLangI(LNG_S_SHLOG_CB_LOG_TRANSFERS);
  cb_log_users.Caption                 :=GetLangI(LNG_S_SHLOG_CB_LOG_USERS);
  cb_log_save.Caption                  :=GetLangI(LNG_S_SHLOG_CB_LOG_SAVE);
  cb_log_servers.Caption               :=GetLangI(LNG_S_SHLOG_CB_LOG_SERVERS);
  cb_log_serverstats.Caption           :=GetLangI(LNG_S_SHLOG_CB_LOG_SERVERSTATS);
  cb_log_clearserverstats.Caption      :=GetLangI(LNG_S_SHLOG_CB_LOG_CLEARSERVERSTATS);
  cb_log_clearclientstats.Caption      :=GetLangI(LNG_S_SHLOG_CB_LOG_CLEARCLIENTSTATS);
  cb_log_console.Caption               :=GetLangI(LNG_S_SHLOG_CB_LOG_CONSOLE);
  cb_log_dagsta.Caption                :=GetLangI(LNG_S_SHLOG_CB_LOG_DAGSTA);
  cb_log_browse.Caption                :=GetLangI(LNG_S_SHLOG_CB_LOG_BROWSE);
  //sh_share
  Label13.Caption                      :=GetLangI(LNG_S_SHSHARE_LABEL13);
  Label14.Caption                      :=GetLangI(LNG_S_SHSHARE_LABEL14);
  Label15.Caption                      :=GetLangI(LNG_S_SHSHARE_LABEL15);
  Label16.Caption                      :=GetLangI(LNG_S_SHSHARE_LABEL16);
  Label101.Caption                     :=GetLangI(LNG_S_SHSHARE_LABEL101);
  Label149.Caption                     :=GetLangI(LNG_S_SHSHARE_LABEL149);
  Label150.Caption                     :=GetLangI(LNG_S_SHSHARE_LABEL150);
  cb_share_disable.Caption             :=GetLangI(LNG_S_SHSHARE_CB_SHARE_DISABLE);
  cb_share_inform.Caption              :=GetLangI(LNG_S_SHSHARE_CB_SHARE_INFORM);
  cb_share_nomodem.Caption             :=GetLangI(LNG_S_SHSHARE_CB_SHARE_NOMODEM);
  cb_share_checkdup.Caption            :=GetLangI(LNG_S_SHSHARE_CB_SHARE_CHECKDUP);
  cb_share_friendadd.Caption           :=GetLangI(LNG_S_SHSHARE_CB_SHARE_FRIENDADD);
  //sh_share_mp3
  Label17.Caption                      :=GetLangI(LNG_S_SHSHAREMP3_LABEL17);
  Label18.Caption                      :=GetLangI(LNG_S_SHSHAREMP3_LABEL18);
  Label19.Caption                      :=GetLangI(LNG_S_SHSHAREMP3_LABEL19);
  Label20.Caption                      :=GetLangI(LNG_S_SHSHAREMP3_LABEL20);
  Label45.Caption                      :=GetLangI(LNG_S_SHSHAREMP3_LABEL45);
  Label46.Caption                      :=GetLangI(LNG_S_SHSHAREMP3_LABEL46);
  cb_mp3_320.Caption                   :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_320);
  cb_mp3_256.Caption                   :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_256);
  cb_mp3_224.Caption                   :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_224);
  cb_mp3_192.Caption                   :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_192);
  cb_mp3_160.Caption                   :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_160);
  cb_mp3_128.Caption                   :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_128);
  cb_mp3_112.Caption                   :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_112);
  cb_mp3_96.Caption                    :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_96);
  cb_mp3_80.Caption                    :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_80);
  cb_mp3_64.Caption                    :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_64);
  cb_mp3_56.Caption                    :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_56);
  cb_mp3_48.Caption                    :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_48);
  cb_mp3_40.Caption                    :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_40);
  cb_mp3_32.Caption                    :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_32);
  cb_mp3_24.Caption                    :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_24);
  cb_mp3_0.Caption                     :=GetLangI(LNG_S_SHSHAREMP3_CB_MP3_0);
  //sh_share_audio
  Label21.Caption                      :=GetLangI(LNG_S_SHSHAREAUDIO_LABEL21);
  Label22.Caption                      :=GetLangI(LNG_S_SHSHAREAUDIO_LABEL22);
  Label23.Caption                      :=GetLangI(LNG_S_SHSHAREAUDIO_LABEL23);
  Label24.Caption                      :=GetLangI(LNG_S_SHSHAREAUDIO_LABEL24);
  //sh_share_video
  Label25.Caption                      :=GetLangI(LNG_S_SHSHAREVIDEO_LABEL25);
  Label26.Caption                      :=GetLangI(LNG_S_SHSHAREVIDEO_LABEL26);
  Label27.Caption                      :=GetLangI(LNG_S_SHSHAREVIDEO_LABEL27);
  Label28.Caption                      :=GetLangI(LNG_S_SHSHAREVIDEO_LABEL28);
  //sh_share_images
  Label29.Caption                      :=GetLangI(LNG_S_SHSHAREIMAGES_LABEL29);
  Label30.Caption                      :=GetLangI(LNG_S_SHSHAREIMAGES_LABEL30);
  Label31.Caption                      :=GetLangI(LNG_S_SHSHAREIMAGES_LABEL31);
  Label32.Caption                      :=GetLangI(LNG_S_SHSHAREIMAGES_LABEL32);
  //sh_share_apps
  Label33.Caption                      :=GetLangI(LNG_S_SHSHAREAPPS_LABEL33);
  Label34.Caption                      :=GetLangI(LNG_S_SHSHAREAPPS_LABEL34);
  Label35.Caption                      :=GetLangI(LNG_S_SHSHAREAPPS_LABEL35);
  Label36.Caption                      :=GetLangI(LNG_S_SHSHAREAPPS_LABEL36);
  //sh_share_cd
  Label37.Caption                      :=GetLangI(LNG_S_SHSHARECD_LABEL37);
  Label38.Caption                      :=GetLangI(LNG_S_SHSHARECD_LABEL38);
  Label39.Caption                      :=GetLangI(LNG_S_SHSHARECD_LABEL39);
  Label40.Caption                      :=GetLangI(LNG_S_SHSHARECD_LABEL40);
  //sh_share_text
  Label41.Caption                      :=GetLangI(LNG_S_SHSHARETEXT_LABEL41);
  Label42.Caption                      :=GetLangI(LNG_S_SHSHARETEXT_LABEL42);
  Label43.Caption                      :=GetLangI(LNG_S_SHSHARETEXT_LABEL43);
  Label44.Caption                      :=GetLangI(LNG_S_SHSHARETEXT_LABEL44);
  //sh_napigator
  Label61.Caption                      :=GetLangI(LNG_S_SHNAPIGATOR_LABEL61);
  Label62.Caption                      :=GetLangI(LNG_S_SHNAPIGATOR_LABEL62);
  Label63.Caption                      :=GetLangI(LNG_S_SHNAPIGATOR_LABEL63);
  Label64.Caption                      :=GetLangI(LNG_S_SHNAPIGATOR_LABEL64);
  Label65.Caption                      :=GetLangI(LNG_S_SHNAPIGATOR_LABEL65);
  Label73.Caption                      :=GetLangI(LNG_S_SHNAPIGATOR_LABEL73);
  Label97.Caption                      :=GetLangI(LNG_S_SHNAPIGATOR_LABEL97);
  Label126.Caption                     :=GetLangI(LNG_S_SHNAPIGATOR_LABEL126);
  btn_napigator_password.Caption       :=GetLangI(LNG_S_SHNAPIGATOR_BTN_NAPIGATOR_PASSWORD);
  cb_napigator_enabled.Caption         :=GetLangI(LNG_S_SHNAPIGATOR_CB_NAPIGATOR_ENABLED);
  btn_napigator_disconnect.Caption     :=GetLangI(LNG_S_SHNAPIGATOR_BTN_NAPIGATOR_DISCONNECT);
  cb_napigator_autodisconnect.Caption  :=GetLangI(LNG_S_SHNAPIGATOR_CB_NAPIGATOR_AUTODISCONNECT);
  //sh_search
  Label47.Caption                      :=GetLangI(LNG_S_SHSEARCH_LABEL47);
  Label48.Caption                      :=GetLangI(LNG_S_SHSEARCH_LABEL48);
  Label49.Caption                      :=GetLangI(LNG_S_SHSEARCH_LABEL49);
  Label50.Caption                      :=GetLangI(LNG_S_SHSEARCH_LABEL50);
  Label72.Caption                      :=GetLangI(LNG_S_SHSEARCH_LABEL72);
  lbl_search_maxremote.Caption         :=GetLangI(LNG_S_SHSEARCH_LBL_SEARCH_MAXREMOTE);
  cb_search_disable_remote.Caption     :=GetLangI(LNG_S_SHSEARCH_CB_SEARCH_DISABLE_REMOTE);
  //sh_levels
  Label54.Caption                      :=GetLangI(LNG_S_SHLEVELS_LABEL54);
  Label55.Caption                      :=GetLangI(LNG_S_SHLEVELS_LABEL55);
  Label56.Caption                      :=GetLangI(LNG_S_SHLEVELS_LABEL56);
  Label57.Caption                      :=GetLangI(LNG_S_SHLEVELS_LABEL57);
  Label58.Caption                      :=GetLangI(LNG_S_SHLEVELS_LABEL58);
  Label59.Caption                      :=GetLangI(LNG_S_SHLEVELS_LABEL59);
  Label60.Caption                      :=GetLangI(LNG_S_SHLEVELS_LABEL60);
  Label102.Caption                     :=GetLangI(LNG_S_SHLEVELS_LABEL102);
  btn_level_default.Caption            :=GetLangI(LNG_S_SHLEVELS_BTN_LEVEL_DEFAULT);
  //sh_channels
  Label52.Caption                      :=GetLangI(LNG_S_SHCHANNELS_LABEL52);
  Label53.Caption                      :=GetLangI(LNG_S_SHCHANNELS_LABEL53);
  Label82.Caption                      :=GetLangI(LNG_S_SHCHANNELS_LABEL82);
  Label83.Caption                      :=GetLangI(LNG_S_SHCHANNELS_LABEL83);
  lbl_flood1.Caption                   :=GetLangI(LNG_S_SHCHANNELS_LBL_FLOOD1);
  lbl_flood2.Caption                   :=GetLangI(LNG_S_SHCHANNELS_LBL_FLOOD2);
  cb_channels_allowcreate.Caption      :=GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_ALLOWCREATE);
  cb_channels_blockcqex.Caption        :=GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_BLOCKCQEX);
  cb_channels_oldwallop.Caption        :=GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_OLDWALLOP);
  cb_channels_showops.Caption          :=GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_SHOWOPS);
  cb_channels_timestamp.Caption        :=GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_TIMESTAMP);
  cb_channels_low.Caption              :=GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_LOW);
  cb_channels_preventshout.Caption     :=GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_PREVENTSHOUT);
  cb_channels_flood_warn.Caption       :=GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_FLOOD_WARN);
  cb_channels_floodenable.Caption      :=GetLangI(LNG_S_SHCHANNELS_CB_CHANNELS_FLOODENABLE);
  //sh_console
  Label69.Caption                      :=GetLangI(LNG_S_SHCONSOLE_LABEL69);
  Label70.Caption                      :=GetLangI(LNG_S_SHCONSOLE_LABEL70);
  Label71.Caption                      :=GetLangI(LNG_S_SHCONSOLE_LABEL71);
  Label144.Caption                     :=GetLangI(LNG_S_SHCONSOLE_LABEL144);
  Label145.Caption                     :=GetLangI(LNG_S_SHCONSOLE_LABEL145);
  Label146.Caption                     :=GetLangI(LNG_S_SHCONSOLE_LABEL146);
  Label147.Caption                     :=GetLangI(LNG_S_SHCONSOLE_LABEL147);
  //sh_blocked
  Label68.Caption                      :=GetLangI(LNG_S_SHBLOCKED_LABEL68);
  cb_block_napster.Caption             :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NAPSTER);
  cb_block_audiognome.Caption          :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_AUDIOGNOME);
  cb_block_gnomeplus.Caption           :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_GNOMEPLUS);
  cb_block_amster.Caption              :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_AMSTER);
  cb_block_filenavigator.Caption       :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_FILENAVIGATOR);
  cb_block_cqex.Caption                :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_CQEX);
  cb_block_sunshineun.Caption          :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_SUNSHINEUN);
  cb_block_teknap.Caption              :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_TEKNAP);
  cb_block_nap.Caption                 :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NAP);
  cb_block_macnap.Caption              :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_MACNAP);
  cb_block_mp3rage.Caption             :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_MP3RAGE);
  cb_block_xnap.Caption                :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_XNAP);
  cb_block_spotlight.Caption           :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_SPOTLIGHT);
  cb_block_nfs.Caption                 :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NFS);
  cb_block_dmnapster.Caption           :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_DMNAPSTER);
  cb_block_knapster.Caption            :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_KNAPSTER);
  cb_block_lopster.Caption             :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_LOPSTER);
  cb_block_rapigator.Caption           :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_RAPIGATOR);
  cb_block_swaptor.Caption             :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_SWAPTOR);
  cb_block_other.Caption               :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_OTHER);
  Label74.Caption                      :=GetLangI(LNG_S_SHBLOCKED_LABEL74);
  cb_block_dagsta.Caption              :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_DAGSTA);
  cb_block_floodster.Caption           :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_FLOODSTER);
  cb_block_drumbeat.Caption            :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_DRUMBEAT);
  cb_block_custommessage.Caption       :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_CUSTOMMESSAGE);
  cb_block_defaultmessage.Caption      :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_DEFAULTMESSAGE);
  cb_block_nomessage.Caption           :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NOMESSAGE);
  lbl_block_message.Caption            :=GetLangI(LNG_S_SHBLOCKED_LBL_BLOCK_MESSAGE);
  cb_block_mldonkey.Caption            :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_MLDONKEY);
  cb_block_Napigator.Caption           :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NAPIGATOR);
  cb_block_nap08.Caption               :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_NAP08);
  cb_block_opennap.Caption             :=GetLangI(LNG_S_SHBLOCKED_CB_BLOCK_OPENNAP);
  //sh_links
  Label98.Caption                      :=GetLangI(LNG_S_SHLINKS_LABEL98);
  Label139.Caption                     :=GetLangI(LNG_S_SHLINKS_LABEL139);
  Label141.Caption                     :=GetLangI(LNG_S_SHLINKS_LABEL141);
  Label151.Caption                     :=GetLangI(LNG_S_SHLINKS_LABEL151);
  cb_link_all.Caption                  :=GetLangI(LNG_S_SHLINKS_CB_LINK_ALL);
  cb_link_list.Caption                 :=GetLangI(LNG_S_SHLINKS_CB_LINK_LIST);
  cb_link_list2.Caption                :=GetLangI(LNG_S_SHLINKS_CB_LINK_LIST2);
  cb_link_none.Caption                 :=GetLangI(LNG_S_SHLINKS_CB_LINK_NONE);
  cb_link_hub.Caption                  :=GetLangI(LNG_S_SHLINKS_CB_LINK_HUB);
  cb_link_syncreg.Caption              :=GetLangI(LNG_S_SHLINKS_CB_LINK_SYNCREG);
  cb_link_noautoconnect.Caption        :=GetLangI(LNG_S_SHLINKS_CB_LINK_NOAUTOCONNECT);
  cb_link_syncban.Caption              :=GetLangI(LNG_S_SHLINKS_CB_LINK_SYNCBAN);
  cb_link_restrictoutgoing.Caption     :=GetLangI(LNG_S_SHLINKS_CB_LINK_RESTRICTOUTGOING);
  cb_meta_enabled.Caption              :=GetLangI(LNG_S_SHLINKS_CB_META_ENABLED);
  cb_link_syncblock.Caption            :=GetLangI(LNG_S_SHLINKS_CB_LINK_SYNCBLOCK);
  cb_link_maxservers.Caption           :=GetLangI(LNG_S_SHLINKS_CB_LINK_MAXSERVERS);
  //sh_sockets
  lbl_sockets_users_send.Caption       :=GetLangI(LNG_S_SHSOCKETS_LBL_SOCKETS_USERS_SEND);
  lbl_sockets_users_recv.Caption       :=GetLangI(LNG_S_SHSOCKETS_LBL_SOCKETS_USERS_RECV);
  lbl_sockets_servers_send.Caption     :=GetLangI(LNG_S_SHSOCKETS_LBL_SOCKETS_SERVERS_SEND);
  lbl_sockets_servers_recv.Caption     :=GetLangI(LNG_S_SHSOCKETS_LBL_SOCKETS_SERVERS_RECV);
  Label81.Caption                      :=GetLangI(LNG_S_SHSOCKETS_LABEL81);
  cb_sockets_users_def.Caption         :=GetLangI(LNG_S_SHSOCKETS_CB_SOCKETS_USERS_DEF);
  cb_sockets_servers_def.Caption       :=GetLangI(LNG_S_SHSOCKETS_CB_SOCKETS_SERVERS_DEF);
  //sh_report
  Label148.Caption                     :=GetLangI(LNG_S_SHREPORT_LABEL148);
  cb_report_old_enable.Caption         :=GetLangI(LNG_S_SHREPORT_CB_REPORT_OLD_ENABLE);
  Label89.Caption                      :=GetLangI(LNG_S_SHREPORT_LABEL89);
  cb_report_new_enabled.Caption        :=GetLangI(LNG_S_SHREPORT_CB_REPORT_NEW_ENABLED);
  cb_report_new_hidehub.Caption        :=GetLangI(LNG_S_SHREPORT_CB_REPORT_NEW_HIDEHUB);
  Label90.Caption                      :=GetLangI(LNG_S_SHREPORT_LABEL90);
  cb_report_truestats.Caption          :=GetLangI(LNG_S_SHREPORT_CB_REPORT_TRUESTATS);
  ksoOfficeGroupBox2.Caption           :=GetLangI(LNG_S_SHREPORT_KSOOFFICEGROUPBOX2);
  ksoOfficeGroupBox3.Caption           :=GetLangI(LNG_S_SHREPORT_KSOOFFICEGROUPBOX3);
  //sh_other
  Label84.Caption                      :=GetLangI(LNG_S_SHOTHER_LABEL84);
  cb_ann_enable.Caption                :=GetLangI(LNG_S_SHOTHER_CB_ANN_ENABLE);
  Label85.Caption                      :=GetLangI(LNG_S_SHOTHER_LABEL85);
  Label86.Caption                      :=GetLangI(LNG_S_SHOTHER_LABEL86);
  Label87.Caption                      :=GetLangI(LNG_S_SHOTHER_LABEL87);
  Label88.Caption                      :=GetLangI(LNG_S_SHOTHER_LABEL88);
  ksoOfficeGroupBox1.Caption           :=GetLangI(LNG_S_SHOTHER_KSOOFFICEGROUPBOX1);
  //sh_minshare
  Label91.Caption                      :=GetLangI(LNG_S_SHMINSHARE_LABEL91);
  Label92.Caption                      :=GetLangI(LNG_S_SHMINSHARE_LABEL92);
  Label93.Caption                      :=GetLangI(LNG_S_SHMINSHARE_LABEL93);
  Label94.Caption                      :=GetLangI(LNG_S_SHMINSHARE_LABEL94);
  Label95.Caption                      :=GetLangI(LNG_S_SHMINSHARE_LABEL95);
  Label160.Caption                     :=GetLangI(LNG_S_SHMINSHARE_LABEL160);
  cb_minshare_ban.Caption              :=GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_BAN);
  cb_minshare_onlyfull.Caption         :=GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_ONLYFULL);
  cb_minshare_banip.Caption            :=GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_BANIP);
  cb_minshare_full10.Caption           :=GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_FULL10);
  cb_minshare_kickchat.Caption         :=GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_KICKCHAT);
  cb_minshare_wallop.Caption           :=GetLangI(LNG_S_SHMINSHARE_CB_MINSHARE_WALLOP);
  //sh_motd
  Label96.Caption                      :=GetLangI(LNG_S_SHMOTD_LABEL96);
  //sh_colors
  Label104.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL104);
  Label105.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL105);
  Label106.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL106);
  Label107.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL107);
  Label108.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL108);
  Label109.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL109);
  Label110.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL110);
  Label111.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL111);
  Label112.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL112);
  Label113.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL113);
  Label114.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL114);
  Label115.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL115);
  Label116.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL116);
  Label117.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL117);
  Label118.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL118);
  Label119.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL119);
  Label120.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL120);
  Label121.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL121);
  Label122.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL122);
  Label123.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL123);
  Label124.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL124);
  Label125.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL125);
  Label136.Caption                     :=GetLangI(LNG_S_SHCOLORS_LABEL136);
  Label51.Caption                      :=GetLangI(LNG_S_SHCOLORS_LABEL51);
  btn_colors_default.Caption           :=GetLangI(LNG_S_SHCOLORS_BTN_COLORS_DEFAULT);
  //sh_links2
  Label80.Caption                      :=GetLangI(LNG_S_SHLINKS2_LABEL80);
  cb_link2_lagnosearch.Caption         :=GetLangI(LNG_S_SHLINKS2_CB_LINK2_LAGNOSEARCH);
  cb_link2_lagnosearchreq.Caption      :=GetLangI(LNG_S_SHLINKS2_CB_LINK2_LAGNOSEARCHREQ);
  cb_link2_lagnobrowse.Caption         :=GetLangI(LNG_S_SHLINKS2_CB_LINK2_LAGNOBROWSE);
  cb_link2_lagnobrowsereq.Caption      :=GetLangI(LNG_S_SHLINKS2_CB_LINK2_LAGNOBROWSEREQ);
  //sh_dagsta
  Label103.Caption                     :=GetLangI(LNG_S_SHDAGSTA_LABEL103);
  Label129.Caption                     :=GetLangI(LNG_S_SHDAGSTA_LABEL129);
  Label130.Caption                     :=GetLangI(LNG_S_SHDAGSTA_LABEL130);
  Label131.Caption                     :=GetLangI(LNG_S_SHDAGSTA_LABEL131);
  Label132.Caption                     :=GetLangI(LNG_S_SHDAGSTA_LABEL132);
  Label133.Caption                     :=GetLangI(LNG_S_SHDAGSTA_LABEL133);
  Label134.Caption                     :=GetLangI(LNG_S_SHDAGSTA_LABEL134);
  Label135.Caption                     :=GetLangI(LNG_S_SHDAGSTA_LABEL135);
  Label137.Caption                     :=GetLangI(LNG_S_SHDAGSTA_LABEL137);
  btn_dagsta_password.Caption          :=GetLangI(LNG_S_SHDAGSTA_BTN_DAGSTA_PASSWORD);
  cb_dagsta_enabled.Caption            :=GetLangI(LNG_S_SHDAGSTA_CB_DAGSTA_ENABLED);
  btn_dagsta_disconnect.Caption        :=GetLangI(LNG_S_SHDAGSTA_BTN_DAGSTA_DISCONNECT);
  cb_dagsta_autodisconnect.Caption     :=GetLangI(LNG_S_SHDAGSTA_CB_DAGSTA_AUTODISCONNECT);
  //sh_blockedwinmx
  lbl_blockmx_percentage.Caption       :=GetLangI(LNG_S_SHBLOCKEDWINMX_LBL_BLOCKMX_PERCENTAGE);
  Label140.Caption                     :=GetLangI(LNG_S_SHBLOCKEDWINMX_LABEL140);
  Label142.Caption                     :=GetLangI(LNG_S_SHBLOCKEDWINMX_LABEL142);
  Label143.Caption                     :=GetLangI(LNG_S_SHBLOCKEDWINMX_LABEL143);
  cb_blockmx_normal.Caption            :=GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_NORMAL);
  cb_blockmx_limit.Caption             :=GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_LIMIT);
  cb_blockmx_detect.Caption            :=GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_DETECT);
  cb_blockmx_jap.Caption               :=GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_JAP);
  cb_blockmx_pong.Caption              :=GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_PONG);
  cb_blockmx_ban.Caption               :=GetLangI(LNG_S_SHBLOCKEDWINMX_CB_BLOCKMX_BAN);
  //sh_blocks
  cb_blocks_allow_share.Caption        :=GetLangI(LNG_S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE);
  cb_blocks_allow_share_admins.Caption :=GetLangI(LNG_S_SHBLOCKS_CB_BLOCKS_ALLOW_SHARE_ADMINS);
  cb_blocks_checkmods.Caption          :=GetLangI(LNG_S_SHBLOCKS_CB_BLOCKS_CHECKMODS);
  //sh_other2
  Label153.Caption                     :=GetLangI(LNG_S_SHOTHER2_LABEL153);
  Label154.Caption                     :=GetLangI(LNG_S_SHOTHER2_LABEL154);
  gb_searchblock.Caption               :=GetLangI(LNG_S_SHOTHER2_GB_SEARCHBLOCK);
  cb_searchblock_chkfiles.Caption      :=GetLangI(LNG_S_SHOTHER2_CB_SEARCHBLOCK_CHKFILES);
  cb_searchblock_chksize.Caption       :=GetLangI(LNG_S_SHOTHER2_CB_SEARCHBLOCK_CHKSIZE);
  rd_searchblock_hard.Caption          :=GetLangI(LNG_S_SHOTHER2_RD_SEARCHBLOCK_HARD);
  rd_searchblock_normal.Caption        :=GetLangI(LNG_S_SHOTHER2_RD_SEARCHBLOCK_NORMAL);
  gb_domblock.Caption                  :=GetLangI(LNG_S_SHOTHER2_GB_DOMBLOCK);
  cb_domblock_chkfiles.Caption         :=GetLangI(LNG_S_SHOTHER2_CB_DOMBLOCK_CHKFILES);
  cb_domblock_chksize.Caption          :=GetLangI(LNG_S_SHOTHER2_CB_DOMBLOCK_CHKSIZE);
  rd_domblock_hard.Caption             :=GetLangI(LNG_S_SHOTHER2_RD_DOMBLOCK_HARD);
  rd_domblock_normal.Caption           :=GetLangI(LNG_S_SHOTHER2_RD_DOMBLOCK_NORMAL);
  gb_dlfloodblock.Caption              :=GetLangI(LNG_S_SHOTHER2_GB_DLFLOODBLOCK);
  rd_dlfloodblock_block.Caption        :=GetLangI(LNG_S_SHOTHER2_RD_DLFLOODBLOCK_BAN);
  rd_dlfloodblock_leech.Caption        :=GetLangI(LNG_S_SHOTHER2_RD_DLFLOODBLOCK_BLOCK);
  rd_dlfloodblock_ban.Caption          :=GetLangI(LNG_S_SHOTHER2_RD_DLFLOODBLOCK_LEECH);
  gb_wqfloodblock.Caption              :=GetLangI(LNG_S_SHOTHER2_GB_WQFLOODBLOCK);
  rd_wqfloodblock_block.Caption        :=GetLangI(LNG_S_SHOTHER2_RD_WQFLOODBLOCK_BAN);
  rd_wqfloodblock_leech.Caption        :=GetLangI(LNG_S_SHOTHER2_RD_WQFLOODBLOCK_BLOCK);
  rd_wqfloodblock_ban.Caption          :=GetLangI(LNG_S_SHOTHER2_RD_WQFLOODBLOCK_LEECH);
  cb_nocount_text.Caption              :=GetLangI(LNG_S_SHOTHER2_CB_NOCOUNT_TEXT);
  cb_autoban_incomplete.Caption        :=GetLangI(LNG_S_SHOTHER2_CB_AUTOBAN_INCOMPLETE);
  cb_disable_fakeext.Caption           :=GetLangI(LNG_S_SHOTHER2_CB_DISABLE_FAKEEXT);
  cb_enable_trapport.Caption           :=GetLangI(LNG_S_SHOTHER2_CB_ENABLE_TRAPPORT);
  cb_block_transferport.Caption        :=GetLangI(LNG_S_SHOTHER2_CB_BLOCK_TRANSFERPORT);
  cb_share_matchedfile_only.Caption    :=GetLangI(LNG_S_SHOTHER2_CB_SHARE_MATCHEDFILE_ONLY);
  //sh_other3
  Label156.Caption                     :=GetLangI(LNG_S_SHOTHER3_LABEL156);
  Label157.Caption                     :=GetLangI(LNG_S_SHOTHER3_LABEL157);
  Label158.Caption                     :=GetLangI(LNG_S_SHOTHER3_LABEL158);
  Label159.Caption                     :=GetLangI(LNG_S_SHOTHER3_LABEL159);
  GroupBox1.Caption                    :=GetLangI(LNG_S_SHOTHER3_GROUPBOX1);
  Label155.Caption                     :=GetLangI(LNG_S_SHOTHER3_CB_ENABLE_LOGINIM);
  cb_enable_loginim.Caption            :=GetLangI(LNG_S_SHOTHER3_LABEL155);
  cb_channels_forceenter.Caption       :=GetLangI(LNG_S_SHOTHER3_CB_CHANNELS_FORCEENTER);
  cb_allow_2bytename.Caption           :=GetLangI(LNG_S_SHOTHER3_CB_ALLOW_2BYTENAME);
  cb_check_loginpass.Caption           :=GetLangI(LNG_S_SHOTHER3_CB_CHECK_LOGINPASS);
  cb_enable_msgserv.Caption            :=GetLangI(LNG_S_SHOTHER3_CB_ENABLE_MSGSERV);
  cb_restrict_hitperuser.Caption       :=GetLangI(LNG_S_SHOTHER3_CB_RESTRICT_HITPERUSER);
  cb_refresh_servers.Caption           :=GetLangI(LNG_S_SHOTHER3_CB_REFRESH_SERVERS);
  rd_xbutton_attr.Caption              :=GetLangI(LNG_S_SHOTHER3_RD_XBUTTON_ATTR);
  rd_xbutton_attr.Items[0]             :=GetLangI(LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS1);
  rd_xbutton_attr.Items[1]             :=GetLangI(LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS2);
  rd_xbutton_attr.Items[2]             :=GetLangI(LNG_S_SHOTHER3_RD_XBUTTON_ATTR_ITEMS3);
  cb_kill_idleuser.Caption             :=GetLangI(LNG_S_SHOTHER3_CB_KILL_IDLEUSER);
  Label161.Caption                     :=GetLangI(LNG_S_SHOTHER3_LABEL161);
  Label162.Caption                     :=GetLangI(LNG_S_SHOTHER3_LABEL162);
  cb_minshare_noblockact.Caption       :=GetLangI(LNG_S_SHOTHER3_CB_MINSHARE_NOBLOCKACT);
  cb_deny_listall_for_users.Caption    :=GetLangI(LNG_S_SHOTHER3_CB_DENY_LISTALL_FOR_USERS);
  cb_block_weird_xnapfile.Caption      :=GetLangI(LNG_S_SHOTHER3_CB_BLOCK_WEIRD_XNAPFILE);
  cb_suggest_dbrowse.Caption           :=GetLangI(LNG_S_SHOTHER3_CB_SUGGEST_DBROWSE);
  //sh_other4
  cb_regsoft_only.Caption              :=GetLangI(LNG_S_SHOTHER4_CB_REGSOFT_ONLY);
  cb_allow_2get.Caption                :=GetLangI(LNG_S_SHOTHER4_CB_ALLOW_2GET);
  cb_allow_lopster.Caption             :=GetLangI(LNG_S_SHOTHER4_CB_ALLOW_LOPSTER);
  cb_allow_napchan.Caption             :=GetLangI(LNG_S_SHOTHER4_CB_ALLOW_NAPCHAN);
  cb_allow_napster.Caption             :=GetLangI(LNG_S_SHOTHER4_CB_ALLOW_NAPSTER);
  cb_allow_other.Caption               :=GetLangI(LNG_S_SHOTHER4_CB_ALLOW_OTHER);
  cb_allow_teknap.Caption              :=GetLangI(LNG_S_SHOTHER4_CB_ALLOW_TEKNAP);
  cb_allow_utatane.Caption             :=GetLangI(LNG_S_SHOTHER4_CB_ALLOW_UTATANE);
  cb_allow_winmx.Caption               :=GetLangI(LNG_S_SHOTHER4_CB_ALLOW_WINMX);
  cb_allow_xnap.Caption                :=GetLangI(LNG_S_SHOTHER4_CB_ALLOW_XNAP);
  Label163.Caption                     :=GetLangI(LNG_S_SHOTHER4_LABEL163);
end;

procedure TSlavaNapSettings.cb_allow_otherClick(Sender: TObject);
begin
  edit_allow_sign0.Visible:=cb_allow_other.Checked;
  edit_allow_sign1.Visible:=cb_allow_other.Checked;
  edit_allow_sign2.Visible:=cb_allow_other.Checked;
  edit_allow_sign3.Visible:=cb_allow_other.Checked;
  edit_allow_sign4.Visible:=cb_allow_other.Checked;
end;

procedure TSlavaNapSettings.cb_kill_idleuserClick(Sender: TObject);
begin
  Label161.Visible:=cb_kill_idleuser.Checked;
  Label162.Visible:=cb_kill_idleuser.Checked;
  edit_kill_idleuser_time.Visible:=cb_kill_idleuser.Checked;
end;

procedure TSlavaNapSettings.btn_log_folderClick(Sender: TObject);
var
  Memory: IMalloc;
  Buffer: PChar;
  Ret, Root: PItemIDList;
begin
  SHGetMalloc(Memory);
  Buffer:= Memory.Alloc(MAX_PATH);
  SHGetSpecialFolderLocation(SlavaNapSettings.Handle, CSIDL_DRIVES, Root);
  with BrowseInfo do
  begin
    hwndOwner:= SlavaNapSettings.Handle;
    pidlRoot:= Root;
    ulFlags:= BIF_STATUSTEXT ;
    lpszTitle:= 'OtH_w肵ĂB';
    pszDisplayName:= Buffer;
    lpfn:= BrowseCallbackProc;
  end;
  Ret := SHBrowseForFolder(BrowseInfo);
  if SHGetPathFromIDList(Ret, Buffer) then
    edit_log_folder.Text := Buffer;
  if edit_log_folder.Text[Length(edit_log_folder.Text)]<>'\' then
    edit_log_folder.Text := Buffer + '\';
  Memory.Free(Ret);
  Memory.Free(Root);
  Memory.Free(Buffer);
end;

function BrowseCallbackProc(hWnd: HWND; uMsg: UINT; lParam, lpData: lParam): Integer;
var
 Path: array[0..65536] of Char;
begin
  if BrowseInfo.ulFlags=BIF_STATUSTEXT then
  begin
    if uMsg = BFFM_SELCHANGED then
    begin
      SHGetPathFromIDList(PItemIDList(lParam), Path);
      SendMessage(hWnd, BFFM_SETSTATUSTEXT, 0, LongInt(String(Path)));
    end;
  end;
  Result:= 0;
end;

end.


