{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: setupform

 Setup window

*********************************************************}
unit setupform;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, inifiles, constants, vars, stypes, Pages, Classes;

type
  TSlavaNapSetup = class(TForm)
    pages: TDFWPageControles;
    sh1: TDFWTabSheetes;
    sh2: TDFWTabSheetes;
    sh3: TDFWTabSheetes;
    sh4: TDFWTabSheetes;
    Label1: TLabel;
    ksoOfficeButton1: TButton;
    ksoOfficeButton2: TButton;
    ksoOfficeButton3: TButton;
    ksoOfficeButton4: TButton;
    ksoOfficeButton5: TButton;
    ksoOfficeButton6: TButton;
    ksoOfficeButton7: TButton;
    ksoOfficeButton8: TButton;
    ksoOfficeButton9: TButton;
    ksoOfficeButton11: TButton;
    Label3: TLabel;
    edit_ports: TEdit;
    edit_host: TEdit;
    Label4: TLabel;
    edit_admin: TEdit;
    Label5: TLabel;
    Label2: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure ksoOfficeButton2Click(Sender: TObject);
    procedure ksoOfficeButton1Click(Sender: TObject);
    procedure ksoOfficeButton3Click(Sender: TObject);
    procedure ksoOfficeButton5Click(Sender: TObject);
    procedure ksoOfficeButton6Click(Sender: TObject);
    procedure ksoOfficeButton7Click(Sender: TObject);
    procedure ksoOfficeButton11Click(Sender: TObject);
    procedure ksoOfficeButton9Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure ShowSetup;

implementation

uses mainform, languages;

{$R *.DFM}

procedure ShowSetup;
var
 f: TSlavaNapSetup;
begin
 f:=TSlavaNapSetup.Create(SlavaNapWindow);
 f.ShowModal;
end;

procedure TSlavaNapSetup.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 Action:=caFree;
end;

procedure TSlavaNapSetup.FormCreate(Sender: TObject);
var
 ini: TIniFile;
begin
 pages.ActivePage:=sh1;
 Height:=Height-16;
 ini:=TIniFile.Create(ApplicationDir+'config');
 ini.WriteString('Server','Version',SLAVANAP_VERSION);
 edit_ports.Text:=ini.ReadString('Server','Ports',DEF_LISTEN_PORTS);
 edit_host.Text:=ini.ReadString('Server','ReportHost','localhost');
 edit_admin.Text:=ini.ReadString('Console','User','Admin');
 ini.Free;
 SlavaNapLanguage.SetFont(Self);
 label7.Font.Style:=[fsBold];
end;

procedure TSlavaNapSetup.ksoOfficeButton11Click(Sender: TObject);
begin
 pages.ActivePage:=sh2;
end;

procedure TSlavaNapSetup.ksoOfficeButton2Click(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapSetup.ksoOfficeButton1Click(Sender: TObject);
begin
 pages.ActivePage:=sh2;
end;

procedure TSlavaNapSetup.ksoOfficeButton3Click(Sender: TObject);
var
 ini: TIniFile;
begin
 if not check_name(edit_admin.Text,true) then
 begin
   ShowMessage('ǗҖ܂');
   exit;
 end;
 ini:=TIniFile.Create(ApplicationDir+'config');
 ini.WriteString('Server','Version',SLAVANAP_VERSION);
 ini.WriteString('Server','Ports',edit_ports.Text);
 ini.WriteString('Server','ReportHost',edit_host.Text);
 ini.WriteString('Console','User',edit_admin.Text);
 ini.Free;
 Close;
end;

procedure TSlavaNapSetup.ksoOfficeButton5Click(Sender: TObject);
begin
 pages.ActivePage:=sh1;
end;

procedure TSlavaNapSetup.ksoOfficeButton6Click(Sender: TObject);
begin
 pages.ActivePage:=sh2;
end;

procedure TSlavaNapSetup.ksoOfficeButton7Click(Sender: TObject);
begin
 pages.ActivePage:=sh4;
end;

procedure TSlavaNapSetup.ksoOfficeButton9Click(Sender: TObject);
begin
 pages.ActivePage:=sh3;
end;

end.
 