{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: modeform

 Console user mode

*********************************************************}
unit modeform;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  OfficeControls, StdCtrls, OfficeButtons, Classes;

type
  TSlavaNapMode = class(TForm)
    cb_errors: TCheckBox;
    cb_announcements: TCheckBox;
    cb_mban: TCheckBox;
    cb_change: TCheckBox;
    cb_kill: TCheckBox;
    cb_level: TCheckBox;
    cb_server: TCheckBox;
    cb_muzzle: TCheckBox;
    cb_port: TCheckBox;
    cb_wallop: TCheckBox;
    cb_cloak: TCheckBox;
    cb_flood: TCheckBox;
    cb_msg: TCheckBox;
    cb_whois: TCheckBox;
    cb_browse: TCheckBox;
    cb_friends: TCheckBox;
    cb_channel: TCheckBox;
    cb_register: TCheckBox;
    cb_var: TCheckBox;
    btn_ok: TButton;
    btn_all: TButton;
    btn_none: TButton;
    btn_cancel: TButton;
    cb_ping: TCheckBox;
    cb_mbanconn: TCheckBox;
    cb_sban: TCheckBox;
    cb_sbanconn: TCheckBox;
    cb_leech: TCheckBox;
    cb_samenic: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure btn_cancelClick(Sender: TObject);
    procedure btn_allClick(Sender: TObject);
    procedure btn_noneClick(Sender: TObject);
    procedure btn_okClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowForm;
  end;

var
  SlavaNapMode: TSlavaNapMode;

implementation

uses mainform, lang, constants, vars, stypes, languages;

{$R *.DFM}

procedure TSlavaNapMode.FormCreate(Sender: TObject);
var
 r: TRect;
begin
 SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
 Top:=(r.Top+r.Bottom-Height) div 2;
 Left:=(r.Right+r.Left-Width-4) div 2;
 SlavaNapLanguage.SetFont(Self);
end;

procedure TSlavaNapMode.ShowForm;
var
 st: TUserState;
begin
 st:=cons.data^.state;
 caption:=GetLangI(LNG_MODE_CAPTION);
 cb_errors.Caption:=GetLangI(LNG_MODE_ERROR);
 cb_announcements.Caption:=GetLangI(LNG_MODE_ANNOUNCE);
 cb_mban.Caption:=GetLangI(LNG_MODE_MBAN);
 cb_mbanconn.Caption:=GetLangI(LNG_MODE_MBANCONN);
 cb_sban.Caption:=GetLangI(LNG_MODE_SBAN);
 cb_sbanconn.Caption:=GetLangI(LNG_MODE_SBANCONN);
 cb_change.Caption:=GetLangI(LNG_MODE_CHANGE);
 cb_kill.Caption:=GetLangI(LNG_MODE_KILL);
 cb_level.Caption:=GetLangI(LNG_MODE_LEVEL);
 cb_server.Caption:=GetLangI(LNG_MODE_SERVER);
 cb_muzzle.Caption:=GetLangI(LNG_MODE_MUZZLE);
 cb_port.Caption:=GetLangI(LNG_MODE_PORT);
 cb_wallop.Caption:=GetLangI(LNG_MODE_WALLOP);
 cb_cloak.Caption:=GetLangI(LNG_MODE_CLOAK);
 cb_flood.Caption:=GetLangI(LNG_MODE_FLOOD);
 cb_msg.Caption:=GetLangI(LNG_MODE_MSG);
 cb_whois.Caption:=GetLangI(LNG_MODE_WHOIS);
 cb_browse.Caption:=GetLangI(LNG_MODE_BROWSE);
 cb_friends.Caption:=GetLangI(LNG_MODE_FRIEND);
 cb_channel.Caption:=GetLangI(LNG_MODE_CHANNEL);
 cb_register.Caption:=GetLangI(LNG_MODE_REGISTER);
 cb_var.Caption:=GetLangI(LNG_MODE_VAR);
 cb_ping.Caption:=GetLangI(LNG_MODE_PING);
 cb_leech.Caption:=GetLangI(LNG_MODE_LEECH);
 cb_samenic.Caption:=GetLangI(LNG_MODE_SAMENIC);
 btn_ok.Caption:=GetLangI(LNG_MODE_OK);
 btn_all.Caption:=GetLangI(LNG_MODE_ALL);
 btn_none.Caption:=GetLangI(LNG_MODE_NONE);
 btn_cancel.Caption:=GetLangI(LNG_MODE_CANCEL);
 cb_errors.Checked:=not (userHideErrors in st);
 cb_announcements.Checked:=not (userHideAnnouncements in st);
 cb_mban.Checked:=not (userHideMBans in st);
 cb_mbanconn.Checked:=not (userHideMBanConn in st);
 cb_sban.Checked:=not (userHideSBans in st);
 cb_sbanconn.Checked:=not (userHideSBanConn in st);
 cb_change.Checked:=not (userHideChange in st);
 cb_kill.Checked:=not (userHideKill in st);
 cb_level.Checked:=not (userHideLevel in st);
 cb_server.Checked:=not (userHideServer in st);
 cb_muzzle.Checked:=not (userHideMuzzle in st);
 cb_port.Checked:=not (userHidePort in st);
 cb_wallop.Checked:=not (userHideWallop in st);
 cb_cloak.Checked:=not (userHideCloak in st);
 cb_flood.Checked:=not (userHideFlood in st);
 cb_msg.Checked:=not (userHidePM in st);
 cb_whois.checked:=not (userHideWhois in st);
 cb_browse.Checked:=not (userHideBrowse in st);
 cb_friends.Checked:=not (userHideFriends in st);
 cb_channel.Checked:=not (userHideChannel in st);
 cb_register.Checked:=not (userHideRegister in st);
 cb_var.Checked:=not (userHideVar in st);
 cb_ping.Checked:=not (userHidePing in st);
 cb_leech.Checked:=not (userHideLeech in st);
 cb_samenic.checked:=not (userHideSameNic in st);
 try
  Show;
  except
 end;
end;


procedure TSlavaNapMode.btn_cancelClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapMode.btn_allClick(Sender: TObject);
begin
 cmd_list.AddDoubleCmd(MSG_CLIENT_USER_MODE,0,'ALL','');
 Close;
end;

procedure TSlavaNapMode.btn_noneClick(Sender: TObject);
begin
 cmd_list.AddDoubleCmd(MSG_CLIENT_USER_MODE,0,'NONE','');
 Close;
end;

procedure TSlavaNapMode.btn_okClick(Sender: TObject);
var
 str: String;
begin
 Close;
 if cb_errors.Checked then str:='+ERROR'
 else str:='-ERROR';
 if cb_announcements.Checked then str:=str+' +ANNOUNCE'
 else str:=str+' -ANNOUNCE';
 if cb_mban.Checked then str:=str+' +MBAN'
 else str:=str+' -MBAN';
 if cb_mbanconn.Checked then str:=str+' +MBANCONN'
 else str:=str+' -MBANCONN';
 if cb_sban.Checked then str:=str+' +SBAN'
 else str:=str+' -SBAN';
 if cb_sbanconn.Checked then str:=str+' +SBANCONN'
 else str:=str+' -SBANCONN';
 if cb_change.Checked then str:=str+' +CHANGE'
 else str:=str+' -CHANGE';
 if cb_kill.checked then str:=str+' +KILL'
 else str:=str+' -KILL';
 if cb_level.Checked then str:=str+' +LEVEL'
 else str:=str+' -LEVEL';
 if cb_server.Checked then str:=str+' +SERVER'
 else str:=str+' -SERVER';
 if cb_muzzle.Checked then str:=str+' +MUZZLE'
 else str:=str+' -MUZZLE';
 if cb_port.checked then str:=str+' +PORT'
 else str:=str+' -PORT';
 if cb_wallop.Checked then str:=str+' +WALLOP'
 else str:=str+' -WALLOP';
 if cb_cloak.Checked then str:=str+' +CLOAK'
 else str:=str+' -CLOAK';
 if cb_flood.Checked then str:=str+' +FLOOD'
 else str:=str+' -FLOOD';
 if cb_msg.Checked then str:=str+' +MSG'
 else str:=str+' -MSG';
 if cb_whois.checked then str:=str+' +WHOIS'
 else str:=str+' -WHOIS';
 if cb_browse.Checked then str:=str+' +BROWSE'
 else str:=str+' -BROWSE';
 if cb_friends.Checked then str:=str+' +FRIEND'
 else str:=str+' -FRIEND';
 if cb_channel.Checked then str:=str+' +CHANNEL'
 else str:=str+' -CHANNEL';
 if cb_register.Checked then str:=str+' +REGISTER'
 else str:=str+' -REGISTER';
 if cb_var.Checked then str:=str+' +VAR'
 else str:=str+' -VAR';
 if cb_ping.Checked then str:=str+' +PING'
 else str:=str+' -PING';
 if cb_leech.Checked then str:=str+' +LEECH'
 else str:=str+' -LEECH';
 if cb_samenic.Checked then str:=str+' +SAMENIC'
 else str:=str+' -SAMENIC';
 cmd_list.AddDoubleCmd(MSG_CLIENT_USER_MODE,0,str,'');
end;

end.
