{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: editdialog

 Window for editing string

*********************************************************}
unit editdialog;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OfficeButtons, OfficeEdit, Classes;

const
 SE_NAPIGATORPASS   = 0;
 SE_ADDCHANNEL = 1;
 SE_DAGSTAPASS = 2;

type
  TSlavaNapEdit = class(TForm)
    Label1: TLabel;
    edit: TksoEdit;
    btn_ok: TksoOfficeButton;
    btn_cancel: TksoOfficeButton;
    procedure btn_cancelClick(Sender: TObject);
    procedure btn_okClick(Sender: TObject);
    function  CheckData: Boolean;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    query: Integer;
    procedure Ask(q: Integer);
  end;

var
  SlavaNapEdit: TSlavaNapEdit;

implementation

uses lang, stypes, vars, constants, languages;

procedure TSlavaNapEdit.Ask(q: Integer);
begin
 query:=q;
 case query of
    SE_NAPIGATORPASS:    begin
                           label1.Caption:=GetLangI(LNG_EDIT_NAPIGATOR);
                           edit.Text:='';
                           edit.PasswordChar:='*';
                           btn_ok.Caption:=GetLangI(LNG_OK);
                           btn_cancel.Caption:=GetLangI(LNG_CANCEL);
                         end;
    SE_DAGSTAPASS:    begin
                           label1.Caption:=GetLangI(LNG_EDIT_DAGSTA);
                           edit.Text:='';
                           edit.PasswordChar:='*';
                           btn_ok.Caption:=GetLangI(LNG_OK);
                           btn_cancel.Caption:=GetLangI(LNG_CANCEL);
                         end;
    SE_ADDCHANNEL:       begin
                           label1.Caption:=GetLangI(LNG_EDIT_ADDCHANNEL);
                           edit.Text:='channel';
                           edit.PasswordChar:=#0;
                           btn_ok.Caption:=GetLangI(LNG_OK);
                           btn_cancel.Caption:=GetLangI(LNG_CANCEL);
                         end;
 end;
 try
   Show;
   edit.SetFocus;
  except
 end;
end;


{$R *.DFM}

procedure TSlavaNapEdit.btn_cancelClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapEdit.btn_okClick(Sender: TObject);
begin
 if not CheckData then
 try
   edit.SetFocus;
   exit;
  except
   exit;
 end;
 Close;
 if not running then exit;
 if cmd_list=nil then exit;
 case query of
  SE_NAPIGATORPASS:   cmd_list.AddDoubleCmd(MSG_CMD_SETNAPIGATORPASS,0,edit.text,'');
  SE_DAGSTAPASS:      cmd_list.AddDoubleCmd(MSG_CMD_SETDAGSTAPASS,0,edit.text,'');
  SE_ADDCHANNEL:      cmd_list.AddDoubleCmd(MSG_CLIENT_ADDCHANNEL,0,edit.text,'');
 end;
end;

function TSlavaNapEdit.CheckData: Boolean;
begin
  Result:=true;
  case query of
    SE_ADDCHANNEL:  Result:=channelname(edit.text)<>'';
  end;
end;

procedure TSlavaNapEdit.FormCreate(Sender: TObject);
begin
  SlavaNapLanguage.SetFont(Self);
end;

end.
