{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: keywords

 Functions to manage/search keywords list

*********************************************************}
unit keywords;

interface

uses
 Windows, Classes2, SysUtils, stypes, constants, slavastrings, class_cmdlist,
 class_cmd2list, keywords2, share;

{$I defines.pas}

procedure InitKeywords; // should be called before first share/search command
procedure FreeKeywords; // should be called after all files are unshared
function  SplitToKeywords(str: String; list: TNapCmdList; limit: Integer): Integer;
procedure SplitToKeywordsEx(inc_str, exc_str: String; inc_list, exc_list: TNapCmdList; limit: Integer);
function  GetKeywordIndex(keyword: String): Integer;
procedure LoadDirs;
procedure SaveDirs;
procedure FreeDirs;

var
 // global list of keywords.
 // sorted this way (3-dimentional array to search it faster):
 // 1 - type of shared file: SHARED_xxx constants
 // 2 - first character of keyword
 // 3 - length of keyword
 db_keywords: Array[0..SHARED_ARRAY-1,0..KEYWORDS_FIRST_COUNT-1,KEYWORD_LEN_MIN..KEYWORD_LEN_MAX] of PKeywordList;

implementation

uses
 vars, handler;

function SplitToKeywords(str: String; list: TNapCmdList; limit: Integer): Integer;
var
 i, start, count, added, crc: Integer;
 spacing: Boolean;
 c: Char;
 item: String;
begin // extract up to $limit keywords from string and add it to list with CRC
 // before calling this function you should add ' ' at the end of string or you might loose your last keyword
 tmp_pos:=1280;
 result:=0;
 spacing:=true;
 for i:=1 to Length(str) do
 begin
   c:=str[i];
   if spacing then
   begin // searching for beginning of keyword
//     if pos(c,KEYWORDS_FIRST)>0 then // found our first keyword character
     if pos(c,KEYWORDS_SEPARATORS)=0 then // found our first keyword character
     begin
       start:=i;
       spacing:=false;
     end;
   end
   else
   begin // searching for end of keyword
     if pos(c,KEYWORDS_SEPARATORS)>0 then // found spacing
     if not (ByteType(str,i)=mbTrailByte) then
     begin
       spacing:=true;
       count:=i-start;
       if count>=KEYWORD_LEN_MIN then
       begin
         if count>KEYWORD_LEN_MAX then count:=KEYWORD_LEN_MAX;
         item:=Copy(str,start,count);
         crc:=StringCRC(item,false);
         if list.FindItem(crc,item)=-1 then
         begin
           list.AddCmd(crc,item);
           inc(result);
           if result>=limit then exit;
         end;
       end;
     end;
   end;
 end;
 tmp_pos:=1281;
end;

procedure SplitToKeywordsEx(inc_str, exc_str: String; inc_list, exc_list: TNapCmdList; limit: Integer);
var 
 i, j, start, count, added, crc: Integer; 
 spacing, hardspacing, excluding, last_exc: Boolean; 
 c: Char; 
 item: String; 
begin // extract up to $limit keywords from string and add it to list with CRC 
 // before calling this function you should add ' ' at the end of string or you might loose your last keyword 
 tmp_pos:=1280; 
 spacing:=true; 
 hardspacing:=true; 
 excluding:=false; 
 last_exc:=false; 
 for i:=1 to Length(inc_str) do 
 begin 
   c:=inc_str[i]; 
   if spacing then 
   begin // searching for beginning of keyword
//     if pos(c,KEYWORDS_FIRST)>0 then // found our first keyword character
     if pos(c,KEYWORDS_SEPARATORS)=0 then // found our first keyword character
     begin
       start:=i;
       spacing:=false; 
       hardspacing:=false;
       excluding:=last_exc;
       last_exc:=false; 
     end 
     else 
     begin 
      if (c='-') and hardspacing then
        last_exc:=true
      else
        last_exc:=false;
      if c=#$20 then hardspacing:=true 
      else hardspacing:=false;
     end;
   end 
   else 
   begin // searching for end of keyword
     last_exc:=false;
     hardspacing:=false; 
     if pos(c,KEYWORDS_SEPARATORS)>0 then // found spacing 
     if not (ByteType(inc_str,i)=mbTrailByte) then
     begin
       spacing:=true;
       if c=#$20 then hardspacing:=true;
       count:=i-start;
       if count>=KEYWORD_LEN_MIN then
       begin 
         if count>KEYWORD_LEN_MAX then count:=KEYWORD_LEN_MAX; 
         item:=Copy(inc_str,start,count); 
         crc:=StringCRC(item,false); 
         if excluding then 
         begin 
           if exc_list.FindItem(crc,item)=-1 then 
            exc_list.AddCmd(crc,item); 
           j:=inc_list.FindItem(crc,item); 
           if j<>-1 then 
            inc_list.Delete(j); 
         end
         else
         begin 
           if (inc_list.FindItem(crc,item)=-1) and (inc_list.count<limit) then 
             inc_list.AddCmd(crc,item); 
           j:=exc_list.FindItem(crc,item); 
           if j<>-1 then 
            exc_list.Delete(j); 
         end; 
       end; 
     end; 
   end; 
 end; 
 spacing:=true; 
 hardspacing:=false; 
 for i:=1 to Length(exc_str) do 
 begin 
   c:=exc_str[i]; 
   if spacing then 
   begin // searching for beginning of keyword 
//     if pos(c,KEYWORDS_FIRST)>0 then // found our first keyword character
     if pos(c,KEYWORDS_SEPARATORS)=0 then // found our first keyword character
     begin
       start:=i; 
       spacing:=false; 
     end; 
   end 
   else 
   begin // searching for end of keyword 
     if pos(c,KEYWORDS_SEPARATORS)>0 then // found spacing 
     if not (ByteType(exc_str,i)=mbTrailByte) then
     begin
       spacing:=true; 
       count:=i-start;
       if count>=KEYWORD_LEN_MIN then
       begin 
         if count>KEYWORD_LEN_MAX then count:=KEYWORD_LEN_MAX;
         item:=Copy(exc_str,start,count);
         crc:=StringCRC(item,false); 
         if exc_list.FindItem(crc,item)=-1 then
         begin
           exc_list.AddCmd(crc,item);
         end; 
         j:=inc_list.FindItem(crc,item); 
         if j<>-1 then 
          inc_list.Delete(j); 
       end; 
     end;
   end; 
 end; 
 tmp_pos:=1281; 
end; 

function GetKeywordIndex(keyword: String): Integer;
// returns index of keyword or -1 if keyword is invalid
begin
 if Length(keyword)<1 then Result:=KEYWORDS_NOINDEX
 else if pos(keyword[1],KEYWORDS_FIRST)=0 then result:=KEYWORDS_FIRST_COUNT-1//2byte char
 else result:=pos(keyword[1],KEYWORDS_FIRST)-1;
end;

procedure InitKeywords;
var
 i,j,k: Integer;
begin
 for i:=0 to SHARED_ARRAY-1 do
  for j:=0 to KEYWORDS_FIRST_COUNT-1 do
   for k:=KEYWORD_LEN_MIN to KEYWORD_LEN_MAX do
    db_keywords[i,j,k]:=KWList_CreateList;
end;

procedure FreeKeywords;
var
 i,j,k: Integer;
begin
 for i:=0 to SHARED_ARRAY-1 do
  for j:=0 to KEYWORDS_FIRST_COUNT-1 do
   for k:=KEYWORD_LEN_MIN to KEYWORD_LEN_MAX do
   begin
    KWList_FreeList(db_keywords[i,j,k]);
    db_keywords[i,j,k]:=nil;
   end;
end;

procedure LoadDirs;
var
 list: TMyStringList;
 i: Integer;
 str: String;
begin
 if db_dirs<>nil then db_dirs.Clear
 else db_dirs:=TNapCmdList.Create;
 list:=TMyStringList.Create;
 try
  list.LoadFromFile(ApplicationDir+'dirs');
  except
 end;
 for i:=0 to list.count-1 do
  if Length(list.Strings[i])>1 then
   if list.Strings[i][1]<>'#' then
   begin
    str:=AnsiLowerCase(list.Strings[i]);
    db_dirs.AddCmd(StringCRC(str,false),str);
   end;
 list.Free;
end;

procedure SaveDirs;
var
 list: TMyStringList;
 i: Integer;
begin
 if db_dirs=nil then exit;
 list:=TMyStringList.Create;
 for i:=0 to db_dirs.Count-1 do
  list.Add(PNapCmd(db_dirs.Items[i])^.cmd);
 list.Sort;
 list.Insert(0,'# CfbNXȂA悭fBNg̈ꗗ');
 list.Insert(1,'# ');
 list.Insert(2,'# 悭gfBNgL珜O΁A');
 list.Insert(3,'# ʂȌʂāAT[o[gȂĂ݂܂B');
 list.Insert(4,'# ');
 try
  list.SaveToFile(ApplicationDir+'dirs');
  except
 end;
 list.Free;
end;

procedure FreeDirs;
begin
 if db_dirs<>nil then db_dirs.Free;
 db_dirs:=nil;
end;

initialization
 db_dirs:=nil;
end.
