/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.renderer;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.bootchart.common.BootStats;
import org.bootchart.common.CPUSample;
import org.bootchart.common.Common;
import org.bootchart.common.DiskTPutSample;
import org.bootchart.common.DiskUtilSample;
import org.bootchart.common.FileOpenSample;
import org.bootchart.common.Process;
import org.bootchart.common.ProcessSample;
import org.bootchart.common.ProcessTree;
import org.bootchart.common.Sample;
import org.bootchart.common.Stats;
import org.bootchart.parser.linux.ProcDiskStatParser;
import org.bootchart.renderer.CSSInliner;
import org.bootchart.renderer.Renderer;

public class SVGRenderer
extends Renderer {
    private static final File CHART_SVG_TEMPLATE = new File("svg/bootchart.svg.template");
    private static final File PROCESS_SVG_TEMPLATE = new File("svg/process.svg.template");
    private static final File SVG_CSS_FILE = new File("svg/style.css");
    private static final boolean COMPRESS_SVG = true;
    private static final DateFormat BOOT_TIME_FORMAT = new SimpleDateFormat("m:ss", Common.LOCALE);
    private static final int MIN_IMG_W = 800;
    private static final boolean INLINE_CSS = true;
    static String processTemplate = null;

    @Override
    public void render(Properties properties, BootStats bootStats, OutputStream outputStream) throws IOException {
        Object object;
        int n;
        Object object22;
        CharSequence charSequence;
        Stats stats = bootStats.diskStats;
        Stats stats2 = bootStats.cpuStats;
        ProcessTree processTree = bootStats.procTree;
        long l = processTree.duration;
        int n2 = 25;
        int n3 = (int)(l / 1000L * (long)n2);
        int n4 = 16;
        int n5 = 300;
        int n6 = n4 * processTree.numProc + n5;
        String string = "width=\"" + Math.max(n3, 800) + "px\" height=\"" + (n6 + 1) + "px\"";
        String string2 = Common.loadFile(CHART_SVG_TEMPLATE);
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (properties != null) {
            string4 = SVGRenderer.encodeArg(properties.getProperty("title", ""));
            string5 = "uname: " + SVGRenderer.encodeArg(properties.getProperty("system.uname", ""));
            string6 = "release: " + SVGRenderer.encodeArg(properties.getProperty("system.release", ""));
            string7 = "CPU: " + SVGRenderer.encodeArg(properties.getProperty("system.cpu", ""));
            string7 = string7.replaceFirst("model name\\s*:\\s*", "");
            string8 = properties.getProperty("profile.process") != null ? "application: " + SVGRenderer.encodeArg(properties.getProperty("profile.process")) : "kernel options: " + SVGRenderer.encodeArg(properties.getProperty("system.kernel.options", ""));
        }
        Date date = new Date(Math.round((double)l / 1000.0) * 1000L);
        String string9 = "time: " + BOOT_TIME_FORMAT.format(date);
        int n7 = 50;
        StringBuffer stringBuffer = new StringBuffer();
        int n8 = 0;
        while ((long)n8 <= l / 1000L) {
            int n9 = n8 * n2;
            charSequence = n8 % 5 == 0 ? "class=\"Bold\" " : "";
            stringBuffer.append("<line " + (String)charSequence + "x1=\"" + n9 + "\" " + "y1=\"0\" x2=\"" + n9 + "\" y2=\"" + n7 + "\"/>\n");
            ++n8;
        }
        String string10 = stringBuffer.toString();
        string10 = string10.replaceAll("\n", "\n\t\t\t");
        string10 = string10.trim();
        stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        charSequence = new StringBuffer();
        if (stats2 != null) {
            int n10;
            int n11 = 0;
            for (Object object22 : stats2.getSamples()) {
                n = (int)((((CPUSample)object22).time.getTime() - processTree.startTime.getTime()) * (long)n3 / l);
                n10 = n7 - (int)((((CPUSample)object22).user + ((CPUSample)object22).sys + ((CPUSample)object22).io) * (double)n7);
                if (stringBuffer2.length() == 0) {
                    stringBuffer2.append(n + "," + n7);
                }
                stringBuffer2.append(" " + n + "," + n10);
                n11 = n;
            }
            stringBuffer2.append(" " + n11 + "," + n7);
            n11 = 0;
            for (Object object22 : stats2.getSamples()) {
                n = (int)((((CPUSample)object22).time.getTime() - processTree.startTime.getTime()) * (long)n3 / l);
                n10 = n7 - (int)((((CPUSample)object22).user + ((CPUSample)object22).sys) * (double)n7);
                if (((StringBuffer)charSequence).length() == 0) {
                    ((StringBuffer)charSequence).append(n + "," + n7);
                }
                ((StringBuffer)charSequence).append(" " + n + "," + n10);
                n11 = n;
            }
            ((StringBuffer)charSequence).append(" " + n11 + "," + n7);
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        Iterator iterator = new StringBuffer();
        object22 = new StringBuffer();
        if (stats != null) {
            int n12;
            n = 0;
            for (Sample sample : stats.getSamples()) {
                if (!(sample instanceof DiskUtilSample)) continue;
                DiskUtilSample diskUtilSample = (DiskUtilSample)sample;
                Iterator iterator2 = new Date(processTree.startTime.getTime() + l);
                if (diskUtilSample.time.compareTo(processTree.startTime) < 0 || diskUtilSample.time.compareTo((Date)((Object)iterator2)) > 0) continue;
                int n13 = (int)((diskUtilSample.time.getTime() - processTree.startTime.getTime()) * (long)n3 / l);
                int n14 = n7 - (int)(diskUtilSample.util * (double)n7);
                n = n13;
                if (stringBuffer3.length() == 0) {
                    stringBuffer3.append(n13 + "," + n7);
                }
                stringBuffer3.append(" " + n13 + "," + n14);
            }
            stringBuffer3.append(" " + n + "," + n7);
            Object object3 = null;
            double d = ProcDiskStatParser.getMaxDiskTPut(stats.getSamples());
            for (Sample sample : stats.getSamples()) {
                if (!(sample instanceof DiskTPutSample)) continue;
                DiskTPutSample diskTPutSample = (DiskTPutSample)sample;
                Date date2 = new Date(processTree.startTime.getTime() + l);
                if (diskTPutSample.time.compareTo(processTree.startTime) < 0 || diskTPutSample.time.compareTo(date2) > 0) continue;
                n12 = (int)((diskTPutSample.time.getTime() - processTree.startTime.getTime()) * (long)n3 / l);
                double d2 = (diskTPutSample.read + diskTPutSample.write) / d;
                int n15 = n7 - (int)(d2 * (double)n7);
                if (object3 != null) {
                    ((StringBuffer)((Object)iterator)).append("\t\t\t<line x1=\"" + ((Point)object3).x + "\" y1=\"" + ((Point)object3).y + "\" x2=\"" + n12 + "\" y2=\"" + n15 + "\"/>\n");
                }
                object3 = new Point(n12, n15);
            }
            for (Sample sample : stats.getSamples()) {
                if (!(sample instanceof DiskTPutSample)) continue;
                DiskTPutSample diskTPutSample = (DiskTPutSample)sample;
                if (diskTPutSample.read + diskTPutSample.write != d) continue;
                int n16 = (int)((diskTPutSample.time.getTime() - processTree.startTime.getTime()) * (long)n3 / l);
                n12 = n7 - (int)(1.0 * (double)n7);
                String string11 = (int)Math.round((diskTPutSample.read + diskTPutSample.write) / 1024.0) + " MB/s";
                ((StringBuffer)((Object)iterator)).append("\t\t\t<text class=\"DiskLabel\" x=\"" + n16 + "\" y=\"" + n12 + "\" " + "dx=\"-" + string11.length() / 3 + "em\" dy=\"-2px\">" + string11 + "</text>\n");
                break;
            }
            object3 = null;
            int n17 = FileOpenSample.getMaxFileOpens(stats.getSamples());
            for (Sample sample : stats.getSamples()) {
                if (!(sample instanceof FileOpenSample)) continue;
                FileOpenSample fileOpenSample = (FileOpenSample)sample;
                Date date3 = new Date(processTree.startTime.getTime() + l);
                if (fileOpenSample.time.compareTo(processTree.startTime) < 0 || fileOpenSample.time.compareTo(date3) > 0) continue;
                int n18 = (int)((fileOpenSample.time.getTime() - processTree.startTime.getTime()) * (long)n3 / l);
                double d3 = (double)fileOpenSample.fileOpens / (double)n17;
                int n19 = n7 - (int)(d3 * (double)n7);
                if (object3 != null) {
                    ((StringBuffer)object22).append("\t\t\t<line x1=\"" + ((Point)object3).x + "\" y1=\"" + ((Point)object3).y + "\" x2=\"" + n18 + "\" y2=\"" + n19 + "\"/>\n");
                }
                object3 = new Point(n18, n19);
            }
            for (Sample sample : stats.getSamples()) {
                if (!(sample instanceof FileOpenSample)) continue;
                FileOpenSample fileOpenSample = (FileOpenSample)sample;
                if (fileOpenSample.fileOpens != n17) continue;
                int n20 = (int)((fileOpenSample.time.getTime() - processTree.startTime.getTime()) * (long)n3 / l);
                int n21 = n7 - (int)(1.0 * (double)n7);
                String string12 = fileOpenSample.fileOpens + "/s";
                ((StringBuffer)object22).append("\t\t\t<text class=\"FileOpenLabel\" x=\"" + n20 + "\" y=\"" + n21 + "\" " + "dx=\"-" + string12.length() / 3 + "em\" dy=\"-5px\">" + string12 + "</text>\n");
                break;
            }
        }
        n = processTree.numProc * n4;
        stringBuffer = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n22 = 0;
        while ((long)n22 <= l / 1000L) {
            int n23 = n22 * n2;
            String string13 = n22 % 5 == 0 ? "class=\"Bold\" " : "";
            stringBuffer.append("<line " + string13 + "x1=\"" + n23 + "\" " + "y1=\"0\" x2=\"" + n23 + "\" y2=\"" + n + "\"/>\n");
            if (n22 > 0 && n22 % 5 == 0) {
                object = n22 + "s";
                int n24 = ((String)object).length();
                stringBuffer4.append("<text class=\"AxisLabel\" x=\"" + n23 + "\" y=\"0\" dx=\"" + (double)(-n24) / 4.0 + "em\" dy=\"-3\">" + (String)object + "</text>\n");
            }
            ++n22;
        }
        String string14 = stringBuffer.toString();
        String string15 = stringBuffer4.toString();
        string14 = string14.replaceAll("\n", "\n\t\t\t");
        string15 = string15.replaceAll("\n", "\n\t\t\t");
        string14 = string14.trim();
        string15 = string15.trim();
        Rectangle rectangle = new Rectangle(0, 0, n3, processTree.numProc * n4);
        object = new StringBuffer();
        this.renderProcessList(processTree.processTree, -1, -1, processTree, 0, n4, rectangle, (StringBuffer)object);
        if (stringBuffer2.length() == 0) {
            stringBuffer2.append("0,0");
        }
        if (((StringBuffer)charSequence).length() == 0) {
            ((StringBuffer)charSequence).append("0,0");
        }
        if (stringBuffer3.length() == 0) {
            stringBuffer3.append("0,0");
        }
        if (((StringBuffer)((Object)iterator)).length() == 0) {
            ((StringBuffer)((Object)iterator)).append("0,0");
        }
        if (((StringBuffer)object22).length() == 0) {
            ((StringBuffer)object22).append("0,0");
        }
        Object[] objectArray = new Object[]{string, string3, string4, string5, string6, string7, string8, string9, string10, stringBuffer2.toString(), ((StringBuffer)charSequence).toString(), string10, stringBuffer3.toString(), ((StringBuffer)((Object)iterator)).toString().trim(), ((StringBuffer)object22).toString().trim(), string15, string14, ((StringBuffer)object).toString()};
        String string16 = MessageFormat.format(string2, objectArray);
        Object object4 = SVG_CSS_FILE;
        string16 = CSSInliner.inline(string16, (File)object4);
        object4 = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object4);
        gZIPOutputStream.write(string16.getBytes());
        gZIPOutputStream.close();
        outputStream.write(((ByteArrayOutputStream)object4).toByteArray());
    }

    private int renderProcessList(List list, int n, int n2, ProcessTree processTree, int n3, int n4, Rectangle rectangle, StringBuffer stringBuffer) {
        for (Process process : list) {
            String string = this.renderProcess(process, n, n2, processTree, n3, n4, rectangle);
            string = string.replaceAll("\n", "\n\t\t\t");
            string = string.trim();
            stringBuffer.append(string);
            int n5 = rectangle.x + (int)((process.startTime.getTime() - processTree.startTime.getTime()) * (long)rectangle.width / processTree.duration);
            int n6 = n3 + n4;
            n3 = this.renderProcessList(process.childList, n5, n6, processTree, n3 + n4, n4, rectangle, stringBuffer);
        }
        return n3;
    }

    private String renderProcess(Process process, int n, int n2, ProcessTree processTree, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6;
        Object object2;
        if (processTemplate == null) {
            try {
                processTemplate = Common.loadFile(PROCESS_SVG_TEMPLATE);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        int n7 = rectangle.x + (int)((process.startTime.getTime() - processTree.startTime.getTime()) * (long)rectangle.width / processTree.duration);
        int n8 = (int)(process.duration * (long)rectangle.width / processTree.duration);
        String string = n7 + "," + n3;
        String string2 = "width=\"" + n8 + "\" height=\"" + n4 + "\"";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<rect class=\"Sleeping\" x=\"0\" y=\"0\" width=\"" + n8 + "\" height=\"" + n4 + "\"/>\n");
        int n9 = -1;
        for (Object object2 : process.samples) {
            if (((ProcessSample)object2).time.before(process.startTime) || ((ProcessSample)object2).time.after(new Date(process.startTime.getTime() + process.duration - (long)processTree.samplePeriod))) continue;
            n6 = (int)Math.round((double)((((ProcessSample)object2).time.getTime() - process.startTime.getTime()) * (long)rectangle.width) / (double)processTree.duration);
            n5 = (int)Math.round((double)(processTree.samplePeriod * rectangle.width) / (double)processTree.duration);
            if (n9 != -1 && Math.abs(n9 - n6) <= 3) {
                n5 += n6 - n9;
                n6 = n9;
            }
            n9 = n6 + n5;
            int n10 = ((ProcessSample)object2).state;
            double d = ((ProcessSample)object2).cpu.user + ((ProcessSample)object2).cpu.sys;
            String string3 = "Sleeping";
            String string4 = "";
            switch (n10) {
                case 3: {
                    string3 = "UnintSleep";
                    break;
                }
                case 1: {
                    double d2 = d;
                    string3 = "Running";
                    string4 = "fill-opacity=\"" + d2 + "\" ";
                    break;
                }
                case 2: {
                    string3 = null;
                    break;
                }
                case 4: {
                    string3 = "Traced";
                    break;
                }
                case 5: {
                    string3 = "Zombie";
                    break;
                }
            }
            if (string3 == null) continue;
            stringBuffer.append("<rect class=\"" + string3 + "\" " + string4 + "x=\"" + n6 + "\" y=\"0\" width=\"" + n5 + "\" height=\"" + n4 + "\"/>\n");
        }
        Object object3 = stringBuffer.toString();
        object3 = ((String)object3).replaceAll("\n", "\n\t\t");
        object3 = ((String)object3).trim();
        object2 = new StringBuffer();
        if (n != -1 && n2 != -1) {
            n2 -= n3;
            if ((n -= n7) == 0) {
                n6 = 3;
                n5 = n4 / 4;
                Point point = new Point(0, n4 / 2);
                Point point2 = new Point(n - n6, n4 / 2);
                ((StringBuffer)object2).append(SVGRenderer.getConnLineSVG(point, point2) + "\n");
                point = new Point(n - n6, n4 / 2);
                point2 = new Point(n - n6, n2 - n5);
                ((StringBuffer)object2).append(SVGRenderer.getConnLineSVG(point, point2) + "\n");
                point = new Point(n - n6, n2 - n5);
                point2 = new Point(n, n2 - n5);
                ((StringBuffer)object2).append(SVGRenderer.getConnLineSVG(point, point2) + "\n");
            } else {
                Point point = new Point(0, n4 / 2);
                Point point3 = new Point(n, n4 / 2);
                ((StringBuffer)object2).append(SVGRenderer.getConnLineSVG(point, point3) + "\n");
                point = new Point(n, n4 / 2);
                point3 = new Point(n, n2);
                ((StringBuffer)object2).append(SVGRenderer.getConnLineSVG(point, point3) + "\n");
            }
        }
        String string5 = "";
        string5 = n8 < 200 && n7 + n8 + 200 < rectangle.x + rectangle.width ? "dx=\"2\" dy=\"" + (n4 - 1) + "\" x=\"" + n8 + "\" y=\"0\"" : "dx=\"2\" dy=\"" + (n4 - 1) + "\" x=\"0\" y=\"0\"";
        String string6 = process.cmd;
        String string7 = Common.getProcessDesc(process, processTree.startTime);
        Object[] objectArray = new Object[]{string, object3, string2, object2, string5, string6, string7};
        String string8 = MessageFormat.format(processTemplate, objectArray);
        return string8;
    }

    private static String encodeArg(String string) {
        return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static String getConnLineSVG(Point point, Point point2) {
        String string = "style=\"stroke-dasharray: 3,3;\" ";
        String string2 = "<line " + string + "x1=\"" + point.x + "\" y1=\"" + point.y + "\" " + "x2=\"" + point2.x + "\" y2=\"" + point2.y + "\"/>";
        return string2;
    }

    @Override
    public String getFileSuffix() {
        return "svgz";
    }
}

