/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.renderer;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;
import org.bootchart.common.BootStats;
import org.bootchart.renderer.ImageRenderer;

public class PNGRenderer
extends ImageRenderer {
    private static final Logger log = Logger.getLogger(PNGRenderer.class.getName());

    @Override
    public void render(Properties properties, BootStats bootStats, OutputStream outputStream) throws IOException {
        super.render(properties, bootStats, null);
        log.fine("Writing image");
        try {
            Class<?> clazz = Class.forName("javax.imageio.ImageIO");
            Class[] classArray = new Class[]{RenderedImage.class, String.class, OutputStream.class};
            Method method = clazz.getMethod("write", classArray);
            method.invoke(null, this.img, "png", outputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getFileSuffix() {
        return "png";
    }
}

