/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.bootchart.common.BootStats;
import org.bootchart.common.CPUSample;
import org.bootchart.common.Common;
import org.bootchart.common.DiskTPutSample;
import org.bootchart.common.DiskUtilSample;
import org.bootchart.common.FileOpenSample;
import org.bootchart.common.Process;
import org.bootchart.common.ProcessSample;
import org.bootchart.common.ProcessTree;
import org.bootchart.common.Sample;
import org.bootchart.common.Stats;
import org.bootchart.parser.linux.ProcDiskStatParser;
import org.bootchart.renderer.Renderer;

public abstract class ImageRenderer
extends Renderer {
    private static String fontFamily = "SansSerif";
    private static final Logger log = Logger.getLogger(ImageRenderer.class.getName());
    private static final Color BACK_COLOR = new Color(255, 255, 255, 255);
    private static final Color BORDER_COLOR = new Color(160, 160, 160, 255);
    private static final Color TICK_COLOR = new Color(235, 235, 235, 255);
    private static final Color TICK_COLOR_BOLD = new Color(220, 220, 220, 255);
    private static final Color TEXT_COLOR = new Color(0, 0, 0, 255);
    private static final Font TITLE_FONT = new Font(fontFamily, 1, 18);
    private static final Font TEXT_FONT = new Font(fontFamily, 0, 12);
    private static final Font AXIS_FONT = new Font(fontFamily, 0, 11);
    private static final Font LEGEND_FONT = new Font(fontFamily, 0, 12);
    private static final Color CPU_COLOR = new Color(102, 140, 178, 255);
    private static final Color IO_COLOR = new Color(194, 122, 122, 128);
    private static final Color DISK_TPUT_COLOR = new Color(50, 180, 50, 255);
    private static final Color FILE_OPEN_COLOR = new Color(50, 180, 180, 255);
    private static final Color PROC_BORDER_COLOR = new Color(180, 180, 180, 255);
    private static final Color PROC_COLOR_D = new Color(194, 122, 122, 64);
    private static final Color PROC_COLOR_R = CPU_COLOR;
    private static final Color PROC_COLOR_S = new Color(240, 240, 240, 255);
    private static final Color PROC_COLOR_T = new Color(240, 128, 128, 255);
    private static final Color PROC_COLOR_Z = new Color(180, 180, 180, 255);
    private static final Color PROC_TEXT_COLOR = new Color(48, 48, 48, 255);
    private static final Font PROC_TEXT_FONT = new Font(fontFamily, 0, 12);
    private static final Color SIG_COLOR = new Color(0, 0, 0, 80);
    private static final Font SIG_FONT = new Font(fontFamily, 1, 14);
    private static final String SIGNATURE = "";
    private static final Stroke DISK_STROKE = new BasicStroke(1.5f);
    private static final Color DEP_COLOR = new Color(192, 192, 192, 255);
    private static final Stroke DEP_STROKE = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private static final DateFormat BOOT_TIME_FORMAT = new SimpleDateFormat("m:ss", Common.LOCALE);
    private static final int MIN_IMG_W = 800;
    private static final int MAX_IMG_DIM = 4096;
    protected Graphics g = null;
    protected BufferedImage img = null;
    protected boolean allowAlpha = true;

    @Override
    public void render(Properties properties, BootStats bootStats, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        Object object;
        int[] nArray;
        int n3;
        Stats stats = bootStats.diskStats;
        Stats stats2 = bootStats.cpuStats;
        ProcessTree processTree = bootStats.procTree;
        int n4 = 280;
        int n5 = 55;
        int n6 = 10;
        int n7 = 10;
        int n8 = 25;
        int n9 = (int)(processTree.duration * (long)n8 / 1000L) + 2 * n6;
        int n10 = 16;
        int n11 = n10 * processTree.numProc + n4 + 2 * n7;
        while (n9 > 4096 && n8 > 1) {
            n9 = (int)(processTree.duration * (long)(n8 /= 2) / 1000L) + 2 * n6;
        }
        while (n11 > 4096) {
            n10 = n10 * 3 / 4;
            n11 = n10 * processTree.numProc + n4 + 2 * n7;
        }
        n9 = Math.min(n9, 4096);
        n11 = Math.min(n11, 4096);
        log.fine("Creating image: (" + n9 + ", " + n11 + ")");
        if (this.g == null) {
            n3 = this.allowAlpha ? 2 : 1;
            this.img = new BufferedImage(Math.max(n9, 800), n11, n3);
            this.g = this.img.createGraphics();
        }
        if (this.g instanceof Graphics2D) {
            HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
            hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hashMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            hashMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)this.g).addRenderingHints(hashMap);
        }
        this.setColor(this.g, Color.WHITE);
        this.g.fillRect(0, 0, Math.max(n9, 800), n11);
        this.drawHeader(properties, n6, processTree.duration);
        n3 = n6;
        int n12 = n4 + n7;
        int n13 = n9 - 2 * n6;
        int n14 = n11 - 2 * n7 - n4;
        this.g.setFont(LEGEND_FONT);
        int n15 = n12 - 2 * n5 - 6 * n7;
        int n16 = n6;
        int n17 = 10;
        if (ImageRenderer.hasSamples(stats2, CPUSample.class)) {
            String string = "CPU (user+sys)";
            this.setColor(this.g, CPU_COLOR);
            this.g.fillRect(n16, n15 - n17, n17, n17);
            this.setColor(this.g, PROC_BORDER_COLOR);
            this.g.drawRect(n16, n15 - n17, n17, n17);
            this.setColor(this.g, TEXT_COLOR);
            this.g.drawString(string, n16 + n17 + 5, n15);
            this.setColor(this.g, IO_COLOR);
            this.g.fillRect(n16 += 120, n15 - n17, n17, n17);
            this.setColor(this.g, PROC_BORDER_COLOR);
            this.g.drawRect(n16, n15 - n17, n17, n17);
            this.setColor(this.g, TEXT_COLOR);
            this.g.drawString("I/O (wait)", n16 + n17 + 5, n15);
            n16 += 120;
        }
        n16 = n6;
        if (ImageRenderer.hasSamples(stats, DiskTPutSample.class)) {
            n15 = n12 - n5 - 4 * n7;
            n16 = n6;
            this.setColor(this.g, DISK_TPUT_COLOR);
            this.g.fillRect(n16, n15 - n17 / 2, n17 + 1, 3);
            this.g.fillArc(n16 + n17 / 2 - 2, n15 - n17 / 2 - 1, 5, 5, 0, 360);
            this.setColor(this.g, TEXT_COLOR);
            this.g.drawString("Disk throughput", n16 + n17 + 5, n15);
            n16 += 120;
        }
        if (ImageRenderer.hasSamples(stats, DiskUtilSample.class)) {
            this.setColor(this.g, IO_COLOR);
            this.g.fillRect(n16, n15 - n17, n17, n17);
            this.setColor(this.g, PROC_BORDER_COLOR);
            this.g.drawRect(n16, n15 - n17, n17, n17);
            this.setColor(this.g, TEXT_COLOR);
            this.g.drawString("Disk utilization", n16 + n17 + 5, n15);
            n16 += 120;
        }
        if (ImageRenderer.hasSamples(stats, FileOpenSample.class)) {
            this.setColor(this.g, FILE_OPEN_COLOR);
            this.g.fillRect(n16, n15 - n17 / 2, n17 + 1, 3);
            this.g.fillArc(n16 + n17 / 2 - 2, n15 - n17 / 2 - 1, 5, 5, 0, 360);
            this.setColor(this.g, PROC_BORDER_COLOR);
            this.setColor(this.g, TEXT_COLOR);
            this.g.drawString("Files opened", n16 + n17 + 5, n15);
            n16 += 120;
        }
        int n18 = n16;
        n15 = n12 - 17;
        n16 = n6;
        String string = "Running (%cpu)";
        this.setColor(this.g, PROC_COLOR_R);
        this.g.fillRect(n16, n15 - n17, n17, n17);
        this.setColor(this.g, PROC_BORDER_COLOR);
        this.g.drawRect(n16, n15 - n17, n17, n17);
        this.setColor(this.g, TEXT_COLOR);
        this.g.drawString(string, n16 + n17 + 5, n15);
        String string2 = "Unint.sleep (I/O)";
        this.setColor(this.g, TEXT_COLOR);
        this.g.drawString(string2, (n16 += 120) + n17 + 5, n15);
        this.setColor(this.g, PROC_COLOR_D);
        this.g.fillRect(n16, n15 - n17, n17, n17);
        this.setColor(this.g, PROC_BORDER_COLOR);
        this.g.drawRect(n16, n15 - n17, n17, n17);
        String string3 = "Sleeping";
        this.setColor(this.g, PROC_COLOR_S);
        this.g.fillRect(n16 += 120, n15 - n17, n17, n17);
        this.setColor(this.g, PROC_BORDER_COLOR);
        this.g.drawRect(n16, n15 - n17, n17, n17);
        this.setColor(this.g, TEXT_COLOR);
        this.g.drawString(string3, n16 + n17 + 5, n15);
        String string4 = "Zombie";
        this.setColor(this.g, PROC_COLOR_Z);
        this.g.fillRect(n16 += 120, n15 - n17, n17, n17);
        this.setColor(this.g, PROC_BORDER_COLOR);
        this.g.drawRect(n16, n15 - n17, n17, n17);
        this.setColor(this.g, TEXT_COLOR);
        this.g.drawString(string4, n16 + n17 + 5, n15);
        n16 += this.g.getFontMetrics(LEGEND_FONT).stringWidth(string4) + n6;
        n16 += 120;
        int n19 = n12 - 4 * n7 - n5 - n6 - 5;
        this.setColor(this.g, BORDER_COLOR);
        this.g.drawRect(n3, n19 - n5, n13, n5);
        for (int i = 0; i <= n13; i += n8) {
            if (i / n8 % 5 == 0) {
                this.setColor(this.g, TICK_COLOR_BOLD);
            } else {
                this.setColor(this.g, TICK_COLOR);
            }
            this.g.drawLine(n3 + i, n19 - n5, n3 + i, n19);
        }
        if (stats2 != null) {
            int n20;
            Point point = null;
            nArray = new int[stats2.getSamples().size() + 2];
            object = new int[stats2.getSamples().size() + 2];
            n2 = 0;
            this.setColor(this.g, IO_COLOR);
            point = null;
            for (Sample sample : stats2.getSamples()) {
                n = n3 + (int)((sample.time.getTime() - processTree.startTime.getTime()) * (long)n13 / processTree.duration);
                if (n < n3 || n > n3 + n13) continue;
                n20 = n19 - (int)((sample.user + sample.sys + sample.io) * (double)n5);
                if (point != null) {
                    this.g.drawLine(point.x, point.y, n, n20);
                }
                point = new Point(n, n20);
                nArray[n2] = n;
                object[n2] = n20;
                ++n2;
            }
            nArray[n2] = nArray[Math.max(0, n2 - 1)];
            object[n2] = n19;
            nArray[++n2] = nArray[0];
            object[n2] = n19;
            this.g.fillPolygon(nArray, (int[])object, ++n2);
            this.setColor(this.g, CPU_COLOR);
            point = null;
            n2 = 0;
            for (Sample sample : stats2.getSamples()) {
                n = n6 + (int)((sample.time.getTime() - processTree.startTime.getTime()) * (long)n13 / processTree.duration);
                if (n < n3 || n > n3 + n13) continue;
                n20 = n19 - (int)((sample.user + sample.sys) * (double)n5);
                if (point != null) {
                    this.g.drawLine(point.x, point.y, n, n20);
                }
                point = new Point(n, n20);
                nArray[n2] = n;
                object[n2] = n20;
                ++n2;
            }
            nArray[n2] = nArray[Math.max(0, n2 - 1)];
            object[n2] = n19;
            nArray[++n2] = nArray[0];
            object[n2] = n19;
            this.g.fillPolygon(nArray, (int[])object, ++n2);
        }
        if (stats != null) {
            int n21;
            Point point = null;
            nArray = new int[stats.getSamples().size() + 2];
            object = new int[stats.getSamples().size() + 2];
            n2 = 0;
            n19 = n12 - 2 * n7 - n7 - 5;
            this.setColor(this.g, BORDER_COLOR);
            this.g.drawRect(n3, n19 - n5, n13, n5);
            for (int i = 0; i <= n13; i += n8) {
                if (i / n8 % 5 == 0) {
                    this.setColor(this.g, TICK_COLOR_BOLD);
                } else {
                    this.setColor(this.g, TICK_COLOR);
                }
                this.g.drawLine(n3 + i, n19 - n5, n3 + i, n19);
            }
            this.setColor(this.g, IO_COLOR);
            point = null;
            for (Sample sample : stats.getSamples()) {
                int n22;
                if (!(sample instanceof DiskUtilSample)) continue;
                DiskUtilSample diskUtilSample = (DiskUtilSample)sample;
                Date date = new Date(processTree.startTime.getTime() + processTree.duration);
                if (diskUtilSample.time.compareTo(processTree.startTime) < 0 || diskUtilSample.time.compareTo(date) > 0 || (n22 = n3 + (int)((diskUtilSample.time.getTime() - processTree.startTime.getTime()) * (long)n13 / processTree.duration)) < n3 || n22 > n3 + n13) continue;
                int n23 = n19 - (int)(diskUtilSample.util * (double)n5);
                if (point != null) {
                    this.g.drawLine(point.x, point.y, n22, n23);
                }
                point = new Point(n22, n23);
                nArray[n2] = n22;
                object[n2] = n23;
                ++n2;
            }
            nArray[n2] = nArray[Math.max(0, n2 - 1)];
            object[n2] = n19;
            nArray[++n2] = nArray[0];
            object[n2] = n19;
            this.g.fillPolygon(nArray, (int[])object, ++n2);
            if (this.g instanceof Graphics2D) {
                ((Graphics2D)this.g).setStroke(DISK_STROKE);
            }
            point = null;
            this.setColor(this.g, DISK_TPUT_COLOR);
            double d = ProcDiskStatParser.getMaxDiskTPut(stats.getSamples());
            for (Sample sample : stats.getSamples()) {
                if (!(sample instanceof DiskTPutSample)) continue;
                DiskTPutSample diskTPutSample = (DiskTPutSample)sample;
                Date date = new Date(processTree.startTime.getTime() + processTree.duration);
                if (diskTPutSample.time.compareTo(processTree.startTime) < 0 || diskTPutSample.time.compareTo(date) > 0 || (n21 = n3 + (int)((diskTPutSample.time.getTime() - processTree.startTime.getTime()) * (long)n13 / processTree.duration)) < n3 || n21 > n3 + n13) continue;
                double d2 = (diskTPutSample.read + diskTPutSample.write) / d;
                int n24 = n19 - (int)(d2 * (double)n5);
                if (point != null) {
                    this.g.drawLine(point.x, point.y, n21, n24);
                }
                point = new Point(n21, n24);
            }
            for (Sample sample : stats.getSamples()) {
                int n25;
                if (!(sample instanceof DiskTPutSample)) continue;
                DiskTPutSample diskTPutSample = (DiskTPutSample)sample;
                if (diskTPutSample.read + diskTPutSample.write != d || (n25 = n3 + (int)((diskTPutSample.time.getTime() - processTree.startTime.getTime()) * (long)n13 / processTree.duration)) < n3 || n25 > n3 + n13) continue;
                n21 = n19 - (int)(1.0 * (double)n5);
                if (n25 < n18) {
                    n21 += 15;
                    n25 += 30;
                }
                String string5 = (int)Math.round((diskTPutSample.read + diskTPutSample.write) / 1024.0) + " MB/s";
                this.setColor(this.g, ImageRenderer.opaque(DISK_TPUT_COLOR));
                this.g.drawString(string5, n25 - 20, n21 - 3);
                break;
            }
            point = null;
            this.setColor(this.g, FILE_OPEN_COLOR);
            n = FileOpenSample.getMaxFileOpens(stats.getSamples());
            for (Sample sample : stats.getSamples()) {
                int n26;
                if (!(sample instanceof FileOpenSample)) continue;
                FileOpenSample fileOpenSample = (FileOpenSample)sample;
                Date date = new Date(processTree.startTime.getTime() + processTree.duration);
                if (fileOpenSample.time.compareTo(processTree.startTime) < 0 || fileOpenSample.time.compareTo(date) > 0 || (n26 = n3 + (int)((fileOpenSample.time.getTime() - processTree.startTime.getTime()) * (long)n13 / processTree.duration)) < n3 || n26 > n3 + n13) continue;
                double d3 = (double)fileOpenSample.fileOpens / (double)n;
                int n27 = n19 - (int)(d3 * (double)n5);
                if (point != null) {
                    this.g.drawLine(point.x, point.y, n26, n27);
                }
                point = new Point(n26, n27);
            }
            for (Sample sample : stats.getSamples()) {
                int n28;
                if (!(sample instanceof FileOpenSample)) continue;
                FileOpenSample fileOpenSample = (FileOpenSample)sample;
                if (fileOpenSample.fileOpens != n || (n28 = n3 + (int)((fileOpenSample.time.getTime() - processTree.startTime.getTime()) * (long)n13 / processTree.duration)) < n3 || n28 > n3 + n13) continue;
                int n29 = n19 - (int)(1.0 * (double)n5);
                if (n28 < n18) {
                    n29 += 15;
                    n28 += 30;
                }
                String string6 = fileOpenSample.fileOpens + "/s";
                this.setColor(this.g, ImageRenderer.opaque(FILE_OPEN_COLOR));
                this.g.drawString(string6, n28 - 15, n29 - 3);
                break;
            }
            if (this.g instanceof Graphics2D) {
                ((Graphics2D)this.g).setStroke(new BasicStroke());
            }
        }
        this.setColor(this.g, BACK_COLOR);
        this.g.fillRect(n3, n12, n13, n14);
        this.g.setFont(AXIS_FONT);
        FontMetrics fontMetrics = this.g.getFontMetrics(TEXT_FONT);
        for (int i = 0; i <= n13; i += n8) {
            this.setColor(this.g, TICK_COLOR);
            this.g.drawLine(n3 + i, n12, n3 + i, n12 + n14);
            if (i / n8 % 5 != 0) continue;
            this.setColor(this.g, TICK_COLOR_BOLD);
            this.g.drawLine(n3 + i, n12, n3 + i, n12 + n14);
            this.setColor(this.g, TEXT_COLOR);
            object = i / n8 + "s";
            this.g.drawString((String)object, n3 + i - fontMetrics.stringWidth((String)object) / 2, n12 - 2);
        }
        this.g.setFont(PROC_TEXT_FONT);
        if (processTree.processTree != null) {
            this.drawProcessList(processTree.processTree, -1, -1, processTree, n12, n10, new Rectangle(n3, n12, n13, n14));
        }
        this.setColor(this.g, BORDER_COLOR);
        this.g.drawRect(n3, n12, n13, n14);
        this.setColor(this.g, SIG_COLOR);
        this.g.setFont(SIG_FONT);
        this.g.drawString(SIGNATURE, n6 + 5, n11 - n7 - 5);
        String string7 = properties.getProperty("title");
        if (string7 == null) {
            string7 = SIGNATURE;
        }
        int n30 = this.g.getFontMetrics(TITLE_FONT).stringWidth(string7) + 2 * n6;
        if (this.img != null && n9 < 800) {
            log.fine("Cropping image");
            this.img = this.img.getSubimage(0, 0, Math.max(n9, n30), n11);
        }
    }

    private void drawHeader(Properties properties, int n, long l) {
        String string;
        Object object;
        this.setColor(this.g, TEXT_COLOR);
        this.g.setFont(TITLE_FONT);
        int n2 = this.g.getFontMetrics(TITLE_FONT).getMaxAscent() + 2;
        if (properties != null && properties.getProperty("title") != null) {
            this.g.drawString(properties.getProperty("title"), n, n2);
        }
        this.g.setFont(TEXT_FONT);
        n2 += 2;
        int n3 = 1;
        if (properties != null) {
            object = "uname: " + properties.getProperty("system.uname", SIGNATURE);
            this.g.drawString((String)object, n, n2 + n3++ * (TEXT_FONT.getSize() + 2));
            string = "release: " + properties.getProperty("system.release", SIGNATURE);
            this.g.drawString(string, n, n2 + n3++ * (TEXT_FONT.getSize() + 2));
            String string2 = "CPU: " + properties.getProperty("system.cpu", SIGNATURE);
            string2 = string2.replaceFirst("model name\\s*:\\s*", SIGNATURE);
            this.g.drawString(string2, n, n2 + n3++ * (TEXT_FONT.getSize() + 2));
            if (properties.getProperty("profile.process") != null) {
                String string3 = "application: " + properties.getProperty("profile.process", SIGNATURE);
                this.g.drawString(string3, n, n2 + n3++ * (TEXT_FONT.getSize() + 2));
            } else {
                String string4 = "kernel options: " + properties.getProperty("system.kernel.options", SIGNATURE);
                this.g.drawString(string4, n, n2 + n3++ * (TEXT_FONT.getSize() + 2));
            }
        }
        object = new Date(Math.round((double)l / 1000.0) * 1000L);
        string = "time: " + BOOT_TIME_FORMAT.format((Date)object);
        this.g.drawString(string, n, n2 + n3++ * (TEXT_FONT.getSize() + 2));
    }

    private int drawProcessList(List list, int n, int n2, ProcessTree processTree, int n3, int n4, Rectangle rectangle) {
        for (Process process : list) {
            int n5 = n4;
            this.drawProcess(process, n, n2, processTree, n3, n4, rectangle);
            int n6 = rectangle.x + (int)((process.startTime.getTime() - processTree.startTime.getTime()) * (long)rectangle.width / processTree.duration);
            int n7 = n3 + n4;
            n3 = this.drawProcessList(process.childList, n6, n7, processTree, n3 + n5, n4, rectangle);
        }
        return n3;
    }

    private void drawProcess(Process process, int n, int n2, ProcessTree processTree, int n3, int n4, Rectangle rectangle) {
        int n5;
        Object object2;
        int n6;
        int n7 = rectangle.x + (int)((process.startTime.getTime() - processTree.startTime.getTime()) * (long)rectangle.width / processTree.duration);
        int n8 = (int)(process.duration * (long)rectangle.width / processTree.duration);
        this.setColor(this.g, PROC_COLOR_S);
        this.g.fillRect(n7, n3, n8, n4);
        if (this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setStroke(DEP_STROKE);
        }
        this.setColor(this.g, DEP_COLOR);
        if (n != -1 && n2 != -1) {
            if (Math.abs(n - n7) < 3) {
                n6 = 3;
                int n9 = n4 / 4;
                this.g.drawLine(n7, n3 + n4 / 2, n - n6, n3 + n4 / 2);
                this.g.drawLine(n - n6, n3 + n4 / 2, n - n6, n2 - n9);
                this.g.drawLine(n - n6, n2 - n9, n, n2 - n9);
            } else {
                this.g.drawLine(n7, n3 + n4 / 2, n, n3 + n4 / 2);
                this.g.drawLine(n, n3 + n4 / 2, n, n2);
            }
        }
        if (this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setStroke(new BasicStroke());
        }
        n6 = -1;
        for (Object object2 : process.samples) {
            Date date = new Date(process.startTime.getTime() + process.duration - (long)processTree.samplePeriod);
            if (((ProcessSample)object2).time.before(process.startTime) || ((ProcessSample)object2).time.after(date)) continue;
            n5 = rectangle.x + (int)Math.round((double)((((ProcessSample)object2).time.getTime() - processTree.startTime.getTime()) * (long)rectangle.width) / (double)processTree.duration);
            int n10 = (int)Math.round((double)(processTree.samplePeriod * rectangle.width) / (double)processTree.duration);
            if (n6 != -1 && Math.abs(n6 - n5) <= n10) {
                n10 -= n6 - n5;
                n5 = n6;
            }
            n6 = n5 + n10;
            int n11 = ((ProcessSample)object2).state;
            double d = ((ProcessSample)object2).cpu.user + ((ProcessSample)object2).cpu.sys;
            boolean bl = false;
            switch (n11) {
                case 3: {
                    this.setColor(this.g, PROC_COLOR_D);
                    bl = true;
                    break;
                }
                case 1: {
                    int n12 = (int)(d * 255.0);
                    n12 = Math.max(0, Math.min(n12, 255));
                    Color color = new Color(PROC_COLOR_R.getRed(), PROC_COLOR_R.getGreen(), PROC_COLOR_R.getBlue(), n12);
                    this.setColor(this.g, color, PROC_COLOR_S);
                    bl = true;
                    break;
                }
                case 4: {
                    this.setColor(this.g, PROC_COLOR_T);
                    bl = true;
                    break;
                }
                case 5: {
                    this.setColor(this.g, PROC_COLOR_Z);
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) continue;
            this.g.fillRect(n5, n3, n10, n4);
        }
        this.setColor(this.g, PROC_BORDER_COLOR);
        this.g.drawRect(n7, n3, n8, n4);
        this.setColor(this.g, PROC_TEXT_COLOR);
        FontMetrics fontMetrics = this.g.getFontMetrics(PROC_TEXT_FONT);
        object2 = process.cmd;
        int n13 = fontMetrics.stringWidth((String)object2);
        n5 = n7 + n8 / 2 - n13 / 2;
        if (n13 + 10 > n8) {
            n5 = n7 + n8 + 5;
        }
        if (n5 + n13 > rectangle.x + rectangle.width) {
            n5 = n7 - n13 - 5;
        }
        this.g.drawString((String)object2, n5, n3 + n4 - 2);
    }

    private void setColor(Graphics graphics, Color color, Color color2) {
        if (!this.allowAlpha) {
            int n = color.getAlpha();
            int n2 = color.getRed();
            n2 += (int)((double)((color2.getRed() - n2) * (color2.getRed() - n)) / 255.0);
            int n3 = color.getGreen();
            n3 += (int)((double)((color2.getGreen() - n3) * (color2.getGreen() - n)) / 255.0);
            int n4 = color.getBlue();
            n4 += (int)((double)((color2.getBlue() - n4) * (color2.getBlue() - n)) / 255.0);
            color = new Color(n2, n3, n4, 255);
        }
        graphics.setColor(color);
    }

    private void setColor(Graphics graphics, Color color) {
        this.setColor(graphics, color, Color.WHITE);
    }

    private static Color opaque(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
    }

    private static boolean hasSamples(Stats stats, Class clazz) {
        if (stats == null || stats.getSamples() == null || stats.getSamples().isEmpty()) {
            return false;
        }
        for (Sample sample : stats.getSamples()) {
            if (!sample.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract String getFileSuffix();
}

