/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.renderer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bootchart.common.Common;

public class CSSInliner {
    private static final Pattern CLASS_PATTERN = Pattern.compile("(\\S+)\\s*\\{([^\\}]*)\\}");

    public static String inline(String string, File file) throws FileNotFoundException, IOException {
        Properties properties = CSSInliner.parseCSS(file);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            string = string.replaceAll("class=\"" + entry.getKey() + "\"", "style=\"" + entry.getValue() + "\"");
        }
        return string;
    }

    private static Properties parseCSS(File file) throws FileNotFoundException, IOException {
        String string = Common.loadFile(file);
        Properties properties = new Properties();
        Matcher matcher = CLASS_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            String string3 = matcher.group(2);
            string3 = string3.replaceAll("\\s+", " ").trim();
            String string4 = properties.getProperty(string2);
            if (string4 != null) {
                properties.setProperty(string2, string4 + " " + string3);
                continue;
            }
            properties.setProperty(string2, string3);
        }
        return properties;
    }
}

