/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.parser.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.logging.Logger;
import org.bootchart.common.CPUSample;
import org.bootchart.common.Common;
import org.bootchart.common.Stats;

public class ProcStatParser {
    private static final Logger log = Logger.getLogger(ProcStatParser.class.getName());

    public static Stats parseLog(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = Common.getReader(inputStream);
        String string = bufferedReader.readLine();
        int n = 0;
        Stats stats = new Stats();
        long[] lArray = null;
        while (string != null) {
            while (string != null && string.trim().length() == 0) {
                string = bufferedReader.readLine();
            }
            if (string == null) break;
            if ((string = string.trim()).startsWith("#")) continue;
            Date date = null;
            if (string.matches("^\\d+$")) {
                date = new Date(Long.parseLong(string) * 10L);
                ++n;
            } else {
                string = bufferedReader.readLine();
                continue;
            }
            string = bufferedReader.readLine();
            String[] stringArray = string.split("\\s+");
            long[] lArray2 = new long[7];
            for (int i = 1; i < stringArray.length; ++i) {
                if (i - 1 >= lArray2.length) continue;
                lArray2[i - 1] = Long.parseLong(stringArray[i]);
            }
            if (lArray != null) {
                long l = lArray2[0] + lArray2[1] - (lArray[0] + lArray[1]);
                long l2 = lArray2[2] + lArray2[5] + lArray2[6] - (lArray[2] + lArray[5] + lArray[6]);
                long l3 = lArray2[3] - lArray[3];
                long l4 = lArray2[4] - lArray[4];
                double d = l + l2 + l3 + l4;
                d = Math.max(d, 1.0);
                CPUSample cPUSample = new CPUSample(date, (double)l / d, (double)l2 / d, (double)l4 / d);
                stats.addSample(cPUSample);
            }
            lArray = lArray2;
            if (n > 4500) break;
            while (string != null && string.trim().length() > 0) {
                string = bufferedReader.readLine();
            }
        }
        log.fine("Parsed " + stats.getSamples().size() + " /proc/stat samples");
        return stats;
    }
}

