/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.parser.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.bootchart.common.CPUSample;
import org.bootchart.common.Common;
import org.bootchart.common.Process;
import org.bootchart.common.ProcessSample;
import org.bootchart.common.PsStats;
import org.bootchart.common.Sample;
import org.bootchart.parser.linux.PacctParser;

public class ProcPsParser {
    private static final Logger log = Logger.getLogger(ProcPsParser.class.getName());

    public static PsStats parseLog(InputStream inputStream, Map map, Map map2) throws IOException {
        BufferedReader bufferedReader = Common.getReader(inputStream);
        String string = bufferedReader.readLine();
        TreeMap<Integer, Process> treeMap = new TreeMap<Integer, Process>();
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        HashMap<Integer, Long> hashMap2 = new HashMap<Integer, Long>();
        int n = 0;
        Date date = null;
        Date date2 = null;
        Date date3 = null;
        while (string != null) {
            while (string != null && string.trim().length() == 0) {
                string = bufferedReader.readLine();
            }
            if (string == null) break;
            if ((string = string.trim()).matches("^\\d+$")) {
                date2 = new Date(Long.parseLong(string) * 10L);
                if (date == null) {
                    date = date2;
                }
                ++n;
            } else {
                string = bufferedReader.readLine();
                continue;
            }
            string = bufferedReader.readLine();
            while (string != null && string.trim().length() > 0) {
                int n2;
                int n3 = (string = string.trim()).indexOf(32);
                if (n3 == -1) {
                    log.fine("Invalid line: " + string);
                    string = bufferedReader.readLine();
                    continue;
                }
                int n4 = Integer.parseInt(string.substring(0, string.indexOf(32)));
                int n5 = string.indexOf(40) + 1;
                int n6 = string.lastIndexOf(41);
                if (n5 == -1 || n6 == -1) {
                    log.fine("Invalid line: " + string);
                    string = bufferedReader.readLine();
                    continue;
                }
                String string2 = string.substring(n5, n6);
                if (n4 == 0) {
                    log.fine("Invalid line: " + string);
                    string = bufferedReader.readLine();
                    continue;
                }
                String[] stringArray = string.substring(n6 + 1).trim().split("\\s+");
                Process process = (Process)treeMap.get(new Integer(n4));
                if (process == null) {
                    n2 = Integer.parseInt(stringArray[1]);
                    process = new Process(n4, string2);
                    process.ppid = n2;
                    process.startTime = new Date(Math.min((long)(Integer.parseInt(stringArray[19]) * 10), date2.getTime()));
                    treeMap.put(new Integer(n4), process);
                } else {
                    process.cmd = string2;
                }
                n2 = ProcPsParser.getState(stringArray[0]);
                long l = Long.parseLong(stringArray[11]);
                long l2 = Long.parseLong(stringArray[12]);
                double d = 0.0;
                Long l3 = (Long)hashMap.get(new Integer(n4));
                Long l4 = (Long)hashMap2.get(new Integer(n4));
                if (l3 != null && l4 != null && date3 != null) {
                    double d2;
                    long l5 = date2.getTime() - date3.getTime();
                    double d3 = (double)(l - l3) * 10.0 / (double)l5;
                    d = d3 + (d2 = (double)(l2 - l4) * 10.0 / (double)l5);
                    if (d > 1.0) {
                        d3 /= d;
                        d2 /= d;
                    }
                    CPUSample cPUSample = new CPUSample(null, d3, d2, 0.0);
                    ProcessSample processSample = new ProcessSample(date2, n2, cPUSample, null, null);
                    process.samples.add(processSample);
                }
                hashMap.put(new Integer(n4), new Long(l));
                hashMap2.put(new Integer(n4), new Long(l2));
                if (d > 0.0) {
                    n2 = 1;
                }
                string = bufferedReader.readLine();
            }
            date3 = date2;
            if (n <= 4500) continue;
        }
        log.fine("Parsed " + n + " process samples " + "(" + treeMap.values().size() + " processes)");
        for (Process process : treeMap.values()) {
            List list;
            if (map2 != null && (list = PacctParser.getPPIDs(process.pid, map2)) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int n7 = (Integer)iterator.next();
                    if (treeMap.get(new Integer(n7)) == null) continue;
                    process.ppid = n7;
                    break;
                }
            }
            if (process.ppid == -1) continue;
            process.parent = (Process)treeMap.get(new Integer(process.ppid));
            if (process.parent != null || process.pid <= 1) continue;
            log.fine("No parent for: " + process);
        }
        int n8 = (int)(date2.getTime() - date.getTime()) / n;
        log.fine("Sample period: " + n8);
        for (Process process : treeMap.values()) {
            Object object;
            if (process.samples.size() > 0) {
                Sample sample = (Sample)process.samples.get(0);
                process.startTime = new Date(Math.min(sample.time.getTime(), process.startTime.getTime()));
                object = (Sample)process.samples.get(process.samples.size() - 1);
                process.duration = ((Sample)object).time.getTime() - process.startTime.getTime() + (long)n8;
            } else {
                process.duration = 0L;
            }
            if (map != null && map.containsKey(new Integer(process.pid))) {
                String[] stringArray = (String[])map.get(new Integer(process.pid));
                process.cmd = stringArray[0];
                object = new StringBuffer();
                if (stringArray.length > 1) {
                    ((StringBuffer)object).append(stringArray[1]);
                    for (int i = 2; i < stringArray.length; ++i) {
                        ((StringBuffer)object).append("\n" + stringArray[i]);
                    }
                }
                process.desc = ((StringBuffer)object).toString();
            }
            int n9 = 0;
            for (ProcessSample processSample : process.samples) {
                if (processSample.cpu != null && processSample.cpu.user + processSample.cpu.sys + processSample.cpu.io > 0.0) {
                    ++n9;
                    continue;
                }
                if (processSample.state != 3) continue;
                ++n9;
            }
            process.active = n9 > 2;
        }
        PsStats psStats = new PsStats();
        psStats.processList = new ArrayList(treeMap.values());
        psStats.samplePeriod = n8;
        psStats.startTime = date;
        psStats.endTime = date2;
        return psStats;
    }

    public static int getState(String string) {
        if ("D".equals(string)) {
            return 3;
        }
        if ("R".equals(string)) {
            return 1;
        }
        if ("S".equals(string)) {
            return 2;
        }
        if ("T".equals(string)) {
            return 4;
        }
        if ("Z".equals(string)) {
            return 5;
        }
        return 0;
    }
}

