/*
 * Decompiled with CFR 0.152.
 */
package org.bootchart.common;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;
import org.bootchart.common.Common;
import org.bootchart.common.Process;
import org.bootchart.common.PsStats;

public class ProcessTree {
    private static final Logger log = Logger.getLogger(ProcessTree.class.getName());
    private static final String LOGGER_PROC = "bootchartd";
    private static final List MERGE_PROC_LIST = Arrays.asList("hwup");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("mm:ss.SSS", Common.LOCALE);
    public Date startTime;
    public Date endTime;
    public long duration;
    private PsStats psStats;
    public int samplePeriod;
    public int numProc;
    private List processList;
    public List processTree;

    public ProcessTree(PsStats psStats, String string, boolean bl) {
        this.psStats = psStats;
        if (psStats == null || psStats.processList.size() == 0) {
            this.processList = null;
            return;
        }
        this.processList = psStats.processList;
        this.samplePeriod = psStats.samplePeriod;
        if (this.processList == null || this.processList.size() == 0) {
            return;
        }
        this.build();
        log.fine("Number of all processes: " + ProcessTree.numNodes(this.processTree));
        int n = -1;
        int n2 = -1;
        Process process = null;
        for (Process process2 : this.processList) {
            if (!process2.cmd.equals("rc") || process2.ppid != 1) continue;
            process = process2;
            n = process2.pid;
            n2 = ProcessTree.getMaxPid(process2.childList);
        }
        if (n != -1 && n2 != -1) {
            for (Process process2 : this.processList) {
                if (process2.pid <= n || process2.pid >= n2 || process2.ppid != 1) continue;
                process2.ppid = n;
                process2.parent = process;
            }
            for (Process process2 : this.processList) {
                process2.childList = new ArrayList();
            }
            this.build();
        }
        this.startTime = this.getStartTime(this.processTree);
        this.endTime = this.getEndTime(this.processTree);
        this.duration = this.endTime.getTime() - this.startTime.getTime();
        int n3 = this.mergeLogger(this.processTree, LOGGER_PROC, string, false);
        if (string != null) {
            int n4 = this.removePreExisting();
            log.fine("Removing " + n4 + " pre-existing processes");
        }
        if (bl) {
            n3 = this.prune(this.processTree, null);
            log.fine("Number of removed idle processes: " + n3);
            n3 = this.mergeExploders(this.processTree, MERGE_PROC_LIST);
            log.fine("Number of removed exploders: " + n3);
            n3 = this.mergeSiblings(this.processTree);
            log.fine("Number of removed threads: " + n3);
            n3 = this.mergeRuns(this.processTree);
            log.fine("Number of removed runs: " + n3);
        }
        this.numProc = ProcessTree.numNodes(this.processTree);
        log.fine("Number of processes after pruning: " + this.numProc);
        this.sort(this.processTree);
        if (string == null) {
            this.startTime = this.getStartTime(this.processTree);
            this.endTime = this.getEndTime(this.processTree);
        } else {
            this.startTime = psStats.startTime;
            this.endTime = psStats.endTime;
        }
        this.duration = this.endTime.getTime() - this.startTime.getTime();
        log.fine("Boot time: " + this.duration);
    }

    private void build() {
        this.processTree = new ArrayList();
        for (Process process : this.processList) {
            if (process.parent != null) {
                process.parent.childList.add(process);
                continue;
            }
            this.processTree.add(process);
        }
    }

    private Date getStartTime(List list) {
        long l = Long.MAX_VALUE;
        for (Process process : list) {
            if (process.startTime.getTime() < l) {
                l = process.startTime.getTime();
            }
            l = Math.min(l, this.getStartTime(process.childList).getTime());
        }
        return new Date(l);
    }

    private Date getEndTime(List list) {
        long l = Long.MIN_VALUE;
        for (Process process : list) {
            if (process.startTime.getTime() + process.duration > l) {
                l = process.startTime.getTime() + process.duration;
            }
            l = Math.max(l, this.getEndTime(process.childList).getTime());
        }
        return new Date(l);
    }

    private static int getMaxPid(List list) {
        int n = Integer.MIN_VALUE;
        for (Process process : list) {
            if (process.pid > n) {
                n = process.pid;
            }
            n = Math.max(n, ProcessTree.getMaxPid(process.childList));
        }
        return n;
    }

    private Map getProcessMap(List list) {
        HashMap<Process, Process> hashMap = new HashMap<Process, Process>();
        for (Process process : list) {
            hashMap.put(process, process);
            hashMap.putAll(this.getProcessMap(process.childList));
        }
        return hashMap;
    }

    private int prune(List list, Process process) {
        int n = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Process process2 = (Process)listIterator.next();
            if (process != null || process2.childList.size() == 0) {
                Date date = new Date(process2.startTime.getTime() + process2.duration);
                boolean bl = false;
                if (!process2.active && date.getTime() >= this.startTime.getTime() + this.duration && process2.startTime.getTime() > this.startTime.getTime() && (double)process2.duration > 0.9 * (double)this.duration && ProcessTree.numNodes(process2.childList) == 0) {
                    bl = true;
                } else if (process2.duration <= (long)(2 * this.samplePeriod)) {
                    bl = true;
                }
                if (bl) {
                    listIterator.remove();
                    ++n;
                    Iterator iterator = process2.childList.iterator();
                    while (iterator.hasNext()) {
                        listIterator.add(iterator.next());
                        listIterator.previous();
                    }
                    continue;
                }
                n += this.prune(process2.childList, process2);
                continue;
            }
            n += this.prune(process2.childList, process2);
        }
        return n;
    }

    private int mergeExploders(List list, List list2) {
        int n = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Process process = (Process)listIterator.next();
            if (list2.contains(process.cmd) && process.childList.size() > 0) {
                Map map = this.getProcessMap(process.childList);
                for (Map.Entry entry : map.entrySet()) {
                    Process process2 = (Process)entry.getValue();
                    ProcessTree.mergeProcesses(process, process2);
                }
                n += map.size();
                process.childList = new ArrayList();
                process.cmd = process.cmd + " (+)";
                continue;
            }
            n += this.mergeExploders(process.childList, list2);
        }
        return n;
    }

    private int mergeLogger(List list, String string, String string2, boolean bl) {
        int n = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Process process = (Process)listIterator.next();
            boolean bl2 = bl;
            if (string.equals(process.cmd) && !bl) {
                bl2 = true;
                n += this.mergeLogger(process.childList, string, string2, bl2);
                continue;
            }
            if (bl && string2 != null && string2.equals(process.cmd)) {
                bl2 = false;
            }
            if (bl2) {
                ListIterator listIterator2 = process.childList.listIterator();
                while (listIterator2.hasNext()) {
                    Process process2 = (Process)listIterator2.next();
                    ProcessTree.mergeProcesses(process, process2);
                    ++n;
                }
                process.childList = new ArrayList();
                continue;
            }
            n += this.mergeLogger(process.childList, string, string2, bl2);
        }
        return n;
    }

    private int mergeSiblings(List list) {
        int n = 0;
        for (int i = 0; i < list.size() - 1; ++i) {
            Process process = (Process)list.get(i);
            Process process2 = (Process)list.get(i + 1);
            if (process2.cmd.equals(process.cmd)) {
                list.remove(i + 1);
                --i;
                ++n;
                Iterator iterator = process2.childList.iterator();
                while (iterator.hasNext()) {
                    process.childList.add(iterator.next());
                }
                ProcessTree.mergeProcesses(process, process2);
            }
            n += this.mergeSiblings(process.childList);
        }
        if (list.size() > 0) {
            Process process = (Process)list.get(list.size() - 1);
            n += this.mergeSiblings(process.childList);
        }
        return n;
    }

    private static void mergeProcesses(Process process, Process process2) {
        process.samples.addAll(process2.samples);
        long l = process.startTime.getTime();
        long l2 = process2.startTime.getTime();
        process.startTime = new Date(Math.min(l, l2));
        long l3 = Math.max(l + process.duration, l2 + process2.duration);
        process.duration = l3 - process.startTime.getTime();
    }

    private int mergeRuns(List list) {
        int n = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Process process = (Process)listIterator.next();
            if (process.childList.size() == 1 && ((Process)process.childList.get((int)0)).cmd.equals(process.cmd)) {
                Process process2 = (Process)process.childList.get(0);
                process.childList = new ArrayList();
                Iterator iterator = process2.childList.iterator();
                while (iterator.hasNext()) {
                    process.childList.add(iterator.next());
                }
                process.samples.addAll(process2.samples);
                long l = process.startTime.getTime();
                long l2 = process2.startTime.getTime();
                process.startTime = new Date(Math.min(l, l2));
                long l3 = Math.max(l + process.duration, l2 + process2.duration);
                process.duration = l3 - process.startTime.getTime();
                ++n;
                listIterator.previous();
                continue;
            }
            n += this.mergeRuns(process.childList);
        }
        return n;
    }

    private int removePreExisting(List list) {
        int n = 0;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Process process = (Process)iterator.next();
            if (process.startTime.getTime() >= this.psStats.startTime.getTime()) continue;
            if (process.parent != null) {
                log.fine("Removing process " + process.cmd);
                ProcessTree.mergeProcesses(process.parent, process);
                n += this.removePreExisting(process.childList);
                Iterator iterator2 = process.childList.iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(iterator2.next());
                }
                iterator.remove();
                ++n;
                continue;
            }
            n += this.removePreExisting(process.childList);
            process.startTime = this.psStats.startTime;
            process.duration = this.psStats.endTime.getTime() - process.startTime.getTime();
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return n;
    }

    private int removePreExisting() {
        return this.removePreExisting(this.processTree);
    }

    private void sort(List list) {
        for (Process process : list) {
            Collections.sort(process.childList);
            this.sort(process.childList);
        }
    }

    private static int numNodes(List list) {
        int n = 0;
        for (Process process : list) {
            ++n;
            n += ProcessTree.numNodes(process.childList);
        }
        return n;
    }

    private String toString(List list, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Process process : list) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(process.pid + " " + process.cmd + " " + TIME_FORMAT.format(process.startTime) + " " + process.duration + "\n");
            stringBuffer.append(this.toString(process.childList, n + 1));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(this.processTree, 0);
    }
}

