/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.tar;

import java.io.File;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.compress.tar.TarUtils;

public class TarEntry {
    public static final int NAMELEN = 100;
    private int m_checkSum;
    private int m_devMajor;
    private int m_devMinor;
    private File m_file;
    private int m_groupID;
    private StringBuffer m_groupName;
    private byte m_linkFlag;
    private StringBuffer m_linkName;
    private StringBuffer m_magic = new StringBuffer("ustar");
    private long m_modTime;
    private int m_mode;
    private StringBuffer m_name = new StringBuffer();
    private long m_size;
    private int m_userID;
    private StringBuffer m_userName;

    public TarEntry(String string) {
        this();
        boolean bl = string.endsWith("/");
        this.m_name = new StringBuffer(string);
        this.m_mode = bl ? 16877 : 33188;
        this.m_linkFlag = (byte)(bl ? 53 : 48);
        this.m_modTime = new Date().getTime() / 1000L;
        this.m_linkName = new StringBuffer("");
        this.m_userName = new StringBuffer("");
        this.m_groupName = new StringBuffer("");
    }

    public TarEntry(String string, byte by) {
        this(string);
        this.m_linkFlag = by;
    }

    public TarEntry(File file) {
        this();
        int n;
        this.m_file = file;
        String string = file.getPath();
        String string2 = System.getProperty("os.name").toLowerCase(Locale.US);
        if (-1 != string2.indexOf("netware")) {
            if (string.length() > 2) {
                n = string.charAt(0);
                char c = string.charAt(1);
                if (c == ':' && (n >= 97 && n <= 122 || n >= 65 && n <= 90)) {
                    string = string.substring(2);
                }
            }
        } else if (-1 != string2.indexOf("netware") && (n = string.indexOf(58)) != -1) {
            string = string.substring(n + 1);
        }
        string = string.replace(File.separatorChar, '/');
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.m_linkName = new StringBuffer("");
        this.m_name = new StringBuffer(string);
        if (file.isDirectory()) {
            this.m_mode = 16877;
            this.m_linkFlag = (byte)53;
            if (this.m_name.charAt(this.m_name.length() - 1) != '/') {
                this.m_name.append("/");
            }
        } else {
            this.m_mode = 33188;
            this.m_linkFlag = (byte)48;
        }
        this.m_size = file.length();
        this.m_modTime = file.lastModified() / 1000L;
        this.m_checkSum = 0;
        this.m_devMajor = 0;
        this.m_devMinor = 0;
    }

    public TarEntry(byte[] byArray) {
        this();
        this.parseTarHeader(byArray);
    }

    private TarEntry() {
        this.m_linkName = new StringBuffer();
        String string = System.getProperty("user.name", "");
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        this.m_userName = new StringBuffer(string);
        this.m_groupName = new StringBuffer("");
    }

    public void setGroupID(int n) {
        this.m_groupID = n;
    }

    public void setGroupId(int n) {
        this.m_groupID = n;
    }

    public void setGroupName(String string) {
        this.m_groupName = new StringBuffer(string);
    }

    public void setModTime(long l) {
        this.m_modTime = l / 1000L;
    }

    public void setModTime(Date date) {
        this.m_modTime = date.getTime() / 1000L;
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public void setName(String string) {
        this.m_name = new StringBuffer(string);
    }

    public void setSize(long l) {
        this.m_size = l;
    }

    public void setUserID(int n) {
        this.m_userID = n;
    }

    public void setUserId(int n) {
        this.m_userID = n;
    }

    public void setUserName(String string) {
        this.m_userName = new StringBuffer(string);
    }

    public TarEntry[] getDirectoryEntries() {
        if (null == this.m_file || !this.m_file.isDirectory()) {
            return new TarEntry[0];
        }
        String[] stringArray = this.m_file.list();
        TarEntry[] tarEntryArray = new TarEntry[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            tarEntryArray[i] = new TarEntry(new File(this.m_file, stringArray[i]));
        }
        return tarEntryArray;
    }

    public File getFile() {
        return this.m_file;
    }

    public int getGroupId() {
        return this.m_groupID;
    }

    public int getGroupID() {
        return this.m_groupID;
    }

    public String getGroupName() {
        return this.m_groupName.toString();
    }

    public Date getModTime() {
        return new Date(this.m_modTime * 1000L);
    }

    public int getMode() {
        return this.m_mode;
    }

    public String getName() {
        return this.m_name.toString();
    }

    public long getSize() {
        return this.m_size;
    }

    public int getCheckSum() {
        return this.m_checkSum;
    }

    public int getUserId() {
        return this.m_userID;
    }

    public int getUserID() {
        return this.m_userID;
    }

    public String getUserName() {
        return this.m_userName.toString();
    }

    public boolean isDescendent(TarEntry tarEntry) {
        return tarEntry.getName().startsWith(this.getName());
    }

    public boolean isDirectory() {
        if (this.m_file != null) {
            return this.m_file.isDirectory();
        }
        if (this.m_linkFlag == 53) {
            return true;
        }
        return this.getName().endsWith("/");
    }

    public boolean isGNULongNameEntry() {
        return this.m_linkFlag == 76 && this.m_name.toString().equals("././@LongLink");
    }

    public boolean equals(TarEntry tarEntry) {
        return this.getName().equals(tarEntry.getName());
    }

    private void parseTarHeader(byte[] byArray) {
        int n = 0;
        this.m_name = TarUtils.parseName(byArray, n, 100);
        this.m_mode = (int)TarUtils.parseOctal(byArray, n += 100, 8);
        this.m_userID = (int)TarUtils.parseOctal(byArray, n += 8, 8);
        this.m_groupID = (int)TarUtils.parseOctal(byArray, n += 8, 8);
        this.m_size = TarUtils.parseOctal(byArray, n += 8, 12);
        this.m_modTime = TarUtils.parseOctal(byArray, n += 12, 12);
        this.m_checkSum = (int)TarUtils.parseOctal(byArray, n += 12, 8);
        n += 8;
        this.m_linkFlag = byArray[n++];
        this.m_linkName = TarUtils.parseName(byArray, n, 100);
        this.m_magic = TarUtils.parseName(byArray, n += 100, 8);
        this.m_userName = TarUtils.parseName(byArray, n += 8, 32);
        this.m_groupName = TarUtils.parseName(byArray, n += 32, 32);
        this.m_devMajor = (int)TarUtils.parseOctal(byArray, n += 32, 8);
        this.m_devMinor = (int)TarUtils.parseOctal(byArray, n += 8, 8);
    }

    public void writeEntryHeader(byte[] byArray) {
        int n = 0;
        n = TarUtils.getNameBytes(this.m_name, byArray, n, 100);
        n = TarUtils.getOctalBytes(this.m_mode, byArray, n, 8);
        n = TarUtils.getOctalBytes(this.m_userID, byArray, n, 8);
        n = TarUtils.getOctalBytes(this.m_groupID, byArray, n, 8);
        n = TarUtils.getLongOctalBytes(this.m_size, byArray, n, 12);
        int n2 = n = TarUtils.getLongOctalBytes(this.m_modTime, byArray, n, 12);
        for (int i = 0; i < 8; ++i) {
            byArray[n++] = 32;
        }
        byArray[n++] = this.m_linkFlag;
        n = TarUtils.getNameBytes(this.m_linkName, byArray, n, 100);
        n = TarUtils.getNameBytes(this.m_magic, byArray, n, 8);
        n = TarUtils.getNameBytes(this.m_userName, byArray, n, 32);
        n = TarUtils.getNameBytes(this.m_groupName, byArray, n, 32);
        n = TarUtils.getOctalBytes(this.m_devMajor, byArray, n, 8);
        n = TarUtils.getOctalBytes(this.m_devMinor, byArray, n, 8);
        while (n < byArray.length) {
            byArray[n++] = 0;
        }
        long l = TarUtils.computeCheckSum(byArray);
        TarUtils.getCheckSumOctalBytes(l, byArray, n2, 8);
    }
}

