/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Parser;

public class PosixParser
extends Parser {
    private ArrayList tokens = new ArrayList();
    private boolean eatTheRest;
    private Option currentOption;
    private Options options;

    private void init() {
        this.eatTheRest = false;
        this.tokens.clear();
        this.currentOption = null;
    }

    @Override
    protected String[] flatten(Options options, String[] stringArray, boolean bl) {
        this.init();
        this.options = options;
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = iterator.next();
            if (string.startsWith("--")) {
                if (string.indexOf(61) != -1) {
                    this.tokens.add(string.substring(0, string.indexOf(61)));
                    this.tokens.add(string.substring(string.indexOf(61) + 1, string.length()));
                } else {
                    this.tokens.add(string);
                }
            } else if ("-".equals(string)) {
                this.processSingleHyphen(string);
            } else if (string.startsWith("-")) {
                int n = string.length();
                if (n == 2) {
                    this.processOptionToken(string, bl);
                } else {
                    this.burstToken(string, bl);
                }
            } else if (bl) {
                this.process(string);
            } else {
                this.tokens.add(string);
            }
            this.gobble(iterator);
        }
        return this.tokens.toArray(new String[0]);
    }

    private void gobble(Iterator iterator) {
        if (this.eatTheRest) {
            while (iterator.hasNext()) {
                this.tokens.add(iterator.next());
            }
        }
    }

    private void process(String string) {
        if (this.currentOption != null && this.currentOption.hasArg()) {
            if (this.currentOption.hasArg()) {
                this.tokens.add(string);
                this.currentOption = null;
            } else if (this.currentOption.hasArgs()) {
                this.tokens.add(string);
            }
        } else {
            this.eatTheRest = true;
            this.tokens.add("--");
            this.tokens.add(string);
        }
    }

    private void processSingleHyphen(String string) {
        this.tokens.add(string);
    }

    private void processOptionToken(String string, boolean bl) {
        if (this.options.hasOption(string)) {
            this.currentOption = this.options.getOption(string);
            this.tokens.add(string);
        } else if (bl) {
            this.eatTheRest = true;
        }
    }

    protected void burstToken(String string, boolean bl) {
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            String string2 = String.valueOf(string.charAt(i));
            boolean bl2 = this.options.hasOption(string2);
            if (bl2) {
                this.tokens.add("-" + string2);
                this.currentOption = this.options.getOption(string2);
                if (!this.currentOption.hasArg() || string.length() == i + 1) continue;
                this.tokens.add(string.substring(i + 1));
                break;
            }
            if (bl) {
                this.process(string.substring(i));
                continue;
            }
            this.tokens.add("-" + string2);
        }
    }
}

