/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class PatternOptionBuilder {
    public static final Class STRING_VALUE = String.class;
    public static final Class OBJECT_VALUE = Object.class;
    public static final Class NUMBER_VALUE = Number.class;
    public static final Class DATE_VALUE = Date.class;
    public static final Class CLASS_VALUE = Class.class;
    public static final Class EXISTING_FILE_VALUE = FileInputStream.class;
    public static final Class FILE_VALUE = File.class;
    public static final Class FILES_VALUE = File[].class;
    public static final Class URL_VALUE = URL.class;

    public static Object getValueClass(char c) {
        if (c == '@') {
            return OBJECT_VALUE;
        }
        if (c == ':') {
            return STRING_VALUE;
        }
        if (c == '%') {
            return NUMBER_VALUE;
        }
        if (c == '+') {
            return CLASS_VALUE;
        }
        if (c == '#') {
            return DATE_VALUE;
        }
        if (c == '<') {
            return EXISTING_FILE_VALUE;
        }
        if (c == '>') {
            return FILE_VALUE;
        }
        if (c == '*') {
            return FILES_VALUE;
        }
        if (c == '/') {
            return URL_VALUE;
        }
        return null;
    }

    public static boolean isValueCode(char c) {
        return c == '@' || c == ':' || c == '%' || c == '+' || c == '#' || c == '<' || c == '>' || c == '*' || c == '/';
    }

    public static Options parsePattern(String string) {
        int n = string.length();
        int n2 = 32;
        int n3 = 32;
        boolean bl = false;
        Object object = null;
        Options options = new Options();
        for (int i = 0; i < n; ++i) {
            n3 = string.charAt(i);
            if (!PatternOptionBuilder.isValueCode((char)n3)) {
                if (n2 != 32) {
                    OptionBuilder.hasArg(object != null);
                    OptionBuilder.isRequired(bl);
                    OptionBuilder.withType(object);
                    options.addOption(OptionBuilder.create((char)n2));
                    bl = false;
                    object = null;
                    n2 = 32;
                }
                n2 = n3;
                continue;
            }
            if (n3 == 33) {
                bl = true;
                continue;
            }
            object = PatternOptionBuilder.getValueClass((char)n3);
        }
        if (n2 != 32) {
            OptionBuilder.hasArg(object != null);
            OptionBuilder.isRequired(bl);
            OptionBuilder.withType(object);
            options.addOption(OptionBuilder.create((char)n2));
        }
        return options;
    }
}

