require 'amrita/template';
require 'skypeer/servent';

module SkyPeer

  class UploaderServlet < WEBrick::HTTPServlet::AbstractServlet
    include WEBrick;
    include Amrita;

    def initialize( server, *options )
      @server = server;
      super( server, *options );
    end
    
    def do_GET( req, res )
      raise HTTPStatus::Forbidden unless( @server.is_privilege_host?( req.addr[ 3 ] ) );
      res['content-type'] = 'text/html; charset=utf-8';
      html = File::open( 'template/head.html', 'r' ) { |io| io.read( ); }
      html << File::open( 'template/upload.html', 'r' ) { |io| io.read( ); }
      html << File::open( 'template/foot.html', 'r' ) { |io| io.read( ); }
      res.body << html;
    end
    
    def do_POST( req, res )
      raise HTTPStatus::Forbidden unless( @server.is_privilege_host?( req.addr[ 3 ] ) );
      begin
	ofile = req.query['upfile'].filename;
	if( ofile.to_s.empty? ) then raise "うpするファイルの名前いれてね。"; end
	# アップロードデータ
	data = req.query['upfile'];
	if( data.nil? || data.empty? ) then raise "データがないよ。"; end
	# アップロードデータの MD5 ハッシュ
	hash = Digest::MD5::hexdigest( data );
	# 元ファイル名から拡張子を得る
        ext = File::extname( ofile );
	if( ext.empty? ) then raise "拡張子がないよ。"; end
	# 新しいファイル名とパス
	file = "#{hash}#{ext}";
	filepath = "#{@server.config[:DataDir]}/#{file}";
	# ファイルが既に存在する場合
	if( File::exist?( filepath ) ) then raise "#{ofile}(#{file}) はもうあるよ。"; end
	# アップロードデータをファイルに書き込む
	File::open( filepath, 'w' ) { |io|
	  io.flock( File::LOCK_EX );
	  io.write( data );
	}
	# DBサーバーにファイル所有者を登録
	@server.regist_fileowner( [ file ] );
	# 
	res['refresh'] = "0;/info?file=#{file}";
      rescue Exception
	res['content-type'] = 'text/html'
	html = File::open( 'template/head.html', 'r' ) { |io| io.read( ); }
	html << File::open( 'template/upload.html', 'r' ) { |io| io.read( ); }
	html << File::open( 'template/foot.html', 'r' ) { |io| io.read( ); }
	tmpl = TemplateText.new( html );
	tmpl.amrita_id = :spid;
	model = Hash.new( );
	model[:error] = "ERROR: #{$!}";
	model[:upfile] = a( :value=>ofile );
	tmpl.expand( res.body, model );
      end
    end
  end
  
end  
