require 'pstore';
require 'soap/rpc/driver';
require 'skypeer/filehandler';
require 'skypeer/filelist';
require 'skypeer/uploader';
require 'skypeer/fileinfo';
require 'skypeer/filedelete';
require 'skypeer/htaccess';

module SkyPeer

  class Servent < WEBrick::HTTPServer
    include WEBrick;
    HOSTID_FILE = '.hostid';
    FILEINFO = 'fileinfo.dump';
    attr_reader :htaccess;
    attr_accessor :fileinfos;
    
    def initialize( config )
      super( config );
      @logger = @config[:Logger];
      # SOAP ドライバ
      set_soap_drivers( );
      # Host ID をファイルから読み込む */
      @hostid = get_hostid( );
      # 共有ファイルの情報を読み込む
      @fileinfos = PStore.new( FILEINFO );
      # サーブレットのマウント
      mount( "/list", SkyPeer::FileListServlet, nil );
      mount( "/upload", SkyPeer::UploaderServlet, nil );
      mount( "/info", SkyPeer::FileInfoServlet, nil );
      mount( "/delete", SkyPeer::FileDeleteServlet, nil );
      mount( "/data/", SkyPeer::FileHandler, "#{@config[:DataDir]}" );
      # アクセス制御設定を読み込む
      # @htaccess = SkyPeer::HTAccess.new( 'access.conf' );
      @hostregistrar = nil;
    end

    # SOAP ドライバをセット
    def set_soap_drivers( )
      @drivers = Array.new( );
      endpoint = @config[:EndPoint].shift;
      @pdriver = SOAP::RPC::Driver.new( endpoint, 'urn:SkyPeerDB' );
      @pdriver.add_method( 'regist_host', 'id', 'port', 'speed' );
      @pdriver.add_method( 'delete_host', 'id' );
      @pdriver.add_method( 'regist_fileowner', 'id', 'files' );
      @pdriver.add_method( 'delete_fileowner', 'id', 'files' );
      @pdriver.add_method( 'get_fileowner', 'file' );
      @pdriver.add_method( 'get_fileinfo', 'file' );
      @pdriver.add_method( 'set_fileinfo', 'fileinfo', 'digest' );
      @pdriver.add_method( 'search_fileinfo', 'elem' );
      @drivers.push( @pdriver );
      @logger.info( "set soapdriver for #{endpoint}" );
      @config[:EndPoint].each { |endpoint|
	driver = SOAP::RPC::Driver.new( endpoint, 'urn:SkyPeerDB' );
	driver.add_method( 'get_fileowner', 'file' );
	driver.add_method( 'get_filinfo', 'file' );
	driver.add_method( 'search_filinfo', 'elem' );
	@drivers.push( driver );
	@logger.info( "set soapdriver for #{endpoint}" );
      }
      # @pdriver.wiredump_dev= STDERR;
    end
    private :set_soap_drivers

    # SkyPeerServent スタート
    def start( )
      result = regist_host( );
      result = regist_current_fileowner( );
      start_hostregistrar( );
      super( );
    end
    
    # Servent シャットダウン
    def shutdown( )
      @hostregistrar = nil;
      delete_host( );
      super( );
    end
    
    def regist_host( )
      @logger.debug( "regist_host( #{@hostid} #{@config[:Port]} #{@config[:Speed]} )" );
      result = @pdriver.regist_host( @hostid, @config[:Port], @config[:Speed] );
      return( result );
    end
    
    def delete_host( )
      @logger.debug( "delete_host( #{@hostid} #{@config[:Port]} #{@config[:Speed]} )" );
      result = @pdriver.delete_host( @hostid );
      return( result );
    end
    
    def regist_fileowner( files )
      @logger.debug( "regist_fileowner( #{files.join(',')} )" );
      result = @pdriver.regist_fileowner( @hostid, files );
      return( result );
    end
    
    def delete_fileowner( files )
      @logger.debug( "delete_fileowner( #{files.join(',')} )" );
      result = @pdriver.delete_fileowner( @hostid, files );
      return( result );
    end
    
    def get_fileowner( file )
      @logger.debug( "get_fileowner( #{file} )" );
      cands = Array.new;
      begin
	@drivers.each { |driver|
	  result, owners = driver.get_fileowner( file );
	  cands += owners.flatten;
	  if( @config[:MaxCandidate] < cands.size ) then break; end
	}
      rescue
      end
      return( cands );
    end
    
    def get_fileinfo( file )
      @logger.debug( "get_fileinfo( #{file} )" );
      result = nil;
      fileinfo = nil;
      begin
	@drivers.each { |driver|
	  result, fileinfo = @pdriver.get_fileinfo( file );
	  unless( fileinfo.nil? ) then break; end
	}
      rescue
      end
      return( [ result, fileinfo ] );
    end
    
    def set_fileinfo( fileinfo, digest )
      @logger.debug( "set_fileinfo( #{fileinfo}, #{digest} )" );
      result, fileinfo = @pdriver.set_fileinfo( fileinfo, digest );
      return( [ result, fileinfo ] );
    end
    
    def search_fileinfo( elem )
      @logger.debug( "search_fileinfo( #{elem} )" );
      result, fileinfos = @pdriver.search_fileinfo( elem );
      return( [ result, fileinfos ] );
    end

    def is_privilege_host?( raddr )
      raddr = IPAddr.new( raddr );
      @config[:PrivilegeHost].each { |addr|
	return( true ) if( addr == raddr || addr.include?( raddr ) );
      }
      return( false );
    end

    def get_hostid( )
      # ホストIDファイルが無ければつくる
      unless( File::exist?( HOSTID_FILE ) ) then 
	id = "";
	# UUID 使う？
	( 1..32 ).each { id << rand( 10 ).to_s; }
	File::open( HOSTID_FILE, 'w' ) { |io| io.write( id ); }
      end
      hostid = File::open( HOSTID_FILE, 'r' ) { |io| io.read; }
      return( hostid );
    end
    private :get_hostid;
    
    def start_hostregistrar( )
      Thread.start {
	@hostregistrar = Thread.current( );
	while( @hostregistrar ) do
	  begin
	    result = regist_host( );
	    raise Exception, result if( result !~ /^200/ );
	  rescue
	    p $!;
	  end
	  sleep( 120 );
	end
      }
    end
    private :start_hostregistrar;
    
    def regist_current_fileowner( )
      files = Array.new;
      Dir::foreach( "#{@config[:DataDir]}" ) { |file|
	size = File::stat( "#{@config[:DataDir]}/#{file}" ).size;
	#if( size <= @config[:MaxDownloadSize] && file =~ /^([0-9a-f]{32})\.(\w{2,5})/ ) then
	if( file =~ /^([0-9a-f]{32})\.(\w{2,5})/ ) then
	  hash = $1;
	  ext = $2;
	  #if( @config[:AllowExt].match( ext ) ) then
	    files.push( "#{hash}.#{ext}" );
	  #end
	end
      }
      result = regist_fileowner( files );
      return( result );
    end
    private :regist_current_fileowner;
  end
  
end
