require 'amrita/template';
require 'skypeer/servent';

module SkyPeer

  class FileDeleteServlet < WEBrick::HTTPServlet::AbstractServlet
    include WEBrick;
    include Amrita;
    
    def initialize( server, *options )
      @server = server;
      super( server, *options );
    end
    
    def do_GET( req, res )
      do_POST( req, res );
    end
    
    def do_POST( req, res )
      raise HTTPStatus::Forbidden unless( @server.is_privilege_host?( req.addr[ 3 ] ) );
      res['content-type'] = 'text/html; charset=utf-8';
      html = File::open( 'template/head.html', 'r' ) { |io| io.read( ); }
      html << File::open( 'template/filedelete.html', 'r' ) { |io| io.read( ); }
      html << File::open( 'template/foot.html', 'r' ) { |io| io.read( ); }
      tmpl = TemplateText.new( html );
      tmpl.amrita_id = :spid;
      model = Hash.new( );
      if( req.query['file'].to_s.empty? ) then
	model[:form1] = true;
      elsif( !File::exist?( "#{@server.config[:DataDir]}/#{req.query['file']}" ) ) then
	model[:form1] = true;
	model[:error] = "ERROR: \"#{req.query['file']}\" そんなファイルないよ。";
      else
	File::delete( "#{@server.config[:DataDir]}/#{req.query['file']}" );
	@server.fileinfos.transaction {
	  @server.fileinfos.delete( req.query['file'] );
	}
	model[:message] = "\"#{req.query['file']}\" を削除しました。";
      end
      tmpl.expand( res.body, model );
    end
  end
  
end
