#!/usr/local/bin/ruby
config_file = ARGV.shift( );
config_file = File::expand_path( config_file );
Dir::chdir( File::dirname( __FILE__ ) );
require 'skypeer/config';

def dig_directory( path )
  items = path.split( %r|/+| );
  if( items.first.empty? ) then 
    items.shift( );
    items[ 0 ] = '/' + items[ 0 ];
  end
  ( 1..items.size ).each { |i|
    path = items[ 0, i ].join( '/' );
    unless( File::directory?( path ) ) then
      STDERR.puts( "Create #{path}" );
      Dir::mkdir( path );
    end
  }
end

def make_file( path )
  dir = File::dirname( path );
  dig_directory( dir );
  unless( File::file?( path ) ) then
    STDERR.puts( "Create #{path}" );
    File::open( path, 'w' ) { |io| }
  end
end

config = SkyPeer::Config::load_config( config_file );
make_file( "log/debug.log" );
make_file( "log/access.log" );
make_file( "fileinfo.dump" );
dig_directory( config[:DocumentRoot] );
dig_directory( config[:DataDir] );
dig_directory( "#{config[:DataDir]}/thumbnail" );
